/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.invoke;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.Hierarchy;
import soot.Local;
import soot.PhaseOptions;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Trap;
import soot.TrapManager;
import soot.Unit;
import soot.UnitBox;
import soot.UnitPatchingChain;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.IdentityRef;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NullConstant;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.Stmt;
import soot.jimple.ThisRef;
import soot.jimple.toolkits.invoke.SynchronizerManager;
import soot.jimple.toolkits.invoke.ThrowManager;
import soot.jimple.toolkits.scalar.LocalNameStandardizer;

public class SiteInliner {
    public String getDefaultOptions() {
        return "insert-null-checks insert-redundant-casts";
    }

    public static void inlineSites(List sites) {
        SiteInliner.inlineSites(sites, new HashMap());
    }

    public static void inlineSites(List sites, Map options) {
        for (List l : sites) {
            SootMethod inlinee = (SootMethod)l.get(0);
            Stmt toInline = (Stmt)l.get(1);
            SootMethod container2 = (SootMethod)l.get(2);
            SiteInliner.inlineSite(inlinee, toInline, container2, options);
        }
    }

    public static void inlineSite(SootMethod inlinee, Stmt toInline, SootMethod container2) {
        SiteInliner.inlineSite(inlinee, toInline, container2, new HashMap());
    }

    public static List inlineSite(SootMethod inlinee, Stmt toInline, SootMethod container2, Map options) {
        boolean enableNullPointerCheckInsertion = PhaseOptions.getBoolean(options, "insert-null-checks");
        boolean enableRedundantCastInsertion = PhaseOptions.getBoolean(options, "insert-redundant-casts");
        Hierarchy hierarchy = Scene.v().getActiveHierarchy();
        JimpleBody containerB = (JimpleBody)container2.getActiveBody();
        UnitPatchingChain containerUnits = containerB.getUnits();
        if (!inlinee.getDeclaringClass().isApplicationClass() && !inlinee.getDeclaringClass().isLibraryClass()) {
            return null;
        }
        Body inlineeB = inlinee.getActiveBody();
        UnitPatchingChain inlineeUnits = inlineeB.getUnits();
        InvokeExpr ie = toInline.getInvokeExpr();
        Value thisToAdd = null;
        if (ie instanceof InstanceInvokeExpr) {
            thisToAdd = ((InstanceInvokeExpr)ie).getBase();
        }
        boolean targetUsesThis = true;
        if (enableRedundantCastInsertion && ie instanceof InstanceInvokeExpr && targetUsesThis) {
            SootClass localType = ((RefType)((InstanceInvokeExpr)ie).getBase().getType()).getSootClass();
            SootClass parameterType = inlinee.getDeclaringClass();
            if (localType.isInterface() || hierarchy.isClassSuperclassOf(localType, parameterType)) {
                Local castee = Jimple.v().newLocal("__castee", parameterType.getType());
                containerB.getLocals().add(castee);
                containerB.getUnits().insertBefore(Jimple.v().newAssignStmt(castee, Jimple.v().newCastExpr(((InstanceInvokeExpr)ie).getBase(), parameterType.getType())), toInline);
                thisToAdd = castee;
            }
        }
        if (enableNullPointerCheckInsertion && ie instanceof InstanceInvokeExpr) {
            boolean caught = TrapManager.isExceptionCaughtAt(Scene.v().getSootClass("java.lang.NullPointerException"), toInline, containerB);
            if (caught) {
                IfStmt insertee = Jimple.v().newIfStmt((Value)Jimple.v().newNeExpr(((InstanceInvokeExpr)ie).getBase(), NullConstant.v()), toInline);
                containerB.getUnits().insertBefore(insertee, toInline);
                insertee.setTarget(toInline);
                ThrowManager.addThrowAfter(containerB, insertee);
            } else {
                Stmt throwPoint = ThrowManager.getNullPointerExceptionThrower(containerB);
                containerB.getUnits().insertBefore(Jimple.v().newIfStmt((Value)Jimple.v().newEqExpr(((InstanceInvokeExpr)ie).getBase(), NullConstant.v()), throwPoint), toInline);
            }
        }
        if (inlinee.isSynchronized()) {
            if (ie instanceof InstanceInvokeExpr) {
                SynchronizerManager.v().synchronizeStmtOn(toInline, containerB, (Local)((InstanceInvokeExpr)ie).getBase());
            } else if (!container2.getDeclaringClass().isInterface()) {
                Local l = SynchronizerManager.v().addStmtsToFetchClassBefore(containerB, toInline);
                SynchronizerManager.v().synchronizeStmtOn(toInline, containerB, l);
            }
        }
        Stmt exitPoint = containerUnits.getSuccOf(toInline);
        HashMap<Local, Local> oldLocalsToNew = new HashMap<Local, Local>();
        HashMap<Stmt, Stmt> oldUnitsToNew = new HashMap<Stmt, Stmt>();
        Stmt cursor = toInline;
        for (Stmt stmt : inlineeUnits) {
            Stmt stmt2 = (Stmt)stmt.clone();
            if (stmt2 == null) {
                throw new RuntimeException("getting null from clone!");
            }
            stmt2.addAllTagsOf(stmt);
            containerUnits.insertAfter(stmt2, cursor);
            cursor = stmt2;
            oldUnitsToNew.put(stmt, stmt2);
        }
        for (Local local : inlineeB.getLocals()) {
            Local local2 = (Local)local.clone();
            if (local2 == null) {
                throw new RuntimeException("getting null from local clone!");
            }
            containerB.getLocals().add(local2);
            oldLocalsToNew.put(local, local2);
        }
        Iterator<Stmt> it = containerUnits.iterator(containerUnits.getSuccOf(toInline), containerUnits.getPredOf(exitPoint));
        while (it.hasNext()) {
            Stmt patchee = it.next();
            for (ValueBox valueBox : patchee.getUseAndDefBoxes()) {
                if (!(valueBox.getValue() instanceof Local)) continue;
                Local lPrime = (Local)oldLocalsToNew.get(valueBox.getValue());
                if (lPrime != null) {
                    valueBox.setValue(lPrime);
                    continue;
                }
                throw new RuntimeException("local has no clone!");
            }
            for (UnitBox unitBox : patchee.getUnitBoxes()) {
                Unit uPrime = (Unit)oldUnitsToNew.get(unitBox.getUnit());
                if (uPrime != null) {
                    unitBox.setUnit(uPrime);
                    continue;
                }
                throw new RuntimeException("inlined stmt has no clone!");
            }
        }
        Trap prevTrap = null;
        for (Trap trap : inlineeB.getTraps()) {
            Stmt stmt = (Stmt)oldUnitsToNew.get(trap.getBeginUnit());
            Stmt newEnd = (Stmt)oldUnitsToNew.get(trap.getEndUnit());
            Stmt newHandler = (Stmt)oldUnitsToNew.get(trap.getHandlerUnit());
            if (stmt == null || newEnd == null || newHandler == null) {
                throw new RuntimeException("couldn't map trap!");
            }
            Trap trap2 = Jimple.v().newTrap(trap.getException(), stmt, newEnd, newHandler);
            if (prevTrap == null) {
                containerB.getTraps().addFirst(trap2);
            } else {
                containerB.getTraps().insertAfter(trap2, prevTrap);
            }
            prevTrap = trap2;
        }
        it = containerUnits.iterator(containerUnits.getSuccOf(toInline), containerUnits.getPredOf(exitPoint));
        ArrayList<Stmt> cuCopy = new ArrayList<Stmt>();
        while (it.hasNext()) {
            cuCopy.add(it.next());
        }
        for (Unit unit : cuCopy) {
            Stmt s = (Stmt)unit;
            if (s instanceof IdentityStmt) {
                IdentityRef rhs = (IdentityRef)((IdentityStmt)s).getRightOp();
                if (rhs instanceof CaughtExceptionRef) continue;
                if (rhs instanceof ThisRef) {
                    if (!(ie instanceof InstanceInvokeExpr)) {
                        throw new RuntimeException("thisref with no receiver!");
                    }
                    containerUnits.swapWith(s, Jimple.v().newAssignStmt(((IdentityStmt)s).getLeftOp(), thisToAdd));
                    continue;
                }
                if (!(rhs instanceof ParameterRef)) continue;
                ParameterRef pref = (ParameterRef)rhs;
                containerUnits.swapWith(s, Jimple.v().newAssignStmt(((IdentityStmt)s).getLeftOp(), ie.getArg(pref.getIndex())));
                continue;
            }
            if (s instanceof ReturnStmt) {
                if (toInline instanceof InvokeStmt) {
                    containerUnits.swapWith(s, Jimple.v().newGotoStmt(exitPoint));
                    continue;
                }
                if (!(toInline instanceof AssignStmt)) {
                    throw new RuntimeException("invoking stmt neither InvokeStmt nor AssignStmt!??!?!");
                }
                Value ro = ((ReturnStmt)s).getOp();
                Value lhs = ((AssignStmt)toInline).getLeftOp();
                AssignStmt as = Jimple.v().newAssignStmt(lhs, ro);
                containerUnits.insertBefore(as, s);
                containerUnits.swapWith(s, Jimple.v().newGotoStmt(exitPoint));
                continue;
            }
            if (!(s instanceof ReturnVoidStmt)) continue;
            containerUnits.swapWith(s, Jimple.v().newGotoStmt(exitPoint));
        }
        ArrayList<Stmt> newStmts = new ArrayList<Stmt>();
        Iterator<Stmt> i = containerUnits.iterator(containerUnits.getSuccOf(toInline), containerUnits.getPredOf(exitPoint));
        while (i.hasNext()) {
            newStmts.add(i.next());
        }
        containerUnits.remove(toInline);
        LocalNameStandardizer.v().transform(containerB, "ji.lns");
        return newStmts;
    }
}

