/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread.mhp;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import soot.toolkits.graph.DirectedGraph;

public class SCC {
    private Set<Object> gray = new HashSet<Object>();
    private final LinkedList<Object> finishedOrder = new LinkedList();
    private final List<List<Object>> sccList = new ArrayList<List<Object>>();

    public SCC(Iterator it, DirectedGraph g) {
        while (it.hasNext()) {
            Object s = it.next();
            if (this.gray.contains(s)) continue;
            this.visitNode(g, s);
        }
        this.gray = new HashSet<Object>();
        for (Object e : this.finishedOrder) {
            if (this.gray.contains(e)) continue;
            ArrayList<Object> scc = new ArrayList<Object>();
            this.visitRevNode(g, e, scc);
            this.sccList.add(scc);
        }
    }

    private void visitNode(DirectedGraph g, Object s) {
        this.gray.add(s);
        Iterator<Object> it = g.getSuccsOf(s).iterator();
        if (g.getSuccsOf(s).size() > 0) {
            while (it.hasNext()) {
                Object succ = it.next();
                if (this.gray.contains(succ)) continue;
                this.visitNode(g, succ);
            }
        }
        this.finishedOrder.addFirst(s);
    }

    private void visitRevNode(DirectedGraph g, Object s, List<Object> scc) {
        scc.add(s);
        this.gray.add(s);
        if (g.getPredsOf(s) != null) {
            Iterator<Object> predsIt = g.getPredsOf(s).iterator();
            if (g.getPredsOf(s).size() > 0) {
                while (predsIt.hasNext()) {
                    Object pred = predsIt.next();
                    if (this.gray.contains(pred)) continue;
                    this.visitRevNode(g, pred, scc);
                }
            }
        }
    }

    public List<List<Object>> getSccList() {
        return this.sccList;
    }

    public LinkedList<Object> getFinishedOrder() {
        return this.finishedOrder;
    }
}

