/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.registry;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class NacosServiceRegistry
implements ServiceRegistry<Registration> {
    private static final Logger log = LoggerFactory.getLogger(NacosServiceRegistry.class);
    private final NacosDiscoveryProperties nacosDiscoveryProperties;
    private NacosServiceManager nacosServiceManager;

    public NacosServiceRegistry(NacosDiscoveryProperties nacosDiscoveryProperties, NacosServiceManager nacosServiceManager) {
        this.nacosDiscoveryProperties = nacosDiscoveryProperties;
        this.nacosServiceManager = nacosServiceManager;
    }

    public void register(Registration registration) {
        if (StringUtils.isEmpty((Object)registration.getServiceId())) {
            log.warn("No service to register for nacos client...");
            return;
        }
        NamingService namingService = this.namingService();
        String serviceId = registration.getServiceId();
        String group = this.nacosDiscoveryProperties.getGroup();
        Instance instance = this.getNacosInstanceFromRegistration(registration);
        try {
            namingService.registerInstance(serviceId, group, instance);
            log.info("nacos registry, {} {} {}:{} register finished", new Object[]{group, serviceId, instance.getIp(), instance.getPort()});
        }
        catch (Exception e) {
            log.error("nacos registry, {} register failed...{},", new Object[]{serviceId, registration.toString(), e});
            ReflectionUtils.rethrowRuntimeException((Throwable)e);
        }
    }

    public void deregister(Registration registration) {
        log.info("De-registering from Nacos Server now...");
        if (StringUtils.isEmpty((Object)registration.getServiceId())) {
            log.warn("No dom to de-register for nacos client...");
            return;
        }
        NamingService namingService = this.namingService();
        String serviceId = registration.getServiceId();
        String group = this.nacosDiscoveryProperties.getGroup();
        try {
            namingService.deregisterInstance(serviceId, group, registration.getHost(), registration.getPort(), this.nacosDiscoveryProperties.getClusterName());
        }
        catch (Exception e) {
            log.error("ERR_NACOS_DEREGISTER, de-register failed...{},", (Object)registration.toString(), (Object)e);
        }
        log.info("De-registration finished.");
    }

    public void close() {
        try {
            this.nacosServiceManager.nacosServiceShutDown();
        }
        catch (NacosException e) {
            log.error("Nacos namingService shutDown failed", (Throwable)e);
        }
    }

    public void setStatus(Registration registration, String status) {
        if (!status.equalsIgnoreCase("UP") && !status.equalsIgnoreCase("DOWN")) {
            log.warn("can't support status {},please choose UP or DOWN", (Object)status);
            return;
        }
        String serviceId = registration.getServiceId();
        Instance instance = this.getNacosInstanceFromRegistration(registration);
        if (status.equalsIgnoreCase("DOWN")) {
            instance.setEnabled(false);
        } else {
            instance.setEnabled(true);
        }
        try {
            Properties nacosProperties = this.nacosDiscoveryProperties.getNacosProperties();
            this.nacosServiceManager.getNamingMaintainService(nacosProperties).updateInstance(serviceId, instance);
        }
        catch (Exception e) {
            throw new RuntimeException("update nacos instance status fail", e);
        }
    }

    public Object getStatus(Registration registration) {
        String serviceName = registration.getServiceId();
        try {
            List instances = this.namingService().getAllInstances(serviceName);
            for (Instance instance : instances) {
                if (!instance.getIp().equalsIgnoreCase(this.nacosDiscoveryProperties.getIp()) || instance.getPort() != this.nacosDiscoveryProperties.getPort()) continue;
                return instance.isEnabled() ? "UP" : "DOWN";
            }
        }
        catch (Exception e) {
            log.error("get all instance of {} error,", (Object)serviceName, (Object)e);
        }
        return null;
    }

    private Instance getNacosInstanceFromRegistration(Registration registration) {
        Instance instance = new Instance();
        instance.setIp(registration.getHost());
        instance.setPort(registration.getPort());
        instance.setWeight((double)this.nacosDiscoveryProperties.getWeight());
        instance.setClusterName(this.nacosDiscoveryProperties.getClusterName());
        instance.setEnabled(this.nacosDiscoveryProperties.isInstanceEnabled());
        instance.setMetadata(registration.getMetadata());
        instance.setEphemeral(this.nacosDiscoveryProperties.isEphemeral());
        return instance;
    }

    private NamingService namingService() {
        return this.nacosServiceManager.getNamingService(this.nacosDiscoveryProperties.getNacosProperties());
    }
}

