/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.service.schema.model.enums;

import com.alipay.service.schema.model.attribute.Attribute;
import com.alipay.service.schema.model.attribute.ComplexAttribute;
import com.alipay.service.schema.model.attribute.MultiAttribute;
import com.alipay.service.schema.model.attribute.MultiComplexAttribute;
import com.alipay.service.schema.model.attribute.SingleAttribute;

public enum AttrTypeEnum {
    SINGLE("single"),
    MULTI("multi"),
    COMPLEX("complex"),
    MULTICOMPLEX("multiComplex");

    private final String type;

    public static Attribute createAttribute(AttrTypeEnum attributeType) {
        Attribute attribute = null;
        switch (attributeType) {
            case SINGLE: {
                attribute = new SingleAttribute();
                break;
            }
            case MULTI: {
                attribute = new MultiAttribute();
                break;
            }
            case COMPLEX: {
                attribute = new ComplexAttribute();
                break;
            }
            case MULTICOMPLEX: {
                attribute = new MultiComplexAttribute();
            }
        }
        attribute.setType(attributeType);
        return attribute;
    }

    private AttrTypeEnum(String type) {
        this.type = type;
    }

    public static AttrTypeEnum getType(String type) {
        AttrTypeEnum[] values;
        for (AttrTypeEnum value : values = AttrTypeEnum.values()) {
            if (!value.getType().equals(type)) continue;
            return value;
        }
        return null;
    }

    public String toString() {
        return this.type;
    }

    public String getType() {
        return this.type;
    }
}

