/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticache.model.Endpoint;
import com.amazonaws.services.elasticache.model.NodeGroupMember;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NodeGroup
implements Serializable,
Cloneable {
    private String nodeGroupId;
    private String status;
    private Endpoint primaryEndpoint;
    private ListWithAutoConstructFlag<NodeGroupMember> nodeGroupMembers;

    public String getNodeGroupId() {
        return this.nodeGroupId;
    }

    public void setNodeGroupId(String nodeGroupId) {
        this.nodeGroupId = nodeGroupId;
    }

    public NodeGroup withNodeGroupId(String nodeGroupId) {
        this.nodeGroupId = nodeGroupId;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public NodeGroup withStatus(String status) {
        this.status = status;
        return this;
    }

    public Endpoint getPrimaryEndpoint() {
        return this.primaryEndpoint;
    }

    public void setPrimaryEndpoint(Endpoint primaryEndpoint) {
        this.primaryEndpoint = primaryEndpoint;
    }

    public NodeGroup withPrimaryEndpoint(Endpoint primaryEndpoint) {
        this.primaryEndpoint = primaryEndpoint;
        return this;
    }

    public List<NodeGroupMember> getNodeGroupMembers() {
        if (this.nodeGroupMembers == null) {
            this.nodeGroupMembers = new ListWithAutoConstructFlag();
            this.nodeGroupMembers.setAutoConstruct(true);
        }
        return this.nodeGroupMembers;
    }

    public void setNodeGroupMembers(Collection<NodeGroupMember> nodeGroupMembers) {
        if (nodeGroupMembers == null) {
            this.nodeGroupMembers = null;
            return;
        }
        ListWithAutoConstructFlag nodeGroupMembersCopy = new ListWithAutoConstructFlag(nodeGroupMembers.size());
        nodeGroupMembersCopy.addAll(nodeGroupMembers);
        this.nodeGroupMembers = nodeGroupMembersCopy;
    }

    public NodeGroup withNodeGroupMembers(NodeGroupMember ... nodeGroupMembers) {
        if (this.getNodeGroupMembers() == null) {
            this.setNodeGroupMembers(new ArrayList<NodeGroupMember>(nodeGroupMembers.length));
        }
        for (NodeGroupMember value : nodeGroupMembers) {
            this.getNodeGroupMembers().add(value);
        }
        return this;
    }

    public NodeGroup withNodeGroupMembers(Collection<NodeGroupMember> nodeGroupMembers) {
        if (nodeGroupMembers == null) {
            this.nodeGroupMembers = null;
        } else {
            ListWithAutoConstructFlag nodeGroupMembersCopy = new ListWithAutoConstructFlag(nodeGroupMembers.size());
            nodeGroupMembersCopy.addAll(nodeGroupMembers);
            this.nodeGroupMembers = nodeGroupMembersCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNodeGroupId() != null) {
            sb.append("NodeGroupId: " + this.getNodeGroupId() + ",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: " + this.getStatus() + ",");
        }
        if (this.getPrimaryEndpoint() != null) {
            sb.append("PrimaryEndpoint: " + this.getPrimaryEndpoint() + ",");
        }
        if (this.getNodeGroupMembers() != null) {
            sb.append("NodeGroupMembers: " + this.getNodeGroupMembers());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNodeGroupId() == null ? 0 : this.getNodeGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getPrimaryEndpoint() == null ? 0 : this.getPrimaryEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getNodeGroupMembers() == null ? 0 : this.getNodeGroupMembers().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeGroup)) {
            return false;
        }
        NodeGroup other = (NodeGroup)obj;
        if (other.getNodeGroupId() == null ^ this.getNodeGroupId() == null) {
            return false;
        }
        if (other.getNodeGroupId() != null && !other.getNodeGroupId().equals(this.getNodeGroupId())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getPrimaryEndpoint() == null ^ this.getPrimaryEndpoint() == null) {
            return false;
        }
        if (other.getPrimaryEndpoint() != null && !other.getPrimaryEndpoint().equals(this.getPrimaryEndpoint())) {
            return false;
        }
        if (other.getNodeGroupMembers() == null ^ this.getNodeGroupMembers() == null) {
            return false;
        }
        return other.getNodeGroupMembers() == null || other.getNodeGroupMembers().equals(this.getNodeGroupMembers());
    }

    public NodeGroup clone() {
        try {
            return (NodeGroup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

