/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.tablestorage.model;

import com.baidubce.BceClientException;
import com.baidubce.services.tablestorage.TableStorageConstants;
import com.baidubce.services.tablestorage.model.AbstractTableStorageRequest;
import com.baidubce.services.tablestorage.model.CellType;
import com.baidubce.services.tablestorage.model.TableStorageCell;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public class ScanRequest
extends AbstractTableStorageRequest {
    private String startRowkey = "";
    private boolean includeStart = true;
    private String stopRowkey = TableStorageConstants.DEFAULT_STOP_ROWKEY;
    private boolean includeStop = false;
    private int limit = Integer.MAX_VALUE;
    private int maxVersions = 1;
    private List<TableStorageCell> selectors = new ArrayList<TableStorageCell>();

    public ScanRequest(String tableName) {
        super(tableName);
    }

    public String getStartRowkey() {
        return this.startRowkey;
    }

    public void setStartRowkey(String startRowkey, boolean includeStart) {
        this.startRowkey = startRowkey;
        this.includeStart = includeStart;
    }

    public boolean isIncludeStart() {
        return this.includeStart;
    }

    public String getStopRowkey() {
        return this.stopRowkey;
    }

    public void setStopRowkey(String stopRowkey, boolean includeStop) {
        this.stopRowkey = stopRowkey;
        this.includeStop = includeStop;
    }

    public boolean isIncludeStop() {
        return this.includeStop;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getMaxVersions() {
        return this.maxVersions;
    }

    public void setMaxVersions(int maxVersions) {
        this.maxVersions = maxVersions;
    }

    public List<TableStorageCell> getSelectors() {
        return this.selectors;
    }

    public ScanRequest addSelector(String column) {
        TableStorageCell cell = new TableStorageCell(CellType.ScanCell, column);
        this.selectors.add(cell);
        return this;
    }

    protected static void checkScanRequest(ScanRequest request) {
        int compareResult;
        if (request == null) {
            return;
        }
        if (request.getStartRowkey() != null && request.getStopRowkey() != null && request.getStartRowkey() != "" && request.getStopRowkey() != TableStorageConstants.DEFAULT_STOP_ROWKEY && (compareResult = request.getStopRowkey().compareTo(request.getStartRowkey())) < 0) {
            throw new BceClientException("The stopRowkey's value " + request.getStopRowkey() + " must be greater than the startRowkey's value " + request.getStartRowkey() + ".");
        }
        if (request.getLimit() <= 0) {
            throw new BceClientException("The limit's value must be positive. limit=" + request.getLimit() + ".");
        }
        if (request.getMaxVersions() <= 0) {
            throw new BceClientException("The maxVersions' value must be positive. maxVersions=" + request.getMaxVersions() + ".");
        }
        if (request.selectors.size() > 128) {
            throw new BceClientException("The number of selectors should not exceed the limit 128. selectorNum=" + request.selectors.size() + ".");
        }
        for (TableStorageCell cell : request.selectors) {
            TableStorageCell.checkCell(cell);
        }
    }

    @Override
    public String toJsonString() {
        ScanRequest.checkScanRequest(this);
        StringBuffer buffer = new StringBuffer("{");
        buffer.append("\"maxVersions\":" + this.maxVersions);
        try {
            if (this.startRowkey != null && this.startRowkey != "") {
                buffer.append(",\"startRowkey\":\"");
                buffer.append(URLEncoder.encode(this.startRowkey, TableStorageConstants.DEFAULT_ENCODING));
                buffer.append("\",\"includeStart\":");
                buffer.append(this.includeStart);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("The startRowkey's value don't support " + TableStorageConstants.DEFAULT_ENCODING + " encode, startRowkey=" + this.startRowkey + ".");
        }
        try {
            if (this.stopRowkey != null && this.stopRowkey != TableStorageConstants.DEFAULT_STOP_ROWKEY) {
                buffer.append(",\"stopRowkey\":\"");
                buffer.append(URLEncoder.encode(this.stopRowkey, TableStorageConstants.DEFAULT_ENCODING));
                buffer.append("\",\"includeStop\":");
                buffer.append(this.includeStop);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("The stopRowkey's value don't support " + TableStorageConstants.DEFAULT_ENCODING + " encode, stopRowkey=" + this.stopRowkey + ".");
        }
        buffer.append(",\"selector\":[");
        for (int i = 0; i < this.selectors.size(); ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            TableStorageCell cell = this.selectors.get(i);
            buffer.append(cell.toJsonString());
        }
        buffer.append("]");
        if (this.limit != Integer.MAX_VALUE) {
            buffer.append(",\"limit\":");
            buffer.append(this.limit);
        }
        buffer.append("}");
        return buffer.toString();
    }
}

