/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.tablestoragehbaseclient.adaptor;

import com.baidubce.services.tablestoragehbaseclient.adaptor.TableStorageAdaptor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TablestorageResultScanner {
    private static final Logger LOG = LoggerFactory.getLogger(TablestorageResultScanner.class);
    private BlockingQueue<Result> resultQueue = new LinkedBlockingQueue<Result>(10);
    private TableStorageAdaptor adaptor;
    CountDownLatch count;
    private Scan scan;
    private String tableName;
    private String startRowkey = "";
    private String errMsg;
    private boolean error = false;
    private boolean stop = false;
    private boolean scanEnd = false;

    public TablestorageResultScanner(TableStorageAdaptor adaptor, ExecutorService pool, Scan scan, String tableName) {
        this.adaptor = adaptor;
        this.tableName = tableName;
        this.scan = scan;
        pool.submit(new ScanRunnable());
    }

    public Result next() throws IOException {
        Result result;
        while ((result = (Result)this.resultQueue.poll()) == null) {
            if (this.error) {
                throw new IOException(this.errMsg);
            }
            if (this.scanEnd && this.resultQueue.isEmpty()) {
                LOG.debug("scan end");
                return null;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public void close() {
        this.stop = true;
        try {
            if (this.count != null) {
                this.count.await();
            }
        }
        catch (InterruptedException e) {
            LOG.debug("count wait failed");
        }
    }

    public class ScanRunnable
    implements Runnable {
        @Override
        public void run() {
            block7: {
                TablestorageResultScanner.this.count = new CountDownLatch(1);
                do {
                    ByteArrayOutputStream nextStartRowkeyStream = new ByteArrayOutputStream();
                    List<Object> results = new ArrayList();
                    try {
                        results = TablestorageResultScanner.this.adaptor.scan(TablestorageResultScanner.this.tableName, TablestorageResultScanner.this.scan, TablestorageResultScanner.this.startRowkey, nextStartRowkeyStream);
                    }
                    catch (Exception e) {
                        TablestorageResultScanner.this.error = true;
                        TablestorageResultScanner.this.errMsg = e.getMessage();
                        e.printStackTrace();
                        break block7;
                    }
                    byte[] nextRowkeyBytes = nextStartRowkeyStream.toByteArray();
                    TablestorageResultScanner.this.startRowkey = Bytes.toString((byte[])nextRowkeyBytes);
                    block5: for (Result result : results) {
                        while (!TablestorageResultScanner.this.resultQueue.offer(result)) {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            if (!TablestorageResultScanner.this.stop) continue;
                            TablestorageResultScanner.this.scanEnd = true;
                            continue block5;
                        }
                    }
                } while (TablestorageResultScanner.this.startRowkey != "");
                TablestorageResultScanner.this.scanEnd = true;
            }
            TablestorageResultScanner.this.count.countDown();
        }
    }
}

