/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.vms;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.vms.model.LaunchCallRequest;
import com.baidubce.services.vms.model.LaunchCallResponse;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import java.io.UnsupportedEncodingException;

public class VmsClient
extends AbstractBceClient {
    private static final HttpResponseHandler[] responseHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public VmsClient(BceClientConfiguration config) {
        super(config, responseHandlers, false);
    }

    public LaunchCallResponse launchCall(LaunchCallRequest request) {
        return this.invokeJsonCall(HttpMethodName.POST, "call", request, LaunchCallResponse.class);
    }

    protected <T extends AbstractBceResponse> T invokeJsonCall(HttpMethodName method, String path, Object request, Class<T> responseClass) {
        byte[] body;
        try {
            body = JsonUtils.toJsonString(request).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get UTF-8 bytes", e);
        }
        InternalRequest internalRequest = new InternalRequest(method, HttpUtils.appendUri(this.getEndpoint(), "v1", path));
        internalRequest.setContent(RestartableInputStream.wrap(body));
        internalRequest.addHeader("Content-Type", "application/json");
        internalRequest.addHeader("Content-Length", String.valueOf(body.length));
        return this.invokeHttpClient(internalRequest, responseClass);
    }
}

