/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.dugo;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.dugo.AbstractDuGoRequest;
import com.baidubce.services.dugo.alarm.AlarmBatchRequest;
import com.baidubce.services.dugo.alarm.AlarmCreateRequest;
import com.baidubce.services.dugo.alarm.AlarmDetailsResponse;
import com.baidubce.services.dugo.alarm.AlarmRuleListResponse;
import com.baidubce.services.dugo.alarm.AlarmUpdateRequest;
import com.baidubce.services.dugo.core.protocol.http.BceIotHttpClient;
import com.baidubce.services.dugo.map.CreateFenceRequest;
import com.baidubce.services.dugo.map.CreateFenceResponse;
import com.baidubce.services.dugo.map.DeleteMonitoredVehicleRequest;
import com.baidubce.services.dugo.map.DeviceStatusInfoResponse;
import com.baidubce.services.dugo.map.DrivingBehaviorRequest;
import com.baidubce.services.dugo.map.DrivingBehaviorResponse;
import com.baidubce.services.dugo.map.FenceDetailResponse;
import com.baidubce.services.dugo.map.FenceListResponse;
import com.baidubce.services.dugo.map.FenceMonitoredVehicleRequest;
import com.baidubce.services.dugo.map.GeoCodingRequest;
import com.baidubce.services.dugo.map.GeoCodingResponse;
import com.baidubce.services.dugo.map.GeoDecodingRequest;
import com.baidubce.services.dugo.map.GeoDecodingResponse;
import com.baidubce.services.dugo.map.GetDeviceInfoRequest;
import com.baidubce.services.dugo.map.GetDistanceRequest;
import com.baidubce.services.dugo.map.GetDistanceResponse;
import com.baidubce.services.dugo.map.GetFenceAlarmsResponse;
import com.baidubce.services.dugo.map.GetLatestPointRequest;
import com.baidubce.services.dugo.map.GetLatestPointResponse;
import com.baidubce.services.dugo.map.GetTrackRequest;
import com.baidubce.services.dugo.map.GetTrackResponse;
import com.baidubce.services.dugo.map.MonitoredVehicleListResponse;
import com.baidubce.services.dugo.map.QueryDeviceLogResponse;
import com.baidubce.services.dugo.map.StayPointRequest;
import com.baidubce.services.dugo.map.StayPointResponse;
import com.baidubce.services.dugo.map.UpdateFenceAlarmRequest;
import com.baidubce.services.dugo.map.UpdateFenceRequest;
import com.baidubce.services.dugo.project.ActivateDeviceRequest;
import com.baidubce.services.dugo.project.BatchAddDeviceRequest;
import com.baidubce.services.dugo.project.BatchBindVehicleRequest;
import com.baidubce.services.dugo.project.BatchRemoveDeviceRequest;
import com.baidubce.services.dugo.project.BatchUnbindVehiclesRequest;
import com.baidubce.services.dugo.project.DeviceShadowResponse;
import com.baidubce.services.dugo.project.DownloadAuthInfoResponse;
import com.baidubce.services.dugo.project.GetBatchListResponse;
import com.baidubce.services.dugo.project.GetProjectByIdResponse;
import com.baidubce.services.dugo.project.GetProjectListResponse;
import com.baidubce.services.dugo.project.GroupDeviceShadowResponse;
import com.baidubce.services.dugo.project.QueryDeviceHistoryRequest;
import com.baidubce.services.dugo.project.QueryDeviceHistoryResponse;
import com.baidubce.services.dugo.project.QueryDeviceResponse;
import com.baidubce.services.dugo.project.QueryInstancesByBatchResponse;
import com.baidubce.services.dugo.project.QueryMqttBindResultResponse;
import com.baidubce.services.dugo.project.RandomBindVehiclesRequest;
import com.baidubce.services.dugo.project.UpdateAliasNameRequest;
import com.baidubce.services.dugo.project.UpdateBatchDescRequest;
import com.baidubce.services.dugo.vehicle.GB32960ParamQueryRequest;
import com.baidubce.services.dugo.vehicle.GB32960ParamQueryResponse;
import com.baidubce.services.dugo.vehicle.GB32960ParamSettingRequest;
import com.baidubce.services.dugo.vehicle.GB32960VehicleControlRequest;
import com.baidubce.services.dugo.vehicle.HistoryInfoQueryRequest;
import com.baidubce.services.dugo.vehicle.HistoryInfoQueryResponse;
import com.baidubce.services.dugo.vehicle.QueryMultipleShadowRequest;
import com.baidubce.services.dugo.vehicle.QueryMultipleShadowResponse;
import com.baidubce.services.dugo.vehicle.QuerySingleShadowRequest;
import com.baidubce.services.dugo.vehicle.QuerySingleShadowResponse;
import com.baidubce.services.dugo.vehicle.QueryVehicleStatusRequest;
import com.baidubce.services.dugo.vehicle.QueryVehicleStatusResponse;
import com.baidubce.services.dugo.vehicle.SchemaAttributeNameResponse;
import com.baidubce.services.dugo.vehicle.SchemaDisplayNameResponse;
import com.baidubce.services.dugo.vehicle.ShadowFilterRequest;
import com.baidubce.services.dugo.vehicle.ShadowFilterResponse;
import com.baidubce.services.dugo.vehicle.UploadDynamicDataRequest;
import com.baidubce.services.dugo.vehicle.UploadStaticDataRequest;
import com.baidubce.services.dugo.video.AlarmInfoByTimeRequest;
import com.baidubce.services.dugo.video.AlarmInfoByVehicleIdListRequest;
import com.baidubce.services.dugo.video.AlarmInfoListResponse;
import com.baidubce.services.dugo.video.AlarmVideoInfoByVehicleIdListRequest;
import com.baidubce.services.dugo.video.AlarmVideoInfoByVehicleIdRequest;
import com.baidubce.services.dugo.video.AlarmVideoInfoListResponse;
import com.baidubce.services.dugo.video.FileNameRequest;
import com.baidubce.services.dugo.video.FileUploadResponse;
import com.baidubce.services.dugo.video.GetDownloadUrlResponse;
import com.baidubce.services.dugo.video.GetMediaInfoListResponse;
import com.baidubce.services.dugo.video.GetMediaInfoResponse;
import com.baidubce.services.dugo.video.GetPlayUrlResponse;
import com.baidubce.services.dugo.video.GetTaskStatusResponse;
import com.baidubce.services.dugo.video.MediaInfoByTimeRequest;
import com.baidubce.services.dugo.video.ParameterSettingRequest;
import com.baidubce.services.dugo.video.PlaybackRequest;
import com.baidubce.services.dugo.video.RealTimeRequest;
import com.baidubce.services.dugo.video.TrackAlarmMediaInfoRequest;
import com.baidubce.services.dugo.video.TrackAlarmVideoInfoResponse;
import com.baidubce.services.dugo.video.UploadTaskListRequest;
import com.baidubce.services.dugo.video.UploadTaskListResponse;
import com.baidubce.services.dugo.video.model.RealDataType;
import com.baidubce.services.dugo.video.model.RealStreamType;
import com.baidubce.services.dugo.video.model.VideoType;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DuGoClient
extends AbstractBceClient {
    private static final String ENDPOINT = "https://ivc.gz.baidubce.com";
    private static final String PREFIX_VERSION1 = "/v1/ivc/data";
    private static final String PREFIX_VIDEO_VERSION1 = "/v1/video";
    private static final String PREFIX_REMOTE_DIAGNOSIS_VERSION1 = "/v1/ivc/remote-diagnosis/api";
    private static final String REQUEST = "request";
    private static final String PROJECT_ID = "projectId";
    private static final String BATCH_ID = "batchId";
    private static final String VEHICLE_IDS = "vehicleIds";
    private static final String VEHICLE_ID = "vehicleId";
    private static final String VIN = "vin";
    private static final String ICCID = "iccid";
    private static final String GROUP_ID = "groupId";
    private static final String DEVICE_ID = "deviceId";
    private static final String ALARM_IDS = "alarmIds";
    private static final String ALARM_ID = "alarmId";
    private static final String FENCE_ID = "fenceId";
    private static final String PAGE_NUM = "pageNum";
    private static final String PAGE_NO = "pageNo";
    private static final String PAGE_SIZE = "pageSize";
    private static final String START_TIME = "startTime";
    private static final String END_TIME = "endTime";
    private static final String FILE_NAME = "fileName";
    private static HttpResponseHandler[] handlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public DuGoClient(BceClientConfiguration config) {
        super(StringUtils.isEmpty((CharSequence)config.getEndpoint()) ? config.withEndpoint(ENDPOINT) : config, handlers);
    }

    private InternalRequest buildInternalRequest(String path, HttpMethodName methodName, AbstractDuGoRequest request, Map<String, String> param) {
        BceIotHttpClient client = new BceIotHttpClient();
        client.withAuth(this.config.getCredentials().getAccessKeyId(), this.config.getCredentials().getSecretKey());
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path);
        client.withMethod(methodName, uri);
        if (methodName == HttpMethodName.POST || methodName == HttpMethodName.PUT) {
            client.withPayload(JsonUtils.toJsonString(request).getBytes());
        }
        if (param != null) {
            for (Map.Entry<String, String> entry : param.entrySet()) {
                client.addParams(entry.getKey(), entry.getValue());
            }
        }
        return client.getInternalRequest();
    }

    private InternalRequest buildInternalRequest(String path, HttpMethodName methodName, AbstractDuGoRequest request) {
        return this.buildInternalRequest(path, methodName, request, null);
    }

    public GetProjectListResponse getProjects() {
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/project", HttpMethodName.GET, null);
        return this.invokeHttpClient(internalRequest, GetProjectListResponse.class);
    }

    public GetProjectByIdResponse getProjectById(String projectId) {
        this.isEmptyCheck(projectId, PROJECT_ID);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/project/" + projectId, HttpMethodName.GET, null);
        return this.invokeHttpClient(internalRequest, GetProjectByIdResponse.class);
    }

    public GetBatchListResponse getBatchList(String projectId) {
        this.isEmptyCheck(projectId, PROJECT_ID);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/project/" + projectId + "/batches", HttpMethodName.GET, null);
        return this.invokeHttpClient(internalRequest, GetBatchListResponse.class);
    }

    public QueryInstancesByBatchResponse queryInstanceByBatch(String batchId, Integer pageNum, Integer pageSize) {
        this.isEmptyCheck(batchId, BATCH_ID);
        this.isNullCheck(pageNum, PAGE_NUM);
        this.isNullCheck(pageSize, PAGE_SIZE);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(BATCH_ID, batchId);
        param.put(PAGE_NUM, String.valueOf(pageNum));
        param.put(PAGE_SIZE, String.valueOf(pageSize));
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/vehicle/batch", HttpMethodName.GET, null, param);
        return this.invokeHttpClient(internalRequest, QueryInstancesByBatchResponse.class);
    }

    public void updateBatchDesc(UpdateBatchDescRequest request, String projectId, String batchId) {
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(projectId, PROJECT_ID);
        this.isEmptyCheck(batchId, BATCH_ID);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/project/" + projectId + "/batch/" + batchId, HttpMethodName.PUT, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void bindVehiclesInBatch(BatchBindVehicleRequest request) {
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(request.getBatchId(), BATCH_ID);
        this.isEmptyCheck(request.getVehicleIds(), VEHICLE_IDS);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/vehicle/bind/batch", HttpMethodName.POST, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void bindVehiclesInRandom(RandomBindVehiclesRequest request) {
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(request.getProjectId(), PROJECT_ID);
        this.isEmptyCheck(request.getVehicleIds(), VEHICLE_IDS);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/vehicle/bind", HttpMethodName.POST, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void unbindVehiclesInBatch(BatchUnbindVehiclesRequest request) {
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(request.getProjectId(), PROJECT_ID);
        this.isEmptyCheck(request.getVehicleIds(), VEHICLE_IDS);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/vehicle/unbind", HttpMethodName.POST, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public QueryMqttBindResultResponse queryBindResult(String projectId) {
        this.isEmptyCheck(projectId, PROJECT_ID);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(PROJECT_ID, projectId);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/mqtt/results", HttpMethodName.GET, null, param);
        return this.invokeHttpClient(internalRequest, QueryMqttBindResultResponse.class);
    }

    public DownloadAuthInfoResponse downloadAuthInfo(String downloadUrl) {
        this.isEmptyCheck(downloadUrl, "downloadUrl");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("downloadUrl", downloadUrl);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/mqtt/download", HttpMethodName.GET, null, param);
        return this.invokeHttpClient(internalRequest, DownloadAuthInfoResponse.class);
    }

    public void batchAddDevice(BatchAddDeviceRequest request) {
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(request.getDeviceBindInfoList(), "device info");
        for (BatchAddDeviceRequest.DeviceBindInfo deviceInfo : request.getDeviceBindInfoList()) {
            this.isEmptyCheck(deviceInfo.getPk(), "pk");
            this.isEmptyCheck(deviceInfo.getDn(), "dn");
            this.isEmptyCheck(deviceInfo.getSign(), "sign");
        }
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/device/batchbind", HttpMethodName.POST, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void batchRemoveDevice(BatchRemoveDeviceRequest request) {
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(request.getDeviceIds(), "deviceIds");
        for (String deviceId : request.getDeviceIds()) {
            this.isEmptyCheck(deviceId, DEVICE_ID);
        }
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/device/batchunbind", HttpMethodName.POST, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updateDeviceAlias(String deviceId, UpdateAliasNameRequest request) {
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(deviceId, DEVICE_ID);
        this.isEmptyCheck(request.getAliasName(), "aliasName");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/device/" + deviceId, HttpMethodName.PUT, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void activateDevices(ActivateDeviceRequest request) {
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(request.getDeviceIds(), "deviceIds");
        for (String deviceId : request.getDeviceIds()) {
            this.isEmptyCheck(deviceId, DEVICE_ID);
        }
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/device/activate", HttpMethodName.POST, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public QueryDeviceResponse queryDeviceInfo(String groupId, String deviceId, String aliasName, String pk, String dn, Integer pageNo, Integer pageSize) {
        this.isNullCheck(pageNo, PAGE_NO);
        this.isNullCheck(pageSize, PAGE_SIZE);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(GROUP_ID, groupId);
        params.put(DEVICE_ID, deviceId);
        params.put("aliasName", aliasName);
        params.put("pk", pk);
        params.put("dn", dn);
        params.put(PAGE_NO, String.valueOf(pageNo));
        params.put(PAGE_SIZE, String.valueOf(pageSize));
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/device", HttpMethodName.GET, null, params);
        return this.invokeHttpClient(internalRequest, QueryDeviceResponse.class);
    }

    public DeviceShadowResponse queryDeviceShadow(String deviceId, Boolean needUpdateTime) {
        this.isEmptyCheck(deviceId, DEVICE_ID);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(DEVICE_ID, deviceId);
        params.put("needUpdateTime", String.valueOf(needUpdateTime));
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/device/shadow", HttpMethodName.GET, null, params);
        return this.invokeHttpClient(internalRequest, DeviceShadowResponse.class);
    }

    public GroupDeviceShadowResponse queryGroupDeviceShadow(String groupId, Boolean needUpdateTime, Integer pageNo, Integer pageSize) {
        this.isEmptyCheck(groupId, GROUP_ID);
        this.isNullCheck(pageNo, PAGE_NO);
        this.isNullCheck(pageSize, PAGE_SIZE);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(GROUP_ID, groupId);
        params.put("needUpdateTime", String.valueOf(needUpdateTime));
        params.put(PAGE_NO, String.valueOf(pageNo));
        params.put(PAGE_SIZE, String.valueOf(pageSize));
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/device/shadow/group", HttpMethodName.GET, null, params);
        return this.invokeHttpClient(internalRequest, GroupDeviceShadowResponse.class);
    }

    public QueryDeviceHistoryResponse queryDeviceHistory(QueryDeviceHistoryRequest request) {
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(request.getDeviceId(), DEVICE_ID);
        this.isEmptyCheck(request.getFields(), "fields");
        for (String field : request.getFields()) {
            this.isEmptyCheck(field, "field");
        }
        this.isNullCheck(request.getStart(), "start");
        this.isNullCheck(request.getEnd(), "end");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/device/history", HttpMethodName.POST, request);
        return this.invokeHttpClient(internalRequest, QueryDeviceHistoryResponse.class);
    }

    public QueryDeviceLogResponse queryDeviceLog(String deviceId, String startHour, String endHour) {
        this.isEmptyCheck(deviceId, DEVICE_ID);
        this.isEmptyCheck(startHour, "startHour");
        this.isEmptyCheck(endHour, "endHour");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(DEVICE_ID, deviceId);
        params.put("startHour", startHour);
        params.put("endHour", endHour);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/remote-diagnosis/api/log/release", HttpMethodName.GET, null, params);
        return this.invokeHttpClient(internalRequest, QueryDeviceLogResponse.class);
    }

    public DeviceStatusInfoResponse queryDeviceStatusInfo(String deviceId, GetDeviceInfoRequest request) {
        this.isEmptyCheck(deviceId, DEVICE_ID);
        this.isNullCheck(request.getFields(), "fields");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(DEVICE_ID, deviceId);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/remote-diagnosis/api/info/query", HttpMethodName.POST, request, params);
        return this.invokeHttpClient(internalRequest, DeviceStatusInfoResponse.class);
    }

    public void uploadStaticData(UploadStaticDataRequest request) {
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(request.getVehicleId(), VEHICLE_ID);
        this.isEmptyCheck(request.getData(), "data");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/static/upload", HttpMethodName.POST, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void uploadDynamicData(UploadDynamicDataRequest request) {
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(request.getPoints(), "points");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/data", HttpMethodName.POST, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public QueryVehicleStatusResponse queryVehicleOnlineStatus(QueryVehicleStatusRequest request) {
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(request.getVehicleIds(), VEHICLE_IDS);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/shadow/onlinequery", HttpMethodName.POST, request);
        return this.invokeHttpClient(internalRequest, QueryVehicleStatusResponse.class);
    }

    public QuerySingleShadowResponse querySingleShadow(QuerySingleShadowRequest request) {
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(request.getVehicleId(), VEHICLE_ID);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/shadow/query", HttpMethodName.POST, request);
        return this.invokeHttpClient(internalRequest, QuerySingleShadowResponse.class);
    }

    public QueryMultipleShadowResponse queryMultipleShadow(QueryMultipleShadowRequest request) {
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(request.getVehicleIds(), VEHICLE_IDS);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/shadow/batchquery", HttpMethodName.POST, request);
        return this.invokeHttpClient(internalRequest, QueryMultipleShadowResponse.class);
    }

    public ShadowFilterResponse queryShadowByTag(ShadowFilterRequest request) {
        this.isNullCheck(request, REQUEST);
        this.isNullCheck(request.getPageNo(), PAGE_NUM);
        this.isNullCheck(request.getPageSize(), PAGE_SIZE);
        this.isEmptyCheck(request.getProjectId(), PROJECT_ID);
        this.isEmptyCheck(request.getTags(), "tags");
        this.isEmptyCheck(request.getFields(), "fields");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/shadow/filterquery", HttpMethodName.POST, request);
        return this.invokeHttpClient(internalRequest, ShadowFilterResponse.class);
    }

    public HistoryInfoQueryResponse queryVehicleHistoryData(HistoryInfoQueryRequest request) {
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(request.getVehicleIds(), VEHICLE_IDS);
        this.isNullCheck(request.getStart(), "start");
        this.isNullCheck(request.getEnd(), "end");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/historyinfo/query", HttpMethodName.POST, request);
        return this.invokeHttpClient(internalRequest, HistoryInfoQueryResponse.class);
    }

    public SchemaDisplayNameResponse queryDisplayName(String projectId, String attributeName) {
        this.isEmptyCheck(projectId, PROJECT_ID);
        this.isEmptyCheck(attributeName, "attributeName");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(PROJECT_ID, projectId);
        param.put("attributeName", attributeName);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/schema/displayName", HttpMethodName.GET, null, param);
        return this.invokeHttpClient(internalRequest, SchemaDisplayNameResponse.class);
    }

    public SchemaAttributeNameResponse queryAttributeName(String projectId, String displayName) {
        this.isEmptyCheck(projectId, PROJECT_ID);
        this.isEmptyCheck(displayName, "displayName");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(PROJECT_ID, projectId);
        param.put("displayName", displayName);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/schema/attributeNames", HttpMethodName.GET, null, param);
        return this.invokeHttpClient(internalRequest, SchemaAttributeNameResponse.class);
    }

    public GB32960ParamQueryResponse queryTerminalParams(GB32960ParamQueryRequest request) {
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(request.getVin(), VIN);
        this.isEmptyCheck(request.getIccid(), ICCID);
        this.isEmptyCheck(request.getParamIds(), "paramIds");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/32960/param/query", HttpMethodName.POST, request);
        return this.invokeHttpClient(internalRequest, GB32960ParamQueryResponse.class);
    }

    public void settingTerminalParams(GB32960ParamSettingRequest request) {
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(request.getVin(), VIN);
        this.isEmptyCheck(request.getIccid(), ICCID);
        this.isEmptyCheck(request.getParams(), "params");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/32960/param/setting", HttpMethodName.POST, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void controlVehicleTerminal(GB32960VehicleControlRequest request) {
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(request.getVin(), VIN);
        this.isEmptyCheck(request.getIccid(), ICCID);
        this.isNullCheck(request.getCommandId(), "commandId");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/32960/vehicle/control", HttpMethodName.POST, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void createAlarmRule(String projectId, AlarmCreateRequest request) {
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(projectId, PROJECT_ID);
        this.isEmptyCheck(request.getName(), "name");
        this.isNullCheck(request.getAlarmRule(), "alarmRule");
        this.isNullCheck(request.getAlarmPolicy(), "alarmPolicy");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(PROJECT_ID, projectId);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/alarm", HttpMethodName.POST, request, param);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updateAlarmRule(String projectId, AlarmUpdateRequest request) {
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(projectId, PROJECT_ID);
        this.isEmptyCheck(request.getName(), "name");
        this.isNullCheck(request.getAlarmRule(), "alarmRule");
        this.isNullCheck(request.getAlarmPolicy(), "alarmPolicy");
        this.isEmptyCheck(request.getAlarmId(), ALARM_ID);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(PROJECT_ID, projectId);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/alarm", HttpMethodName.PUT, request, param);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public AlarmDetailsResponse getAlarmRuleDetails(String projectId, String alarmId) {
        this.isEmptyCheck(projectId, PROJECT_ID);
        this.isEmptyCheck(alarmId, ALARM_ID);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(PROJECT_ID, projectId);
        param.put(ALARM_ID, alarmId);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/alarm", HttpMethodName.GET, null, param);
        return this.invokeHttpClient(internalRequest, AlarmDetailsResponse.class);
    }

    public AlarmRuleListResponse getAlarmRuleList(String projectId, Integer pageNum, Integer pageSize) {
        this.isEmptyCheck(projectId, PROJECT_ID);
        this.isNullCheck(pageNum, PAGE_NUM);
        this.isNullCheck(pageSize, PAGE_SIZE);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(PROJECT_ID, projectId);
        param.put(PAGE_NUM, String.valueOf(pageNum));
        param.put(PAGE_SIZE, String.valueOf(pageSize));
        param.put("list", "");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/alarm", HttpMethodName.GET, null, param);
        return this.invokeHttpClient(internalRequest, AlarmRuleListResponse.class);
    }

    public void batchDeleteAlarmRules(String projectId, AlarmBatchRequest request) {
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(projectId, PROJECT_ID);
        this.isEmptyCheck(request.getAlarmIds(), ALARM_IDS);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("delete", "");
        param.put(PROJECT_ID, projectId);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/alarm", HttpMethodName.POST, request, param);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void batchShieldAlarms(AlarmBatchRequest request, String projectId) {
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(projectId, PROJECT_ID);
        this.isEmptyCheck(request.getAlarmIds(), ALARM_IDS);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("shield", "");
        param.put(PROJECT_ID, projectId);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/alarm", HttpMethodName.POST, request, param);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void batchRecoverAlarms(AlarmBatchRequest request, String projectId) {
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(projectId, PROJECT_ID);
        this.isEmptyCheck(request.getAlarmIds(), ALARM_IDS);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("recover", "");
        param.put(PROJECT_ID, projectId);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/alarm", HttpMethodName.POST, request, param);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public GeoCodingResponse geoCoding(GeoCodingRequest request) {
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(request.getAddress(), "address");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/geocoder", HttpMethodName.POST, request);
        return this.invokeHttpClient(internalRequest, GeoCodingResponse.class);
    }

    public GeoDecodingResponse geoDecoding(GeoDecodingRequest request) {
        this.isNullCheck(request, REQUEST);
        this.isNullCheck(request.getLatitude(), "latitude");
        this.isNullCheck(request.getLongitude(), "longitude");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/reversegeocoder", HttpMethodName.POST, request);
        return this.invokeHttpClient(internalRequest, GeoDecodingResponse.class);
    }

    public GetLatestPointResponse getLatestPoint(GetLatestPointRequest request) {
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(request.getVehicleId(), VEHICLE_ID);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/track/getlatestpoint", HttpMethodName.POST, request);
        return this.invokeHttpClient(internalRequest, GetLatestPointResponse.class);
    }

    public GetTrackResponse getTrack(GetTrackRequest request) {
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(request.getVehicleId(), VEHICLE_ID);
        this.isNullCheck(request.getStartTime(), START_TIME);
        this.isNullCheck(request.getEndTime(), END_TIME);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/track/gettrack", HttpMethodName.POST, request);
        return this.invokeHttpClient(internalRequest, GetTrackResponse.class);
    }

    public GetDistanceResponse getDistance(GetDistanceRequest request) {
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(request.getVehicleId(), VEHICLE_ID);
        this.isNullCheck(request.getStartTime(), START_TIME);
        this.isNullCheck(request.getEndTime(), END_TIME);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/track/getdistance", HttpMethodName.POST, request);
        return this.invokeHttpClient(internalRequest, GetDistanceResponse.class);
    }

    public StayPointResponse getStayPoint(StayPointRequest request) {
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(request.getVehicleId(), VEHICLE_ID);
        this.isNullCheck(request.getStartTime(), START_TIME);
        this.isNullCheck(request.getEndTime(), END_TIME);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/analysis/staypoint", HttpMethodName.POST, request);
        return this.invokeHttpClient(internalRequest, StayPointResponse.class);
    }

    public DrivingBehaviorResponse getDrivingBehavior(DrivingBehaviorRequest request) {
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(request.getVehicleId(), VEHICLE_ID);
        this.isNullCheck(request.getStartTime(), START_TIME);
        this.isNullCheck(request.getEndTime(), END_TIME);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/analysis/drivingbehavior", HttpMethodName.POST, request);
        return this.invokeHttpClient(internalRequest, DrivingBehaviorResponse.class);
    }

    public CreateFenceResponse createFence(CreateFenceRequest request) {
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(request.getProjectId(), PROJECT_ID);
        this.isEmptyCheck(request.getFenceName(), "fenceName");
        this.isEmptyCheck(request.getFenceType(), "fenceType");
        this.isNullCheck(request.getFenceParamsOption(), "fenceParamsOption");
        this.isEmptyCheck(request.getCoordType(), "coordType");
        this.isEmptyCheck(request.getMonitoredObjectList(), "monitoredObjectList");
        this.isEmptyCheck(request.getAlertType(), "alertType");
        this.isEmptyCheck(request.getAlertSinkList(), "alertSinkList");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/fence", HttpMethodName.POST, request);
        return this.invokeHttpClient(internalRequest, CreateFenceResponse.class);
    }

    public void updateFence(UpdateFenceRequest request) {
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(request.getProjectId(), PROJECT_ID);
        this.isEmptyCheck(request.getFenceId(), FENCE_ID);
        this.isEmptyCheck(request.getFenceName(), "fenceName");
        this.isNullCheck(request.getFenceParamsOption(), "fenceParamsOption");
        this.isEmptyCheck(request.getCoordType(), "coordType");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/fence", HttpMethodName.PUT, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public FenceDetailResponse getFenceDetail(String projectId, String fenceId) {
        this.isEmptyCheck(projectId, PROJECT_ID);
        this.isEmptyCheck(fenceId, FENCE_ID);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(PROJECT_ID, projectId);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/fence/" + fenceId, HttpMethodName.GET, null, param);
        return this.invokeHttpClient(internalRequest, FenceDetailResponse.class);
    }

    public void deleteFence(String projectId, String fenceId) {
        this.isEmptyCheck(projectId, PROJECT_ID);
        this.isEmptyCheck(fenceId, FENCE_ID);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(PROJECT_ID, projectId);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/fence/" + fenceId, HttpMethodName.DELETE, null, param);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public FenceListResponse getFenceList(String projectId, String fenceName, String vehicleId, Integer pageNum, Integer pageSize) {
        this.isEmptyCheck(projectId, PROJECT_ID);
        this.isNullCheck(pageNum, PAGE_NUM);
        this.isNullCheck(pageSize, PAGE_SIZE);
        Validate.checkIsTrue(pageSize <= 1000, "\u5206\u9875\u53c2\u6570\u4e0d\u5f97\u8d85\u8fc71000");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(PROJECT_ID, projectId);
        param.put("fenceName", fenceName);
        param.put(VEHICLE_ID, vehicleId);
        param.put(PAGE_NUM, String.valueOf(pageNum));
        param.put(PAGE_SIZE, String.valueOf(pageSize));
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/fence", HttpMethodName.GET, null, param);
        return this.invokeHttpClient(internalRequest, FenceListResponse.class);
    }

    public void updateFenceAlarmConfig(UpdateFenceAlarmRequest request) {
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(request.getProjectId(), PROJECT_ID);
        this.isEmptyCheck(request.getFenceId(), FENCE_ID);
        this.isEmptyCheck(request.getAlertType(), "alertType");
        this.isEmptyCheck(request.getAlertSinkList(), "alertSinkList");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/fence/alert", HttpMethodName.PUT, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public GetFenceAlarmsResponse getFenceAlarms(String projectId, String fenceId, Integer pageNum, Integer pageSize, String startTime, String endTime, String vehicleId) {
        this.isEmptyCheck(projectId, PROJECT_ID);
        this.isNullCheck(pageNum, PAGE_NUM);
        this.isNullCheck(pageSize, PAGE_SIZE);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(PROJECT_ID, projectId);
        param.put(PAGE_NUM, String.valueOf(pageNum));
        param.put(PAGE_SIZE, String.valueOf(pageSize));
        param.put(START_TIME, startTime);
        param.put(END_TIME, endTime);
        param.put(VEHICLE_ID, vehicleId);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/fence/" + fenceId + "/alarm", HttpMethodName.GET, null, param);
        return this.invokeHttpClient(internalRequest, GetFenceAlarmsResponse.class);
    }

    public void addMonitoredVehiclesToFence(String fenceId, FenceMonitoredVehicleRequest request) {
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(fenceId, FENCE_ID);
        this.isEmptyCheck(request.getProjectId(), PROJECT_ID);
        this.isEmptyCheck(request.getVehicleDigestList(), "vehicleDigestList");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/fence/" + fenceId + "/vehicle", HttpMethodName.POST, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updateMonitoredVehiclesForFence(String fenceId, FenceMonitoredVehicleRequest request) {
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(fenceId, FENCE_ID);
        this.isEmptyCheck(request.getProjectId(), PROJECT_ID);
        this.isEmptyCheck(request.getVehicleDigestList(), "vehicleDigestList");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/fence/" + fenceId + "/vehicle", HttpMethodName.PUT, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void removeVehiclesFromFence(String fenceId, DeleteMonitoredVehicleRequest request) {
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(fenceId, FENCE_ID);
        this.isEmptyCheck(request.getProjectId(), PROJECT_ID);
        this.isEmptyCheck(request.getVehicleIdList(), "vehicleIdList");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/fence/" + fenceId + "/vehicle/delete", HttpMethodName.POST, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public MonitoredVehicleListResponse getVehiclesInFence(String projectId, String fenceId, Integer pageNum, Integer pageSize, String vehicleId) {
        this.isEmptyCheck(projectId, PROJECT_ID);
        this.isEmptyCheck(fenceId, FENCE_ID);
        this.isNullCheck(pageNum, PAGE_NUM);
        this.isNullCheck(pageSize, PAGE_SIZE);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(PROJECT_ID, projectId);
        param.put(PAGE_NUM, String.valueOf(pageNum));
        param.put(PAGE_SIZE, String.valueOf(pageSize));
        param.put(VEHICLE_ID, vehicleId);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/fence/" + fenceId + "/vehicle", HttpMethodName.GET, null, param);
        return this.invokeHttpClient(internalRequest, MonitoredVehicleListResponse.class);
    }

    public GetPlayUrlResponse realTimePlay(String vehicleId, Integer channel, RealTimeRequest request) {
        this.isEmptyCheck(vehicleId, VEHICLE_ID);
        this.isNullCheck(channel, "channel");
        this.isNullCheck(request, REQUEST);
        this.isEnumValue(request.getDataType(), "dataType", RealDataType.class);
        this.isEnumValue(request.getStreamType(), "streamType", RealStreamType.class);
        this.isEnumValue(request.getVideoType(), "videoType", VideoType.class);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/video/real-time/" + vehicleId + "/" + channel, HttpMethodName.POST, request);
        return this.invokeHttpClient(internalRequest, GetPlayUrlResponse.class);
    }

    public void endRealTimePlay(String vehicleId, Integer channel) {
        this.isEmptyCheck(vehicleId, VEHICLE_ID);
        this.isNullCheck(channel, "channel");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("close", "");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/video/real-time/" + vehicleId + "/" + channel, HttpMethodName.PUT, null, param);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public GetPlayUrlResponse historyPlayback(String vehicleId, PlaybackRequest request) {
        this.isEmptyCheck(vehicleId, VEHICLE_ID);
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(request.getFileName(), FILE_NAME);
        this.isEnumValue(request.getVideoType(), "videoType", VideoType.class);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("open", "");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/video/playback/" + vehicleId, HttpMethodName.POST, request, param);
        return this.invokeHttpClient(internalRequest, GetPlayUrlResponse.class);
    }

    public void endHistoryPlayback(String vehicleId, String fileName) {
        this.isEmptyCheck(vehicleId, VEHICLE_ID);
        this.isEmptyCheck(fileName, FILE_NAME);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(FILE_NAME, fileName);
        param.put("close", "");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/video/playback/" + vehicleId, HttpMethodName.PUT, null, param);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public FileUploadResponse videoUploadByName(String vehicleId, FileNameRequest request) {
        this.isEmptyCheck(vehicleId, VEHICLE_ID);
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(request.getFileName(), FILE_NAME);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("name", "");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/video/upload/" + vehicleId, HttpMethodName.POST, request, param);
        return this.invokeHttpClient(internalRequest, FileUploadResponse.class);
    }

    public void videoUploadCancel(String taskUuid) {
        this.isEmptyCheck(taskUuid, "taskUuid");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("cancel", "");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/video/upload/tasks/" + taskUuid, HttpMethodName.PUT, null, param);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public GetTaskStatusResponse getTaskStatus(String taskUuid) {
        this.isEmptyCheck(taskUuid, "taskUuid");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("status", "");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/video/playback/tasks/" + taskUuid, HttpMethodName.GET, null, param);
        return this.invokeHttpClient(internalRequest, GetTaskStatusResponse.class);
    }

    public UploadTaskListResponse getUploadTaskList(Integer pageNum, Integer pageSize, UploadTaskListRequest request) {
        this.isNullCheck(pageNum, PAGE_NUM);
        this.isNullCheck(pageSize, PAGE_SIZE);
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(request.getVehicleId(), VEHICLE_ID);
        this.isNullCheck(request.getStartTime(), START_TIME);
        this.isNullCheck(request.getEndTime(), END_TIME);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(PAGE_NUM, String.valueOf(pageNum));
        param.put(PAGE_SIZE, String.valueOf(pageSize));
        InternalRequest internalRequest = this.buildInternalRequest("/v1/video/query/upload/tasks", HttpMethodName.POST, request, param);
        return this.invokeHttpClient(internalRequest, UploadTaskListResponse.class);
    }

    public GetPlayUrlResponse getPlayUrlByTask(String taskUuid) {
        this.isEmptyCheck(taskUuid, "taskUuid");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("url", "");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/video/playback/tasks/" + taskUuid, HttpMethodName.GET, null, param);
        return this.invokeHttpClient(internalRequest, GetPlayUrlResponse.class);
    }

    public GetPlayUrlResponse getPlayUrlByName(String vehicleId, FileNameRequest request) {
        this.isEmptyCheck(vehicleId, VEHICLE_ID);
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(request.getFileName(), FILE_NAME);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("name", "");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/video/playback/" + vehicleId, HttpMethodName.POST, request, param);
        return this.invokeHttpClient(internalRequest, GetPlayUrlResponse.class);
    }

    public GetDownloadUrlResponse getVideoDownloadUrl(String vehicleId, FileNameRequest request) {
        this.isEmptyCheck(vehicleId, VEHICLE_ID);
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(request.getFileName(), FILE_NAME);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("video", "");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/video/download/" + vehicleId, HttpMethodName.POST, request, param);
        return this.invokeHttpClient(internalRequest, GetDownloadUrlResponse.class);
    }

    public GetDownloadUrlResponse getImageDownloadUrl(String vehicleId, FileNameRequest request) {
        this.isEmptyCheck(vehicleId, VEHICLE_ID);
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(request.getFileName(), FILE_NAME);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("image", "");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/video/download/" + vehicleId, HttpMethodName.POST, request, param);
        return this.invokeHttpClient(internalRequest, GetDownloadUrlResponse.class);
    }

    public void setParam(String vehicleId, ParameterSettingRequest request) {
        this.isEmptyCheck(vehicleId, VEHICLE_ID);
        this.isNullCheck(request, REQUEST);
        this.isMatchPattern(request.getParamHex(), "paramHex", "^[A-Fa-f0-9]{1,210}$");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/video/param-setting/" + vehicleId, HttpMethodName.PUT, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public GetMediaInfoListResponse getVideoInfoByTime(String vehicleId, MediaInfoByTimeRequest request) {
        this.isEmptyCheck(vehicleId, VEHICLE_ID);
        this.isNullCheck(request, REQUEST);
        this.isNullCheck(request.getStartTime(), START_TIME);
        this.isNullCheck(request.getEndTime(), END_TIME);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/video/query/media/" + vehicleId, HttpMethodName.POST, request);
        return this.invokeHttpClient(internalRequest, GetMediaInfoListResponse.class);
    }

    public GetMediaInfoResponse getMediaInfoByFileName(String vehicleId, String fileName) {
        this.isEmptyCheck(vehicleId, VEHICLE_ID);
        this.isEmptyCheck(fileName, FILE_NAME);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(FILE_NAME, fileName);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/video/query/media/" + vehicleId + "/filename", HttpMethodName.GET, null, param);
        return this.invokeHttpClient(internalRequest, GetMediaInfoResponse.class);
    }

    public GetMediaInfoListResponse getMediaInfoByAlarmUuid(String alarmUuid) {
        this.isEmptyCheck(alarmUuid, "alarmUuid");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("alarmUuid", alarmUuid);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/video/query/media/alarm-uuid", HttpMethodName.GET, null, param);
        return this.invokeHttpClient(internalRequest, GetMediaInfoListResponse.class);
    }

    public GetMediaInfoListResponse getMediaInfoByAlarmRefKey(String vehicleId, String alarmRefKey) {
        this.isEmptyCheck(vehicleId, VEHICLE_ID);
        this.isEmptyCheck(alarmRefKey, "alarmRefKey");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("alarmRefKey", alarmRefKey);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/video/query/media/" + vehicleId + "/alarm-ref-key", HttpMethodName.GET, null, param);
        return this.invokeHttpClient(internalRequest, GetMediaInfoListResponse.class);
    }

    public AlarmInfoListResponse getAlarmInfoByVehicleIdList(AlarmInfoByVehicleIdListRequest request) {
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(request.getVehicleIdList(), "vehicleIdList");
        this.isNullCheck(request.getStartTime(), START_TIME);
        this.isNullCheck(request.getEndTime(), END_TIME);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("id", "");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/video/query/alarm", HttpMethodName.POST, request, param);
        return this.invokeHttpClient(internalRequest, AlarmInfoListResponse.class);
    }

    public AlarmInfoListResponse getAlarmInfoByTime(AlarmInfoByTimeRequest request) {
        this.isNullCheck(request, REQUEST);
        this.isNullCheck(request.getStartTime(), START_TIME);
        this.isNullCheck(request.getEndTime(), END_TIME);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("time", "");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/video/query/alarm", HttpMethodName.POST, request, param);
        return this.invokeHttpClient(internalRequest, AlarmInfoListResponse.class);
    }

    public AlarmVideoInfoListResponse getAlarmVideoInfoByVehicleId(AlarmVideoInfoByVehicleIdRequest request) {
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(request.getVehicleId(), VEHICLE_ID);
        this.isNullCheck(request.getStartTime(), START_TIME);
        this.isNullCheck(request.getEndTime(), END_TIME);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("id", "");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/video/query/alarm/video", HttpMethodName.POST, request, param);
        return this.invokeHttpClient(internalRequest, AlarmVideoInfoListResponse.class);
    }

    public AlarmVideoInfoListResponse getAlarmVideoInfoByVehicleIdList(AlarmVideoInfoByVehicleIdListRequest request) {
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(request.getVehicleIdList(), "vehicleIdList");
        this.isNullCheck(request.getStartTime(), START_TIME);
        this.isNullCheck(request.getEndTime(), END_TIME);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("ids", "");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/video/query/alarm/video", HttpMethodName.POST, request, param);
        return this.invokeHttpClient(internalRequest, AlarmVideoInfoListResponse.class);
    }

    public TrackAlarmVideoInfoResponse getTrackAlarmMediaInfoListByVehicleId(TrackAlarmMediaInfoRequest request) {
        this.isNullCheck(request, REQUEST);
        this.isEmptyCheck(request.getVehicleId(), VEHICLE_ID);
        this.isNullCheck(request.getStartTime(), START_TIME);
        this.isNullCheck(request.getEndTime(), END_TIME);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("id", "");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/video/query/track", HttpMethodName.POST, request, param);
        return this.invokeHttpClient(internalRequest, TrackAlarmVideoInfoResponse.class);
    }

    private void isEmptyCheck(String keyValue, String keyName) {
        Validate.checkStringNotEmpty(keyValue, keyName + " should not be empty");
    }

    private void isEmptyCheck(List keyValues, String keyName) {
        this.isNullCheck(keyValues, keyName);
        Validate.checkIsTrue(!keyValues.isEmpty(), keyName + " should not be empty");
    }

    private void isEmptyCheck(Map keyValues, String keyName) {
        this.isNullCheck(keyValues, keyName);
        Validate.checkIsTrue(!keyValues.isEmpty(), keyName + " should not be empty");
    }

    private void isNullCheck(Object keyValue, String keyName) {
        Validate.checkNotNull(keyValue, keyName + " should not be null");
    }

    private void isMatchPattern(String keyValue, String keyName, String pattern) {
        Validate.checkPattern(keyValue, pattern, keyName + " format should be " + pattern);
    }

    private void isEnumValue(String keyValue, String keyName, Class<?> enumCls) {
        Validate.checkValidValue(keyValue, enumCls, "the value of " + keyName + " is not valid");
    }
}

