/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.tsdb.model;

import com.baidubce.services.tsdb.model.FieldFilter;
import com.baidubce.services.tsdb.model.TagFilter;
import com.baidubce.services.tsdb.model.ValueFilter;
import com.baidubce.util.JsonUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Filters {
    private JsonNode start;
    private JsonNode end;
    @JsonIgnore
    private Map<String, List<String>> tags;
    @JsonIgnore
    private List<TagFilter> tagFilters;
    private String value;
    private List<FieldFilter> fields;
    private List<Filters> or;

    public JsonNode getStart() {
        return this.start;
    }

    public void setStart(JsonNode start) {
        this.start = start;
    }

    public JsonNode getEnd() {
        return this.end;
    }

    public void setEnd(JsonNode end) {
        this.end = end;
    }

    @JsonIgnore
    public Map<String, List<String>> getTags() {
        return this.tags;
    }

    @JsonIgnore
    public void setTags(Map<String, List<String>> tags) {
        this.tagFilters = null;
        this.tags = tags;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public List<FieldFilter> getFields() {
        return this.fields;
    }

    public void setFields(List<FieldFilter> fields) {
        this.fields = fields;
    }

    public List<Filters> getOr() {
        return this.or;
    }

    public void setOr(List<Filters> or) {
        this.or = or;
    }

    @JsonIgnore
    public List<TagFilter> getTagFilters() {
        return this.tagFilters;
    }

    @JsonIgnore
    public void setTagFilters(List<TagFilter> tagFilters) {
        this.tags = null;
        this.tagFilters = tagFilters;
    }

    @JsonProperty(value="tags")
    public JsonNode getTagsJsonNode() {
        if (this.tagFilters != null) {
            return JsonUtils.getObjectMapper().valueToTree(this.tagFilters);
        }
        return JsonUtils.getObjectMapper().valueToTree(this.tags);
    }

    @JsonProperty(value="tags")
    public void setTagsJsonNode(JsonNode tags) throws JsonProcessingException {
        if (tags.isArray()) {
            TypeReference<List<TagFilter>> type = new TypeReference<List<TagFilter>>(){};
            this.tagFilters = (List)JsonUtils.getObjectMapper().convertValue((Object)tags, (TypeReference)type);
        } else {
            TypeReference<Map<String, List<String>>> type = new TypeReference<Map<String, List<String>>>(){};
            this.tags = (Map)JsonUtils.getObjectMapper().convertValue((Object)tags, (TypeReference)type);
        }
    }

    public Filters withTagFilters(List<TagFilter> tagFilters) {
        this.tags = null;
        this.tagFilters = tagFilters;
        return this;
    }

    public Filters addTagFilter(TagFilter tagFilter) {
        if (this.tagFilters == null) {
            this.tags = null;
            this.tagFilters = new ArrayList<TagFilter>();
        }
        this.tagFilters.add(tagFilter);
        return this;
    }

    public Filters withValue(ValueFilter value) {
        this.value = value.getOperation() + " " + value.getValue();
        return this;
    }

    public Filters withValue(String value) {
        this.value = value;
        return this;
    }

    public Filters withFields(List<FieldFilter> fields) {
        this.fields = fields;
        return this;
    }

    public Filters withAbsoluteStart(long start) {
        this.start = new LongNode(start);
        return this;
    }

    public Filters withRelativeStart(String start) {
        this.start = new TextNode(start);
        return this;
    }

    public Filters withAbsoluteEnd(long end) {
        this.end = new LongNode(end);
        return this;
    }

    public Filters withRelativeEnd(String end) {
        this.end = new TextNode(end);
        return this;
    }

    public Filters withTags(Map<String, List<String>> tags) {
        this.tagFilters = null;
        this.tags = tags;
        return this;
    }

    public Filters addField(FieldFilter field) {
        this.initialFields();
        this.fields.add(field);
        return this;
    }

    public Filters addField(String field, String value) {
        this.initialFields();
        this.fields.add(new FieldFilter(field, value));
        return this;
    }

    public Filters addTag(String tagKey, List<String> tagValues) {
        this.addTags(tagKey, tagValues);
        return this;
    }

    public Filters addTag(String tagKey, String ... tagValues) {
        this.addTags(tagKey, tagValues);
        return this;
    }

    public Filters withOr(List<Filters> or) {
        this.emptyOtherFields();
        this.or = or;
        return this;
    }

    public Filters addOr(Filters or) {
        this.emptyOtherFields();
        this.initialOr();
        this.or.add(or);
        return this;
    }

    private void addTags(String tagKey, List<String> tagValues) {
        this.initialTags();
        if (this.tags.containsKey(tagKey)) {
            this.tags.get(tagKey).addAll(tagValues);
        } else {
            this.tags.put(tagKey, Lists.newArrayList(tagValues));
        }
    }

    private void addTags(String tagKey, String ... tagValues) {
        this.initialTags();
        if (this.tags.containsKey(tagKey)) {
            for (String tagValue : tagValues) {
                this.tags.get(tagKey).add(tagValue);
            }
        } else {
            this.tags.put(tagKey, Lists.newArrayList((Object[])tagValues));
        }
    }

    private void initialTags() {
        if (this.tags == null) {
            this.tagFilters = null;
            this.tags = Maps.newHashMap();
        }
    }

    private void initialFields() {
        if (this.fields == null) {
            this.fields = new ArrayList<FieldFilter>();
        }
    }

    private void initialOr() {
        if (this.or == null) {
            this.or = new ArrayList<Filters>();
        }
    }

    private void emptyOtherFields() {
        this.start = null;
        this.end = null;
        this.tags = null;
        this.value = null;
        this.fields = null;
    }
}

