/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dataConvertion.accessor;

import dm.jdbc.dataConvertion.accessor.BaseAccessor;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.util.StringUtil;
import dm.sql.DmdbSQLInput;
import dm.sql.STRUCT;
import dm.sql.TypeData;
import dm.sql.TypeDescriptor;
import java.sql.Array;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComplexTypeAccessor
extends BaseAccessor {
    private TypeDescriptor typeDesc;

    public ComplexTypeAccessor(TypeDescriptor typeDesc) {
        this.typeDesc = typeDesc;
    }

    @Override
    public Object getObjectInner(Map<String, Class<?>> typeMap) throws SQLException {
        this.getByteArrayValue();
        if (this.wasNull) {
            return null;
        }
        if (this.typeDesc == null) {
            DBError.throwSQLException(6007);
        }
        Object ret = null;
        switch (this.dtype) {
            case 119: {
                ret = TypeData.bytesToObj(this.dataBuffer, null, this.typeDesc);
                break;
            }
            case 121: {
                ret = TypeData.bytesToRecord(this.dataBuffer, null, this.typeDesc);
                break;
            }
            case 117: {
                ret = TypeData.bytesToArray(this.dataBuffer, null, this.typeDesc);
                break;
            }
            case 122: {
                ret = TypeData.bytesToSArray(this.dataBuffer, null, this.typeDesc);
            }
        }
        if (typeMap != null && ret instanceof STRUCT && StringUtil.isNotEmpty(this.registTypeName)) {
            return ComplexTypeAccessor.getStruct_SQLData(typeMap, (STRUCT)ret, this.registTypeName);
        }
        return ret;
    }

    @Override
    public Array getArray() throws SQLException {
        Object result = this.getObjectInner(null);
        if (this.wasNull) {
            return null;
        }
        if (result instanceof Array) {
            return (Array)result;
        }
        DBError.throwSQLException(6007);
        return null;
    }

    @Override
    public Struct getStruct() throws SQLException {
        Object result = this.getObjectInner(null);
        if (this.wasNull) {
            return null;
        }
        if (result instanceof Struct) {
            return (Struct)result;
        }
        DBError.throwSQLException(6007);
        return null;
    }

    @Override
    public String getString() throws SQLException {
        Object result = this.getObjectInner(null);
        if (this.wasNull) {
            return null;
        }
        return result.toString();
    }

    public static Object getStruct_SQLData(Map<String, Class<?>> typeMap, STRUCT struct, String typeName) throws SQLException {
        if (typeMap == null || typeMap.size() == 0) {
            return struct;
        }
        Class<?> cls = typeMap.get(typeName);
        if (cls != null) {
            try {
                Object obj = cls.newInstance();
                DmdbSQLInput stream = new DmdbSQLInput(typeMap, struct.getAttributes(typeMap));
                ((SQLData)obj).readSQL(stream, typeName);
                return obj;
            }
            catch (Exception exception) {
                DBError.throwSQLException(6007);
            }
        }
        return struct;
    }
}

