/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dataConvertion.accessor;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dataConvertion.accessor.BaseAccessor;
import dm.jdbc.dbaccess.Const;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.driver.DmdbType;
import dm.sql.DmdbTimestamp;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatetimeAccessor
extends BaseAccessor {
    Calendar calendar = Calendar.getInstance();
    int[] dt = new int[8];
    boolean isBdta = false;

    public DatetimeAccessor(boolean isBdta) {
        this.isBdta = isBdta;
    }

    @Override
    public Date getDate() throws SQLException {
        this.getByteArrayValue();
        if (this.wasNull) {
            return null;
        }
        this.decode(this.dataBuffer, this.isBdta);
        if (DmdbType.isLocalTimeZone(this.dtype, this.scale)) {
            DatetimeAccessor.transitTZ(this.dt, this.dbTimezone, this.localTimezone);
        }
        return new Date(DmdbTimestamp.toTimeInMillis(this.dt, this.calendar));
    }

    @Override
    public Time getTime() throws SQLException {
        this.getByteArrayValue();
        if (this.wasNull) {
            return null;
        }
        this.decode(this.dataBuffer, this.isBdta);
        if (DmdbType.isLocalTimeZone(this.dtype, this.scale)) {
            DatetimeAccessor.transitTZ(this.dt, this.dbTimezone, this.localTimezone);
        }
        return new Time(DmdbTimestamp.toTimeInMillis(this.dt, this.calendar));
    }

    @Override
    public Timestamp getTimestamp() throws SQLException {
        this.getByteArrayValue();
        if (this.wasNull) {
            return null;
        }
        this.decode(this.dataBuffer, this.isBdta);
        if (DmdbType.isLocalTimeZone(this.dtype, this.scale)) {
            DatetimeAccessor.transitTZ(this.dt, this.dbTimezone, this.localTimezone);
        }
        Timestamp ts = new Timestamp(DmdbTimestamp.toTimeInMillis(this.dt, this.calendar));
        ts.setNanos(this.dt[6] * 1000);
        return ts;
    }

    @Override
    public DmdbTimestamp getDmdbTimestamp() throws SQLException {
        this.getByteArrayValue();
        if (this.wasNull) {
            return null;
        }
        if (DmdbType.isLocalTimeZone(this.dtype, this.scale)) {
            this.decode(this.dataBuffer, this.isBdta);
            DatetimeAccessor.transitTZ(this.dt, this.dbTimezone, this.localTimezone);
            int[] retDt = new int[this.dt.length];
            System.arraycopy(this.dt, 0, retDt, 0, this.dt.length);
            return new DmdbTimestamp(retDt, this.dtype, this.scale);
        }
        this.decode(this.dataBuffer, this.isBdta);
        int[] retDt = new int[this.dt.length];
        System.arraycopy(this.dt, 0, retDt, 0, this.dt.length);
        return new DmdbTimestamp(retDt, this.dtype, this.scale);
    }

    @Override
    public String getString() throws SQLException {
        this.getByteArrayValue();
        if (this.wasNull) {
            return null;
        }
        this.decode(this.dataBuffer, this.isBdta);
        if (DmdbType.isLocalTimeZone(this.dtype, this.scale)) {
            DatetimeAccessor.transitTZ(this.dt, this.dbTimezone, this.localTimezone);
        }
        return DmdbTimestamp.toString(this.dt, this.dtype, this.scale);
    }

    @Override
    public Object getObjectInner(Map<String, Class<?>> typeMap) throws SQLException {
        switch (this.dtype) {
            case 14: {
                return this.getDate();
            }
            case 15: {
                return this.getTime();
            }
            case 16: {
                return this.getTimestamp();
            }
        }
        return this.getDmdbTimestamp();
    }

    public int[] decode(byte[] value, boolean isBdta) {
        if (isBdta) {
            return this.dmdtDecodeBdta(value);
        }
        return this.dmdtDecodeFast(value);
    }

    int[] dmdtDecodeFast(byte[] value) {
        this.dt[7] = Integer.MIN_VALUE;
        if (value.length == 3) {
            this.dt[0] = Convertion.getShort(value, 0) & Short.MAX_VALUE;
            if (this.dt[0] > 9999) {
                this.dt[0] = (short)((short)this.dt[0] | 0x8000);
            }
            this.dt[1] = (value[1] >> 7 & 1) + ((value[2] & 7) << 1);
            this.dt[2] = (value[2] & 0xF8) >> 3 & 0x1F;
        } else if (value.length < 8) {
            this.dt[3] = (short)(value[0] & 0x1F);
            this.dt[4] = (short)((value[0] >> 5 & 7) + ((value[1] & 7) << 3));
            this.dt[5] = (short)((value[1] >> 3 & 0x1F) + ((value[2] & 1) << 5));
            this.dt[6] = (value[2] >> 1 & 0x7F) + ((value[3] & 0xFF) << 7) + ((value[4] & 0x1F) << 15);
            if (value.length > 5) {
                this.dt[7] = Convertion.getShort(value, 5);
            }
        } else {
            this.dt[0] = Convertion.getShort(value, 0) & Short.MAX_VALUE;
            if (this.dt[0] > 9999) {
                this.dt[0] = (short)((short)this.dt[0] | 0x8000);
            }
            this.dt[1] = (value[1] >> 7 & 1) + ((value[2] & 7) << 1);
            this.dt[2] = (value[2] & 0xF8) >> 3 & 0x1F;
            this.dt[3] = value[3] & 0x1F;
            this.dt[4] = (value[3] >> 5 & 7) + ((value[4] & 7) << 3);
            this.dt[5] = (value[4] >> 3 & 0x1F) + ((value[5] & 1) << 5);
            this.dt[6] = (value[5] >> 1 & 0x7F) + ((value[6] & 0xFF) << 7) + ((value[7] & 0x1F) << 15);
            if (value.length > 8) {
                this.dt[7] = Convertion.getShort(value, 8);
            }
        }
        return this.dt;
    }

    int[] dmdtDecodeBdta(byte[] value) {
        this.dt[0] = Convertion.getShort(value, 0);
        this.dt[1] = (short)(value[2] & 0xFF);
        this.dt[2] = (short)(value[3] & 0xFF);
        this.dt[3] = (short)(value[4] & 0xFF);
        this.dt[4] = (short)(value[5] & 0xFF);
        this.dt[5] = (short)(value[6] & 0xFF);
        this.dt[6] = (value[7] & 0xFF) + (value[8] << 8) + (value[9] << 16);
        this.dt[7] = Convertion.getShort(value, 10);
        return this.dt;
    }

    public static void transitTZ(int[] dt, int defaultSrcTz, int destTz) throws SQLException {
        int srcTz = defaultSrcTz;
        if (dt[7] != Integer.MIN_VALUE) {
            srcTz = dt[7];
        }
        if (destTz != srcTz) {
            DatetimeAccessor.dmdtAddByFmt(dt, 5, destTz - srcTz);
            if (dt[7] != Integer.MIN_VALUE) {
                dt[7] = destTz;
            }
        }
    }

    static int[] dmdtAddByFmt(int[] dt, int fmt, int n) throws SQLException {
        if (dt == null) {
            DBError.throwSQLException(-2512);
        }
        int year = dt[0];
        int month = dt[1];
        int day = dt[2];
        int hour = dt[3];
        int min = dt[4];
        int sec = dt[5];
        int msec = dt[6];
        short tz = (short)dt[7];
        int[] rets = null;
        switch (fmt) {
            case 1: {
                year += n;
                break;
            }
            case 8: {
                n *= 3;
            }
            case 2: {
                year += (month += n) / 12;
                if ((month %= 12) < 1) {
                    month += 12;
                    --year;
                }
                if (day <= Const.global_day_by_month[month]) break;
                day = Const.global_day_by_month[month];
                if (month != 2 || !DmdbTimestamp.dmdt_is_leap_year(year)) break;
                ++day;
                break;
            }
            case 7: {
                msec = msec / 1000 + n;
                n = msec / 1000;
                msec %= 1000;
                while (msec < 0) {
                    msec += 1000;
                    --n;
                }
                msec *= 1000;
                if (n == 0) break;
            }
            case 6: {
                int tmp = sec + n;
                n = tmp / 60;
                sec = tmp % 60;
                if (sec < 0) {
                    sec += 60;
                    --n;
                }
                if (n == 0) break;
            }
            case 5: {
                int tmp = min + n;
                n = tmp / 60;
                min = tmp % 60;
                if (min < 0) {
                    min += 60;
                    --n;
                }
                if (n == 0) break;
            }
            case 4: {
                int tmp = hour + n;
                n = tmp / 24;
                hour = tmp % 24;
                if (hour < 0) {
                    hour += 24;
                    --n;
                }
                if (n == 0) break;
            }
            case 3: 
            case 9: {
                rets = DatetimeAccessor.dmdtDateAdd(year, month, day, n);
                year = rets[0];
                month = rets[1];
                day = rets[2];
                break;
            }
            case 10: {
                rets = DatetimeAccessor.dmdtDateAdd(year, month, day, n * 7);
                year = rets[0];
                month = rets[1];
                day = rets[2];
                break;
            }
        }
        if (year > 9999) {
            DBError.throwSQLException(-2512);
        }
        dt[0] = year;
        dt[1] = month;
        dt[2] = day;
        dt[3] = hour;
        dt[4] = min;
        dt[5] = sec;
        dt[6] = msec;
        dt[7] = tz;
        return dt;
    }

    static int[] dmdtDateAdd(int year, int month, int day, int n) {
        int ndays = DatetimeAccessor.dmdt_calc_n_days_from_zero(year, month, day);
        return DatetimeAccessor.dmdt_get_date_by_ndays_from_zero(ndays += n);
    }

    static int dmdt_calc_n_days_from_zero(int year, int month, int day) {
        if (year <= 0 && month <= 0 && day <= 0) {
            return 0;
        }
        int ndays = year * 365 + Const.global_days_befor_month[month - 1] + day;
        if (month <= 2) {
            --year;
        }
        int leap_days = year / 4 - year / 100 + year / 400;
        return ndays += leap_days;
    }

    static int[] dmdt_get_date_by_ndays_from_zero(int ndays) {
        int[] retVals = new int[3];
        if (ndays <= 365 || ndays > 3652424) {
            retVals[2] = 99;
            retVals[1] = 99;
            retVals[0] = 99;
            return retVals;
        }
        int year = ndays * 100 / 36525;
        int tmp = ((year - 1) / 100 + 1) * 3 / 4;
        int days_left = ndays - year * 365 - (year - 1) / 4 + tmp;
        int days_in_year = DmdbTimestamp.dmdt_is_leap_year(year) ? 366 : 365;
        while (days_left > days_in_year) {
            days_left -= days_in_year;
            int n = days_in_year = DmdbTimestamp.dmdt_is_leap_year(++year) ? 366 : 365;
        }
        if (days_in_year == 366 && days_left > 59 && --days_left == 59) {
            retVals[0] = year;
            retVals[1] = 2;
            retVals[2] = 29;
            return retVals;
        }
        int month = 1;
        while (days_left > Const.global_day_by_month[month]) {
            days_left -= Const.global_day_by_month[month];
            ++month;
        }
        retVals[0] = year;
        retVals[1] = month;
        retVals[2] = days_left;
        return retVals;
    }
}

