/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.processor;

import dm.jdbc.dbaccess.DbAccessPure;
import dm.jdbc.desc.DmSvcConf;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.processor.BaseThread;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBAliveCheckThread
extends BaseThread {
    private List<DmdbConnection_bs> connList = new ArrayList<DmdbConnection_bs>();

    private DBAliveCheckThread() {
        super("DB-ALIVE-CHECK-THREAD");
    }

    public static DBAliveCheckThread getInstance() {
        return DBAliveCheckThreadHolder.dbAliveCheckThread;
    }

    public synchronized void addConnection(DmdbConnection_bs conn) {
        this.connList.add(conn);
    }

    public synchronized void removeConnection(DmdbConnection_bs conn) {
        this.connList.remove(conn);
    }

    public synchronized void removeConnection(List<DmdbConnection_bs> connList) {
        this.connList.removeAll(connList);
    }

    public synchronized List<DmdbConnection_bs> copyConnList() {
        ArrayList<DmdbConnection_bs> connList = new ArrayList<DmdbConnection_bs>(this.connList.size());
        for (DmdbConnection_bs conn : this.connList) {
            connList.add(conn);
        }
        return connList;
    }

    @Override
    public void run() {
        HashMap dbStatMap = new HashMap();
        ArrayList<DmdbConnection_bs> removeList = new ArrayList<DmdbConnection_bs>();
        while (true) {
            try {
                while (true) {
                    dbStatMap.clear();
                    removeList.clear();
                    List<DmdbConnection_bs> connList = this.copyConnList();
                    for (DmdbConnection_bs conn : connList) {
                        DbAccessPure primaryAccessPure = conn.getDbAccess().getAccessPrimary();
                        String url = String.valueOf(primaryAccessPure.getHostName()) + ":" + primaryAccessPure.getPortNumber();
                        Boolean alive = (Boolean)dbStatMap.get(url);
                        if (alive == null) {
                            alive = this.checkDbAlive(primaryAccessPure.getHostName(), primaryAccessPure.getPortNumber());
                        }
                        if (!alive.booleanValue()) {
                            conn.forceClose(1);
                            removeList.add(conn);
                        } else if (!conn.getRwSeparate() || conn.getDbAccess().isStandbyAlive()) {
                            // empty if block
                        }
                        DbAccessPure standbyAccessPure = conn.getDbAccess().getAccessStandby();
                        url = String.valueOf(standbyAccessPure.getHostName()) + ":" + standbyAccessPure.getPortNumber();
                        alive = (Boolean)dbStatMap.get(url);
                        if (alive == null) {
                            alive = this.checkDbAlive(standbyAccessPure.getHostName(), standbyAccessPure.getPortNumber());
                        }
                        if (alive.booleanValue()) continue;
                        conn.forceClose(0);
                    }
                    if (removeList.size() != 0) {
                        this.removeConnection(removeList);
                    }
                    Thread.sleep(DmSvcConf.dbAliveCheckFreq);
                }
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    private boolean checkDbAlive(String host, int port) {
        boolean alive;
        block14: {
            alive = false;
            Socket socket = null;
            try {
                try {
                    socket = new Socket();
                    InetSocketAddress socketAddress = new InetSocketAddress(host, port);
                    socket.connect(socketAddress, 10000);
                    alive = true;
                    socket.close();
                }
                catch (Exception exception) {
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (Exception exception2) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception exception) {}
            }
        }
        return alive;
    }

    /* synthetic */ DBAliveCheckThread(DBAliveCheckThread dBAliveCheckThread) {
        this();
    }

    private static class DBAliveCheckThreadHolder {
        public static DBAliveCheckThread dbAliveCheckThread = null;

        static {
            if (DmSvcConf.dbAliveCheckFreq > 0) {
                dbAliveCheckThread = new DBAliveCheckThread(null);
                dbAliveCheckThread.start();
            }
        }

        private DBAliveCheckThreadHolder() {
        }
    }
}

