/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import java.util.NoSuchElementException;

public class List {
    private Node Head = null;
    private Node Tail = null;
    private Node Pointer = null;
    private int Length = 0;

    public void deleteAll() {
        this.Head = null;
        this.Tail = null;
        this.Pointer = null;
        this.Length = 0;
    }

    public Object getHead() {
        return this.Head.data;
    }

    public Object getTail() {
        return this.Tail.data;
    }

    public Node getTailNode() {
        return this.Tail;
    }

    public void reset() {
        this.Pointer = null;
    }

    public boolean isEmpty() {
        return this.Length == 0;
    }

    public boolean isEnd() {
        if (this.Length == 0) {
            throw new NullPointerException();
        }
        if (this.Length == 1) {
            return true;
        }
        return this.cursor() == this.Tail;
    }

    public boolean hasNextObject() {
        if (this.Length == 1 || this.Length == 0) {
            return false;
        }
        Node temp = this.cursor();
        return temp != this.Tail;
    }

    public Object nextNode() {
        Node temp;
        if (this.Length == 1) {
            throw new NoSuchElementException();
        }
        if (this.Length == 0) {
            throw new NullPointerException();
        }
        this.Pointer = temp = this.cursor();
        if (temp != this.Tail) {
            return temp.next.data;
        }
        throw new NoSuchElementException();
    }

    public Node next() {
        Node temp;
        if (this.Length == 1) {
            throw new NoSuchElementException();
        }
        if (this.Length == 0) {
            throw new NullPointerException();
        }
        this.Pointer = temp = this.cursor();
        if (temp != this.Tail) {
            return temp.next;
        }
        throw new NoSuchElementException();
    }

    public Object currentNode() {
        Node temp = this.cursor();
        return temp.data;
    }

    public void insert(Object d) {
        Node e = new Node(d);
        if (this.Length == 0) {
            this.Tail = e;
            this.Head = e;
        } else {
            Node temp;
            e.next = temp = this.cursor();
            e.previous = temp.previous;
            temp.previous.next = e;
            temp.previous = e;
            if (this.Pointer == null) {
                this.Head = e;
            } else {
                this.Pointer.next = e;
            }
        }
        ++this.Length;
    }

    public void addLast(Object d) {
        Node e = new Node(d);
        if (this.Length == 0) {
            this.Tail = e;
            this.Head = e;
        } else {
            e.next = null;
            e.previous = this.Tail;
            this.Tail.next = e;
            this.Tail = e;
        }
        ++this.Length;
    }

    public int size() {
        return this.Length;
    }

    public Object remove() {
        Object temp;
        if (this.Length == 0) {
            throw new NoSuchElementException();
        }
        if (this.Length == 1) {
            temp = this.Head.data;
            this.deleteAll();
        } else {
            Node cur = this.cursor();
            temp = cur.data;
            if (cur == this.Head) {
                this.Head = cur.next;
                this.Head.previous = null;
            } else if (cur == this.Tail) {
                this.Pointer.next = null;
                this.Tail = this.Pointer;
                this.reset();
            } else {
                cur.next.previous = this.Pointer;
                this.Pointer.next = cur.next;
            }
            --this.Length;
        }
        return temp;
    }

    public void removeAll() {
        this.reset();
        while (this.Length != 0) {
            this.remove();
        }
    }

    private Node cursor() {
        if (this.Head == null) {
            throw new NullPointerException();
        }
        if (this.Pointer == null) {
            return this.Head;
        }
        return this.Pointer.next;
    }

    public class Node {
        public Object data;
        public Node next;
        public Node previous;

        Node(Object d) {
            this.data = d;
            this.next = null;
            this.previous = null;
        }
    }
}

