/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util.stat;

import dm.jdbc.log.ILogger;
import dm.jdbc.log.LogFactory;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import javax.management.JMException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public class FilterUtil {
    private static ILogger LOG = LogFactory.getLog(FilterUtil.class);
    private static CompositeType THROWABLE_COMPOSITE_TYPE = null;
    private static final String[] THROWABLE_COMPOSITE_INDEX_NAMES = new String[]{"message", "class", "stackTrace"};
    private static final String[] THROWABLE_COMPOSITE_INDEX_DESCRIPTIONS = new String[]{"message", "class", "stackTrace"};
    private static final OpenType[] THROWABLE_COMPOSITE_INDEX_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING};

    public static CompositeType getThrowableCompositeType() throws JMException {
        if (THROWABLE_COMPOSITE_TYPE == null) {
            THROWABLE_COMPOSITE_TYPE = new CompositeType("Throwable", "Throwable", THROWABLE_COMPOSITE_INDEX_NAMES, THROWABLE_COMPOSITE_INDEX_DESCRIPTIONS, THROWABLE_COMPOSITE_INDEX_TYPES);
        }
        return THROWABLE_COMPOSITE_TYPE;
    }

    public static String toString(StackTraceElement[] stackTrace) {
        StringBuilder buf = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = stackTrace;
        int n = stackTrace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement item = stackTraceElementArray[n2];
            buf.append(item.toString());
            buf.append("\n");
            ++n2;
        }
        return buf.toString();
    }

    public static CompositeData getErrorCompositeData(Throwable error) throws JMException {
        if (error == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("class", error.getClass().getName());
        map.put("message", error.getMessage());
        map.put("stackTrace", FilterUtil.getStackTrace(error));
        return new CompositeDataSupport(FilterUtil.getThrowableCompositeType(), map);
    }

    public static String getStackTrace(Throwable ex) {
        StringWriter buf = new StringWriter();
        ex.printStackTrace(new PrintWriter(buf));
        return buf.toString();
    }

    public static long murmurhash2_64(String text) {
        byte[] bytes = text.getBytes();
        return FilterUtil.murmurhash2_64(bytes, bytes.length, -512093083);
    }

    public static long murmurhash2_64(byte[] data, int length, int seed) {
        long h = (long)seed & 0xFFFFFFFFL ^ (long)length * -4132994306676758123L;
        int length8 = length / 8;
        int i = 0;
        while (i < length8) {
            int i8 = i * 8;
            long k = ((long)data[i8 + 0] & 0xFFL) + (((long)data[i8 + 1] & 0xFFL) << 8) + (((long)data[i8 + 2] & 0xFFL) << 16) + (((long)data[i8 + 3] & 0xFFL) << 24) + (((long)data[i8 + 4] & 0xFFL) << 32) + (((long)data[i8 + 5] & 0xFFL) << 40) + (((long)data[i8 + 6] & 0xFFL) << 48) + (((long)data[i8 + 7] & 0xFFL) << 56);
            k *= -4132994306676758123L;
            k ^= k >>> 47;
            h ^= (k *= -4132994306676758123L);
            h *= -4132994306676758123L;
            ++i;
        }
        switch (length % 8) {
            case 7: {
                h ^= (long)(data[(length & 0xFFFFFFF8) + 6] & 0xFF) << 48;
            }
            case 6: {
                h ^= (long)(data[(length & 0xFFFFFFF8) + 5] & 0xFF) << 40;
            }
            case 5: {
                h ^= (long)(data[(length & 0xFFFFFFF8) + 4] & 0xFF) << 32;
            }
            case 4: {
                h ^= (long)(data[(length & 0xFFFFFFF8) + 3] & 0xFF) << 24;
            }
            case 3: {
                h ^= (long)(data[(length & 0xFFFFFFF8) + 2] & 0xFF) << 16;
            }
            case 2: {
                h ^= (long)(data[(length & 0xFFFFFFF8) + 1] & 0xFF) << 8;
            }
            case 1: {
                h ^= (long)(data[length & 0xFFFFFFF8] & 0xFF);
                h *= -4132994306676758123L;
            }
        }
        h ^= h >>> 47;
        h *= -4132994306676758123L;
        h ^= h >>> 47;
        return h;
    }

    public static String subString(String src, String start, String to) {
        int indexTo;
        int indexFrom = start == null ? 0 : src.indexOf(start);
        int n = indexTo = to == null ? src.length() : src.indexOf(to);
        if (indexFrom < 0 || indexTo < 0 || indexFrom > indexTo) {
            return null;
        }
        if (start != null) {
            indexFrom += start.length();
        }
        return src.substring(indexFrom, indexTo);
    }

    public static Integer subStringToInteger(String src, String start, String to) {
        return FilterUtil.stringToInteger(FilterUtil.subString(src, start, to));
    }

    public static Integer stringToInteger(String in) {
        if (in == null) {
            return null;
        }
        if ((in = in.trim()).length() == 0) {
            return null;
        }
        try {
            return Integer.parseInt(in);
        }
        catch (NumberFormatException e) {
            LOG.warn("stringToInteger fail,string=" + in, e);
            return null;
        }
    }
}

