/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import java.io.Serializable;
import smile.math.kernel.MercerKernel;

public class PearsonKernel
implements MercerKernel<double[]>,
Serializable {
    private static final long serialVersionUID = 1L;
    private double omega;
    private double sigma;
    private double constant;

    public double getOmega() {
        return this.omega;
    }

    public void setOmega(double omega) {
        this.omega = omega;
        this.constant = 2.0 * Math.sqrt(Math.pow(2.0, 1.0 / omega) - 1.0) / this.sigma;
    }

    public double getSigma() {
        return this.sigma;
    }

    public void setSigma(double sigma) {
        this.sigma = sigma;
        this.constant = 2.0 * Math.sqrt(Math.pow(2.0, 1.0 / this.omega) - 1.0) / sigma;
    }

    public PearsonKernel() {
        this(1.0, 1.0);
    }

    public PearsonKernel(double omega, double sigma) {
        this.omega = omega;
        this.sigma = sigma;
    }

    public String toString() {
        return "Pearson Kernel";
    }

    @Override
    public double k(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        double xx = 0.0;
        double yy = 0.0;
        double xy = 0.0;
        for (int i = 0; i < x.length; ++i) {
            xx += x[i] * x[i];
            yy += y[i] * y[i];
            xy += x[i] * y[i];
        }
        double m = this.constant * Math.sqrt(-2.0 * xy + xx + yy);
        return 1.0 / Math.pow(1.0 + m * m, this.omega);
    }
}

