/*
 * Decompiled with CFR 0.152.
 */
package smile.stat.hypothesis;

import smile.math.Math;
import smile.math.special.Beta;
import smile.math.special.Erf;
import smile.math.special.Gamma;
import smile.sort.QuickSort;

public class CorTest {
    public double cor;
    public double df;
    public double t;
    public double pvalue;

    private CorTest(double cor, double df, double t, double pvalue) {
        this.cor = cor;
        this.df = df;
        this.t = t;
        this.pvalue = pvalue;
    }

    public static CorTest pearson(double[] x, double[] y) {
        int j;
        double TINY = 1.0E-20;
        int n = x.length;
        double syy = 0.0;
        double sxy = 0.0;
        double sxx = 0.0;
        double ay = 0.0;
        double ax = 0.0;
        for (j = 0; j < n; ++j) {
            ax += x[j];
            ay += y[j];
        }
        ax /= (double)n;
        ay /= (double)n;
        for (j = 0; j < n; ++j) {
            double xt = x[j] - ax;
            double yt = y[j] - ay;
            sxx += xt * xt;
            syy += yt * yt;
            sxy += xt * yt;
        }
        double r = sxy / (Math.sqrt(sxx * syy) + 1.0E-20);
        int df = n - 2;
        double t = r * Math.sqrt((double)df / ((1.0 - r + 1.0E-20) * (1.0 + r + 1.0E-20)));
        double prob = Beta.regularizedIncompleteBetaFunction(0.5 * (double)df, 0.5, (double)df / ((double)df + t * t));
        return new CorTest(r, df, t, prob);
    }

    private static double crank(double[] w) {
        int n = w.length;
        double s = 0.0;
        int j = 1;
        while (j < n) {
            int jt;
            if (w[j] != w[j - 1]) {
                w[j - 1] = j;
                ++j;
                continue;
            }
            for (jt = j + 1; jt <= n && w[jt - 1] == w[j - 1]; ++jt) {
            }
            double rank = 0.5 * (double)(j + jt - 1);
            for (int ji = j; ji <= jt - 1; ++ji) {
                w[ji - 1] = rank;
            }
            double t = jt - j;
            s += t * t * t - t;
            j = jt;
        }
        if (j == n) {
            w[n - 1] = n;
        }
        return s;
    }

    public static CorTest spearman(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Input vectors have different size");
        }
        int n = x.length;
        double[] wksp1 = new double[n];
        double[] wksp2 = new double[n];
        for (int j = 0; j < n; ++j) {
            wksp1[j] = x[j];
            wksp2[j] = y[j];
        }
        QuickSort.sort(wksp1, wksp2);
        double sf = CorTest.crank(wksp1);
        QuickSort.sort(wksp2, wksp1);
        double sg = CorTest.crank(wksp2);
        double d = 0.0;
        for (int j = 0; j < n; ++j) {
            d += Math.sqr(wksp1[j] - wksp2[j]);
        }
        int en = n;
        double en3n = en * en * en - en;
        double fac = (1.0 - sf / en3n) * (1.0 - sg / en3n);
        double rs = (1.0 - 6.0 / en3n * (d + (sf + sg) / 12.0)) / Math.sqrt(fac);
        fac = (rs + 1.0) * (1.0 - rs);
        double probrs = 0.0;
        double t = rs * Math.sqrt(((double)en - 2.0) / fac);
        int df = en - 2;
        if (fac > 0.0) {
            probrs = Beta.regularizedIncompleteBetaFunction(0.5 * (double)df, 0.5, (double)df / ((double)df + t * t));
        }
        return new CorTest(rs, df, t, probrs);
    }

    public static CorTest kendall(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Input vectors have different size");
        }
        int is = 0;
        int n2 = 0;
        int n1 = 0;
        int n = x.length;
        for (int j = 0; j < n - 1; ++j) {
            for (int k = j + 1; k < n; ++k) {
                double a1 = x[j] - x[k];
                double a2 = y[j] - y[k];
                double aa = a1 * a2;
                if (aa != 0.0) {
                    ++n1;
                    ++n2;
                    if (aa > 0.0) {
                        ++is;
                        continue;
                    }
                    --is;
                    continue;
                }
                if (a1 != 0.0) {
                    ++n1;
                }
                if (a2 == 0.0) continue;
                ++n2;
            }
        }
        double tau = (double)is / (Math.sqrt(n1) * Math.sqrt(n2));
        double svar = (4.0 * (double)n + 10.0) / (9.0 * (double)n * ((double)n - 1.0));
        double z = tau / Math.sqrt(svar);
        double prob = Erf.erfcc(Math.abs(z) / 1.4142136);
        return new CorTest(tau, 0.0, z, prob);
    }

    public static CorTest chisq(int[][] table) {
        double TINY = 1.0E-30;
        int ni = table.length;
        int nj = table[0].length;
        boolean correct = false;
        if (ni == 2 && nj == 2) {
            correct = true;
        }
        double sum = 0.0;
        int nni = ni;
        double[] sumi = new double[ni];
        for (int i = 0; i < ni; ++i) {
            for (int j = 0; j < nj; ++j) {
                int n = i;
                sumi[n] = sumi[n] + (double)table[i][j];
                sum += (double)table[i][j];
            }
            if (sumi[i] != 0.0) continue;
            --nni;
        }
        int nnj = nj;
        double[] sumj = new double[nj];
        for (int j = 0; j < nj; ++j) {
            for (int i = 0; i < ni; ++i) {
                int n = j;
                sumj[n] = sumj[n] + (double)table[i][j];
            }
            if (sumj[j] != 0.0) continue;
            --nnj;
        }
        int df = nni * nnj - nni - nnj + 1;
        double chisq = 0.0;
        for (int i = 0; i < ni; ++i) {
            for (int j = 0; j < nj; ++j) {
                double expctd = sumj[j] * sumi[i] / sum;
                double temp = (double)table[i][j] - expctd;
                if (correct) {
                    temp = Math.abs(temp) - 0.5;
                }
                chisq += temp * temp / (expctd + 1.0E-30);
            }
        }
        double prob = Gamma.regularizedUpperIncompleteGamma(0.5 * (double)df, 0.5 * chisq);
        int minij = nni < nnj ? nni - 1 : nnj - 1;
        double v = Math.sqrt(chisq / (sum * (double)minij));
        return new CorTest(v, df, chisq, prob);
    }
}

