/*
 * Decompiled with CFR 0.152.
 */
package com.github.rutledgepaulv.qbuilders.visitors;

import com.github.rutledgepaulv.qbuilders.nodes.AndNode;
import com.github.rutledgepaulv.qbuilders.nodes.ComparisonNode;
import com.github.rutledgepaulv.qbuilders.nodes.OrNode;
import com.github.rutledgepaulv.qbuilders.operators.ComparisonOperator;
import com.github.rutledgepaulv.qbuilders.visitors.AbstractVoidContextNodeVisitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.commons.lang3.reflect.FieldUtils;

public class PredicateVisitor<T>
extends AbstractVoidContextNodeVisitor<Predicate<T>> {
    @Override
    protected Predicate<T> visit(AndNode node) {
        return t -> node.getChildren().stream().map(this::visitAny).allMatch(p -> p.test(t));
    }

    @Override
    protected Predicate<T> visit(OrNode node) {
        return t -> node.getChildren().stream().map(this::visitAny).anyMatch(p -> p.test(t));
    }

    @Override
    protected Predicate<T> visit(ComparisonNode node) {
        ComparisonOperator operator = node.getOperator();
        if (ComparisonOperator.EQ.equals(operator)) {
            return this.single(node, this::equality);
        }
        if (ComparisonOperator.NE.equals(operator)) {
            return this.single(node, this::inequality);
        }
        if (ComparisonOperator.EX.equals(operator)) {
            return (Boolean)node.getValues().iterator().next() != false ? this.exists(node) : this.doesNotExist(node);
        }
        if (ComparisonOperator.GT.equals(operator)) {
            return this.single(node, this::greaterThan);
        }
        if (ComparisonOperator.LT.equals(operator)) {
            return this.single(node, this::lessThan);
        }
        if (ComparisonOperator.GTE.equals(operator)) {
            return this.single(node, this::greaterThanOrEqualTo);
        }
        if (ComparisonOperator.LTE.equals(operator)) {
            return this.single(node, this::lessThanOrEqualTo);
        }
        if (ComparisonOperator.IN.equals(operator)) {
            return this.multi(node, this::in);
        }
        if (ComparisonOperator.NIN.equals(operator)) {
            return this.multi(node, this::nin);
        }
        if (ComparisonOperator.RE.equals(operator)) {
            return this.single(node, this::regex);
        }
        if (ComparisonOperator.SUB_CONDITION_ANY.equals(operator)) {
            Predicate test = (Predicate)this.condition(node);
            return this.single(node, (fieldValue, subQueryCondition) -> this.subquery(fieldValue, test));
        }
        throw new UnsupportedOperationException("This visitor does not support the operator " + operator + ".");
    }

    protected boolean subquery(Object actual, Predicate<Object> func) {
        if (actual != null && actual.getClass().isArray()) {
            Object[] values = (Object[])actual;
            return Arrays.stream(values).anyMatch(func);
        }
        if (actual != null && Collection.class.isAssignableFrom(actual.getClass())) {
            Collection values = (Collection)actual;
            return values.stream().anyMatch(func);
        }
        throw new IllegalArgumentException("You cannot do a subquery against a single element.");
    }

    protected boolean regex(Object actual, Object query) {
        Object values;
        if (!(query instanceof String)) {
            return false;
        }
        String queryRegex = (String)query;
        Predicate<String> test = Pattern.compile(queryRegex).asPredicate();
        if (actual.getClass().isArray()) {
            values = (String[])actual;
            return Arrays.stream(values).anyMatch(test);
        }
        if (Collection.class.isAssignableFrom(actual.getClass())) {
            values = (Collection)actual;
            return values.stream().anyMatch(test);
        }
        if (actual instanceof String) {
            return test.test((String)actual);
        }
        return false;
    }

    protected boolean equality(Object actual, Object query) {
        if (actual != null && actual.getClass().isArray()) {
            Object[] values = (Object[])actual;
            return Arrays.stream(values).anyMatch(query::equals);
        }
        if (actual != null && Collection.class.isAssignableFrom(actual.getClass())) {
            Collection values = (Collection)actual;
            return values.stream().anyMatch(query::equals);
        }
        return query.equals(actual);
    }

    protected boolean inequality(Object actual, Object query) {
        if (actual != null && actual.getClass().isArray()) {
            Object[] values = (Object[])actual;
            return Arrays.stream(values).noneMatch(query::equals);
        }
        if (actual != null && Collection.class.isAssignableFrom(actual.getClass())) {
            Collection values = (Collection)actual;
            return values.stream().noneMatch(query::equals);
        }
        return !query.equals(actual);
    }

    protected boolean nin(Object actual, Collection<?> queries) {
        if (actual != null && actual.getClass().isArray()) {
            Object[] values = (Object[])actual;
            return Arrays.stream(values).noneMatch(queries::contains);
        }
        if (actual != null && Collection.class.isAssignableFrom(actual.getClass())) {
            Collection values = (Collection)actual;
            return values.stream().noneMatch(queries::contains);
        }
        return !queries.contains(actual);
    }

    protected boolean in(Object actual, Collection<?> queries) {
        if (actual != null && actual.getClass().isArray()) {
            Object[] values = (Object[])actual;
            return Arrays.stream(values).anyMatch(queries::contains);
        }
        if (actual != null && Collection.class.isAssignableFrom(actual.getClass())) {
            Collection values = (Collection)actual;
            return values.stream().anyMatch(queries::contains);
        }
        return queries.contains(actual);
    }

    protected boolean greaterThan(Object actual, Object query) {
        if (query instanceof Number && actual instanceof Number) {
            return ((Number)actual).doubleValue() > ((Number)query).doubleValue();
        }
        if (query instanceof String && actual instanceof String) {
            return ((String)actual).compareTo((String)query) > 0;
        }
        throw new UnsupportedOperationException("Incompatible types provided.");
    }

    protected boolean greaterThanOrEqualTo(Object actual, Object query) {
        if (query instanceof Number && actual instanceof Number) {
            return ((Number)actual).doubleValue() >= ((Number)query).doubleValue();
        }
        if (query instanceof String && actual instanceof String) {
            return ((String)actual).compareTo((String)query) >= 0;
        }
        throw new UnsupportedOperationException("Incompatible types provided.");
    }

    protected boolean lessThan(Object actual, Object query) {
        if (query instanceof Number && actual instanceof Number) {
            return ((Number)actual).doubleValue() < ((Number)query).doubleValue();
        }
        if (query instanceof String && actual instanceof String) {
            return ((String)actual).compareTo((String)query) < 0;
        }
        throw new UnsupportedOperationException("Incompatible types provided.");
    }

    protected boolean lessThanOrEqualTo(Object actual, Object query) {
        if (query instanceof Number && actual instanceof Number) {
            return ((Number)actual).doubleValue() <= ((Number)query).doubleValue();
        }
        if (query instanceof String && actual instanceof String) {
            return ((String)actual).compareTo((String)query) <= 0;
        }
        throw new UnsupportedOperationException("Incompatible types provided.");
    }

    private Predicate<T> doesNotExist(ComparisonNode node) {
        return t -> this.resolveSingleField(t, node.getField().asKey(), node, (one, two) -> Objects.isNull(one));
    }

    private Predicate<T> exists(ComparisonNode node) {
        return t -> this.resolveSingleField(t, node.getField().asKey(), node, (one, two) -> Objects.nonNull(one));
    }

    private Predicate<T> single(ComparisonNode node, BiPredicate<Object, Object> func) {
        return t -> this.resolveSingleField(t, node.getField().asKey(), node, func);
    }

    private Predicate<T> multi(ComparisonNode node, BiPredicate<Object, Collection<?>> func) {
        return t -> this.resolveMultiField(t, node.getField().asKey(), node, func);
    }

    private boolean resolveSingleField(Object root, String field, ComparisonNode node, BiPredicate<Object, Object> func) {
        if (root == null || node.getField() == null) {
            return func.test(null, node.getValues().iterator().next());
        }
        String[] splitField = field.split("\\.", 2);
        Object currentField = this.getFieldValueFromString(root, splitField[0]);
        if (splitField.length == 1) {
            return func.test(currentField, node.getValues().iterator().next());
        }
        return this.recurseSingle(currentField, splitField[1], node, func);
    }

    private boolean recurseSingle(Object root, String field, ComparisonNode node, BiPredicate<Object, Object> func) {
        if (root.getClass().isArray()) {
            return Arrays.stream((Object[])root).anyMatch(t -> this.resolveSingleField(t, field, node, func));
        }
        if (root instanceof Collection) {
            return ((Collection)root).stream().anyMatch(t -> this.resolveSingleField(t, field, node, func));
        }
        return this.resolveSingleField(root, field, node, func);
    }

    private boolean resolveMultiField(Object root, String field, ComparisonNode node, BiPredicate<Object, Collection<?>> func) {
        if (root == null || node.getField() == null) {
            return func.test(null, node.getValues());
        }
        String[] splitField = field.split("\\.", 2);
        Object currentField = this.getFieldValueFromString(root, splitField[0]);
        if (splitField.length == 1) {
            return func.test(currentField, node.getValues());
        }
        return this.recurseMulti(currentField, splitField[1], node, func);
    }

    private boolean recurseMulti(Object root, String field, ComparisonNode node, BiPredicate<Object, Collection<?>> func) {
        if (root.getClass().isArray()) {
            return Arrays.stream((Object[])root).anyMatch(t -> this.resolveMultiField(t, field, node, func));
        }
        if (root instanceof Collection) {
            return ((Collection)root).stream().anyMatch(t -> this.resolveMultiField(t, field, node, func));
        }
        return this.resolveMultiField(root, field, node, func);
    }

    private Object getFieldValueFromString(Object o, String s) {
        if (o == null) {
            return null;
        }
        try {
            return FieldUtils.readField((Object)o, (String)s, (boolean)true);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }
}

