/*
 * Decompiled with CFR 0.152.
 */
package com.github.springtestdbunit;

import com.github.springtestdbunit.dataset.DataSetModifier;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.dbunit.dataset.IDataSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataSetModifiers
implements DataSetModifier {
    private final List<DataSetModifier> modifiers = new ArrayList<DataSetModifier>();

    DataSetModifiers() {
    }

    @Override
    public IDataSet modify(IDataSet dataSet) {
        for (DataSetModifier modifier : this.modifiers) {
            dataSet = modifier.modify(dataSet);
        }
        return dataSet;
    }

    public void add(Object testInstance, Class<? extends DataSetModifier> modifierClass) {
        try {
            Class<?> enclosingClass = modifierClass.getEnclosingClass();
            if (enclosingClass == null || Modifier.isStatic(modifierClass.getModifiers())) {
                this.add(modifierClass.getDeclaredConstructor(new Class[0]), new Object[0]);
            } else {
                this.add(modifierClass.getDeclaredConstructor(enclosingClass), testInstance);
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private void add(Constructor<? extends DataSetModifier> constructor, Object ... args) throws Exception {
        constructor.setAccessible(true);
        this.modifiers.add(constructor.newInstance(args));
    }
}

