/*
 * Decompiled with CFR 0.152.
 */
package com.github.springtestdbunit.assertion;

import com.github.springtestdbunit.assertion.DatabaseAssertion;
import java.util.LinkedList;
import org.dbunit.Assertion;
import org.dbunit.DatabaseUnitException;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.Columns;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;

class NonStrictDatabaseAssertion
implements DatabaseAssertion {
    NonStrictDatabaseAssertion() {
    }

    public void assertEquals(IDataSet expectedDataSet, IDataSet actualDataSet) throws DatabaseUnitException {
        for (String tableName : expectedDataSet.getTableNames()) {
            ITable expectedTable = expectedDataSet.getTable(tableName);
            ITable actualTable = actualDataSet.getTable(tableName);
            this.assertEquals(expectedTable, actualTable);
        }
    }

    public void assertEquals(ITable expectedTable, ITable actualTable) throws DatabaseUnitException {
        String[] ignoredColumns = this.getColumnsToIgnore(expectedTable.getTableMetaData(), actualTable.getTableMetaData());
        Assertion.assertEqualsIgnoreCols((ITable)expectedTable, (ITable)actualTable, (String[])ignoredColumns);
    }

    protected String[] getColumnsToIgnore(ITableMetaData expectedMetaData, ITableMetaData actualMetaData) throws DataSetException {
        Column[] notSpecifiedInExpected = Columns.getColumnDiff((ITableMetaData)expectedMetaData, (ITableMetaData)actualMetaData).getActual();
        LinkedList<String> result = new LinkedList<String>();
        for (Column column : notSpecifiedInExpected) {
            result.add(column.getColumnName());
        }
        return result.toArray(new String[result.size()]);
    }
}

