/*
 * Decompiled with CFR 0.152.
 */
package com.github.springtestdbunit.bean;

import com.github.springtestdbunit.bean.DatabaseConfigBean;
import javax.sql.DataSource;
import org.dbunit.database.DatabaseDataSourceConnection;
import org.dbunit.database.IDatabaseConnection;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseDataSourceConnectionFactoryBean
implements FactoryBean<DatabaseDataSourceConnection> {
    private DataSource dataSource;
    private boolean transactionAware = true;
    private String username;
    private String password;
    private String schema;
    private DatabaseConfigBean databaseConfig;

    public DatabaseDataSourceConnectionFactoryBean() {
    }

    public DatabaseDataSourceConnectionFactoryBean(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DatabaseDataSourceConnection getObject() throws Exception {
        Assert.notNull((Object)this.dataSource, (String)"The dataSource is required");
        DatabaseDataSourceConnection dataSourceConntection = new DatabaseDataSourceConnection(this.makeTransactionAware(this.dataSource), this.schema, this.username, this.password);
        if (this.databaseConfig != null) {
            this.databaseConfig.apply(dataSourceConntection.getConfig());
        }
        return dataSourceConntection;
    }

    private DataSource makeTransactionAware(DataSource dataSource) {
        if (dataSource instanceof TransactionAwareDataSourceProxy || !this.transactionAware) {
            return dataSource;
        }
        return new TransactionAwareDataSourceProxy(dataSource);
    }

    public Class<?> getObjectType() {
        return DatabaseDataSourceConnection.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setDataSource(DataSource dataSource) {
        Assert.notNull((Object)dataSource, (String)"The dataSource is required.");
        this.dataSource = dataSource;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setDatabaseConfig(DatabaseConfigBean databaseConfig) {
        this.databaseConfig = databaseConfig;
    }

    public void setTransactionAware(boolean transactionAware) {
        this.transactionAware = transactionAware;
    }

    public static IDatabaseConnection newConnection(DataSource dataSource) {
        try {
            return new DatabaseDataSourceConnectionFactoryBean(dataSource).getObject();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }
}

