/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.list.mutable.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.factory.list.primitive.MutableBooleanListFactory;
import com.gs.collections.api.list.primitive.MutableBooleanList;

/**
 * MutableBooleanListFactoryImpl is a factory implementation which creates instances of type {@link MutableBooleanList}.
 * This file was automatically generated from template file mutablePrimitiveListFactoryImpl.stg.
 *
 * @since 6.0.
 */
public class MutableBooleanListFactoryImpl implements MutableBooleanListFactory
{
    public MutableBooleanList empty()
    {
        return new BooleanArrayList();
    }

    public MutableBooleanList of()
    {
        return this.empty();
    }

    public MutableBooleanList with()
    {
        return this.empty();
    }

    public MutableBooleanList of(boolean... items)
    {
        return this.with(items);
    }

    public MutableBooleanList with(boolean... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        return BooleanArrayList.newListWith(items);
    }

    public MutableBooleanList ofAll(BooleanIterable items)
    {
        return this.withAll(items);
    }

    public MutableBooleanList withAll(BooleanIterable items)
    {
        return BooleanArrayList.newList(items);
    }
}
