/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.factory.map.primitive.ImmutableObjectLongMapFactory;
import com.gs.collections.api.map.primitive.ImmutableObjectLongMap;
import com.gs.collections.api.map.primitive.ObjectLongMap;

/**
 * ImmutableObjectLongMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableObjectLongMap}.
 * This file was automatically generated from template file immutableObjectPrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableObjectLongMapFactoryImpl implements ImmutableObjectLongMapFactory
{
    public <K> ImmutableObjectLongMap<K> empty()
    {
        return (ImmutableObjectLongMap<K>) ImmutableObjectLongEmptyMap.INSTANCE;
    }

    public <K> ImmutableObjectLongMap<K> of()
    {
        return this.empty();
    }

    public <K> ImmutableObjectLongMap<K> with()
    {
        return this.empty();
    }

    public <K> ImmutableObjectLongMap<K> of(K key, long value)
    {
        return this.with(key, value);
    }

    public <K> ImmutableObjectLongMap<K> with(K key, long value)
    {
        return new ImmutableObjectLongSingletonMap<K>(key, value);
    }

    public <K> ImmutableObjectLongMap<K> ofAll(ObjectLongMap<? extends K> map)
    {
        return this.withAll(map);
    }

    public <K> ImmutableObjectLongMap<K> withAll(ObjectLongMap<? extends K> map)
    {
        if (map instanceof ImmutableObjectLongMap)
        {
            return (ImmutableObjectLongMap<K>) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            //TODO use keysView() when available.
            final Object[] array = new Object[1];
            map.forEachKey(new Procedure<K>()
            {
                public void value(K each)
                {
                    array[0] = each;
                }
            });
            return new ImmutableObjectLongSingletonMap<K>((K) array[0], map.get(array[0]));
        }
        return new ImmutableObjectLongHashMap<K>(map);
    }
}
