/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.set.immutable.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.set.primitive.ImmutableByteSet;
import com.gs.collections.api.set.primitive.ByteSet;
import com.gs.collections.impl.set.mutable.primitive.ByteHashSet;
import com.gs.collections.impl.set.primitive.AbstractByteSet;

/**
 * This file was automatically generated from template file abstractImmutablePrimitiveSet.stg.
 *
 * @since 6.0.
 */
public abstract class AbstractImmutableByteSet extends AbstractByteSet implements ImmutableByteSet
{
    public ImmutableByteSet newWith(byte element)
    {
        return ByteHashSet.newSet(this).with(element).toImmutable();
    }

    public ImmutableByteSet newWithout(byte element)
    {
        return ByteHashSet.newSet(this).without(element).toImmutable();
    }

    public ImmutableByteSet newWithAll(ByteIterable elements)
    {
        return ByteHashSet.newSet(this).withAll(elements).toImmutable();
    }

    public ImmutableByteSet newWithoutAll(ByteIterable elements)
    {
        return ByteHashSet.newSet(this).withoutAll(elements).toImmutable();
    }

    public ByteSet freeze()
    {
        return this;
    }

    public ImmutableByteSet toImmutable()
    {
        return this;
    }
}
