/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.set.mutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.factory.set.primitive.MutableFloatSetFactory;
import com.gs.collections.api.set.primitive.MutableFloatSet;

/**
 * MutableFloatSetFactoryImpl is a factory implementation which creates instances of type {@link MutableFloatSet}.
 * This file was automatically generated from template file mutablePrimitiveSetFactoryImpl.stg.
 *
 * @since 6.0.
 */
public class MutableFloatSetFactoryImpl implements MutableFloatSetFactory
{
    public MutableFloatSet empty()
    {
        return new FloatHashSet();
    }

    public MutableFloatSet of()
    {
        return this.empty();
    }

    public MutableFloatSet with()
    {
        return this.empty();
    }

    public MutableFloatSet of(float... items)
    {
        return this.with(items);
    }

    public MutableFloatSet with(float... items)
    {
        if (items == null || items.length == 0)
        {
            return this.empty();
        }
        return FloatHashSet.newSetWith(items);
    }

    public MutableFloatSet ofAll(FloatIterable items)
    {
        return this.withAll(items);
    }

    public MutableFloatSet withAll(FloatIterable items)
    {
        return FloatHashSet.newSet(items);
    }
}
