/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.set.mutable.primitive;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.factory.set.primitive.MutableLongSetFactory;
import com.gs.collections.api.set.primitive.MutableLongSet;

/**
 * MutableLongSetFactoryImpl is a factory implementation which creates instances of type {@link MutableLongSet}.
 * This file was automatically generated from template file mutablePrimitiveSetFactoryImpl.stg.
 *
 * @since 6.0.
 */
public class MutableLongSetFactoryImpl implements MutableLongSetFactory
{
    public MutableLongSet empty()
    {
        return new LongHashSet();
    }

    public MutableLongSet of()
    {
        return this.empty();
    }

    public MutableLongSet with()
    {
        return this.empty();
    }

    public MutableLongSet of(long... items)
    {
        return this.with(items);
    }

    public MutableLongSet with(long... items)
    {
        if (items == null || items.length == 0)
        {
            return this.empty();
        }
        return LongHashSet.newSetWith(items);
    }

    public MutableLongSet ofAll(LongIterable items)
    {
        return this.withAll(items);
    }

    public MutableLongSet withAll(LongIterable items)
    {
        return LongHashSet.newSet(items);
    }
}
