/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This package contains implementations of {@link com.gs.collections.api.set.sorted.ImmutableSortedSet}.
 * <p>
 *     This package contains the following immutable sorted set implementation:
 * <ul>
 *     <li>
 *          {@link com.gs.collections.impl.set.sorted.immutable.ImmutableEmptySortedSet} -  a zero element {@link com.gs.collections.api.set.sorted.ImmutableSortedSet}.
 *     </li>
 *     <li>
 *          {@link com.gs.collections.impl.set.sorted.immutable.ImmutableTreeSet} - the non-modifiable equivalent of {@link com.gs.collections.api.set.sorted.MutableSortedSet}.
 *     </li>
 * </ul>
 * <p>
 *     This package contains one factory implementation:
 * <ul>
 *     <li>
 *          {@link com.gs.collections.impl.set.sorted.immutable.ImmutableSortedSetFactoryImpl} -  a factory which creates instances of type {@link com.gs.collections.api.set.sorted.ImmutableSortedSet}
 *     </li>
 * </ul>
 */
package com.gs.collections.impl.set.sorted.immutable;
