/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.list.primitive.CharList;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.impl.bag.mutable.primitive.CharHashBag;
import com.gs.collections.impl.lazy.primitive.AbstractLazyCharIterable;
import com.gs.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.CharArrayList;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;
import java.util.NoSuchElementException;

public class ReverseCharIterable
extends AbstractLazyCharIterable {
    private final CharList adapted;

    public ReverseCharIterable(CharList newAdapted) {
        this.adapted = newAdapted;
    }

    public static ReverseCharIterable adapt(CharList charList) {
        return new ReverseCharIterable(charList);
    }

    public CharIterator charIterator() {
        return new ReverseCharIterator();
    }

    public void forEach(CharProcedure procedure) {
        CharIterator iterator = this.charIterator();
        while (iterator.hasNext()) {
            procedure.value(iterator.next());
        }
    }

    public long sum() {
        return this.adapted.sum();
    }

    public char max() {
        return this.adapted.max();
    }

    public char min() {
        return this.adapted.min();
    }

    public char minIfEmpty(char defaultValue) {
        if (this.adapted.isEmpty()) {
            return defaultValue;
        }
        return this.adapted.min();
    }

    public char maxIfEmpty(char defaultValue) {
        if (this.adapted.isEmpty()) {
            return defaultValue;
        }
        return this.adapted.max();
    }

    public double average() {
        return this.adapted.average();
    }

    public double median() {
        return this.adapted.median();
    }

    public char[] toSortedArray() {
        return this.adapted.toSortedArray();
    }

    public char[] toArray() {
        char[] results = new char[this.adapted.size()];
        int index = 0;
        CharIterator iterator = this.charIterator();
        while (iterator.hasNext()) {
            results[index] = iterator.next();
            ++index;
        }
        return results;
    }

    public boolean contains(char value) {
        return this.adapted.contains(value);
    }

    public boolean containsAll(char ... source) {
        return this.adapted.containsAll(source);
    }

    public boolean containsAll(CharIterable source) {
        return this.adapted.containsAll(source);
    }

    public int size() {
        return this.adapted.size();
    }

    public boolean isEmpty() {
        return this.adapted.isEmpty();
    }

    public boolean notEmpty() {
        return this.adapted.notEmpty();
    }

    public MutableCharList toList() {
        return CharArrayList.newList((CharIterable)this);
    }

    public MutableCharSet toSet() {
        return CharHashSet.newSet((CharIterable)this);
    }

    public MutableCharBag toBag() {
        return CharHashBag.newBag((CharIterable)this);
    }

    public LazyCharIterable asLazy() {
        return new LazyCharIterableAdapter((CharIterable)this);
    }

    private class ReverseCharIterator
    implements CharIterator {
        private int currentIndex;

        private ReverseCharIterator() {
            this.currentIndex = ReverseCharIterable.this.adapted.size() - 1;
        }

        public boolean hasNext() {
            return this.currentIndex != -1;
        }

        public char next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            char next = ReverseCharIterable.this.adapted.get(this.currentIndex);
            --this.currentIndex;
            return next;
        }
    }
}

