/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import java.util.Iterator;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.DbObjectBase;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.engine.User;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.table.Table;
import org.h2.util.New;

public class DropDatabase
extends DefineCommand {
    private boolean dropAllObjects;
    private boolean deleteFiles;

    public DropDatabase(Session session) {
        super(session);
    }

    public int update() {
        if (this.dropAllObjects) {
            this.dropAllObjects();
        }
        if (this.deleteFiles) {
            this.session.getDatabase().setDeleteFilesOnDisconnect(true);
        }
        return 0;
    }

    private void dropAllObjects() {
        Object object;
        Object object2;
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database database = this.session.getDatabase();
        for (Schema object42 : database.getAllSchemas()) {
            if (!object42.canDrop()) continue;
            database.removeDatabaseObject(this.session, object42);
        }
        ArrayList<Table> arrayList = database.getAllTablesAndViews(false);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object2 = (Table)iterator.next();
            if (((DbObjectBase)object2).getName() == null || !"VIEW".equals(((Table)object2).getTableType())) continue;
            database.removeSchemaObject(this.session, (SchemaObject)object2);
        }
        Iterator iterator2 = arrayList.iterator();
        while (iterator2.hasNext()) {
            object2 = (Table)iterator2.next();
            if (((DbObjectBase)object2).getName() == null || !"TABLE LINK".equals(((Table)object2).getTableType())) continue;
            database.removeSchemaObject(this.session, (SchemaObject)object2);
        }
        Iterator iterator3 = arrayList.iterator();
        while (iterator3.hasNext()) {
            object2 = (Table)iterator3.next();
            if (((DbObjectBase)object2).getName() == null || !"TABLE".equals(((Table)object2).getTableType())) continue;
            database.removeSchemaObject(this.session, (SchemaObject)object2);
        }
        this.session.findLocalTempTable(null);
        ArrayList arrayList2 = New.arrayList();
        arrayList2.addAll(database.getAllSchemaObjects(3));
        arrayList2.addAll(database.getAllSchemaObjects(5));
        arrayList2.addAll(database.getAllSchemaObjects(4));
        arrayList2.addAll(database.getAllSchemaObjects(11));
        for (SchemaObject schemaObject : arrayList2) {
            database.removeSchemaObject(this.session, schemaObject);
        }
        for (User user : database.getAllUsers()) {
            if (user == this.session.getUser()) continue;
            database.removeDatabaseObject(this.session, user);
        }
        for (Role role : database.getAllRoles()) {
            object = role.getCreateSQL();
            if (object == null) continue;
            database.removeDatabaseObject(this.session, role);
        }
        object2 = New.arrayList();
        ((ArrayList)object2).addAll(database.getAllRights());
        ((ArrayList)object2).addAll(database.getAllFunctionAliases());
        ((ArrayList)object2).addAll(database.getAllAggregates());
        ((ArrayList)object2).addAll(database.getAllUserDataTypes());
        Iterator iterator4 = ((ArrayList)object2).iterator();
        while (iterator4.hasNext()) {
            object = (DbObject)iterator4.next();
            String string = object.getCreateSQL();
            if (string == null) continue;
            database.removeDatabaseObject(this.session, (DbObject)object);
        }
    }

    public void setDropAllObjects(boolean bl) {
        this.dropAllObjects = bl;
    }

    public void setDeleteFiles(boolean bl) {
        this.deleteFiles = bl;
    }
}

