/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import org.h2.command.Parser;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.engine.DbObjectBase;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.table.Table;
import org.h2.util.New;
import org.h2.util.SourceCompiler;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class FunctionAlias
extends DbObjectBase {
    private String className;
    private String methodName;
    private String source;
    private JavaMethod[] javaMethods;
    private boolean deterministic;

    private FunctionAlias(Database database, int n, String string) {
        this.initDbObjectBase(database, n, string, "function");
    }

    public static FunctionAlias newInstance(Database database, int n, String string, String string2, boolean bl) {
        FunctionAlias functionAlias = new FunctionAlias(database, n, string);
        int n2 = string2.indexOf(40);
        int n3 = string2.lastIndexOf(46, n2 < 0 ? string2.length() : n2);
        if (n3 < 0) {
            throw DbException.get(42000, string2);
        }
        functionAlias.className = string2.substring(0, n3);
        functionAlias.methodName = string2.substring(n3 + 1);
        functionAlias.init(bl);
        return functionAlias;
    }

    public static FunctionAlias newInstanceFromSource(Database database, int n, String string, String string2, boolean bl) {
        FunctionAlias functionAlias = new FunctionAlias(database, n, string);
        functionAlias.source = string2;
        functionAlias.init(bl);
        return functionAlias;
    }

    private void init(boolean bl) {
        block2: {
            try {
                this.load();
            }
            catch (DbException dbException) {
                if (bl) break block2;
                throw dbException;
            }
        }
    }

    private synchronized void load() {
        if (this.javaMethods != null) {
            return;
        }
        if (this.source != null) {
            this.loadFromSource();
        } else {
            this.loadClass();
        }
    }

    private void loadFromSource() {
        SourceCompiler sourceCompiler = this.database.getCompiler();
        String string = "org.h2.dynamic." + this.getName();
        sourceCompiler.setSource(string, this.source);
        try {
            Method method = sourceCompiler.getMethod(string);
            JavaMethod javaMethod = new JavaMethod(method, 0);
            this.javaMethods = new JavaMethod[]{javaMethod};
        }
        catch (DbException dbException) {
            throw dbException;
        }
        catch (Exception exception) {
            throw DbException.get(42000, exception, this.source);
        }
    }

    private void loadClass() {
        Class<?> clazz = Utils.loadUserClass(this.className);
        Method[] methodArray = clazz.getMethods();
        ArrayList<JavaMethod> arrayList = New.arrayList();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (!Modifier.isStatic(method.getModifiers()) || !method.getName().equals(this.methodName) && !this.getMethodSignature(method).equals(this.methodName)) continue;
            JavaMethod javaMethod = new JavaMethod(method, i);
            for (JavaMethod javaMethod2 : arrayList) {
                if (javaMethod2.getParameterCount() != javaMethod.getParameterCount()) continue;
                throw DbException.get(90073, javaMethod2.toString(), javaMethod.toString());
            }
            arrayList.add(javaMethod);
        }
        if (arrayList.size() == 0) {
            throw DbException.get(90139, this.methodName + " (" + this.className + ")");
        }
        this.javaMethods = new JavaMethod[arrayList.size()];
        arrayList.toArray(this.javaMethods);
        Arrays.sort(this.javaMethods);
    }

    private String getMethodSignature(Method method) {
        StatementBuilder statementBuilder = new StatementBuilder(method.getName());
        statementBuilder.append('(');
        for (Class<?> clazz : method.getParameterTypes()) {
            statementBuilder.appendExceptFirst(", ");
            if (clazz.isArray()) {
                statementBuilder.append(clazz.getComponentType().getName()).append("[]");
                continue;
            }
            statementBuilder.append(clazz.getName());
        }
        return statementBuilder.append(')').toString();
    }

    public String getCreateSQLForCopy(Table table, String string) {
        throw DbException.throwInternalError();
    }

    public String getDropSQL() {
        return "DROP ALIAS IF EXISTS " + this.getSQL();
    }

    public String getCreateSQL() {
        StringBuilder stringBuilder = new StringBuilder("CREATE FORCE ALIAS ");
        stringBuilder.append(this.getSQL());
        if (this.deterministic) {
            stringBuilder.append(" DETERMINISTIC");
        }
        if (this.source != null) {
            stringBuilder.append(" AS ").append(StringUtils.quoteStringSQL(this.source));
        } else {
            stringBuilder.append(" FOR ").append(Parser.quoteIdentifier(this.className + "." + this.methodName));
        }
        return stringBuilder.toString();
    }

    public int getType() {
        return 9;
    }

    public synchronized void removeChildrenAndResources(Session session) {
        this.database.removeMeta(session, this.getId());
        this.className = null;
        this.methodName = null;
        this.javaMethods = null;
        this.invalidate();
    }

    public void checkRename() {
        throw DbException.getUnsupportedException("RENAME");
    }

    public JavaMethod findJavaMethod(Expression[] expressionArray) {
        this.load();
        int n = expressionArray.length;
        for (JavaMethod javaMethod : this.javaMethods) {
            int n2 = javaMethod.getParameterCount();
            if (n2 != n && (!javaMethod.isVarArgs() || n2 > n + 1)) continue;
            return javaMethod;
        }
        throw DbException.get(90087, this.methodName + " (" + this.className + ", parameter count: " + n + ")");
    }

    public String getJavaClassName() {
        return this.className;
    }

    public String getJavaMethodName() {
        return this.methodName;
    }

    public JavaMethod[] getJavaMethods() {
        this.load();
        return this.javaMethods;
    }

    public void setDeterministic(boolean bl) {
        this.deterministic = bl;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    public String getSource() {
        return this.source;
    }

    static boolean isVarArgs(Method method) {
        if ("1.5".compareTo(SysProperties.JAVA_SPECIFICATION_VERSION) > 0) {
            return false;
        }
        try {
            Method method2 = method.getClass().getMethod("isVarArgs", new Class[0]);
            Boolean bl = (Boolean)method2.invoke((Object)method, new Object[0]);
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JavaMethod
    implements Comparable<JavaMethod> {
        private final int id;
        private final Method method;
        private final int dataType;
        private boolean hasConnectionParam;
        private boolean varArgs;
        private Class<?> varArgClass;
        private int paramCount;

        JavaMethod(Method method, int n) {
            Class<?> clazz;
            this.method = method;
            this.id = n;
            Class<?>[] classArray = method.getParameterTypes();
            this.paramCount = classArray.length;
            if (this.paramCount > 0 && Connection.class.isAssignableFrom(clazz = classArray[0])) {
                this.hasConnectionParam = true;
                --this.paramCount;
            }
            if (this.paramCount > 0 && (clazz = classArray[classArray.length - 1]).isArray() && FunctionAlias.isVarArgs(method)) {
                this.varArgs = true;
                this.varArgClass = clazz.getComponentType();
            }
            clazz = method.getReturnType();
            this.dataType = DataType.getTypeFromClass(clazz);
        }

        public String toString() {
            return this.method.toString();
        }

        public boolean hasConnectionParam() {
            return this.hasConnectionParam;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Value getValue(Session session, Expression[] expressionArray, boolean bl) {
            Value value;
            Class<?> clazz;
            int n;
            Class<?>[] classArray = this.method.getParameterTypes();
            Object[] objectArray = new Object[classArray.length];
            int n2 = 0;
            if (this.hasConnectionParam && objectArray.length > 0) {
                objectArray[n2++] = session.createConnection(bl);
            }
            Object object = null;
            if (this.varArgs) {
                n = expressionArray.length - objectArray.length + 1 + (this.hasConnectionParam ? 1 : 0);
                objectArray[objectArray.length - 1] = object = Array.newInstance(this.varArgClass, n);
            }
            n = 0;
            while (n < expressionArray.length) {
                boolean bl2 = this.varArgs && n2 >= classArray.length - 1;
                clazz = bl2 ? this.varArgClass : classArray[n2];
                int n3 = DataType.getTypeFromClass(clazz);
                value = expressionArray[n].getValue(session);
                Object object2 = (value = value.convertTo(n3)).getObject();
                if (object2 == null) {
                    if (clazz.isPrimitive()) {
                        if (!bl) return ValueNull.INSTANCE;
                        object2 = DataType.getDefaultForPrimitiveType(clazz);
                    }
                } else if (!clazz.isAssignableFrom(object2.getClass()) && !clazz.isPrimitive()) {
                    object2 = DataType.convertTo(session, session.createConnection(false), value, clazz);
                }
                if (bl2) {
                    Array.set(object, n2 - objectArray.length + 1, object2);
                } else {
                    objectArray[n2] = object2;
                }
                ++n;
                ++n2;
            }
            n = session.getAutoCommit() ? 1 : 0;
            Value value2 = session.getScopeIdentity();
            try {
                session.setAutoCommit(false);
                try {
                    clazz = this.method.invoke(null, objectArray);
                    if (clazz == null) {
                        ValueNull valueNull = ValueNull.INSTANCE;
                        return valueNull;
                    }
                }
                catch (Exception exception) {
                    throw DbException.convert(exception);
                }
                Value value3 = DataType.convertToValue(session, clazz, this.dataType);
                value = value3.convertTo(this.dataType);
                return value;
            }
            finally {
                session.setScopeIdentity(value2);
                session.setAutoCommit(n != 0);
            }
        }

        public Class<?>[] getColumnClasses() {
            return this.method.getParameterTypes();
        }

        public int getDataType() {
            return this.dataType;
        }

        public int getParameterCount() {
            return this.paramCount;
        }

        public boolean isVarArgs() {
            return this.varArgs;
        }

        @Override
        public int compareTo(JavaMethod javaMethod) {
            if (this.varArgs != javaMethod.varArgs) {
                return this.varArgs ? 1 : -1;
            }
            if (this.paramCount != javaMethod.paramCount) {
                return this.paramCount - javaMethod.paramCount;
            }
            if (this.hasConnectionParam != javaMethod.hasConnectionParam) {
                return this.hasConnectionParam ? 1 : -1;
            }
            return this.id - javaMethod.id;
        }
    }
}

