/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import org.h2.result.SearchRow;
import org.h2.store.Data;
import org.h2.util.StatementBuilder;
import org.h2.value.Value;

public class Row
implements SearchRow {
    public static final int MEMORY_CALCULATE = -1;
    private long key;
    private final Value[] data;
    private final int memory;
    private int version;
    private boolean deleted;
    private int sessionId;

    public Row(Value[] valueArray, int n) {
        this.data = valueArray;
        this.memory = n != -1 ? 16 + n * 4 : -1;
    }

    public void setKeyAndVersion(SearchRow searchRow) {
        this.setKey(searchRow.getKey());
        this.setVersion(searchRow.getVersion());
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    public long getKey() {
        return this.key;
    }

    public void setKey(long l) {
        this.key = l;
    }

    public Value getValue(int n) {
        return this.data[n];
    }

    public int getByteCount(Data data) {
        int n = 0;
        for (Value value : this.data) {
            n += data.getValueLen(value);
        }
        return n;
    }

    public void setValue(int n, Value value) {
        this.data[n] = value;
    }

    public boolean isEmpty() {
        return this.data == null;
    }

    public int getColumnCount() {
        return this.data.length;
    }

    public int getMemorySize() {
        if (this.memory != -1) {
            return this.memory;
        }
        int n = 8;
        for (int i = 0; this.data != null && i < this.data.length; ++i) {
            n += this.data[i].getMemory();
        }
        return n;
    }

    public String toString() {
        StatementBuilder statementBuilder = new StatementBuilder("( /* key:");
        statementBuilder.append(this.getKey());
        if (this.version != 0) {
            statementBuilder.append(" v:" + this.version);
        }
        if (this.isDeleted()) {
            statementBuilder.append(" deleted");
        }
        statementBuilder.append(" */ ");
        if (this.data != null) {
            for (Value value : this.data) {
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append(value == null ? "null" : value.getTraceSQL());
            }
        }
        return statementBuilder.append(')').toString();
    }

    public void setDeleted(boolean bl) {
        this.deleted = bl;
    }

    public void setSessionId(int n) {
        this.sessionId = n;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public void commit() {
        this.sessionId = 0;
    }

    public boolean isDeleted() {
        return this.deleted;
    }
}

