/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.h2.constant.SysProperties;
import org.h2.message.DbException;
import org.h2.mvstore.DataUtils;
import org.h2.result.SortOrder;
import org.h2.store.Data;
import org.h2.store.DataHandler;
import org.h2.store.LobStorageFrontend;
import org.h2.store.LobStorageInterface;
import org.h2.tools.SimpleResultSet;
import org.h2.util.DateTimeUtils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueInt;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueLob;
import org.h2.value.ValueLobDb;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueStringFixed;
import org.h2.value.ValueStringIgnoreCase;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueUuid;

public class ValueDataType
implements org.h2.mvstore.type.DataType {
    static final String PREFIX = ValueDataType.class.getName();
    private static final int INT_0_15 = 32;
    private static final int LONG_0_7 = 48;
    private static final int DECIMAL_0_1 = 56;
    private static final int DECIMAL_SMALL_0 = 58;
    private static final int DECIMAL_SMALL = 59;
    private static final int DOUBLE_0_1 = 60;
    private static final int FLOAT_0_1 = 62;
    private static final int BOOLEAN_FALSE = 64;
    private static final int BOOLEAN_TRUE = 65;
    private static final int INT_NEG = 66;
    private static final int LONG_NEG = 67;
    private static final int STRING_0_31 = 68;
    private static final int BYTES_0_31 = 100;
    private static final int LOCAL_TIME = 132;
    private static final int LOCAL_DATE = 133;
    private static final int LOCAL_TIMESTAMP = 134;
    private static final long MILLIS_PER_MINUTE = 60000L;
    final DataHandler handler;
    final CompareMode compareMode;
    final int[] sortTypes;

    public ValueDataType(CompareMode compareMode, DataHandler dataHandler, int[] nArray) {
        this.compareMode = compareMode;
        this.handler = dataHandler;
        this.sortTypes = nArray;
    }

    @Override
    public int compare(Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        if (object instanceof ValueArray && object2 instanceof ValueArray) {
            Value[] valueArray = ((ValueArray)object).getList();
            Value[] valueArray2 = ((ValueArray)object2).getList();
            int n = valueArray.length;
            int n2 = valueArray2.length;
            int n3 = Math.min(n, n2);
            for (int i = 0; i < n3; ++i) {
                int n4 = this.compareValues(valueArray[i], valueArray2[i], this.sortTypes[i]);
                if (n4 == 0) continue;
                return n4;
            }
            if (n3 < n) {
                return -1;
            }
            if (n3 < n2) {
                return 1;
            }
            return 0;
        }
        return this.compareValues((Value)object, (Value)object2, 0);
    }

    private int compareValues(Value value, Value value2, int n) {
        boolean bl;
        if (value == value2) {
            return 0;
        }
        boolean bl2 = value == null;
        boolean bl3 = bl = value2 == null;
        if (bl2 || bl) {
            return SortOrder.compareNull(bl2, n);
        }
        int n2 = this.compareTypeSave(value, value2);
        if ((n & 1) != 0) {
            n2 = -n2;
        }
        return n2;
    }

    private int compareTypeSave(Value value, Value value2) {
        if (value == value2) {
            return 0;
        }
        int n = Value.getHigherOrder(value.getType(), value2.getType());
        value = value.convertTo(n);
        value2 = value2.convertTo(n);
        return value.compareTypeSave(value2, this.compareMode);
    }

    @Override
    public int getMemory(Object object) {
        return ValueDataType.getMemory((Value)object);
    }

    private static int getMemory(Value value) {
        return value == null ? 0 : value.getMemory();
    }

    @Override
    public Value read(ByteBuffer byteBuffer) {
        return this.readValue(byteBuffer);
    }

    @Override
    public ByteBuffer write(ByteBuffer byteBuffer, Object object) {
        Value value = (Value)object;
        byteBuffer = DataUtils.ensureCapacity(byteBuffer, 0);
        byteBuffer = this.writeValue(byteBuffer, value);
        return byteBuffer;
    }

    private ByteBuffer writeValue(ByteBuffer byteBuffer, Value value) {
        int n = byteBuffer.position();
        if (value == ValueNull.INSTANCE) {
            byteBuffer.put((byte)0);
            return byteBuffer;
        }
        int n2 = value.getType();
        switch (n2) {
            case 1: {
                byteBuffer.put((byte)(value.getBoolean() != false ? 65 : 64));
                break;
            }
            case 2: {
                byteBuffer.put((byte)n2);
                byteBuffer.put(value.getByte());
                break;
            }
            case 3: {
                byteBuffer.put((byte)n2);
                byteBuffer.putShort(value.getShort());
                break;
            }
            case 4: {
                int n3 = value.getInt();
                if (n3 < 0) {
                    byteBuffer.put((byte)66);
                    ValueDataType.writeVarInt(byteBuffer, -n3);
                    break;
                }
                if (n3 < 16) {
                    byteBuffer.put((byte)(32 + n3));
                    break;
                }
                byteBuffer.put((byte)n2);
                ValueDataType.writeVarInt(byteBuffer, n3);
                break;
            }
            case 5: {
                long l = value.getLong();
                if (l < 0L) {
                    byteBuffer.put((byte)67);
                    ValueDataType.writeVarLong(byteBuffer, -l);
                    break;
                }
                if (l < 8L) {
                    byteBuffer.put((byte)(48L + l));
                    break;
                }
                byteBuffer.put((byte)n2);
                ValueDataType.writeVarLong(byteBuffer, l);
                break;
            }
            case 6: {
                BigDecimal bigDecimal = value.getBigDecimal();
                if (BigDecimal.ZERO.equals(bigDecimal)) {
                    byteBuffer.put((byte)56);
                    break;
                }
                if (BigDecimal.ONE.equals(bigDecimal)) {
                    byteBuffer.put((byte)57);
                    break;
                }
                int n4 = bigDecimal.scale();
                BigInteger bigInteger = bigDecimal.unscaledValue();
                int n5 = bigInteger.bitLength();
                if (n5 <= 63) {
                    if (n4 == 0) {
                        byteBuffer.put((byte)58);
                        ValueDataType.writeVarLong(byteBuffer, bigInteger.longValue());
                        break;
                    }
                    byteBuffer.put((byte)59);
                    ValueDataType.writeVarInt(byteBuffer, n4);
                    ValueDataType.writeVarLong(byteBuffer, bigInteger.longValue());
                    break;
                }
                byteBuffer.put((byte)n2);
                ValueDataType.writeVarInt(byteBuffer, n4);
                byte[] byArray = bigInteger.toByteArray();
                ValueDataType.writeVarInt(byteBuffer, byArray.length);
                byteBuffer = DataUtils.ensureCapacity(byteBuffer, byArray.length);
                byteBuffer.put(byArray, 0, byArray.length);
                break;
            }
            case 9: {
                if (SysProperties.STORE_LOCAL_TIME) {
                    byteBuffer.put((byte)-124);
                    ValueTime valueTime = (ValueTime)value;
                    long l = valueTime.getNanos();
                    long l2 = l / 1000000L;
                    ValueDataType.writeVarLong(byteBuffer, l2);
                    ValueDataType.writeVarLong(byteBuffer, l -= l2 * 1000000L);
                    break;
                }
                byteBuffer.put((byte)n2);
                ValueDataType.writeVarLong(byteBuffer, DateTimeUtils.getTimeLocalWithoutDst(value.getTime()));
                break;
            }
            case 10: {
                if (SysProperties.STORE_LOCAL_TIME) {
                    byteBuffer.put((byte)-123);
                    long l = ((ValueDate)value).getDateValue();
                    ValueDataType.writeVarLong(byteBuffer, l);
                    break;
                }
                byteBuffer.put((byte)n2);
                long l = DateTimeUtils.getTimeLocalWithoutDst(value.getDate());
                ValueDataType.writeVarLong(byteBuffer, l / 60000L);
                break;
            }
            case 11: {
                if (SysProperties.STORE_LOCAL_TIME) {
                    byteBuffer.put((byte)-122);
                    ValueTimestamp valueTimestamp = (ValueTimestamp)value;
                    long l = valueTimestamp.getDateValue();
                    ValueDataType.writeVarLong(byteBuffer, l);
                    long l3 = valueTimestamp.getNanos();
                    long l4 = l3 / 1000000L;
                    ValueDataType.writeVarLong(byteBuffer, l4);
                    ValueDataType.writeVarLong(byteBuffer, l3 -= l4 * 1000000L);
                    break;
                }
                Timestamp timestamp = value.getTimestamp();
                byteBuffer.put((byte)n2);
                ValueDataType.writeVarLong(byteBuffer, DateTimeUtils.getTimeLocalWithoutDst(timestamp));
                ValueDataType.writeVarInt(byteBuffer, timestamp.getNanos());
                break;
            }
            case 19: {
                byteBuffer.put((byte)n2);
                byte[] byArray = value.getBytesNoCopy();
                ValueDataType.writeVarInt(byteBuffer, byArray.length);
                byteBuffer = DataUtils.ensureCapacity(byteBuffer, byArray.length);
                byteBuffer.put(byArray, 0, byArray.length);
                break;
            }
            case 12: {
                byte[] byArray = value.getBytesNoCopy();
                int n6 = byArray.length;
                if (n6 < 32) {
                    byteBuffer.put((byte)(100 + n6));
                    byteBuffer.put(byArray, 0, byArray.length);
                    break;
                }
                byteBuffer.put((byte)n2);
                ValueDataType.writeVarInt(byteBuffer, byArray.length);
                byteBuffer = DataUtils.ensureCapacity(byteBuffer, byArray.length);
                byteBuffer.put(byArray, 0, byArray.length);
                break;
            }
            case 20: {
                byteBuffer.put((byte)n2);
                ValueUuid valueUuid = (ValueUuid)value;
                byteBuffer.putLong(valueUuid.getHigh());
                byteBuffer.putLong(valueUuid.getLow());
                break;
            }
            case 13: {
                String string = value.getString();
                int n7 = string.length();
                if (n7 < 32) {
                    byteBuffer.put((byte)(68 + n7));
                    byteBuffer = ValueDataType.writeStringWithoutLength(byteBuffer, string, n7);
                    break;
                }
                byteBuffer.put((byte)n2);
                byteBuffer = ValueDataType.writeString(byteBuffer, string);
                break;
            }
            case 14: 
            case 21: {
                byteBuffer.put((byte)n2);
                byteBuffer = ValueDataType.writeString(byteBuffer, value.getString());
                break;
            }
            case 7: {
                double d = value.getDouble();
                if (d == 1.0) {
                    byteBuffer.put((byte)61);
                    break;
                }
                long l = Double.doubleToLongBits(d);
                if (l == ValueDouble.ZERO_BITS) {
                    byteBuffer.put((byte)60);
                    break;
                }
                byteBuffer.put((byte)n2);
                ValueDataType.writeVarLong(byteBuffer, Long.reverse(l));
                break;
            }
            case 8: {
                float f = value.getFloat();
                if (f == 1.0f) {
                    byteBuffer.put((byte)63);
                    break;
                }
                int n8 = Float.floatToIntBits(f);
                if (n8 == ValueFloat.ZERO_BITS) {
                    byteBuffer.put((byte)62);
                    break;
                }
                byteBuffer.put((byte)n2);
                ValueDataType.writeVarInt(byteBuffer, Integer.reverse(n8));
                break;
            }
            case 15: 
            case 16: {
                byteBuffer.put((byte)n2);
                if (value instanceof ValueLob) {
                    ValueLob valueLob = (ValueLob)value;
                    valueLob.convertToFileIfRequired(this.handler);
                    byte[] byArray = valueLob.getSmall();
                    if (byArray == null) {
                        int n9 = -1;
                        if (!valueLob.isLinked()) {
                            n9 = -2;
                        }
                        ValueDataType.writeVarInt(byteBuffer, n9);
                        ValueDataType.writeVarInt(byteBuffer, valueLob.getTableId());
                        ValueDataType.writeVarInt(byteBuffer, valueLob.getObjectId());
                        ValueDataType.writeVarLong(byteBuffer, valueLob.getPrecision());
                        byteBuffer.put((byte)(valueLob.useCompression() ? 1 : 0));
                        if (n9 != -2) break;
                        byteBuffer = ValueDataType.writeString(byteBuffer, valueLob.getFileName());
                        break;
                    }
                    ValueDataType.writeVarInt(byteBuffer, byArray.length);
                    byteBuffer = DataUtils.ensureCapacity(byteBuffer, byArray.length);
                    byteBuffer.put(byArray, 0, byArray.length);
                    break;
                }
                ValueLobDb valueLobDb = (ValueLobDb)value;
                byte[] byArray = valueLobDb.getSmall();
                if (byArray == null) {
                    ValueDataType.writeVarInt(byteBuffer, -3);
                    ValueDataType.writeVarInt(byteBuffer, valueLobDb.getTableId());
                    ValueDataType.writeVarLong(byteBuffer, valueLobDb.getLobId());
                    ValueDataType.writeVarLong(byteBuffer, valueLobDb.getPrecision());
                    break;
                }
                ValueDataType.writeVarInt(byteBuffer, byArray.length);
                byteBuffer = DataUtils.ensureCapacity(byteBuffer, byArray.length);
                byteBuffer.put(byArray, 0, byArray.length);
                break;
            }
            case 17: {
                byteBuffer.put((byte)n2);
                Value[] valueArray = ((ValueArray)value).getList();
                ValueDataType.writeVarInt(byteBuffer, valueArray.length);
                for (Value value2 : valueArray) {
                    byteBuffer = DataUtils.ensureCapacity(byteBuffer, 0);
                    byteBuffer = this.writeValue(byteBuffer, value2);
                }
                break;
            }
            case 18: {
                byteBuffer.put((byte)n2);
                try {
                    int n10;
                    ResultSet resultSet = ((ValueResultSet)value).getResultSet();
                    resultSet.beforeFirst();
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    int n11 = resultSetMetaData.getColumnCount();
                    ValueDataType.writeVarInt(byteBuffer, n11);
                    for (n10 = 0; n10 < n11; ++n10) {
                        byteBuffer = DataUtils.ensureCapacity(byteBuffer, 0);
                        byteBuffer = ValueDataType.writeString(byteBuffer, resultSetMetaData.getColumnName(n10 + 1));
                        ValueDataType.writeVarInt(byteBuffer, resultSetMetaData.getColumnType(n10 + 1));
                        ValueDataType.writeVarInt(byteBuffer, resultSetMetaData.getPrecision(n10 + 1));
                        ValueDataType.writeVarInt(byteBuffer, resultSetMetaData.getScale(n10 + 1));
                    }
                    while (resultSet.next()) {
                        byteBuffer.put((byte)1);
                        for (n10 = 0; n10 < n11; ++n10) {
                            int n12 = DataType.convertSQLTypeToValueType(resultSetMetaData.getColumnType(n10 + 1));
                            Value value3 = DataType.readValue(null, resultSet, n10 + 1, n12);
                            byteBuffer = this.writeValue(byteBuffer, value3);
                        }
                    }
                    byteBuffer.put((byte)0);
                    resultSet.beforeFirst();
                    break;
                }
                catch (SQLException sQLException) {
                    throw DbException.convert(sQLException);
                }
            }
            case 22: {
                byteBuffer.put((byte)n2);
                byte[] byArray = value.getBytes();
                int n13 = byArray.length;
                ValueDataType.writeVarInt(byteBuffer, n13);
                byteBuffer = DataUtils.ensureCapacity(byteBuffer, n13);
                byteBuffer.put(byArray, 0, n13);
                break;
            }
            default: {
                DbException.throwInternalError("type=" + value.getType());
            }
        }
        if (SysProperties.CHECK2 && byteBuffer.position() - n != Data.getValueLen(value, this.handler)) {
            throw DbException.throwInternalError("value size error: got " + (byteBuffer.position() - n) + " expected " + Data.getValueLen(value, this.handler));
        }
        return byteBuffer;
    }

    private static void writeVarInt(ByteBuffer byteBuffer, int n) {
        while ((n & 0xFFFFFF80) != 0) {
            byteBuffer.put((byte)(0x80 | n & 0x7F));
            n >>>= 7;
        }
        byteBuffer.put((byte)n);
    }

    private static void writeVarLong(ByteBuffer byteBuffer, long l) {
        while ((l & 0xFFFFFFFFFFFFFF80L) != 0L) {
            byteBuffer.put((byte)(l & 0x7FL | 0x80L));
            l >>>= 7;
        }
        byteBuffer.put((byte)l);
    }

    private static ByteBuffer writeString(ByteBuffer byteBuffer, String string) {
        int n = string.length();
        ValueDataType.writeVarInt(byteBuffer, n);
        return ValueDataType.writeStringWithoutLength(byteBuffer, string, n);
    }

    private static ByteBuffer writeStringWithoutLength(ByteBuffer byteBuffer, String string, int n) {
        byteBuffer = DataUtils.ensureCapacity(byteBuffer, 3 * n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < '\u0080') {
                byteBuffer.put((byte)c);
                continue;
            }
            if (c >= '\u0800') {
                byteBuffer.put((byte)(0xE0 | c >> 12));
                byteBuffer.put((byte)(c >> 6 & 0x3F));
                byteBuffer.put((byte)(c & 0x3F));
                continue;
            }
            byteBuffer.put((byte)(0xC0 | c >> 6));
            byteBuffer.put((byte)(c & 0x3F));
        }
        return byteBuffer;
    }

    private Value readValue(ByteBuffer byteBuffer) {
        int n = byteBuffer.get() & 0xFF;
        switch (n) {
            case 0: {
                return ValueNull.INSTANCE;
            }
            case 65: {
                return ValueBoolean.get(true);
            }
            case 64: {
                return ValueBoolean.get(false);
            }
            case 66: {
                return ValueInt.get(-ValueDataType.readVarInt(byteBuffer));
            }
            case 4: {
                return ValueInt.get(ValueDataType.readVarInt(byteBuffer));
            }
            case 67: {
                return ValueLong.get(-ValueDataType.readVarLong(byteBuffer));
            }
            case 5: {
                return ValueLong.get(ValueDataType.readVarLong(byteBuffer));
            }
            case 2: {
                return ValueByte.get(byteBuffer.get());
            }
            case 3: {
                return ValueShort.get(byteBuffer.getShort());
            }
            case 56: {
                return (ValueDecimal)ValueDecimal.ZERO;
            }
            case 57: {
                return (ValueDecimal)ValueDecimal.ONE;
            }
            case 58: {
                return ValueDecimal.get(BigDecimal.valueOf(ValueDataType.readVarLong(byteBuffer)));
            }
            case 59: {
                int n2 = ValueDataType.readVarInt(byteBuffer);
                return ValueDecimal.get(BigDecimal.valueOf(ValueDataType.readVarLong(byteBuffer), n2));
            }
            case 6: {
                int n3 = ValueDataType.readVarInt(byteBuffer);
                int n4 = ValueDataType.readVarInt(byteBuffer);
                byte[] byArray = DataUtils.newBytes(n4);
                byteBuffer.get(byArray, 0, n4);
                BigInteger bigInteger = new BigInteger(byArray);
                return ValueDecimal.get(new BigDecimal(bigInteger, n3));
            }
            case 133: {
                return ValueDate.fromDateValue(ValueDataType.readVarLong(byteBuffer));
            }
            case 10: {
                long l = ValueDataType.readVarLong(byteBuffer) * 60000L;
                return ValueDate.get(new Date(DateTimeUtils.getTimeUTCWithoutDst(l)));
            }
            case 132: {
                long l = ValueDataType.readVarLong(byteBuffer) * 1000000L + ValueDataType.readVarLong(byteBuffer);
                return ValueTime.fromNanos(l);
            }
            case 9: {
                return ValueTime.get(new Time(DateTimeUtils.getTimeUTCWithoutDst(ValueDataType.readVarLong(byteBuffer))));
            }
            case 134: {
                long l = ValueDataType.readVarLong(byteBuffer);
                long l2 = ValueDataType.readVarLong(byteBuffer) * 1000000L + ValueDataType.readVarLong(byteBuffer);
                return ValueTimestamp.fromDateValueAndNanos(l, l2);
            }
            case 11: {
                Timestamp timestamp = new Timestamp(DateTimeUtils.getTimeUTCWithoutDst(ValueDataType.readVarLong(byteBuffer)));
                timestamp.setNanos(ValueDataType.readVarInt(byteBuffer));
                return ValueTimestamp.get(timestamp);
            }
            case 12: {
                int n5 = ValueDataType.readVarInt(byteBuffer);
                byte[] byArray = DataUtils.newBytes(n5);
                byteBuffer.get(byArray, 0, n5);
                return ValueBytes.getNoCopy(byArray);
            }
            case 19: {
                int n6 = ValueDataType.readVarInt(byteBuffer);
                byte[] byArray = DataUtils.newBytes(n6);
                byteBuffer.get(byArray, 0, n6);
                return ValueJavaObject.getNoCopy(null, byArray);
            }
            case 20: {
                return ValueUuid.get(byteBuffer.getLong(), byteBuffer.getLong());
            }
            case 13: {
                return ValueString.get(ValueDataType.readString(byteBuffer));
            }
            case 14: {
                return ValueStringIgnoreCase.get(ValueDataType.readString(byteBuffer));
            }
            case 21: {
                return ValueStringFixed.get(ValueDataType.readString(byteBuffer));
            }
            case 62: {
                return ValueFloat.get(0.0f);
            }
            case 63: {
                return ValueFloat.get(1.0f);
            }
            case 60: {
                return ValueDouble.get(0.0);
            }
            case 61: {
                return ValueDouble.get(1.0);
            }
            case 7: {
                return ValueDouble.get(Double.longBitsToDouble(Long.reverse(ValueDataType.readVarLong(byteBuffer))));
            }
            case 8: {
                return ValueFloat.get(Float.intBitsToFloat(Integer.reverse(ValueDataType.readVarInt(byteBuffer))));
            }
            case 15: 
            case 16: {
                int n7 = ValueDataType.readVarInt(byteBuffer);
                if (n7 >= 0) {
                    byte[] byArray = DataUtils.newBytes(n7);
                    byteBuffer.get(byArray, 0, n7);
                    return LobStorageFrontend.createSmallLob(n, byArray);
                }
                if (n7 == -3) {
                    int n8 = ValueDataType.readVarInt(byteBuffer);
                    long l = ValueDataType.readVarLong(byteBuffer);
                    long l3 = ValueDataType.readVarLong(byteBuffer);
                    LobStorageInterface lobStorageInterface = this.handler.getLobStorage();
                    ValueLobDb valueLobDb = ValueLobDb.create(n, lobStorageInterface, n8, l, null, l3);
                    return valueLobDb;
                }
                int n9 = ValueDataType.readVarInt(byteBuffer);
                int n10 = ValueDataType.readVarInt(byteBuffer);
                long l = 0L;
                boolean bl = false;
                if (n7 == -1 || n7 == -2) {
                    l = ValueDataType.readVarLong(byteBuffer);
                    boolean bl2 = bl = byteBuffer.get() == 1;
                }
                if (n7 == -2) {
                    String string = ValueDataType.readString(byteBuffer);
                    return ValueLob.openUnlinked(n, this.handler, n9, n10, l, bl, string);
                }
                ValueLob valueLob = ValueLob.openLinked(n, this.handler, n9, n10, l, bl);
                return valueLob;
            }
            case 17: {
                int n11 = ValueDataType.readVarInt(byteBuffer);
                Value[] valueArray = new Value[n11];
                for (int i = 0; i < n11; ++i) {
                    valueArray[i] = this.readValue(byteBuffer);
                }
                return ValueArray.get(valueArray);
            }
            case 18: {
                SimpleResultSet simpleResultSet = new SimpleResultSet();
                int n12 = ValueDataType.readVarInt(byteBuffer);
                for (int i = 0; i < n12; ++i) {
                    simpleResultSet.addColumn(ValueDataType.readString(byteBuffer), ValueDataType.readVarInt(byteBuffer), ValueDataType.readVarInt(byteBuffer), ValueDataType.readVarInt(byteBuffer));
                }
                while (byteBuffer.get() != 0) {
                    Object[] objectArray = new Object[n12];
                    for (int i = 0; i < n12; ++i) {
                        objectArray[i] = this.readValue(byteBuffer).getObject();
                    }
                    simpleResultSet.addRow(objectArray);
                }
                return ValueResultSet.get(simpleResultSet);
            }
            case 22: {
                int n13 = ValueDataType.readVarInt(byteBuffer);
                byte[] byArray = DataUtils.newBytes(n13);
                byteBuffer.get(byArray, 0, n13);
                return ValueGeometry.get(byArray);
            }
        }
        if (n >= 32 && n < 48) {
            return ValueInt.get(n - 32);
        }
        if (n >= 48 && n < 56) {
            return ValueLong.get(n - 48);
        }
        if (n >= 100 && n < 132) {
            int n14 = n - 100;
            byte[] byArray = DataUtils.newBytes(n14);
            byteBuffer.get(byArray, 0, n14);
            return ValueBytes.getNoCopy(byArray);
        }
        if (n >= 68 && n < 100) {
            return ValueString.get(ValueDataType.readString(byteBuffer, n - 68));
        }
        throw DbException.get(90030, "type: " + n);
    }

    private static int readVarInt(ByteBuffer byteBuffer) {
        return DataUtils.readVarInt(byteBuffer);
    }

    private static long readVarLong(ByteBuffer byteBuffer) {
        return DataUtils.readVarLong(byteBuffer);
    }

    private static String readString(ByteBuffer byteBuffer, int n) {
        return DataUtils.readString(byteBuffer, n);
    }

    private static String readString(ByteBuffer byteBuffer) {
        int n = ValueDataType.readVarInt(byteBuffer);
        return DataUtils.readString(byteBuffer, n);
    }
}

