/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.internal.Constants;
import com.obs.services.internal.IConvertor;
import com.obs.services.internal.IHeaders;
import com.obs.services.internal.RepeatableRequestEntity;
import com.obs.services.internal.RestStorageService;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.SimpleProgressManager;
import com.obs.services.internal.io.ProgressInputStream;
import com.obs.services.internal.utils.AbstractAuthentication;
import com.obs.services.internal.utils.Mimetypes;
import com.obs.services.internal.utils.RestUtils;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.AppendObjectRequest;
import com.obs.services.model.AuthTypeEnum;
import com.obs.services.model.AvailableZoneEnum;
import com.obs.services.model.BucketTypeEnum;
import com.obs.services.model.CopyObjectRequest;
import com.obs.services.model.CopyPartRequest;
import com.obs.services.model.CreateBucketRequest;
import com.obs.services.model.ExtensionBucketPermissionEnum;
import com.obs.services.model.ExtensionObjectPermissionEnum;
import com.obs.services.model.GenericRequest;
import com.obs.services.model.GetObjectRequest;
import com.obs.services.model.HeaderResponse;
import com.obs.services.model.InitiateMultipartUploadRequest;
import com.obs.services.model.ListObjectsRequest;
import com.obs.services.model.ListVersionsRequest;
import com.obs.services.model.ModifyObjectRequest;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.PutObjectBasicRequest;
import com.obs.services.model.PutObjectRequest;
import com.obs.services.model.RestoreObjectRequest;
import com.obs.services.model.RestoreObjectResult;
import com.obs.services.model.SetObjectMetadataRequest;
import com.obs.services.model.SpecialParamEnum;
import com.obs.services.model.SseCHeader;
import com.obs.services.model.SseKmsHeader;
import com.obs.services.model.StorageClassEnum;
import com.obs.services.model.UploadPartRequest;
import com.obs.services.model.fs.FSStatusEnum;
import com.obs.services.model.fs.GetBucketFSStatusResult;
import com.obs.services.model.fs.ListContentSummaryRequest;
import com.obs.services.model.fs.NewBucketRequest;
import com.obs.services.model.fs.WriteFileRequest;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.Response;

public class RequestConvertor
extends RestStorageService {
    private static final ILogger log = LoggerBuilder.getLogger("com.obs.services.ObsClient");

    TransResult transListVersionsRequest(ListVersionsRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(SpecialParamEnum.VERSIONS.getOriginalStringCode(), "");
        if (request.getPrefix() != null) {
            params.put("prefix", request.getPrefix());
        }
        if (request.getDelimiter() != null) {
            params.put("delimiter", request.getDelimiter());
        }
        if (request.getMaxKeys() > 0) {
            params.put("max-keys", String.valueOf(request.getMaxKeys()));
        }
        if (request.getKeyMarker() != null) {
            params.put("key-marker", request.getKeyMarker());
        }
        if (request.getVersionIdMarker() != null) {
            params.put("version-id-marker", request.getVersionIdMarker());
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        if (request.getListTimeout() > 0) {
            this.putHeader(headers, this.getIHeaders().listTimeoutHeader(), String.valueOf(request.getListTimeout()));
        }
        this.transRequestPaymentHeaders(request, headers, this.getIHeaders());
        return new TransResult(headers, params, null);
    }

    Map<String, String> transRequestPaymentHeaders(boolean isRequesterPays, Map<String, String> headers, IHeaders iheaders) throws ServiceException {
        if (isRequesterPays) {
            if (null == headers) {
                headers = new HashMap<String, String>();
            }
            this.putHeader(headers, iheaders.requestPaymentHeader(), "requester");
        }
        return headers;
    }

    Map<String, String> transRequestPaymentHeaders(GenericRequest request, Map<String, String> headers, IHeaders iheaders) throws ServiceException {
        if (null != request) {
            return this.transRequestPaymentHeaders(request.isRequesterPays(), headers, iheaders);
        }
        return null;
    }

    TransResult transInitiateMultipartUploadRequest(InitiateMultipartUploadRequest request) throws ServiceException {
        Object contentType;
        HashMap<String, String> headers = new HashMap<String, String>();
        IHeaders iheaders = this.getIHeaders();
        IConvertor iconvertor = this.getIConvertor();
        ObjectMetadata objectMetadata = request.getMetadata() == null ? new ObjectMetadata() : request.getMetadata();
        for (Map.Entry<String, Object> entry : objectMetadata.getMetadata().entrySet()) {
            String key = entry.getKey();
            if (!ServiceUtils.isValid(key)) continue;
            key = key.trim();
            if ((CAN_USE_STANDARD_HTTP_HEADERS.get() == null || CAN_USE_STANDARD_HTTP_HEADERS.get() != null && !((Boolean)CAN_USE_STANDARD_HTTP_HEADERS.get()).booleanValue()) && Constants.ALLOWED_REQUEST_HTTP_HEADER_METADATA_NAMES.contains(key.toLowerCase())) continue;
            headers.put(key, entry.getValue() == null ? "" : entry.getValue().toString());
        }
        if (objectMetadata.getObjectStorageClass() != null) {
            this.putHeader(headers, iheaders.storageClassHeader(), iconvertor.transStorageClass(objectMetadata.getObjectStorageClass()));
        }
        if (request.getExpires() > 0) {
            this.putHeader(headers, iheaders.expiresHeader(), String.valueOf(request.getExpires()));
        }
        if (ServiceUtils.isValid(objectMetadata.getWebSiteRedirectLocation())) {
            this.putHeader(headers, iheaders.websiteRedirectLocationHeader(), objectMetadata.getWebSiteRedirectLocation());
        }
        if (ServiceUtils.isValid(request.getSuccessRedirectLocation())) {
            this.putHeader(headers, iheaders.successRedirectLocationHeader(), request.getSuccessRedirectLocation());
        }
        if (ServiceUtils.isValid(objectMetadata.getContentEncoding())) {
            headers.put("Content-Encoding", objectMetadata.getContentEncoding().trim());
        }
        this.transRequestPaymentHeaders(request, headers, iheaders);
        this.transExtensionPermissions(request, headers);
        this.transSseHeaders(request, headers, iheaders);
        Object object = contentType = objectMetadata.getContentType() == null ? objectMetadata.getValue("Content-Type") : objectMetadata.getContentType();
        if (contentType == null) {
            contentType = Mimetypes.getInstance().getMimetype(request.getObjectKey());
        }
        String contentTypeStr = contentType.toString().trim();
        headers.put("Content-Type", contentTypeStr);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(SpecialParamEnum.UPLOADS.getOriginalStringCode(), "");
        return new TransResult(headers, params, null);
    }

    String getHeaderByMethodName(String code) {
        try {
            IHeaders iheaders = this.getIHeaders();
            Method m = iheaders.getClass().getMethod(code, new Class[0]);
            Object result = m.invoke((Object)iheaders, new Object[0]);
            return result == null ? "" : result.toString();
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn("Invoke getHeaderByMethodName error", e);
            }
            return null;
        }
    }

    void transExtensionPermissions(PutObjectBasicRequest request, Map<String, String> headers) {
        Set<ExtensionObjectPermissionEnum> extensionPermissionEnums = request.getAllGrantPermissions();
        if (!extensionPermissionEnums.isEmpty()) {
            for (ExtensionObjectPermissionEnum extensionPermissionEnum : extensionPermissionEnums) {
                Set<String> domainIds = request.getDomainIdsByGrantPermission(extensionPermissionEnum);
                ArrayList<String> domainIdList = new ArrayList<String>(domainIds.size());
                for (String domainId : domainIds) {
                    domainIdList.add("id=" + domainId);
                }
                this.putHeader(headers, this.getHeaderByMethodName(extensionPermissionEnum.getCode()), ServiceUtils.join(domainIdList, ","));
            }
        }
    }

    void transSseHeaders(PutObjectBasicRequest request, Map<String, String> headers, IHeaders iheaders) throws ServiceException {
        if (null != request.getSseCHeader()) {
            this.transSseCHeaders(request.getSseCHeader(), headers, iheaders);
        } else if (null != request.getSseKmsHeader()) {
            this.transSseKmsHeaders(request.getSseKmsHeader(), headers, iheaders);
        }
    }

    void transSseCHeaders(SseCHeader cHeader, Map<String, String> headers, IHeaders iheaders) throws ServiceException {
        if (cHeader == null) {
            return;
        }
        String sseCAlgorithm = cHeader.getSSEAlgorithm().getCode();
        this.putHeader(headers, iheaders.sseCHeader(), ServiceUtils.toValid(sseCAlgorithm));
        if (cHeader.getSseCKeyBase64() != null) {
            try {
                this.putHeader(headers, iheaders.sseCKeyHeader(), cHeader.getSseCKeyBase64());
                this.putHeader(headers, iheaders.sseCKeyMd5Header(), ServiceUtils.toBase64(ServiceUtils.computeMD5Hash(ServiceUtils.fromBase64(cHeader.getSseCKeyBase64()))));
            }
            catch (IOException e) {
                throw new IllegalStateException("fail to read sseCkey", e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("fail to read sseCkey", e);
            }
        }
        if (null != cHeader.getSseCKey()) {
            try {
                byte[] data = cHeader.getSseCKey();
                this.putHeader(headers, iheaders.sseCKeyHeader(), ServiceUtils.toBase64(data));
                this.putHeader(headers, iheaders.sseCKeyMd5Header(), ServiceUtils.toBase64(ServiceUtils.computeMD5Hash(data)));
            }
            catch (IOException e) {
                throw new IllegalStateException("fail to read sseCkey", e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("fail to read sseCkey", e);
            }
        }
    }

    TransResult transCreateBucketRequest(CreateBucketRequest request) throws ServiceException {
        Set<ExtensionBucketPermissionEnum> extensionPermissionEnums;
        HashMap<String, String> headers = new HashMap<String, String>();
        IConvertor convertor = this.getIConvertor();
        if (request.getBucketStorageClass() != null) {
            this.putHeader(headers, this.getIHeaders().defaultStorageClassHeader(), convertor.transStorageClass(request.getBucketStorageClass()));
        }
        if (request.getEpid() != null) {
            this.putHeader(headers, this.getIHeaders().epidHeader(), request.getEpid());
        }
        if (request instanceof NewBucketRequest) {
            this.putHeader(headers, this.getIHeaders().fsFileInterfaceHeader(), "Enabled");
        }
        if (null != request.getBucketType() && BucketTypeEnum.PFS == request.getBucketType()) {
            this.putHeader(headers, this.getIHeaders().fsFileInterfaceHeader(), "Enabled");
        }
        if (request.getAvailableZone() != null) {
            this.putHeader(headers, this.getIHeaders().azRedundancyHeader(), request.getAvailableZone().getCode());
        }
        if (!(extensionPermissionEnums = request.getAllGrantPermissions()).isEmpty()) {
            for (ExtensionBucketPermissionEnum extensionBucketPermissionEnum : extensionPermissionEnums) {
                Set<String> domainIds = request.getDomainIdsByGrantPermission(extensionBucketPermissionEnum);
                ArrayList<String> domainIdList = new ArrayList<String>(domainIds.size());
                for (String domainId : domainIds) {
                    domainIdList.add("id=" + domainId);
                }
                this.putHeader(headers, this.getHeaderByMethodName(extensionBucketPermissionEnum.getCode()), ServiceUtils.join(domainIdList, ","));
            }
        }
        if (request.getExtensionHeaderMap() != null) {
            for (Map.Entry entry : request.getExtensionHeaderMap().entrySet()) {
                this.putHeader(headers, (String)entry.getKey(), (String)entry.getValue());
            }
        }
        String contentType = "application/xml";
        headers.put("Content-Type", contentType);
        TransResult transResult = new TransResult(headers);
        if (ServiceUtils.isValid(request.getLocation())) {
            String configXml = convertor.transBucketLoction(request.getLocation());
            headers.put("Content-Length", String.valueOf(configXml.length()));
            RequestBody requestEntity = this.createRequestBody(contentType, configXml);
            transResult.setBody(requestEntity);
        }
        return transResult;
    }

    RestoreObjectRequest.RestoreObjectStatus transRestoreObjectResultToRestoreObjectStatus(RestoreObjectResult result) {
        RestoreObjectRequest.RestoreObjectStatus ret = RestoreObjectRequest.RestoreObjectStatus.valueOf(result.getStatusCode());
        ret.setResponseHeaders(result.getResponseHeaders());
        ret.setStatusCode(result.getStatusCode());
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    TransResult transPutObjectRequest(PutObjectRequest request) throws ServiceException {
        headers = new HashMap<String, String>();
        iconvertor = this.getIConvertor();
        iheaders = this.getIHeaders();
        objectMetadata = request.getMetadata() == null ? new ObjectMetadata() : request.getMetadata();
        for (Map.Entry<String, Object> entry : objectMetadata.getMetadata().entrySet()) {
            key = entry.getKey();
            if (!ServiceUtils.isValid(key)) continue;
            key = key.trim();
            if ((RequestConvertor.CAN_USE_STANDARD_HTTP_HEADERS.get() == null || RequestConvertor.CAN_USE_STANDARD_HTTP_HEADERS.get() != null && !((Boolean)RequestConvertor.CAN_USE_STANDARD_HTTP_HEADERS.get()).booleanValue()) && Constants.ALLOWED_REQUEST_HTTP_HEADER_METADATA_NAMES.contains(key.toLowerCase())) continue;
            headers.put(key, entry.getValue() == null ? "" : entry.getValue().toString());
        }
        if (ServiceUtils.isValid(objectMetadata.getContentMd5())) {
            headers.put("Content-MD5", objectMetadata.getContentMd5().trim());
        }
        if (ServiceUtils.isValid(objectMetadata.getContentEncoding())) {
            headers.put("Content-Encoding", objectMetadata.getContentEncoding().trim());
        }
        if (objectMetadata.getObjectStorageClass() != null) {
            this.putHeader(headers, iheaders.storageClassHeader(), iconvertor.transStorageClass(objectMetadata.getObjectStorageClass()));
        }
        if (request.getExpires() >= 0) {
            this.putHeader(headers, iheaders.expiresHeader(), String.valueOf(request.getExpires()));
        }
        if (objectMetadata.getWebSiteRedirectLocation() != null) {
            this.putHeader(headers, iheaders.websiteRedirectLocationHeader(), objectMetadata.getWebSiteRedirectLocation());
        }
        if (request.getSuccessRedirectLocation() != null) {
            this.putHeader(headers, iheaders.successRedirectLocationHeader(), request.getSuccessRedirectLocation());
        }
        this.transRequestPaymentHeaders(request, headers, iheaders);
        this.transExtensionPermissions(request, headers);
        this.transSseHeaders(request, headers, iheaders);
        v0 = contentType = objectMetadata.getContentType() == null ? objectMetadata.getValue("Content-Type") : objectMetadata.getContentType();
        if (contentType == null) {
            contentType = Mimetypes.getInstance().getMimetype(request.getObjectKey());
        }
        if ((contentLength = objectMetadata.getContentLength()) == null) {
            contentLength = objectMetadata.getValue("Content-Length");
        }
        v1 = contentLengthValue = contentLength == null ? -1L : Long.parseLong(contentLength.toString());
        if (request.getFile() != null) {
            if ("application/octet-stream".equals(contentType)) {
                contentType = Mimetypes.getInstance().getMimetype(request.getFile());
            }
            fileSize = request.getFile().length();
            try {
                request.setInput(new FileInputStream(request.getFile()));
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("File doesnot exist");
            }
            if (request.getOffset() > 0L && request.getOffset() < fileSize) {
                contentLengthValue = contentLengthValue > 0L && contentLengthValue <= fileSize - request.getOffset() ? contentLengthValue : fileSize - request.getOffset();
                try {
                    skipByte = request.getInput().skip(request.getOffset());
                    if (!RequestConvertor.log.isDebugEnabled()) ** GOTO lbl58
                    RequestConvertor.log.debug("Skip " + skipByte + " bytes; offset : " + request.getOffset());
                }
                catch (IOException e) {
                    ServiceUtils.closeStream(request.getInput());
                    throw new ServiceException(e);
                }
            } else if (contentLengthValue < 0L || contentLengthValue > fileSize) {
                contentLengthValue = fileSize;
            }
        }
lbl58:
        // 7 sources

        contentTypeStr = contentType.toString().trim();
        headers.put("Content-Type", contentTypeStr);
        if (contentLengthValue > -1L) {
            this.putHeader(headers, "Content-Length", String.valueOf(contentLengthValue));
        }
        if (request.getInput() != null && request.getProgressListener() != null) {
            progressManager = new SimpleProgressManager(contentLengthValue, 0L, request.getProgressListener(), request.getProgressInterval() > 0L ? request.getProgressInterval() : 102400L);
            request.setInput(new ProgressInputStream(request.getInput(), progressManager));
        }
        body = request.getInput() == null ? null : new RepeatableRequestEntity(request.getInput(), contentTypeStr, contentLengthValue, this.obsProperties);
        return new TransResult(headers, body);
    }

    TransResult transWriteFileRequest(WriteFileRequest request) throws ServiceException {
        TransResult result = this.transPutObjectRequest(request);
        if (request.getPosition() > 0L) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(SpecialParamEnum.MODIFY.getOriginalStringCode(), "");
            params.put("position", String.valueOf(request.getPosition()));
            result.setParams(params);
        }
        return result;
    }

    TransResult transModifyObjectRequest(ModifyObjectRequest request) throws ServiceException {
        TransResult result = this.transPutObjectRequest(request);
        if (request.getPosition() > 0L) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(SpecialParamEnum.MODIFY.getOriginalStringCode(), "");
            params.put("position", String.valueOf(request.getPosition()));
            result.setParams(params);
        }
        return result;
    }

    TransResult transAppendObjectRequest(AppendObjectRequest request) throws ServiceException {
        TransResult result = this.transPutObjectRequest(request);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(SpecialParamEnum.APPEND.getOriginalStringCode(), "");
        params.put("position", String.valueOf(request.getPosition()));
        result.setParams(params);
        return result;
    }

    TransResult transCopyObjectRequest(CopyObjectRequest request) throws ServiceException {
        HashMap<String, String> headers = new HashMap<String, String>();
        IConvertor iconvertor = this.getIConvertor();
        IHeaders iheaders = this.getIHeaders();
        ObjectMetadata objectMetadata = request.getNewObjectMetadata() == null ? new ObjectMetadata() : request.getNewObjectMetadata();
        this.putHeader(headers, iheaders.metadataDirectiveHeader(), request.isReplaceMetadata() ? "REPLACE" : "COPY");
        if (request.isReplaceMetadata()) {
            objectMetadata.getMetadata().remove(iheaders.requestIdHeader());
            objectMetadata.getMetadata().remove(iheaders.requestId2Header());
            for (Map.Entry<String, Object> entry : objectMetadata.getMetadata().entrySet()) {
                String key = entry.getKey();
                if (!ServiceUtils.isValid(key) || Constants.ALLOWED_REQUEST_HTTP_HEADER_METADATA_NAMES.contains((key = key.trim()).toLowerCase())) continue;
                headers.put(key, entry.getValue() == null ? "" : entry.getValue().toString());
            }
        }
        if (objectMetadata.getContentType() != null) {
            headers.put("Content-Type", objectMetadata.getContentType().trim());
        }
        if (objectMetadata.getContentEncoding() != null) {
            headers.put("Content-Encoding", objectMetadata.getContentEncoding().trim());
        }
        if (objectMetadata.getObjectStorageClass() != null) {
            this.putHeader(headers, iheaders.storageClassHeader(), iconvertor.transStorageClass(objectMetadata.getObjectStorageClass()));
        }
        if (objectMetadata.getWebSiteRedirectLocation() != null) {
            this.putHeader(headers, iheaders.websiteRedirectLocationHeader(), objectMetadata.getWebSiteRedirectLocation());
        }
        if (request.getSuccessRedirectLocation() != null) {
            this.putHeader(headers, iheaders.successRedirectLocationHeader(), request.getSuccessRedirectLocation());
        }
        this.transRequestPaymentHeaders(request, headers, iheaders);
        this.transExtensionPermissions(request, headers);
        this.transSseHeaders(request, headers, iheaders);
        this.transSseCSourceHeaders(request.getSseCHeaderSource(), headers, iheaders);
        this.transConditionCopyHeaders(request, headers, iheaders);
        String sourceKey = RestUtils.encodeUrlString(request.getSourceBucketName()) + "/" + RestUtils.encodeUrlString(request.getSourceObjectKey());
        if (ServiceUtils.isValid(request.getVersionId())) {
            sourceKey = sourceKey + "?versionId=" + request.getVersionId().trim();
        }
        this.putHeader(headers, iheaders.copySourceHeader(), sourceKey);
        return new TransResult(headers);
    }

    void transSseCSourceHeaders(SseCHeader sseCHeader, Map<String, String> headers, IHeaders iheaders) throws ServiceException {
        if (sseCHeader != null) {
            String algorithm = sseCHeader.getSSEAlgorithm().getCode();
            this.putHeader(headers, iheaders.copySourceSseCHeader(), ServiceUtils.toValid(algorithm));
            if (sseCHeader.getSseCKeyBase64() != null) {
                try {
                    this.putHeader(headers, iheaders.copySourceSseCKeyHeader(), sseCHeader.getSseCKeyBase64());
                    this.putHeader(headers, iheaders.copySourceSseCKeyMd5Header(), ServiceUtils.toBase64(ServiceUtils.computeMD5Hash(ServiceUtils.fromBase64(sseCHeader.getSseCKeyBase64()))));
                }
                catch (IOException e) {
                    throw new IllegalStateException("fail to read sseCkey", e);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException("fail to read sseCkey", e);
                }
            }
            if (null != sseCHeader.getSseCKey()) {
                try {
                    byte[] data = sseCHeader.getSseCKey();
                    this.putHeader(headers, iheaders.copySourceSseCKeyHeader(), ServiceUtils.toBase64(data));
                    this.putHeader(headers, iheaders.copySourceSseCKeyMd5Header(), ServiceUtils.toBase64(ServiceUtils.computeMD5Hash(data)));
                }
                catch (IOException e) {
                    throw new IllegalStateException("fail to read sseCkey", e);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException("fail to read sseCkey", e);
                }
            }
        }
    }

    void transConditionCopyHeaders(CopyObjectRequest request, Map<String, String> headers, IHeaders iheaders) {
        if (request.getIfModifiedSince() != null) {
            this.putHeader(headers, iheaders.copySourceIfModifiedSinceHeader(), ServiceUtils.formatRfc822Date(request.getIfModifiedSince()));
        }
        if (request.getIfUnmodifiedSince() != null) {
            this.putHeader(headers, iheaders.copySourceIfUnmodifiedSinceHeader(), ServiceUtils.formatRfc822Date(request.getIfUnmodifiedSince()));
        }
        if (ServiceUtils.isValid(request.getIfMatchTag())) {
            this.putHeader(headers, iheaders.copySourceIfMatchHeader(), request.getIfMatchTag().trim());
        }
        if (ServiceUtils.isValid(request.getIfNoneMatchTag())) {
            this.putHeader(headers, iheaders.copySourceIfNoneMatchHeader(), request.getIfNoneMatchTag().trim());
        }
    }

    TransResult transGetObjectRequest(GetObjectRequest request) throws ServiceException {
        HashMap<String, String> headers = new HashMap<String, String>();
        this.transSseCHeaders(request.getSseCHeader(), headers, this.getIHeaders());
        this.transConditionGetObjectHeaders(request, headers);
        this.transRequestPaymentHeaders(request, headers, this.getIHeaders());
        this.transRangeHeader(request, headers);
        HashMap<String, String> params = new HashMap<String, String>();
        this.transGetObjectParams(request, params);
        return new TransResult(headers, params, null);
    }

    void transRangeHeader(GetObjectRequest request, Map<String, String> headers) {
        String start = "";
        String end = "";
        if (null != request.getRangeStart()) {
            ServiceUtils.assertParameterNotNegative(request.getRangeStart(), "start range should not be negative.");
            start = String.valueOf(request.getRangeStart());
        }
        if (null != request.getRangeEnd()) {
            ServiceUtils.assertParameterNotNegative(request.getRangeEnd(), "end range should not be negative.");
            end = String.valueOf(request.getRangeEnd());
        }
        if (null != request.getRangeStart() && null != request.getRangeEnd() && request.getRangeStart() > request.getRangeEnd()) {
            throw new IllegalArgumentException("start must be less than end.");
        }
        if (!"".equals(start) || !"".equals(end)) {
            String range = String.format("bytes=%s-%s", start, end);
            headers.put("Range", range);
        }
    }

    void transGetObjectParams(GetObjectRequest request, Map<String, String> params) {
        if (null != request.getReplaceMetadata()) {
            if (ServiceUtils.isValid(request.getReplaceMetadata().getCacheControl())) {
                params.put("response-cache-control", request.getReplaceMetadata().getCacheControl());
            }
            if (ServiceUtils.isValid(request.getReplaceMetadata().getContentDisposition())) {
                params.put("response-content-disposition", request.getReplaceMetadata().getContentDisposition());
            }
            if (ServiceUtils.isValid(request.getReplaceMetadata().getContentEncoding())) {
                params.put("response-content-encoding", request.getReplaceMetadata().getContentEncoding());
            }
            if (ServiceUtils.isValid(request.getReplaceMetadata().getContentLanguage())) {
                params.put("response-content-language", request.getReplaceMetadata().getContentLanguage());
            }
            if (ServiceUtils.isValid(request.getReplaceMetadata().getContentType())) {
                params.put("response-content-type", request.getReplaceMetadata().getContentType());
            }
            if (ServiceUtils.isValid(request.getReplaceMetadata().getExpires())) {
                params.put("response-expires", request.getReplaceMetadata().getExpires());
            }
        }
        if (ServiceUtils.isValid(request.getImageProcess())) {
            params.put("x-image-process", request.getImageProcess());
        }
        if (request.getVersionId() != null) {
            params.put("versionId", request.getVersionId());
        }
        if (request.getCacheOption() != null) {
            String cacheControl = request.getCacheOption().getCode() + ", ttl=" + request.getTtl();
            params.put("x-cache-control", cacheControl);
        }
    }

    void transConditionGetObjectHeaders(GetObjectRequest request, Map<String, String> headers) {
        if (request.getIfModifiedSince() != null) {
            headers.put("If-Modified-Since", ServiceUtils.formatRfc822Date(request.getIfModifiedSince()));
        }
        if (request.getIfUnmodifiedSince() != null) {
            headers.put("If-Unmodified-Since", ServiceUtils.formatRfc822Date(request.getIfUnmodifiedSince()));
        }
        if (ServiceUtils.isValid(request.getIfMatchTag())) {
            headers.put("If-Match", request.getIfMatchTag().trim());
        }
        if (ServiceUtils.isValid(request.getIfNoneMatchTag())) {
            headers.put("If-None-Match", request.getIfNoneMatchTag().trim());
        }
        if (!request.isAutoUnzipResponse()) {
            headers.put("Accept-Encoding", "identity");
        }
    }

    TransResult transSetObjectMetadataRequest(SetObjectMetadataRequest request) throws ServiceException {
        HashMap<String, String> headers = new HashMap<String, String>();
        IHeaders iheaders = this.getIHeaders();
        IConvertor iconvertor = this.getIConvertor();
        for (Map.Entry<String, String> entry : request.getMetadata().entrySet()) {
            String key = entry.getKey();
            if (!ServiceUtils.isValid(key)) continue;
            key = key.trim();
            headers.put(key, entry.getValue() == null ? "" : entry.getValue());
        }
        if (request.getObjectStorageClass() != null) {
            this.putHeader(headers, iheaders.storageClassHeader(), iconvertor.transStorageClass(request.getObjectStorageClass()));
        }
        if (request.getWebSiteRedirectLocation() != null) {
            this.putHeader(headers, iheaders.websiteRedirectLocationHeader(), request.getWebSiteRedirectLocation());
        }
        if (request.getContentDisposition() != null) {
            this.putHeader(headers, "Content-Disposition", request.getContentDisposition());
        }
        if (request.getContentEncoding() != null) {
            this.putHeader(headers, "Content-Encoding", request.getContentEncoding());
        }
        if (request.getContentLanguage() != null) {
            this.putHeader(headers, "Content-Language", request.getContentLanguage());
        }
        if (request.getContentType() != null) {
            this.putHeader(headers, "Content-Type", request.getContentType());
        }
        if (request.getCacheControl() != null) {
            this.putHeader(headers, "Cache-Control", request.getCacheControl());
        }
        if (request.getExpires() != null) {
            this.putHeader(headers, "Expires", request.getExpires());
        }
        this.transRequestPaymentHeaders(request, headers, iheaders);
        this.putHeader(headers, iheaders.metadataDirectiveHeader(), request.isRemoveUnset() ? "REPLACE" : "REPLACE_NEW");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(SpecialParamEnum.METADATA.getOriginalStringCode(), "");
        if (request.getVersionId() != null) {
            params.put("versionId", request.getVersionId());
        }
        return new TransResult(headers, params, null);
    }

    TransResult transCopyPartRequest(CopyPartRequest request) throws ServiceException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("partNumber", String.valueOf(request.getPartNumber()));
        params.put("uploadId", request.getUploadId());
        HashMap<String, String> headers = new HashMap<String, String>();
        IHeaders iheaders = this.getIHeaders();
        String sourceKey = RestUtils.encodeUrlString(request.getSourceBucketName()) + "/" + RestUtils.encodeUrlString(request.getSourceObjectKey());
        if (ServiceUtils.isValid(request.getVersionId())) {
            sourceKey = sourceKey + "?versionId=" + request.getVersionId().trim();
        }
        this.putHeader(headers, iheaders.copySourceHeader(), sourceKey);
        if (request.getByteRangeStart() != null) {
            String rangeEnd = request.getByteRangeEnd() != null ? String.valueOf(request.getByteRangeEnd()) : "";
            String range = String.format("bytes=%s-%s", request.getByteRangeStart(), rangeEnd);
            this.putHeader(headers, iheaders.copySourceRangeHeader(), range);
        }
        this.transRequestPaymentHeaders(request, headers, iheaders);
        this.transSseCHeaders(request.getSseCHeaderDestination(), headers, iheaders);
        this.transSseCSourceHeaders(request.getSseCHeaderSource(), headers, iheaders);
        return new TransResult(headers, params, null);
    }

    TransResult transListObjectsRequest(ListObjectsRequest listObjectsRequest) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (listObjectsRequest.getPrefix() != null) {
            params.put("prefix", listObjectsRequest.getPrefix());
        }
        if (listObjectsRequest.getDelimiter() != null) {
            params.put("delimiter", listObjectsRequest.getDelimiter());
        }
        if (listObjectsRequest.getMaxKeys() > 0) {
            params.put("max-keys", String.valueOf(listObjectsRequest.getMaxKeys()));
        }
        if (listObjectsRequest.getMarker() != null) {
            params.put("marker", listObjectsRequest.getMarker());
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        this.transRequestPaymentHeaders(listObjectsRequest, headers, this.getIHeaders());
        if (listObjectsRequest.getListTimeout() > 0) {
            this.putHeader(headers, this.getIHeaders().listTimeoutHeader(), String.valueOf(listObjectsRequest.getListTimeout()));
        }
        return new TransResult(headers, params, null);
    }

    TransResult transListContentSummaryRequest(ListContentSummaryRequest listContentSummaryRequest) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (listContentSummaryRequest.getPrefix() != null) {
            params.put("prefix", listContentSummaryRequest.getPrefix());
        }
        if (listContentSummaryRequest.getDelimiter() != null) {
            params.put("delimiter", listContentSummaryRequest.getDelimiter());
        }
        if (listContentSummaryRequest.getMaxKeys() > 0) {
            params.put("max-keys", String.valueOf(listContentSummaryRequest.getMaxKeys()));
        }
        if (listContentSummaryRequest.getMarker() != null) {
            params.put("marker", listContentSummaryRequest.getMarker());
        }
        params.put(SpecialParamEnum.LISTCONTENTSUMMARY.getOriginalStringCode(), "");
        HashMap<String, String> headers = new HashMap<String, String>();
        this.transRequestPaymentHeaders(listContentSummaryRequest, headers, this.getIHeaders());
        if (listContentSummaryRequest.getListTimeout() > 0) {
            this.putHeader(headers, this.getIHeaders().listTimeoutHeader(), String.valueOf(listContentSummaryRequest.getListTimeout()));
        }
        return new TransResult(headers, params, null);
    }

    /*
     * Unable to fully structure code
     */
    TransResult transUploadPartRequest(UploadPartRequest request) throws ServiceException {
        params = new HashMap<String, String>();
        params.put("partNumber", String.valueOf(request.getPartNumber()));
        params.put("uploadId", request.getUploadId());
        headers = new HashMap<String, String>();
        iheaders = this.getIHeaders();
        if (ServiceUtils.isValid(request.getContentMd5())) {
            headers.put("Content-MD5", request.getContentMd5().trim());
        }
        this.transRequestPaymentHeaders(request, headers, iheaders);
        this.transSseCHeaders(request.getSseCHeader(), headers, iheaders);
        contentLength = -1L;
        if (null != request.getFile()) {
            fileSize = request.getFile().length();
            offset = request.getOffset() >= 0L && request.getOffset() < fileSize ? request.getOffset() : 0L;
            contentLength = partSize = request.getPartSize() != null && request.getPartSize() > 0L && request.getPartSize() <= fileSize - offset ? request.getPartSize() : fileSize - offset;
            try {
                if (request.isAttachMd5() && !ServiceUtils.isValid(request.getContentMd5())) {
                    headers.put("Content-MD5", ServiceUtils.toBase64(ServiceUtils.computeMD5Hash(new FileInputStream(request.getFile()), partSize, offset)));
                }
                request.setInput(new FileInputStream(request.getFile()));
                skipByte = request.getInput().skip(offset);
                if (!RequestConvertor.log.isDebugEnabled()) ** GOTO lbl33
                RequestConvertor.log.debug("Skip " + skipByte + " bytes; offset : " + offset);
            }
            catch (Exception e) {
                ServiceUtils.closeStream(request.getInput());
                throw new ServiceException(e);
            }
        } else if (null != request.getInput() && request.getPartSize() != null && request.getPartSize() > 0L) {
            contentLength = request.getPartSize();
        }
lbl33:
        // 5 sources

        if (request.getInput() != null && request.getProgressListener() != null) {
            progressManager = new SimpleProgressManager(contentLength, 0L, request.getProgressListener(), request.getProgressInterval() > 0L ? request.getProgressInterval() : 102400L);
            request.setInput(new ProgressInputStream(request.getInput(), progressManager));
        }
        contentType = Mimetypes.getInstance().getMimetype(request.getObjectKey());
        headers.put("Content-Type", contentType);
        if (contentLength > -1L) {
            this.putHeader(headers, "Content-Length", String.valueOf(contentLength));
        }
        body = request.getInput() == null ? null : new RepeatableRequestEntity(request.getInput(), contentType, contentLength, this.obsProperties);
        return new TransResult(headers, params, body);
    }

    void transSseKmsHeaders(SseKmsHeader kmsHeader, Map<String, String> headers, IHeaders iheaders) {
        if (kmsHeader == null) {
            return;
        }
        String sseKmsEncryption = this.getProviderCredentials().getAuthType() != AuthTypeEnum.OBS ? "aws:" + kmsHeader.getSSEAlgorithm().getCode() : kmsHeader.getSSEAlgorithm().getCode();
        this.putHeader(headers, iheaders.sseKmsHeader(), ServiceUtils.toValid(sseKmsEncryption));
        if (ServiceUtils.isValid(kmsHeader.getKmsKeyId())) {
            this.putHeader(headers, iheaders.sseKmsKeyHeader(), kmsHeader.getKmsKeyId());
        }
        if (ServiceUtils.isValid(kmsHeader.getProjectId())) {
            this.putHeader(headers, iheaders.sseKmsProjectIdHeader(), kmsHeader.getProjectId());
        }
    }

    RequestBody createRequestBody(String mimeType, String content) throws ServiceException {
        try {
            if (log.isTraceEnabled()) {
                try {
                    log.trace("Entity Content:" + content);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return RequestBody.create((MediaType)MediaType.parse((String)mimeType), (byte[])content.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new ServiceException(e);
        }
    }

    void putHeader(Map<String, String> headers, String key, String value) {
        if (ServiceUtils.isValid(key)) {
            headers.put(key, value);
        }
    }

    HeaderResponse build(Response res) {
        HeaderResponse response = new HeaderResponse();
        RequestConvertor.setResponseHeaders(response, this.cleanResponseHeaders(res));
        RequestConvertor.setStatusCode(response, res.code());
        return response;
    }

    static HeaderResponse build(Map<String, Object> responseHeaders) {
        HeaderResponse response = new HeaderResponse();
        RequestConvertor.setResponseHeaders(response, responseHeaders);
        return response;
    }

    GetBucketFSStatusResult getOptionInfoResult(Response response) {
        Headers headers = response.headers();
        Map map = headers.toMultimap();
        String maxAge = headers.get("Access-Control-Max-Age");
        IHeaders iheaders = this.getIHeaders();
        FSStatusEnum status = FSStatusEnum.getValueFromCode(headers.get(iheaders.fsFileInterfaceHeader()));
        BucketTypeEnum bucketType = BucketTypeEnum.OBJECT;
        if (FSStatusEnum.ENABLED == status) {
            bucketType = BucketTypeEnum.PFS;
        }
        GetBucketFSStatusResult output = new GetBucketFSStatusResult(headers.get("Access-Control-Allow-Origin"), (List)map.get("Access-Control-Allow-Headers"), maxAge == null ? 0 : Integer.parseInt(maxAge), (List)map.get("Access-Control-Allow-Methods"), (List)map.get("Access-Control-Expose-Headers"), StorageClassEnum.getValueFromCode(headers.get(iheaders.defaultStorageClassHeader())), headers.get(iheaders.bucketRegionHeader()), headers.get(iheaders.serverVersionHeader()), status, AvailableZoneEnum.getValueFromCode(headers.get(iheaders.azRedundancyHeader())), headers.get(iheaders.epidHeader()), bucketType);
        RequestConvertor.setResponseHeaders(output, this.cleanResponseHeaders(response));
        RequestConvertor.setStatusCode(output, response.code());
        return output;
    }

    Map<String, Object> cleanResponseHeaders(Response response) {
        Map map = response.headers().toMultimap();
        return ServiceUtils.cleanRestMetadataMap(map, this.getIHeaders().headerPrefix(), this.getIHeaders().headerMetaPrefix());
    }

    static void setStatusCode(HeaderResponse response, int statusCode) {
        response.setStatusCode(statusCode);
    }

    AbstractAuthentication getAuthentication() {
        return Constants.AUTHTICATION_MAP.get((Object)this.getProviderCredentials().getAuthType());
    }

    SpecialParamEnum getSpecialParamForStorageClass() {
        return this.getProviderCredentials().getAuthType() == AuthTypeEnum.OBS ? SpecialParamEnum.STORAGECLASS : SpecialParamEnum.STORAGEPOLICY;
    }

    boolean prepareRESTHeaderAclForV2(Map<String, String> metadata, AccessControlList acl) {
        String restHeaderAclValue = null;
        if (acl == AccessControlList.REST_CANNED_PRIVATE) {
            restHeaderAclValue = "private";
        } else if (acl == AccessControlList.REST_CANNED_PUBLIC_READ) {
            restHeaderAclValue = "public-read";
        } else if (acl == AccessControlList.REST_CANNED_PUBLIC_READ_WRITE) {
            restHeaderAclValue = "public-read-write";
        } else if (acl == AccessControlList.REST_CANNED_PUBLIC_READ_DELIVERED) {
            restHeaderAclValue = "public-read";
        } else if (acl == AccessControlList.REST_CANNED_PUBLIC_READ_WRITE_DELIVERED) {
            restHeaderAclValue = "public-read-write";
        } else if (acl == AccessControlList.REST_CANNED_AUTHENTICATED_READ) {
            restHeaderAclValue = "authenticated-read";
        } else if (acl == AccessControlList.REST_CANNED_BUCKET_OWNER_READ) {
            restHeaderAclValue = "bucket-owner-read";
        } else if (acl == AccessControlList.REST_CANNED_BUCKET_OWNER_FULL_CONTROL) {
            restHeaderAclValue = "bucket-owner-full-control";
        } else if (acl == AccessControlList.REST_CANNED_LOG_DELIVERY_WRITE) {
            restHeaderAclValue = "log-delivery-write";
        }
        String aclHeader = this.getIHeaders().aclHeader();
        if (restHeaderAclValue != null) {
            metadata.put(aclHeader, restHeaderAclValue);
        }
        return metadata.containsKey(aclHeader);
    }

    boolean prepareRESTHeaderAclForOBS(Map<String, String> metadata, AccessControlList acl) throws ServiceException {
        String restHeaderAclValue = null;
        boolean invalid = false;
        if (acl == AccessControlList.REST_CANNED_PRIVATE) {
            restHeaderAclValue = "private";
        } else if (acl == AccessControlList.REST_CANNED_PUBLIC_READ) {
            restHeaderAclValue = "public-read";
        } else if (acl == AccessControlList.REST_CANNED_PUBLIC_READ_WRITE) {
            restHeaderAclValue = "public-read-write";
        } else if (acl == AccessControlList.REST_CANNED_PUBLIC_READ_DELIVERED) {
            restHeaderAclValue = "public-read-delivered";
        } else if (acl == AccessControlList.REST_CANNED_PUBLIC_READ_WRITE_DELIVERED) {
            restHeaderAclValue = "public-read-write-delivered";
        } else if (acl == AccessControlList.REST_CANNED_AUTHENTICATED_READ) {
            restHeaderAclValue = "authenticated-read";
            invalid = true;
        } else if (acl == AccessControlList.REST_CANNED_BUCKET_OWNER_READ) {
            restHeaderAclValue = "bucket-owner-read";
            invalid = true;
        } else if (acl == AccessControlList.REST_CANNED_BUCKET_OWNER_FULL_CONTROL) {
            restHeaderAclValue = "bucket-owner-full-control";
            invalid = true;
        } else if (acl == AccessControlList.REST_CANNED_LOG_DELIVERY_WRITE) {
            restHeaderAclValue = "log-delivery-write";
            invalid = true;
        }
        if (invalid) {
            log.info("Invalid Canned ACL:" + restHeaderAclValue);
        }
        String aclHeader = this.getIHeaders().aclHeader();
        if (restHeaderAclValue != null) {
            metadata.put(aclHeader, restHeaderAclValue);
        }
        return metadata.containsKey(aclHeader);
    }

    boolean prepareRESTHeaderAclObject(Map<String, String> metadata, AccessControlList acl) throws ServiceException {
        return this.getProviderCredentials().getAuthType() == AuthTypeEnum.OBS ? this.prepareRESTHeaderAclForOBSObject(metadata, acl) : this.prepareRESTHeaderAclForV2(metadata, acl);
    }

    boolean prepareRESTHeaderAclForOBSObject(Map<String, String> metadata, AccessControlList acl) throws ServiceException {
        String restHeaderAclValue = null;
        boolean invalid = false;
        if (acl == AccessControlList.REST_CANNED_PRIVATE) {
            restHeaderAclValue = "private";
        } else if (acl == AccessControlList.REST_CANNED_PUBLIC_READ) {
            restHeaderAclValue = "public-read";
        } else if (acl == AccessControlList.REST_CANNED_PUBLIC_READ_WRITE) {
            restHeaderAclValue = "public-read-write";
        } else if (acl == AccessControlList.REST_CANNED_PUBLIC_READ_DELIVERED) {
            restHeaderAclValue = "public-read";
        } else if (acl == AccessControlList.REST_CANNED_PUBLIC_READ_WRITE_DELIVERED) {
            restHeaderAclValue = "public-read-write";
        } else if (acl == AccessControlList.REST_CANNED_AUTHENTICATED_READ) {
            restHeaderAclValue = "authenticated-read";
            invalid = true;
        } else if (acl == AccessControlList.REST_CANNED_BUCKET_OWNER_READ) {
            restHeaderAclValue = "bucket-owner-read";
            invalid = true;
        } else if (acl == AccessControlList.REST_CANNED_BUCKET_OWNER_FULL_CONTROL) {
            restHeaderAclValue = "bucket-owner-full-control";
            invalid = true;
        } else if (acl == AccessControlList.REST_CANNED_LOG_DELIVERY_WRITE) {
            restHeaderAclValue = "log-delivery-write";
            invalid = true;
        }
        if (invalid) {
            log.info("Invalid Canned ACL:" + restHeaderAclValue);
        }
        String aclHeader = this.getIHeaders().aclHeader();
        if (restHeaderAclValue != null) {
            metadata.put(aclHeader, restHeaderAclValue);
        }
        return metadata.containsKey(aclHeader);
    }

    boolean prepareRESTHeaderAcl(Map<String, String> metadata, AccessControlList acl) throws ServiceException {
        return this.getProviderCredentials().getAuthType() == AuthTypeEnum.OBS ? this.prepareRESTHeaderAclForOBS(metadata, acl) : this.prepareRESTHeaderAclForV2(metadata, acl);
    }

    protected String getCredential(String shortDate, String accessKey) {
        return accessKey + "/" + shortDate + "/" + "region" + "/" + "s3" + "/" + "aws4_request";
    }

    protected AuthTypeEnum getApiVersion(String bucketName) throws ServiceException {
        if (!ServiceUtils.isValid(bucketName)) {
            return this.parseAuthTypeInResponse("");
        }
        AuthTypeEnum apiVersion = this.apiVersionCache.getApiVersionInCache(bucketName);
        if (apiVersion == null) {
            try {
                this.segmentLock.lock(bucketName);
                apiVersion = this.apiVersionCache.getApiVersionInCache(bucketName);
                if (apiVersion == null) {
                    apiVersion = this.parseAuthTypeInResponse(bucketName);
                    this.apiVersionCache.addApiVersion(bucketName, apiVersion);
                }
            }
            finally {
                this.segmentLock.unlock(bucketName);
            }
        }
        return apiVersion;
    }

    protected static void setResponseHeaders(HeaderResponse response, Map<String, Object> responseHeaders) {
        response.setResponseHeaders(responseHeaders);
    }

    private AuthTypeEnum parseAuthTypeInResponse(String bucketName) throws ServiceException {
        String apiVersion;
        Response response;
        try {
            response = this.getAuthTypeNegotiationResponseImpl(bucketName);
        }
        catch (ServiceException e) {
            if (e.getResponseCode() == 404 || e.getResponseCode() <= 0 || e.getResponseCode() == 408 || e.getResponseCode() >= 500) {
                throw e;
            }
            return AuthTypeEnum.V2;
        }
        return response.code() == 200 && (apiVersion = response.headers().get("x-obs-api")) != null && apiVersion.compareTo("3.0") >= 0 ? AuthTypeEnum.OBS : AuthTypeEnum.V2;
    }

    private Response getAuthTypeNegotiationResponseImpl(String bucketName) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("apiversion", "");
        return this.performRestForApiVersion(bucketName, null, requestParameters, null);
    }

    protected static class TransResult {
        private Map<String, String> headers;
        private Map<String, String> params;
        private RequestBody body;

        TransResult(Map<String, String> headers) {
            this(headers, null, null);
        }

        TransResult(Map<String, String> headers, RequestBody body) {
            this(headers, null, body);
        }

        TransResult(Map<String, String> headers, Map<String, String> params, RequestBody body) {
            this.headers = headers;
            this.params = params;
            this.body = body;
        }

        Map<String, String> getHeaders() {
            if (this.headers == null) {
                this.headers = new HashMap<String, String>();
            }
            return this.headers;
        }

        Map<String, String> getParams() {
            if (this.params == null) {
                this.params = new HashMap<String, String>();
            }
            return this.params;
        }

        public void setParams(Map<String, String> params) {
            this.params = params;
        }

        public void setBody(RequestBody body) {
            this.body = body;
        }

        public RequestBody getBody() {
            return this.body;
        }
    }
}

