/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.management;

import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.ManagementClientImpl;
import com.microsoft.windowsazure.management.SubscriptionOperations;
import com.microsoft.windowsazure.management.models.SubscriptionGetResponse;
import com.microsoft.windowsazure.management.models.SubscriptionListOperationsParameters;
import com.microsoft.windowsazure.management.models.SubscriptionListOperationsResponse;
import com.microsoft.windowsazure.management.models.SubscriptionStatus;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SubscriptionOperationsImpl
implements ServiceOperations<ManagementClientImpl>,
SubscriptionOperations {
    private ManagementClientImpl client;

    SubscriptionOperationsImpl(ManagementClientImpl client) {
        this.client = client;
    }

    public ManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<SubscriptionGetResponse> getAsync() {
        return this.getClient().getExecutorService().submit(new Callable<SubscriptionGetResponse>(){

            @Override
            public SubscriptionGetResponse call() throws Exception {
                return SubscriptionOperationsImpl.this.get();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubscriptionGetResponse get() throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        String baseUrl;
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap tracingParameters = new HashMap();
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            SubscriptionGetResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new SubscriptionGetResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
                Element subscriptionElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"Subscription");
                if (subscriptionElement != null) {
                    Element currentDnsServersElement;
                    Element currentLocalNetworkSitesElement;
                    Element maxDnsServersElement;
                    Element maxLocalNetworkSitesElement;
                    Element currentVirtualNetworkSitesElement;
                    Element maxVirtualNetworkSitesElement;
                    Element currentHostedServicesElement;
                    Element currentStorageAccountsElement;
                    Element currentCoreCountElement;
                    Element maxHostedServicesElement;
                    Element maxStorageAccountsElement;
                    Element maxCoreCountElement;
                    Element serviceAdminLiveEmailIdElement;
                    Element accountAdminLiveEmailIdElement;
                    Element subscriptionStatusElement;
                    Element subscriptionNameElement;
                    Element subscriptionIDElement = XmlUtility.getElementByTagNameNS((Node)subscriptionElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubscriptionID");
                    if (subscriptionIDElement != null) {
                        String subscriptionIDInstance = subscriptionIDElement.getTextContent();
                        result.setSubscriptionID(subscriptionIDInstance);
                    }
                    if ((subscriptionNameElement = XmlUtility.getElementByTagNameNS((Node)subscriptionElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubscriptionName")) != null) {
                        String subscriptionNameInstance = subscriptionNameElement.getTextContent();
                        result.setSubscriptionName(subscriptionNameInstance);
                    }
                    if ((subscriptionStatusElement = XmlUtility.getElementByTagNameNS((Node)subscriptionElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubscriptionStatus")) != null && subscriptionStatusElement.getTextContent() != null && !subscriptionStatusElement.getTextContent().isEmpty()) {
                        SubscriptionStatus subscriptionStatusInstance = SubscriptionStatus.valueOf(subscriptionStatusElement.getTextContent().toUpperCase());
                        result.setSubscriptionStatus(subscriptionStatusInstance);
                    }
                    if ((accountAdminLiveEmailIdElement = XmlUtility.getElementByTagNameNS((Node)subscriptionElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AccountAdminLiveEmailId")) != null) {
                        String accountAdminLiveEmailIdInstance = accountAdminLiveEmailIdElement.getTextContent();
                        result.setAccountAdminLiveEmailId(accountAdminLiveEmailIdInstance);
                    }
                    if ((serviceAdminLiveEmailIdElement = XmlUtility.getElementByTagNameNS((Node)subscriptionElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceAdminLiveEmailId")) != null) {
                        String serviceAdminLiveEmailIdInstance = serviceAdminLiveEmailIdElement.getTextContent();
                        result.setServiceAdminLiveEmailId(serviceAdminLiveEmailIdInstance);
                    }
                    if ((maxCoreCountElement = XmlUtility.getElementByTagNameNS((Node)subscriptionElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MaxCoreCount")) != null) {
                        int maxCoreCountInstance = DatatypeConverter.parseInt((String)maxCoreCountElement.getTextContent());
                        result.setMaximumCoreCount(maxCoreCountInstance);
                    }
                    if ((maxStorageAccountsElement = XmlUtility.getElementByTagNameNS((Node)subscriptionElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MaxStorageAccounts")) != null) {
                        int maxStorageAccountsInstance = DatatypeConverter.parseInt((String)maxStorageAccountsElement.getTextContent());
                        result.setMaximumStorageAccounts(maxStorageAccountsInstance);
                    }
                    if ((maxHostedServicesElement = XmlUtility.getElementByTagNameNS((Node)subscriptionElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MaxHostedServices")) != null) {
                        int maxHostedServicesInstance = DatatypeConverter.parseInt((String)maxHostedServicesElement.getTextContent());
                        result.setMaximumHostedServices(maxHostedServicesInstance);
                    }
                    if ((currentCoreCountElement = XmlUtility.getElementByTagNameNS((Node)subscriptionElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CurrentCoreCount")) != null) {
                        int currentCoreCountInstance = DatatypeConverter.parseInt((String)currentCoreCountElement.getTextContent());
                        result.setCurrentCoreCount(currentCoreCountInstance);
                    }
                    if ((currentStorageAccountsElement = XmlUtility.getElementByTagNameNS((Node)subscriptionElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CurrentStorageAccounts")) != null) {
                        int currentStorageAccountsInstance = DatatypeConverter.parseInt((String)currentStorageAccountsElement.getTextContent());
                        result.setCurrentStorageAccounts(currentStorageAccountsInstance);
                    }
                    if ((currentHostedServicesElement = XmlUtility.getElementByTagNameNS((Node)subscriptionElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CurrentHostedServices")) != null) {
                        int currentHostedServicesInstance = DatatypeConverter.parseInt((String)currentHostedServicesElement.getTextContent());
                        result.setCurrentHostedServices(currentHostedServicesInstance);
                    }
                    if ((maxVirtualNetworkSitesElement = XmlUtility.getElementByTagNameNS((Node)subscriptionElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MaxVirtualNetworkSites")) != null) {
                        int maxVirtualNetworkSitesInstance = DatatypeConverter.parseInt((String)maxVirtualNetworkSitesElement.getTextContent());
                        result.setMaximumVirtualNetworkSites(maxVirtualNetworkSitesInstance);
                    }
                    if ((currentVirtualNetworkSitesElement = XmlUtility.getElementByTagNameNS((Node)subscriptionElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CurrentVirtualNetworkSites")) != null) {
                        int currentVirtualNetworkSitesInstance = DatatypeConverter.parseInt((String)currentVirtualNetworkSitesElement.getTextContent());
                        result.setCurrentVirtualNetworkSites(currentVirtualNetworkSitesInstance);
                    }
                    if ((maxLocalNetworkSitesElement = XmlUtility.getElementByTagNameNS((Node)subscriptionElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MaxLocalNetworkSites")) != null) {
                        int maxLocalNetworkSitesInstance = DatatypeConverter.parseInt((String)maxLocalNetworkSitesElement.getTextContent());
                        result.setMaximumLocalNetworkSites(maxLocalNetworkSitesInstance);
                    }
                    if ((maxDnsServersElement = XmlUtility.getElementByTagNameNS((Node)subscriptionElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MaxDnsServers")) != null) {
                        int maxDnsServersInstance = DatatypeConverter.parseInt((String)maxDnsServersElement.getTextContent());
                        result.setMaximumDnsServers(maxDnsServersInstance);
                    }
                    if ((currentLocalNetworkSitesElement = XmlUtility.getElementByTagNameNS((Node)subscriptionElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CurrentLocalNetworkSites")) != null) {
                        int currentLocalNetworkSitesInstance = DatatypeConverter.parseInt((String)currentLocalNetworkSitesElement.getTextContent());
                        result.setCurrentLocalNetworkSites(currentLocalNetworkSitesInstance);
                    }
                    if ((currentDnsServersElement = XmlUtility.getElementByTagNameNS((Node)subscriptionElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CurrentDnsServers")) != null) {
                        int currentDnsServersInstance = DatatypeConverter.parseInt((String)currentDnsServersElement.getTextContent());
                        result.setCurrentDnsServers(currentDnsServersInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            SubscriptionGetResponse subscriptionGetResponse = result;
            return subscriptionGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<SubscriptionListOperationsResponse> listOperationsAsync(final SubscriptionListOperationsParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<SubscriptionListOperationsResponse>(){

            @Override
            public SubscriptionListOperationsResponse call() throws Exception {
                return SubscriptionOperationsImpl.this.listOperations(parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubscriptionListOperationsResponse listOperations(SubscriptionListOperationsParameters parameters) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        String baseUrl;
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, SubscriptionListOperationsParameters> tracingParameters = new HashMap<String, SubscriptionListOperationsParameters>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listOperationsAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/operations";
        ArrayList<String> queryParameters = new ArrayList<String>();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        queryParameters.add("StartTime=" + URLEncoder.encode(simpleDateFormat.format(parameters.getStartTime().getTime()), "UTF-8"));
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
        simpleDateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
        queryParameters.add("EndTime=" + URLEncoder.encode(simpleDateFormat2.format(parameters.getEndTime().getTime()), "UTF-8"));
        if (parameters.getObjectIdFilter() != null) {
            queryParameters.add("ObjectIdFilter=" + URLEncoder.encode(parameters.getObjectIdFilter(), "UTF-8"));
        }
        if (parameters.getOperationStatus() != null) {
            queryParameters.add("OperationResultFilter=" + URLEncoder.encode(parameters.getOperationStatus().toString(), "UTF-8"));
        }
        if (parameters.getContinuationToken() != null) {
            queryParameters.add("ContinuationToken=" + URLEncoder.encode(parameters.getContinuationToken(), "UTF-8"));
        }
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            SubscriptionListOperationsResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new SubscriptionListOperationsResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
                Element subscriptionOperationCollectionElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubscriptionOperationCollection");
                if (subscriptionOperationCollectionElement != null) {
                    Element subscriptionOperationsSequenceElement;
                    Element continuationTokenElement = XmlUtility.getElementByTagNameNS((Node)subscriptionOperationCollectionElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ContinuationToken");
                    if (continuationTokenElement != null) {
                        String continuationTokenInstance = continuationTokenElement.getTextContent();
                        result.setContinuationToken(continuationTokenInstance);
                    }
                    if ((subscriptionOperationsSequenceElement = XmlUtility.getElementByTagNameNS((Node)subscriptionOperationCollectionElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubscriptionOperations")) != null) {
                        for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)subscriptionOperationsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubscriptionOperation").size(); ++i1) {
                            Element operationCompletedTimeElement;
                            Element operationStartedTimeElement;
                            Element operationStatusElement;
                            Element operationCallerElement;
                            Element operationParametersSequenceElement;
                            Element operationNameElement;
                            Element operationObjectIdElement;
                            Element subscriptionOperationsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)subscriptionOperationsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubscriptionOperation").get(i1);
                            SubscriptionListOperationsResponse.SubscriptionOperation subscriptionOperationInstance = new SubscriptionListOperationsResponse.SubscriptionOperation();
                            result.getSubscriptionOperations().add(subscriptionOperationInstance);
                            Element operationIdElement = XmlUtility.getElementByTagNameNS((Node)subscriptionOperationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OperationId");
                            if (operationIdElement != null) {
                                String operationIdInstance = operationIdElement.getTextContent();
                                subscriptionOperationInstance.setOperationId(operationIdInstance);
                            }
                            if ((operationObjectIdElement = XmlUtility.getElementByTagNameNS((Node)subscriptionOperationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OperationObjectId")) != null) {
                                String operationObjectIdInstance = operationObjectIdElement.getTextContent();
                                subscriptionOperationInstance.setOperationObjectId(operationObjectIdInstance);
                            }
                            if ((operationNameElement = XmlUtility.getElementByTagNameNS((Node)subscriptionOperationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OperationName")) != null) {
                                String operationNameInstance = operationNameElement.getTextContent();
                                subscriptionOperationInstance.setOperationName(operationNameInstance);
                            }
                            if ((operationParametersSequenceElement = XmlUtility.getElementByTagNameNS((Node)subscriptionOperationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OperationParameters")) != null) {
                                for (int i2 = 0; i2 < XmlUtility.getElementsByTagNameNS((Node)operationParametersSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OperationParameter").size(); ++i2) {
                                    Element operationParametersElement = (Element)XmlUtility.getElementsByTagNameNS((Node)operationParametersSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OperationParameter").get(i2);
                                    String operationParametersKey = XmlUtility.getElementByTagNameNS((Node)operationParametersElement, (String)"http://schemas.datacontract.org/2004/07/Microsoft.WindowsAzure.ServiceManagement", (String)"Name").getTextContent();
                                    String operationParametersValue = XmlUtility.getElementByTagNameNS((Node)operationParametersElement, (String)"http://schemas.datacontract.org/2004/07/Microsoft.WindowsAzure.ServiceManagement", (String)"Value").getTextContent();
                                    subscriptionOperationInstance.getOperationParameters().put(operationParametersKey, operationParametersValue);
                                }
                            }
                            if ((operationCallerElement = XmlUtility.getElementByTagNameNS((Node)subscriptionOperationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OperationCaller")) != null) {
                                Element clientIPElement;
                                Element subscriptionCertificateThumbprintElement;
                                Element userEmailAddressElement;
                                SubscriptionListOperationsResponse.OperationCallerDetails operationCallerInstance = new SubscriptionListOperationsResponse.OperationCallerDetails();
                                subscriptionOperationInstance.setOperationCaller(operationCallerInstance);
                                Element usedServiceManagementApiElement = XmlUtility.getElementByTagNameNS((Node)operationCallerElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"UsedServiceManagementApi");
                                if (usedServiceManagementApiElement != null) {
                                    boolean usedServiceManagementApiInstance = DatatypeConverter.parseBoolean((String)usedServiceManagementApiElement.getTextContent().toLowerCase());
                                    operationCallerInstance.setUsedServiceManagementApi(usedServiceManagementApiInstance);
                                }
                                if ((userEmailAddressElement = XmlUtility.getElementByTagNameNS((Node)operationCallerElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"UserEmailAddress")) != null) {
                                    String userEmailAddressInstance = userEmailAddressElement.getTextContent();
                                    operationCallerInstance.setUserEmailAddress(userEmailAddressInstance);
                                }
                                if ((subscriptionCertificateThumbprintElement = XmlUtility.getElementByTagNameNS((Node)operationCallerElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubscriptionCertificateThumbprint")) != null) {
                                    String subscriptionCertificateThumbprintInstance = subscriptionCertificateThumbprintElement.getTextContent();
                                    operationCallerInstance.setSubscriptionCertificateThumbprint(subscriptionCertificateThumbprintInstance);
                                }
                                if ((clientIPElement = XmlUtility.getElementByTagNameNS((Node)operationCallerElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ClientIP")) != null) {
                                    InetAddress clientIPInstance = InetAddress.getByName(clientIPElement.getTextContent());
                                    operationCallerInstance.setClientIPAddress(clientIPInstance);
                                }
                            }
                            if ((operationStatusElement = XmlUtility.getElementByTagNameNS((Node)subscriptionOperationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OperationStatus")) != null) {
                                String operationStatusInstance = operationStatusElement.getTextContent();
                                subscriptionOperationInstance.setOperationStatus(operationStatusInstance);
                            }
                            if ((operationStartedTimeElement = XmlUtility.getElementByTagNameNS((Node)subscriptionOperationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OperationStartedTime")) != null) {
                                Calendar operationStartedTimeInstance = DatatypeConverter.parseDateTime((String)operationStartedTimeElement.getTextContent());
                                subscriptionOperationInstance.setOperationStartedTime(operationStartedTimeInstance);
                            }
                            if ((operationCompletedTimeElement = XmlUtility.getElementByTagNameNS((Node)subscriptionOperationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OperationCompletedTime")) == null) continue;
                            Calendar operationCompletedTimeInstance = DatatypeConverter.parseDateTime((String)operationCompletedTimeElement.getTextContent());
                            subscriptionOperationInstance.setOperationCompletedTime(operationCompletedTimeInstance);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            SubscriptionListOperationsResponse subscriptionListOperationsResponse = result;
            return subscriptionListOperationsResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> registerResourceAsync(final String resourceName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return SubscriptionOperationsImpl.this.registerResource(resourceName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse registerResource(String resourceName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceName == null) {
            throw new NullPointerException("resourceName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceName", resourceName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"registerResourceAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("service=" + URLEncoder.encode(resourceName, "UTF-8"));
        queryParameters.add("action=register");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> unregisterResourceAsync(final String resourceName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return SubscriptionOperationsImpl.this.unregisterResource(resourceName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse unregisterResource(String resourceName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceName == null) {
            throw new NullPointerException("resourceName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceName", resourceName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"unregisterResourceAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("service=" + URLEncoder.encode(resourceName, "UTF-8"));
        queryParameters.add("action=unregister");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

