/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.listener.loadbalance;

import com.nepxion.discovery.common.entity.DiscoveryEntity;
import com.nepxion.discovery.common.entity.RegionEntity;
import com.nepxion.discovery.common.entity.RegionFilterEntity;
import com.nepxion.discovery.common.entity.RuleEntity;
import com.nepxion.discovery.plugin.framework.listener.loadbalance.AbstractLoadBalanceListener;
import com.netflix.loadbalancer.Server;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class RegionFilterLoadBalanceListener
extends AbstractLoadBalanceListener {
    @Override
    public void onGetServers(String serviceId, List<? extends Server> servers) {
        String consumerServiceId = this.pluginAdapter.getServiceId();
        String consumerServiceRegion = this.pluginAdapter.getRegion();
        this.applyRegionFilter(consumerServiceId, consumerServiceRegion, serviceId, servers);
    }

    private void applyRegionFilter(String consumerServiceId, String consumerServiceRegion, String providerServiceId, List<? extends Server> servers) {
        if (StringUtils.isEmpty((CharSequence)consumerServiceRegion)) {
            return;
        }
        RuleEntity ruleEntity = this.pluginAdapter.getRule();
        if (ruleEntity == null) {
            return;
        }
        DiscoveryEntity discoveryEntity = ruleEntity.getDiscoveryEntity();
        if (discoveryEntity == null) {
            return;
        }
        RegionFilterEntity regionFilterEntity = discoveryEntity.getRegionFilterEntity();
        if (regionFilterEntity == null) {
            return;
        }
        Map regionEntityMap = regionFilterEntity.getRegionEntityMap();
        if (MapUtils.isEmpty((Map)regionEntityMap)) {
            return;
        }
        List regionEntityList = (List)regionEntityMap.get(consumerServiceId);
        if (CollectionUtils.isEmpty((Collection)regionEntityList)) {
            return;
        }
        ArrayList allNoFilterValueList = null;
        boolean providerConditionDefined = false;
        for (RegionEntity regionEntity : regionEntityList) {
            String providerServiceName = regionEntity.getProviderServiceName();
            if (!StringUtils.equalsIgnoreCase((CharSequence)providerServiceName, (CharSequence)providerServiceId)) continue;
            providerConditionDefined = true;
            List consumerRegionValueList = regionEntity.getConsumerRegionValueList();
            List providerRegionValueList = regionEntity.getProviderRegionValueList();
            if (CollectionUtils.isNotEmpty((Collection)consumerRegionValueList)) {
                if (!consumerRegionValueList.contains(consumerServiceRegion)) continue;
                if (allNoFilterValueList == null) {
                    allNoFilterValueList = new ArrayList();
                }
                if (!CollectionUtils.isNotEmpty((Collection)providerRegionValueList)) continue;
                allNoFilterValueList.addAll(providerRegionValueList);
                continue;
            }
            if (allNoFilterValueList == null) {
                allNoFilterValueList = new ArrayList();
            }
            if (!CollectionUtils.isNotEmpty((Collection)providerRegionValueList)) continue;
            allNoFilterValueList.addAll(providerRegionValueList);
        }
        if (allNoFilterValueList != null) {
            if (allNoFilterValueList.isEmpty()) {
                return;
            }
            Iterator<? extends Server> iterator = servers.iterator();
            while (iterator.hasNext()) {
                Server server = iterator.next();
                String serverRegion = this.pluginAdapter.getServerRegion(server);
                if (allNoFilterValueList.contains(serverRegion)) continue;
                iterator.remove();
            }
        } else if (providerConditionDefined) {
            servers.clear();
        }
    }

    @Override
    public int getOrder() {
        return -2147483646;
    }
}

