/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.loadbalance.weight;

import com.nepxion.discovery.common.exception.DiscoveryException;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.tuple.Pair;

public class MapWeightRandom<K, V extends Number> {
    private TreeMap<Double, K> weightMap = new TreeMap();

    public MapWeightRandom(List<Pair<K, V>> pairlist) {
        for (Pair<K, V> pair : pairlist) {
            double value = ((Number)pair.getValue()).doubleValue();
            if (value <= 0.0) continue;
            double lastWeight = this.weightMap.size() == 0 ? 0.0 : this.weightMap.lastKey();
            this.weightMap.put(value + lastWeight, (Double)pair.getKey());
        }
    }

    public K random() {
        if (MapUtils.isEmpty(this.weightMap)) {
            throw new DiscoveryException("Weight values are all <= 0 or invalid format");
        }
        double randomWeight = this.weightMap.lastKey() * Math.random();
        NavigableMap<Double, K> tailMap = this.weightMap.tailMap(randomWeight, false);
        return this.weightMap.get(tailMap.firstKey());
    }
}

