/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.eventbus.configuration;

import com.nepxion.banner.Description;
import com.nepxion.banner.LogoBanner;
import com.nepxion.banner.NepxionBanner;
import com.nepxion.eventbus.aop.EventBeanPostProcessor;
import com.nepxion.eventbus.context.EventContextClosedHandler;
import com.nepxion.eventbus.core.EventControllerFactory;
import com.nepxion.eventbus.thread.ThreadPoolFactory;
import com.nepxion.eventbus.thread.entity.ThreadCustomization;
import com.nepxion.eventbus.thread.entity.ThreadParameter;
import com.taobao.text.Color;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class EventConfiguration {
    @Value(value="${threadpool.multi.mode:false}")
    private boolean threadPoolMultiMode;
    @Value(value="${threadpool.shared.name:EventBus}")
    private String threadPoolSharedName;
    @Value(value="${threadpool.name.customized:true}")
    private boolean threadPoolNameCustomized;
    @Value(value="${threadpool.name.ipshown:true}")
    private boolean threadPoolNameIPShown;
    @Value(value="${threadpool.core.pool.size:4}")
    private int threadPoolCorePoolSize;
    @Value(value="${threadpool.maximum.pool.size:8}")
    private int threadPoolMaximumPoolSize;
    @Value(value="${threadpool.keep.alive.time:900000}")
    private long threadPoolKeepAliveTime;
    @Value(value="${threadpool.allow.core.thread.timeout:false}")
    private boolean threadPoolAllowCoreThreadTimeout;
    @Value(value="${threadpool.queue:LinkedBlockingQueue}")
    private String threadPoolQueue;
    @Value(value="${threadpool.queue.capacity:1024}")
    private int threadPoolQueueCapacity;
    @Value(value="${threadpool.rejected.policy:BlockingPolicyWithReport}")
    private String threadPoolRejectedPolicy;

    @Bean
    public ThreadPoolFactory threadPoolFactory() {
        ThreadCustomization threadCustomization = new ThreadCustomization();
        threadCustomization.setThreadPoolMultiMode(this.threadPoolMultiMode);
        threadCustomization.setThreadPoolSharedName(this.threadPoolSharedName);
        threadCustomization.setThreadPoolNameCustomized(this.threadPoolNameCustomized);
        threadCustomization.setThreadPoolNameIPShown(this.threadPoolNameIPShown);
        ThreadParameter threadParameter = new ThreadParameter();
        threadParameter.setThreadPoolCorePoolSize(this.threadPoolCorePoolSize);
        threadParameter.setThreadPoolMaximumPoolSize(this.threadPoolMaximumPoolSize);
        threadParameter.setThreadPoolKeepAliveTime(this.threadPoolKeepAliveTime);
        threadParameter.setThreadPoolAllowCoreThreadTimeout(this.threadPoolAllowCoreThreadTimeout);
        threadParameter.setThreadPoolQueue(this.threadPoolQueue);
        threadParameter.setThreadPoolQueueCapacity(this.threadPoolQueueCapacity);
        threadParameter.setThreadPoolRejectedPolicy(this.threadPoolRejectedPolicy);
        return new ThreadPoolFactory(threadCustomization, threadParameter);
    }

    @Bean
    public EventControllerFactory eventControllerFactory() {
        return new EventControllerFactory();
    }

    @Bean
    public EventBeanPostProcessor eventBeanPostProcessor() {
        return new EventBeanPostProcessor();
    }

    @Bean
    public EventContextClosedHandler eventContextClosedHandler() {
        return new EventContextClosedHandler();
    }

    static {
        LogoBanner logoBanner = new LogoBanner(EventConfiguration.class, "/com/nepxion/eventbus/resource/logo.txt", "Welcome to Nepxion", 8, 5, new Color[]{Color.red, Color.green, Color.cyan, Color.blue, Color.yellow, Color.magenta, Color.red, Color.green}, true);
        NepxionBanner.show((LogoBanner)logoBanner, (Description[])new Description[]{new Description("Version:", "2.0.13", 0, 1), new Description("Github:", "https://github.com/Nepxion/EventBus", 0, 1)});
    }
}

