/*
 * Decompiled with CFR 0.152.
 */
package com.pastdev.jsch.command;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.pastdev.jsch.IOUtils;
import com.pastdev.jsch.SessionFactory;
import com.pastdev.jsch.SessionManager;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandRunner
implements Closeable {
    private static Logger logger = LoggerFactory.getLogger(CommandRunner.class);
    protected static final Charset UTF8 = Charset.forName("UTF-8");
    protected final SessionManager sessionManager;

    public CommandRunner(SessionFactory sessionFactory) {
        this.sessionManager = new SessionManager(sessionFactory);
    }

    @Override
    public void close() throws IOException {
        this.sessionManager.close();
    }

    public CommandRunner duplicate() {
        return new CommandRunner(this.sessionManager.getSessionFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResult execute(String command) throws JSchException, IOException {
        int exitCode;
        logger.debug("executing {} on {}", (Object)command, (Object)this.sessionManager);
        Session session = this.sessionManager.getSession();
        ByteArrayOutputStream stdErr = new ByteArrayOutputStream();
        ByteArrayOutputStream stdOut = new ByteArrayOutputStream();
        ChannelExecWrapper channel = null;
        try {
            channel = new ChannelExecWrapper(session, command, null, stdOut, stdErr);
        }
        finally {
            exitCode = channel.close();
        }
        return new ExecuteResult(exitCode, new String(stdOut.toByteArray(), UTF8), new String(stdErr.toByteArray(), UTF8));
    }

    public ChannelExecWrapper open(String command) throws JSchException, IOException {
        logger.debug("executing {} on {}", (Object)command, (Object)this.sessionManager);
        return new ChannelExecWrapper(this.sessionManager.getSession(), command, null, null, null);
    }

    public class ChannelExecWrapper {
        protected ChannelExec channel;
        protected String command;
        protected OutputStream passedInStdErr;
        protected InputStream passedInStdIn;
        protected OutputStream passedInStdOut;
        protected InputStream stdErr;
        protected OutputStream stdIn;
        protected InputStream stdOut;

        protected ChannelExecWrapper() {
        }

        public ChannelExecWrapper(Session session, String command, InputStream stdIn, OutputStream stdOut, OutputStream stdErr) throws JSchException, IOException {
            this.command = command;
            this.channel = (ChannelExec)session.openChannel("exec");
            if (stdIn != null) {
                this.passedInStdIn = stdIn;
                this.channel.setInputStream(stdIn);
            }
            if (stdOut != null) {
                this.passedInStdOut = stdOut;
                this.channel.setOutputStream(stdOut);
            }
            if (stdErr != null) {
                this.passedInStdErr = stdErr;
                this.channel.setErrStream(stdErr);
            }
            this.channel.setCommand(command);
            this.channel.connect();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int close() {
            int exitCode = -2;
            if (this.channel != null) {
                try {
                    IOUtils.closeAndLogException(this.passedInStdIn);
                    IOUtils.closeAndLogException(this.passedInStdOut);
                    IOUtils.closeAndLogException(this.passedInStdErr);
                    IOUtils.closeAndLogException(this.stdIn);
                    IOUtils.closeAndLogException(this.stdOut);
                    IOUtils.closeAndLogException(this.stdErr);
                    int i = 0;
                    while (!this.channel.isClosed()) {
                        logger.trace("waiting for exit {}", (Object)i++);
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    exitCode = this.channel.getExitStatus();
                }
                finally {
                    if (this.channel.isConnected()) {
                        this.channel.disconnect();
                    }
                }
            }
            logger.trace("`{}` exit {}", (Object)this.command, (Object)exitCode);
            return exitCode;
        }

        public InputStream getErrStream() throws IOException {
            if (this.stdErr == null) {
                this.stdErr = this.channel.getErrStream();
            }
            return this.stdErr;
        }

        public InputStream getInputStream() throws IOException {
            if (this.stdOut == null) {
                this.stdOut = this.channel.getInputStream();
            }
            return this.stdOut;
        }

        public OutputStream getOutputStream() throws IOException {
            if (this.stdIn == null) {
                this.stdIn = this.channel.getOutputStream();
            }
            return this.stdIn;
        }
    }

    public class ExecuteResult {
        private int exitCode;
        private String stderr;
        private String stdout;

        public ExecuteResult(int exitCode, String stdout, String stderr) {
            this.exitCode = exitCode;
            this.stderr = stderr;
            this.stdout = stdout;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public String getStderr() {
            return this.stderr;
        }

        public String getStdout() {
            return this.stdout;
        }
    }
}

