/*
 * Decompiled with CFR 0.152.
 */
package com.pastdev.jsch.scp;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.pastdev.jsch.SessionFactory;
import com.pastdev.jsch.scp.CopyMode;
import com.pastdev.jsch.scp.ScpEntry;
import com.pastdev.jsch.scp.ScpMode;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScpConnection
implements Closeable {
    private static Logger logger = LoggerFactory.getLogger(ScpConnection.class);
    private static final Charset US_ASCII = Charset.forName("US-ASCII");
    private Channel channel;
    private Stack<CurrentEntry> entryStack;
    private InputStream inputStream;
    private OutputStream outputStream;
    private Session session;

    public ScpConnection(SessionFactory sessionFactory, String path, ScpMode scpMode, CopyMode copyMode) throws JSchException, IOException {
        this.session = sessionFactory.newSession();
        logger.debug("connecting session");
        this.session.connect();
        String command = ScpConnection.getCommand(path, scpMode, copyMode);
        this.channel = this.session.openChannel("exec");
        logger.debug("setting exec command to '{}'", (Object)command);
        ((ChannelExec)this.channel).setCommand(command);
        logger.debug("connecting channel");
        this.channel.connect();
        this.outputStream = this.channel.getOutputStream();
        this.inputStream = this.channel.getInputStream();
        if (scpMode == ScpMode.FROM) {
            this.writeAck();
        } else if (scpMode == ScpMode.TO) {
            this.checkAck();
        }
        this.entryStack = new Stack();
    }

    private static String getCommand(String path, ScpMode scpMode, CopyMode copyMode) {
        StringBuilder command = null;
        switch (scpMode) {
            case TO: {
                command = new StringBuilder("scp -tq");
                break;
            }
            case FROM: {
                command = new StringBuilder("scp -fq");
            }
        }
        if (copyMode == CopyMode.RECURSIVE) {
            command.append("r");
        }
        return command.append(" ").append(path).toString();
    }

    private int checkAck() throws IOException {
        logger.trace("wait for ack");
        int b = this.inputStream.read();
        logger.debug("ack response: '{}'", (Object)b);
        if (b == 1 || b == 2) {
            int c;
            StringBuilder sb = new StringBuilder();
            while ((c = this.inputStream.read()) != 10) {
                sb.append((char)c);
            }
            if (b == 1 || b == 2) {
                throw new IOException(sb.toString());
            }
        }
        return b;
    }

    @Override
    public void close() throws IOException {
        IOException toThrow = null;
        try {
            while (!this.entryStack.isEmpty()) {
                this.entryStack.pop().complete();
            }
        }
        catch (IOException e) {
            toThrow = e;
        }
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        catch (IOException e) {
            logger.error("failed to close outputStream: {}", (Object)e.getMessage());
            logger.debug("failed to close outputStream:", (Throwable)e);
        }
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (IOException e) {
            logger.error("failed to close inputStream: {}", (Object)e.getMessage());
            logger.debug("failed to close inputStream:", (Throwable)e);
        }
        if (this.channel != null && this.channel.isConnected()) {
            this.channel.disconnect();
        }
        if (this.session != null && this.session.isConnected()) {
            logger.debug("disconnecting session");
            this.session.disconnect();
        }
        if (toThrow != null) {
            throw toThrow;
        }
    }

    public void closeEntry() throws IOException {
        this.entryStack.pop().complete();
    }

    public InputStream getCurrentInputStream() {
        if (this.entryStack.isEmpty()) {
            return null;
        }
        CurrentEntry currentEntry = this.entryStack.peek();
        return currentEntry instanceof InputStream ? (InputStream)((Object)currentEntry) : null;
    }

    public OutputStream getCurrentOuputStream() {
        if (this.entryStack.isEmpty()) {
            return null;
        }
        CurrentEntry currentEntry = this.entryStack.peek();
        return currentEntry instanceof OutputStream ? (OutputStream)((Object)currentEntry) : null;
    }

    public ScpEntry getNextEntry() throws IOException {
        ScpEntry entry;
        if (!this.entryStack.isEmpty() && !this.entryStack.peek().isDirectoryEntry()) {
            this.closeEntry();
        }
        if ((entry = this.parseMessage()) == null) {
            return null;
        }
        if (entry.isEndOfDirectory()) {
            while (!this.entryStack.isEmpty()) {
                boolean isDirectory = this.entryStack.peek().isDirectoryEntry();
                this.closeEntry();
                if (!isDirectory) continue;
                break;
            }
        } else if (entry.isDirectory()) {
            this.entryStack.push(new InputDirectoryEntry(entry));
        } else {
            this.entryStack.push(new EntryInputStream(entry));
        }
        return entry;
    }

    private ScpEntry parseMessage() throws IOException {
        int ack = this.checkAck();
        if (ack == -1) {
            return null;
        }
        char type = (char)ack;
        ScpEntry scpEntry = null;
        if (type == 'E') {
            scpEntry = ScpEntry.newEndOfDirectory();
            this.readMessageSegment();
        } else if (type == 'C' || type == 'D') {
            String mode = this.readMessageSegment();
            String sizeString = this.readMessageSegment();
            if (sizeString == null) {
                return null;
            }
            long size = Long.parseLong(sizeString);
            String name = this.readMessageSegment();
            if (name == null) {
                return null;
            }
            scpEntry = type == 'C' ? ScpEntry.newFile(name, size, mode) : ScpEntry.newDirectory(name, mode);
        } else {
            throw new UnsupportedOperationException("unknown protocol message type " + type);
        }
        logger.debug("read '{}'", (Object)scpEntry);
        return scpEntry;
    }

    public void putNextEntry(String name) throws IOException {
        this.putNextEntry(ScpEntry.newDirectory(name));
    }

    public void putNextEntry(String name, long size) throws IOException {
        this.putNextEntry(ScpEntry.newFile(name, size));
    }

    public void putNextEntry(ScpEntry entry) throws IOException {
        CurrentEntry currentEntry;
        if (entry.isEndOfDirectory()) {
            while (!this.entryStack.isEmpty()) {
                boolean isDirectory = this.entryStack.peek().isDirectoryEntry();
                this.closeEntry();
                if (!isDirectory) continue;
                break;
            }
            return;
        }
        if (!this.entryStack.isEmpty() && !(currentEntry = this.entryStack.peek()).isDirectoryEntry()) {
            this.closeEntry();
        }
        if (entry.isDirectory()) {
            this.entryStack.push(new OutputDirectoryEntry(entry));
        } else {
            this.entryStack.push(new EntryOutputStream(entry));
        }
    }

    private String readMessageSegment() throws IOException {
        byte[] buffer = new byte[1024];
        int bytesRead = 0;
        while (true) {
            byte b;
            if ((b = (byte)this.inputStream.read()) == -1) {
                return null;
            }
            if (b == 32 || b == 10) break;
            buffer[bytesRead] = b;
            ++bytesRead;
        }
        return new String(buffer, 0, bytesRead, US_ASCII);
    }

    private void writeAck() throws IOException {
        logger.debug("writing ack");
        this.outputStream.write(0);
        this.outputStream.flush();
    }

    private void writeMessage(String message) throws IOException {
        this.writeMessage(message.getBytes(US_ASCII));
    }

    private void writeMessage(byte ... message) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("writing message: '{}'", (Object)new String(message, US_ASCII));
        }
        this.outputStream.write(message);
        this.outputStream.flush();
        this.checkAck();
    }

    private class EntryOutputStream
    extends OutputStream
    implements CurrentEntry {
        private ScpEntry entry;
        private long ioCount;
        private boolean closed;

        public EntryOutputStream(ScpEntry entry) throws IOException {
            this.entry = entry;
            this.ioCount = 0L;
            ScpConnection.this.writeMessage("C" + entry.getMode() + " " + entry.getSize() + " " + entry.getName() + "\n");
            this.closed = false;
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                if (!this.isComplete()) {
                    throw new IOException("stream not finished (" + this.ioCount + "!=" + this.entry.getSize() + ")");
                }
                ScpConnection.this.writeMessage(new byte[]{0});
                this.closed = true;
            }
        }

        @Override
        public void complete() throws IOException {
            this.close();
        }

        private void increment() throws IOException {
            if (this.isComplete()) {
                throw new IOException("too many bytes written for file " + this.entry.getName());
            }
            ++this.ioCount;
        }

        private boolean isComplete() {
            return this.ioCount == this.entry.getSize();
        }

        @Override
        public boolean isDirectoryEntry() {
            return false;
        }

        @Override
        public void write(int b) throws IOException {
            this.increment();
            ScpConnection.this.outputStream.write(b);
        }
    }

    private class EntryInputStream
    extends InputStream
    implements CurrentEntry {
        private ScpEntry entry;
        private long ioCount;
        private boolean closed;

        public EntryInputStream(ScpEntry entry) throws IOException {
            this.entry = entry;
            this.ioCount = 0L;
            ScpConnection.this.writeAck();
            this.closed = false;
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                if (!this.isComplete()) {
                    throw new IOException("stream not finished (" + this.ioCount + "!=" + this.entry.getSize() + ")");
                }
                ScpConnection.this.writeAck();
                ScpConnection.this.checkAck();
                this.closed = true;
            }
        }

        @Override
        public void complete() throws IOException {
            this.close();
        }

        private void increment() throws IOException {
            ++this.ioCount;
        }

        private boolean isComplete() {
            return this.ioCount == this.entry.getSize();
        }

        @Override
        public boolean isDirectoryEntry() {
            return false;
        }

        @Override
        public int read() throws IOException {
            if (this.isComplete()) {
                return -1;
            }
            this.increment();
            return ScpConnection.this.inputStream.read();
        }
    }

    private class OutputDirectoryEntry
    implements CurrentEntry {
        private OutputDirectoryEntry(ScpEntry entry) throws IOException {
            ScpConnection.this.writeMessage("D" + entry.getMode() + " 0 " + entry.getName() + "\n");
        }

        @Override
        public void complete() throws IOException {
            ScpConnection.this.writeMessage("E\n");
        }

        @Override
        public boolean isDirectoryEntry() {
            return true;
        }
    }

    private class InputDirectoryEntry
    implements CurrentEntry {
        private InputDirectoryEntry(ScpEntry entry) throws IOException {
            ScpConnection.this.writeAck();
        }

        @Override
        public void complete() throws IOException {
            ScpConnection.this.writeAck();
        }

        @Override
        public boolean isDirectoryEntry() {
            return true;
        }
    }

    private static interface CurrentEntry {
        public void complete() throws IOException;

        public boolean isDirectoryEntry();
    }
}

