/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.component.AttachedObjectListHolder;
import javax.faces.component.ContextCallback;
import javax.faces.component.NamingContainer;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.StateHolder;
import javax.faces.component.StateHolderSaver;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UniqueIdVendor;
import javax.faces.component.ValueBindingValueExpressionAdapter;
import javax.faces.component.ValueExpressionValueBindingAdapter;
import javax.faces.component.behavior.Behavior;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.BehaviorEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.PostValidateEvent;
import javax.faces.event.PreRemoveFromViewEvent;
import javax.faces.event.PreRenderComponentEvent;
import javax.faces.event.PreValidateEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.faces.render.Renderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIComponentBase
extends UIComponent {
    private static Logger LOGGER = Logger.getLogger("javax.faces.component", "javax.faces.LogStrings");
    private static final String ADDED = UIComponentBase.class.getName() + ".ADDED";
    private Map<Class<?>, Map<String, PropertyDescriptor>> descriptors;
    private Map<String, PropertyDescriptor> pdMap = null;
    private Map<Class<? extends SystemEvent>, List<SystemEventListener>> listenersByEventClass;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private AttributesMap attributes = null;
    private String clientId = null;
    private String id = null;
    private UIComponent parent = null;
    private List<UIComponent> children = null;
    private Map<String, UIComponent> facets = null;
    private AttachedObjectListHolder<FacesListener> listeners;
    private static final int MY_STATE = 0;
    private static final int CHILD_STATE = 1;
    private boolean transientFlag = false;
    private BehaviorsMap behaviors;
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final Iterator<UIComponent> EMPTY_ITERATOR = new Iterator<UIComponent>(){

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UIComponent next() {
            throw new NoSuchElementException("Empty Iterator");
        }

        @Override
        public boolean hasNext() {
            return false;
        }
    };

    public UIComponentBase() {
        this.populateDescriptorsMapIfNecessary();
    }

    private void populateDescriptorsMapIfNecessary() {
        Object object;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Class<?> clazz = this.getClass();
        if (facesContext != null && facesContext.getExternalContext() != null && facesContext.getExternalContext().getApplicationMap() != null) {
            object = facesContext.getExternalContext().getApplicationMap();
            if (!object.containsKey("com.sun.faces.compnent.COMPONENT_DESCRIPTORS_MAP")) {
                object.put("com.sun.faces.compnent.COMPONENT_DESCRIPTORS_MAP", new ConcurrentHashMap());
            }
            this.descriptors = (Map)object.get("com.sun.faces.compnent.COMPONENT_DESCRIPTORS_MAP");
            this.pdMap = this.descriptors.get(clazz);
        }
        if (this.pdMap == null && (object = this.getPropertyDescriptors()) != null) {
            this.pdMap = new HashMap<String, PropertyDescriptor>(((PropertyDescriptor[])object).length, 1.0f);
            for (Object object2 : object) {
                this.pdMap.put(((FeatureDescriptor)object2).getName(), (PropertyDescriptor)object2);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "fine.component.populating_descriptor_map", new Object[]{clazz, Thread.currentThread().getName()});
            }
            if (this.descriptors != null && !this.descriptors.containsKey(clazz)) {
                this.descriptors.put(clazz, this.pdMap);
            }
        }
    }

    private PropertyDescriptor[] getPropertyDescriptors() {
        PropertyDescriptor[] propertyDescriptorArray;
        try {
            propertyDescriptorArray = Introspector.getBeanInfo(this.getClass()).getPropertyDescriptors();
        }
        catch (IntrospectionException introspectionException) {
            throw new FacesException(introspectionException);
        }
        return propertyDescriptorArray;
    }

    @Override
    public Map<String, Object> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new AttributesMap(this);
        }
        return this.attributes;
    }

    @Override
    public Map<String, Object> getPassThroughAttributes(boolean bl) {
        PassThroughAttributesMap passThroughAttributesMap = (PassThroughAttributesMap)this.getStateHelper().get((Serializable)((Object)UIComponent.PropertyKeys.passThroughAttributes));
        if (null == passThroughAttributesMap && bl) {
            passThroughAttributesMap = new PassThroughAttributesMap();
            this.getStateHelper().put((Serializable)((Object)UIComponent.PropertyKeys.passThroughAttributes), passThroughAttributesMap);
        }
        return passThroughAttributesMap;
    }

    @Override
    public ValueBinding getValueBinding(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        ValueBinding valueBinding = null;
        ValueExpression valueExpression = this.getValueExpression(string);
        if (null != valueExpression) {
            valueBinding = valueExpression.getClass().equals(ValueExpressionValueBindingAdapter.class) ? ((ValueExpressionValueBindingAdapter)valueExpression).getWrapped() : new ValueBindingValueExpressionAdapter(valueExpression);
        }
        return valueBinding;
    }

    @Override
    public void setValueBinding(String string, ValueBinding valueBinding) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (valueBinding != null) {
            ValueExpressionValueBindingAdapter valueExpressionValueBindingAdapter = new ValueExpressionValueBindingAdapter(valueBinding);
            this.setValueExpression(string, valueExpressionValueBindingAdapter);
        } else {
            this.setValueExpression(string, null);
        }
    }

    @Override
    public String getClientId(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (this.clientId == null) {
            Object object;
            UIComponent uIComponent;
            UIComponent uIComponent2 = uIComponent = this.getNamingContainerAncestor();
            String string = null;
            if (uIComponent2 != null) {
                string = uIComponent2.getContainerClientId(facesContext);
            }
            this.clientId = this.getId();
            if (this.clientId == null) {
                object = null != uIComponent && uIComponent instanceof UniqueIdVendor ? ((UniqueIdVendor)((Object)uIComponent)).createUniqueId(facesContext, null) : facesContext.getViewRoot().createUniqueId();
                this.setId((String)object);
                this.clientId = this.getId();
            }
            if (string != null) {
                object = new StringBuilder(string.length() + 1 + this.clientId.length());
                this.clientId = ((StringBuilder)object).append(string).append(UINamingContainer.getSeparatorChar(facesContext)).append(this.clientId).toString();
            }
            if ((object = this.getRenderer(facesContext)) != null) {
                this.clientId = ((Renderer)object).convertClientId(facesContext, this.clientId);
            }
        }
        return this.clientId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    private UIComponent getNamingContainerAncestor() {
        for (UIComponent uIComponent = this.getParent(); uIComponent != null; uIComponent = uIComponent.getParent()) {
            if (!(uIComponent instanceof NamingContainer)) continue;
            return uIComponent;
        }
        return null;
    }

    @Override
    public void setId(String string) {
        if (this.id == null || !this.id.equals(string)) {
            UIComponentBase.validateId(string);
            this.id = string;
        }
        this.clientId = null;
    }

    @Override
    public UIComponent getParent() {
        return this.parent;
    }

    @Override
    public void setParent(UIComponent uIComponent) {
        if (uIComponent == null) {
            if (this.parent != null) {
                this.doPreRemoveProcessing(FacesContext.getCurrentInstance(), this);
                this.parent = uIComponent;
            }
            this.compositeParent = null;
        } else {
            this.parent = uIComponent;
            if (this.getAttributes().get(ADDED) == null) {
                this.getAttributes().put(ADDED, Boolean.TRUE);
                this.doPostAddProcessing(FacesContext.getCurrentInstance(), this);
                this.getAttributes().remove(ADDED);
            }
        }
    }

    @Override
    public boolean isRendered() {
        return Boolean.valueOf(this.getStateHelper().eval((Serializable)((Object)UIComponent.PropertyKeys.rendered), Boolean.TRUE).toString());
    }

    @Override
    public void setRendered(boolean bl) {
        this.getStateHelper().put((Serializable)((Object)UIComponent.PropertyKeys.rendered), bl);
    }

    @Override
    public String getRendererType() {
        return (String)this.getStateHelper().eval((Serializable)((Object)UIComponent.PropertyKeys.rendererType));
    }

    @Override
    public void setRendererType(String string) {
        this.getStateHelper().put((Serializable)((Object)UIComponent.PropertyKeys.rendererType), string);
    }

    @Override
    public boolean getRendersChildren() {
        Renderer renderer;
        boolean bl = false;
        if (this.getRendererType() != null && null != (renderer = this.getRenderer(this.getFacesContext()))) {
            bl = renderer.getRendersChildren();
        }
        return bl;
    }

    @Override
    public List<UIComponent> getChildren() {
        if (this.children == null) {
            this.children = new ChildrenList(this);
        }
        return this.children;
    }

    @Override
    public int getChildCount() {
        if (this.children != null) {
            return this.children.size();
        }
        return 0;
    }

    private static void eraseParent(UIComponent uIComponent) {
        Object object;
        int n;
        UIComponent uIComponent2 = uIComponent.getParent();
        if (uIComponent2 == null) {
            return;
        }
        if (uIComponent2.getChildCount() > 0 && (n = (object = uIComponent2.getChildren()).indexOf(uIComponent)) >= 0) {
            object.remove(n);
            return;
        }
        if (uIComponent2.getFacetCount() > 0) {
            object = uIComponent2.getFacets();
            Iterator iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (entry.getValue() != uIComponent) continue;
                iterator.remove();
                return;
            }
        }
        throw new IllegalStateException("Parent was not null, but this component not related");
    }

    private static void validateId(String string) {
        if (string == null) {
            return;
        }
        int n = string.length();
        if (n < 1) {
            throw new IllegalArgumentException("Empty id attribute is not allowed");
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!(i == 0 ? !Character.isLetter(c) && c != '_' : !Character.isLetter(c) && !Character.isDigit(c) && c != '-' && c != '_')) continue;
            throw new IllegalArgumentException(string);
        }
    }

    @Override
    public UIComponent findComponent(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        char c = UINamingContainer.getSeparatorChar(facesContext);
        String string2 = String.valueOf(c);
        if (string.length() == 0) {
            throw new IllegalArgumentException("\"\"");
        }
        UIComponent uIComponent = this;
        if (string.charAt(0) == c) {
            while (uIComponent.getParent() != null) {
                uIComponent = uIComponent.getParent();
            }
            string = string.substring(1);
        } else if (!(uIComponent instanceof NamingContainer)) {
            while (uIComponent.getParent() != null && !(uIComponent instanceof NamingContainer)) {
                uIComponent = uIComponent.getParent();
            }
        }
        UIComponent uIComponent2 = null;
        String[] stringArray = string.split(string2);
        int n = 0;
        int n2 = stringArray.length - 1;
        while (n < stringArray.length) {
            uIComponent2 = UIComponentBase.findComponent(uIComponent, stringArray[n], n == 0);
            if (n == 0 && uIComponent2 == null && stringArray[n].equals(uIComponent.getId())) {
                uIComponent2 = uIComponent;
            }
            if (uIComponent2 != null && !(uIComponent2 instanceof NamingContainer) && n2 > 0) {
                throw new IllegalArgumentException(stringArray[n]);
            }
            if (uIComponent2 == null) break;
            uIComponent = uIComponent2;
            ++n;
            --n2;
        }
        return uIComponent2;
    }

    private static UIComponent findComponent(UIComponent uIComponent, String string, boolean bl) {
        if (bl && string.equals(uIComponent.getId())) {
            return uIComponent;
        }
        UIComponent uIComponent2 = null;
        Iterator<UIComponent> iterator = uIComponent.getFacetsAndChildren();
        while (iterator.hasNext()) {
            UIComponent uIComponent3 = iterator.next();
            if (!(uIComponent3 instanceof NamingContainer)) {
                if (bl && string.equals(uIComponent3.getId())) {
                    uIComponent2 = uIComponent3;
                    break;
                }
                uIComponent2 = UIComponentBase.findComponent(uIComponent3, string, true);
                if (uIComponent2 == null) continue;
                break;
            }
            if (!string.equals(uIComponent3.getId())) continue;
            uIComponent2 = uIComponent3;
            break;
        }
        return uIComponent2;
    }

    @Override
    public boolean invokeOnComponent(FacesContext facesContext, String string, ContextCallback contextCallback) throws FacesException {
        return super.invokeOnComponent(facesContext, string, contextCallback);
    }

    @Override
    public Map<String, UIComponent> getFacets() {
        if (this.facets == null) {
            this.facets = new FacetsMap(this);
        }
        return this.facets;
    }

    @Override
    public int getFacetCount() {
        if (this.facets != null) {
            return this.facets.size();
        }
        return 0;
    }

    @Override
    public UIComponent getFacet(String string) {
        if (this.facets != null) {
            return this.facets.get(string);
        }
        return null;
    }

    @Override
    public Iterator<UIComponent> getFacetsAndChildren() {
        Iterator<UIComponent> iterator;
        int n = this.getChildCount();
        int n2 = this.getFacetCount();
        if (0 == n && 0 == n2) {
            iterator = EMPTY_ITERATOR;
        } else if (0 == n) {
            Collection<UIComponent> collection = Collections.unmodifiableCollection(this.getFacets().values());
            iterator = collection.iterator();
        } else if (0 == n2) {
            List<UIComponent> list = Collections.unmodifiableList(this.getChildren());
            iterator = list.iterator();
        } else {
            iterator = new FacetsAndChildrenIterator(this);
        }
        return iterator;
    }

    @Override
    public void broadcast(FacesEvent facesEvent) throws AbortProcessingException {
        if (facesEvent == null) {
            throw new NullPointerException();
        }
        if (facesEvent instanceof BehaviorEvent) {
            FacesListener[] facesListenerArray = (FacesListener[])facesEvent;
            Behavior behavior = facesListenerArray.getBehavior();
            behavior.broadcast((BehaviorEvent)facesListenerArray);
        }
        if (this.listeners == null) {
            return;
        }
        for (FacesListener facesListener : this.listeners.asArray(FacesListener.class)) {
            if (!facesEvent.isAppropriateListener(facesListener)) continue;
            facesEvent.processListener(facesListener);
        }
    }

    @Override
    public void decode(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        String string = this.getRendererType();
        if (string != null) {
            Renderer renderer = this.getRenderer(facesContext);
            if (renderer != null) {
                renderer.decode(facesContext, this);
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Can't get Renderer for type " + string);
            }
        }
    }

    @Override
    public void encodeBegin(FacesContext facesContext) throws IOException {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        this.pushComponentToEL(facesContext, null);
        if (!this.isRendered()) {
            return;
        }
        facesContext.getApplication().publishEvent(facesContext, PreRenderComponentEvent.class, this);
        String string = this.getRendererType();
        if (string != null) {
            Renderer renderer = this.getRenderer(facesContext);
            if (renderer != null) {
                renderer.encodeBegin(facesContext, this);
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Can't get Renderer for type " + string);
            }
        }
    }

    @Override
    public void encodeChildren(FacesContext facesContext) throws IOException {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        String string = this.getRendererType();
        if (string != null) {
            Renderer renderer = this.getRenderer(facesContext);
            if (renderer != null) {
                renderer.encodeChildren(facesContext, this);
            }
        } else if (this.getChildCount() > 0) {
            for (UIComponent uIComponent : this.getChildren()) {
                uIComponent.encodeAll(facesContext);
            }
        }
    }

    @Override
    public void encodeEnd(FacesContext facesContext) throws IOException {
        Renderer renderer;
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            this.popComponentFromEL(facesContext);
            return;
        }
        String string = this.getRendererType();
        if (string != null && (renderer = this.getRenderer(facesContext)) != null) {
            renderer.encodeEnd(facesContext, this);
        }
        this.popComponentFromEL(facesContext);
    }

    @Override
    protected void addFacesListener(FacesListener facesListener) {
        if (facesListener == null) {
            throw new NullPointerException();
        }
        if (this.listeners == null) {
            this.listeners = new AttachedObjectListHolder();
        }
        this.listeners.add(facesListener);
    }

    @Override
    protected FacesListener[] getFacesListeners(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (!FacesListener.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException();
        }
        if (this.listeners == null) {
            return (FacesListener[])Array.newInstance(clazz, 0);
        }
        FacesListener[] facesListenerArray = this.listeners.asArray(FacesListener.class);
        if (facesListenerArray.length == 0) {
            return (FacesListener[])Array.newInstance(clazz, 0);
        }
        ArrayList<FacesListener> arrayList = new ArrayList<FacesListener>(facesListenerArray.length);
        for (FacesListener facesListener : facesListenerArray) {
            if (!clazz.isAssignableFrom(facesListener.getClass())) continue;
            arrayList.add(facesListener);
        }
        return arrayList.toArray((FacesListener[])Array.newInstance(clazz, arrayList.size()));
    }

    @Override
    protected void removeFacesListener(FacesListener facesListener) {
        if (facesListener == null) {
            throw new NullPointerException();
        }
        if (this.listeners != null) {
            this.listeners.remove(facesListener);
        }
    }

    @Override
    public void queueEvent(FacesEvent facesEvent) {
        if (facesEvent == null) {
            throw new NullPointerException();
        }
        UIComponent uIComponent = this.getParent();
        if (uIComponent == null) {
            throw new IllegalStateException();
        }
        uIComponent.queueEvent(facesEvent);
    }

    @Override
    public void subscribeToEvent(Class<? extends SystemEvent> clazz, ComponentSystemEventListener componentSystemEventListener) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (componentSystemEventListener == null) {
            throw new NullPointerException();
        }
        if (this.initialStateMarked()) {
            this.initialState = false;
        }
        if (null == this.listenersByEventClass) {
            this.listenersByEventClass = new HashMap<Class<? extends SystemEvent>, List<SystemEventListener>>(3, 1.0f);
        }
        UIComponent.ComponentSystemEventListenerAdapter componentSystemEventListenerAdapter = new UIComponent.ComponentSystemEventListenerAdapter(componentSystemEventListener, this);
        List<SystemEventListener> list = this.listenersByEventClass.get(clazz);
        if (list == null) {
            list = new ArrayList<SystemEventListener>(3);
            this.listenersByEventClass.put(clazz, list);
        }
        if (!list.contains(componentSystemEventListenerAdapter)) {
            list.add(componentSystemEventListenerAdapter);
        }
    }

    @Override
    public void unsubscribeFromEvent(Class<? extends SystemEvent> clazz, ComponentSystemEventListener componentSystemEventListener) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (componentSystemEventListener == null) {
            throw new NullPointerException();
        }
        List<SystemEventListener> list = this.getListenersForEventClass(clazz);
        if (list != null && !list.isEmpty()) {
            Iterator<SystemEventListener> iterator = list.iterator();
            while (iterator.hasNext()) {
                SystemEventListener systemEventListener = iterator.next();
                UIComponent.ComponentSystemEventListenerAdapter componentSystemEventListenerAdapter = (UIComponent.ComponentSystemEventListenerAdapter)systemEventListener;
                ComponentSystemEventListener componentSystemEventListener2 = componentSystemEventListenerAdapter.getWrapped();
                if (!componentSystemEventListener2.equals(componentSystemEventListener)) continue;
                iterator.remove();
                break;
            }
        }
    }

    @Override
    public List<SystemEventListener> getListenersForEventClass(Class<? extends SystemEvent> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        List<SystemEventListener> list = null;
        if (this.listenersByEventClass != null) {
            list = this.listenersByEventClass.get(clazz);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processDecodes(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(facesContext, null);
        try {
            Iterator<UIComponent> iterator = this.getFacetsAndChildren();
            while (iterator.hasNext()) {
                UIComponent uIComponent = iterator.next();
                uIComponent.processDecodes(facesContext);
            }
            try {
                this.decode(facesContext);
            }
            catch (RuntimeException runtimeException) {
                facesContext.renderResponse();
                throw runtimeException;
            }
        }
        finally {
            this.popComponentFromEL(facesContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processValidators(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(facesContext, null);
        try {
            Application application = facesContext.getApplication();
            application.publishEvent(facesContext, PreValidateEvent.class, this);
            Iterator<UIComponent> iterator = this.getFacetsAndChildren();
            while (iterator.hasNext()) {
                UIComponent uIComponent = iterator.next();
                uIComponent.processValidators(facesContext);
            }
            application.publishEvent(facesContext, PostValidateEvent.class, this);
        }
        finally {
            this.popComponentFromEL(facesContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processUpdates(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(facesContext, null);
        try {
            Iterator<UIComponent> iterator = this.getFacetsAndChildren();
            while (iterator.hasNext()) {
                UIComponent uIComponent = iterator.next();
                uIComponent.processUpdates(facesContext);
            }
        }
        finally {
            this.popComponentFromEL(facesContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object processSaveState(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (this.isTransient()) {
            return null;
        }
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = EMPTY_ARRAY;
        this.pushComponentToEL(facesContext, null);
        try {
            objectArray[0] = this.saveState(facesContext);
            int n = this.getChildCount() + this.getFacetCount();
            if (n > 0) {
                ArrayList<Object> arrayList = new ArrayList<Object>(n);
                if (this.getChildCount() > 0) {
                    for (UIComponent uIComponent : this.getChildren()) {
                        if (uIComponent.isTransient()) continue;
                        arrayList.add(uIComponent.processSaveState(facesContext));
                    }
                }
                if (this.getFacetCount() > 0) {
                    for (Map.Entry entry : this.getFacets().entrySet()) {
                        UIComponent uIComponent;
                        uIComponent = (UIComponent)entry.getValue();
                        if (uIComponent.isTransient()) continue;
                        Object object = uIComponent.processSaveState(facesContext);
                        Object[] objectArray3 = new Object[]{entry.getKey(), object};
                        arrayList.add(objectArray3);
                    }
                }
                objectArray2 = arrayList.toArray();
            }
        }
        finally {
            this.popComponentFromEL(facesContext);
        }
        objectArray[1] = objectArray2;
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processRestoreState(FacesContext facesContext, Object object) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        this.pushComponentToEL(facesContext, null);
        try {
            Object[] objectArray;
            Object[] objectArray2 = (Object[])object;
            Object[] objectArray3 = (Object[])objectArray2[1];
            this.restoreState(facesContext, objectArray2[0]);
            int n = 0;
            if (this.getChildCount() > 0) {
                for (UIComponent uIComponent : this.getChildren()) {
                    if (uIComponent.isTransient() || (objectArray = objectArray3[n++]) == null) continue;
                    uIComponent.processRestoreState(facesContext, objectArray);
                }
            }
            if (this.getFacetCount() > 0) {
                int n2 = this.getFacets().size();
                for (int i = 0; i < n2; ++i) {
                    if (null == (objectArray = (Object[])objectArray3[n++])) continue;
                    String string = (String)objectArray[0];
                    Object object2 = objectArray[1];
                    UIComponent uIComponent = this.getFacets().get(string);
                    uIComponent.processRestoreState(facesContext, object2);
                }
            }
        }
        finally {
            this.popComponentFromEL(facesContext);
        }
    }

    @Override
    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    @Override
    protected Renderer getRenderer(FacesContext facesContext) {
        String string = this.getRendererType();
        Renderer renderer = null;
        if (string != null) {
            renderer = facesContext.getRenderKit().getRenderer(this.getFamily(), string);
            if (null == renderer && LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Can't get Renderer for type " + string);
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            String string2 = this.getId();
            string2 = null != string2 ? string2 : this.getClass().getName();
            LOGGER.fine("No renderer-type for component " + string2);
        }
        return renderer;
    }

    @Override
    public void markInitialState() {
        super.markInitialState();
        if (this.listeners != null) {
            this.listeners.markInitialState();
        }
        if (this.listenersByEventClass != null) {
            for (List object : this.listenersByEventClass.values()) {
                if (!(object instanceof PartialStateHolder)) continue;
                ((PartialStateHolder)((Object)object)).markInitialState();
            }
        }
        if (this.behaviors != null) {
            for (Map.Entry entry : this.behaviors.entrySet()) {
                for (ClientBehavior clientBehavior : (List)entry.getValue()) {
                    if (!(clientBehavior instanceof PartialStateHolder)) continue;
                    ((PartialStateHolder)((Object)clientBehavior)).markInitialState();
                }
            }
        }
    }

    @Override
    public void clearInitialState() {
        super.clearInitialState();
        if (this.listeners != null) {
            this.listeners.clearInitialState();
        }
        if (this.listenersByEventClass != null) {
            for (List object : this.listenersByEventClass.values()) {
                if (!(object instanceof PartialStateHolder)) continue;
                ((PartialStateHolder)((Object)object)).clearInitialState();
            }
        }
        if (this.behaviors != null) {
            for (Map.Entry entry : this.behaviors.entrySet()) {
                for (ClientBehavior clientBehavior : (List)entry.getValue()) {
                    if (!(clientBehavior instanceof PartialStateHolder)) continue;
                    ((PartialStateHolder)((Object)clientBehavior)).clearInitialState();
                }
            }
        }
    }

    @Override
    public Object saveState(FacesContext facesContext) {
        Object[] objectArray = null;
        if (facesContext == null) {
            throw new NullPointerException();
        }
        assert (!this.transientFlag);
        if (this.initialStateMarked()) {
            Object object = this.listeners != null ? this.listeners.saveState(facesContext) : null;
            Object object2 = this.saveSystemEventListeners(facesContext);
            Object object3 = this.saveBehaviorsState(facesContext);
            Object object4 = null;
            if (this.bindings != null) {
                object4 = this.saveBindingsState(facesContext);
            }
            Object object5 = null;
            if (this.stateHelper != null) {
                object5 = this.stateHelper.saveState(facesContext);
            }
            if (object == null && object2 == null && object3 == null && object4 == null && object5 == null) {
                return null;
            }
            if (objectArray == null || objectArray.length != 5) {
                objectArray = new Object[]{object, object2, object3, object4, object5};
            }
            return objectArray;
        }
        if (objectArray == null || objectArray.length != 6) {
            objectArray = new Object[6];
        }
        objectArray[0] = this.listeners != null ? this.listeners.saveState(facesContext) : null;
        objectArray[1] = this.saveSystemEventListeners(facesContext);
        objectArray[2] = this.saveBehaviorsState(facesContext);
        if (this.bindings != null) {
            objectArray[3] = this.saveBindingsState(facesContext);
        }
        if (this.stateHelper != null) {
            objectArray[4] = this.stateHelper.saveState(facesContext);
        }
        objectArray[5] = this.id;
        return objectArray;
    }

    @Override
    public void restoreState(FacesContext facesContext, Object object) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (object == null) {
            return;
        }
        Object[] objectArray = (Object[])object;
        if (objectArray[0] != null) {
            if (this.listeners == null) {
                this.listeners = new AttachedObjectListHolder();
            }
            this.listeners.restoreState(facesContext, objectArray[0]);
        }
        if (objectArray[1] != null) {
            Map<Class<? extends SystemEvent>, List<SystemEventListener>> map = this.restoreSystemEventListeners(facesContext, objectArray[1]);
            if (this.listenersByEventClass != null) {
                this.listenersByEventClass.putAll(map);
            } else {
                this.listenersByEventClass = map;
            }
        }
        if (objectArray[2] != null) {
            this.behaviors = this.restoreBehaviorsState(facesContext, objectArray[2]);
        }
        if (objectArray[3] != null) {
            this.bindings = UIComponentBase.restoreBindingsState(facesContext, objectArray[3]);
        }
        if (objectArray[4] != null) {
            this.getStateHelper().restoreState(facesContext, objectArray[4]);
        }
        if (objectArray.length == 6 && objectArray[5] != null) {
            this.id = (String)objectArray[5];
        }
    }

    @Override
    public boolean isTransient() {
        return this.transientFlag;
    }

    @Override
    public void setTransient(boolean bl) {
        this.transientFlag = bl;
    }

    public static Object saveAttachedState(FacesContext facesContext, Object object) {
        StateHolderSaver stateHolderSaver;
        if (null == facesContext) {
            throw new NullPointerException();
        }
        if (null == object) {
            return null;
        }
        Class<?> clazz = object.getClass();
        boolean bl = true;
        try {
            int n = clazz.getModifiers();
            bl = Modifier.isPublic(n);
            if (bl) {
                bl = null != clazz.getConstructor(new Class[0]);
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (bl && object instanceof Collection) {
            Collection collection = (Collection)object;
            ArrayList<StateHolderSaver> arrayList = null;
            for (Object e : collection) {
                if (e == null || e instanceof StateHolder && ((StateHolder)e).isTransient()) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<StateHolderSaver>(collection.size() + 1);
                    arrayList.add(new StateHolderSaver(facesContext, clazz));
                }
                arrayList.add(new StateHolderSaver(facesContext, e));
            }
            stateHolderSaver = arrayList;
        } else if (bl && object instanceof Map) {
            Map map = (Map)object;
            ArrayList<StateHolderSaver> arrayList = null;
            for (Map.Entry entry : map.entrySet()) {
                Object v;
                Object k = entry.getKey();
                if (k instanceof StateHolder && ((StateHolder)k).isTransient() || (v = entry.getValue()) instanceof StateHolder && ((StateHolder)v).isTransient()) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<StateHolderSaver>(map.size() * 2 + 1);
                    arrayList.add(new StateHolderSaver(facesContext, clazz));
                }
                arrayList.add(new StateHolderSaver(facesContext, k));
                arrayList.add(new StateHolderSaver(facesContext, v));
            }
            stateHolderSaver = arrayList;
        } else {
            stateHolderSaver = new StateHolderSaver(facesContext, object);
        }
        return stateHolderSaver;
    }

    public static Object restoreAttachedState(FacesContext facesContext, Object object) throws IllegalStateException {
        Object object2;
        if (null == facesContext) {
            throw new NullPointerException();
        }
        if (null == object) {
            return null;
        }
        if (object instanceof List) {
            List list = (List)object;
            StateHolderSaver stateHolderSaver = (StateHolderSaver)list.get(0);
            Class clazz = (Class)stateHolderSaver.restore(facesContext);
            if (Collection.class.isAssignableFrom(clazz)) {
                Collection collection = null;
                try {
                    collection = (Collection)clazz.newInstance();
                }
                catch (Exception exception) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, exception.toString(), exception);
                    }
                    throw new IllegalStateException("Unknown object type");
                }
                int n = list.size();
                for (int i = 1; i < n; ++i) {
                    try {
                        collection.add(((StateHolderSaver)list.get(i)).restore(facesContext));
                        continue;
                    }
                    catch (ClassCastException classCastException) {
                        if (LOGGER.isLoggable(Level.SEVERE)) {
                            LOGGER.log(Level.SEVERE, classCastException.toString(), classCastException);
                        }
                        throw new IllegalStateException("Unknown object type");
                    }
                }
                object2 = collection;
            } else {
                Map map = null;
                try {
                    map = (Map)clazz.newInstance();
                }
                catch (Exception exception) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, exception.toString(), exception);
                    }
                    throw new IllegalStateException("Unknown object type");
                }
                int n = list.size();
                for (int i = 1; i < n; i += 2) {
                    try {
                        map.put(((StateHolderSaver)list.get(i)).restore(facesContext), ((StateHolderSaver)list.get(i + 1)).restore(facesContext));
                        continue;
                    }
                    catch (ClassCastException classCastException) {
                        if (LOGGER.isLoggable(Level.SEVERE)) {
                            LOGGER.log(Level.SEVERE, classCastException.toString(), classCastException);
                        }
                        throw new IllegalStateException("Unknown object type");
                    }
                }
                object2 = map;
            }
        } else if (object instanceof StateHolderSaver) {
            StateHolderSaver stateHolderSaver = (StateHolderSaver)object;
            object2 = stateHolderSaver.restore(facesContext);
        } else {
            throw new IllegalStateException("Unknown object type");
        }
        return object2;
    }

    private static Map<String, ValueExpression> restoreBindingsState(FacesContext facesContext, Object object) {
        if (object == null) {
            return null;
        }
        Object[] objectArray = (Object[])object;
        String[] stringArray = (String[])objectArray[0];
        Object[] objectArray2 = (Object[])objectArray[1];
        HashMap<String, ValueExpression> hashMap = new HashMap<String, ValueExpression>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            hashMap.put(stringArray[i], (ValueExpression)UIComponentBase.restoreAttachedState(facesContext, objectArray2[i]));
        }
        return hashMap;
    }

    private Object saveBindingsState(FacesContext facesContext) {
        if (this.bindings == null) {
            return null;
        }
        Object[] objectArray = new Object[2];
        objectArray[0] = this.bindings.keySet().toArray(new String[this.bindings.size()]);
        Object[] objectArray2 = this.bindings.values().toArray();
        for (int i = 0; i < objectArray2.length; ++i) {
            objectArray2[i] = UIComponentBase.saveAttachedState(facesContext, objectArray2[i]);
        }
        objectArray[1] = objectArray2;
        return objectArray;
    }

    private Object saveSystemEventListeners(FacesContext facesContext) {
        if (this.listenersByEventClass == null) {
            return null;
        }
        int n = this.listenersByEventClass.size();
        Object[][] objectArray = new Object[n][2];
        int n2 = 0;
        boolean bl = false;
        for (Map.Entry<Class<? extends SystemEvent>, List<SystemEventListener>> entry : this.listenersByEventClass.entrySet()) {
            Object[] objectArray2 = objectArray[n2++];
            objectArray2[0] = entry.getKey();
            objectArray2[1] = UIComponentBase.saveAttachedState(facesContext, entry.getValue());
            if (objectArray2[1] == null) {
                objectArray2[0] = null;
                continue;
            }
            bl = true;
        }
        return bl ? objectArray : (Object[][])null;
    }

    private Map<Class<? extends SystemEvent>, List<SystemEventListener>> restoreSystemEventListeners(FacesContext facesContext, Object object) {
        if (object == null) {
            return null;
        }
        Object[][] objectArray = (Object[][])object;
        HashMap<Class<? extends SystemEvent>, List<SystemEventListener>> hashMap = new HashMap<Class<? extends SystemEvent>, List<SystemEventListener>>(objectArray.length, 1.0f);
        for (Object[] objectArray2 : objectArray) {
            hashMap.put((Class)objectArray2[0], (List)UIComponentBase.restoreAttachedState(facesContext, objectArray2[1]));
        }
        return hashMap;
    }

    Map<String, PropertyDescriptor> getDescriptorMap() {
        return this.pdMap;
    }

    private void doPostAddProcessing(FacesContext facesContext, UIComponent uIComponent) {
        if (this.parent.isInView()) {
            UIComponentBase.publishAfterViewEvents(facesContext, facesContext.getApplication(), uIComponent);
        }
    }

    private void doPreRemoveProcessing(FacesContext facesContext, UIComponent uIComponent) {
        if (this.parent.isInView()) {
            UIComponentBase.disconnectFromView(facesContext, facesContext.getApplication(), uIComponent);
        }
    }

    public void addClientBehavior(String string, ClientBehavior clientBehavior) {
        this.assertClientBehaviorHolder();
        Collection<String> collection = this.getEventNames();
        if (collection == null) {
            throw new IllegalStateException("Attempting to add a Behavior to a component that does not support any event types. getEventTypes() must return a non-null Set.");
        }
        if (collection.contains(string)) {
            ArrayList<ClientBehavior> arrayList;
            if (this.initialStateMarked() && this.behaviors != null) {
                arrayList = this.behaviors.entrySet().iterator();
                while (arrayList.hasNext()) {
                    Map.Entry entry = (Map.Entry)arrayList.next();
                    for (ClientBehavior clientBehavior2 : (List)entry.getValue()) {
                        if (!(clientBehavior2 instanceof PartialStateHolder)) continue;
                        ((PartialStateHolder)((Object)clientBehavior)).clearInitialState();
                    }
                }
            }
            if (null == this.behaviors) {
                arrayList = new HashMap(5, 1.0f);
                this.behaviors = new BehaviorsMap((Map)((Object)arrayList));
            }
            if (null == (arrayList = (List)this.behaviors.get(string))) {
                arrayList = new ArrayList<ClientBehavior>(3);
                this.behaviors.getModifiableMap().put(string, arrayList);
            }
            arrayList.add(clientBehavior);
        }
    }

    public Collection<String> getEventNames() {
        this.assertClientBehaviorHolder();
        return null;
    }

    public Map<String, List<ClientBehavior>> getClientBehaviors() {
        if (null == this.behaviors) {
            return Collections.emptyMap();
        }
        return this.behaviors;
    }

    public String getDefaultEventName() {
        this.assertClientBehaviorHolder();
        return null;
    }

    private void assertClientBehaviorHolder() {
        if (!this.isClientBehaviorHolder()) {
            throw new IllegalStateException("Attempting to use a Behavior feature with a component that does not support any event types. Component must implement BehaviourHolder interface.");
        }
    }

    private boolean isClientBehaviorHolder() {
        return ClientBehaviorHolder.class.isInstance(this);
    }

    private Object saveBehaviorsState(FacesContext facesContext) {
        Object[] objectArray = null;
        if (null != this.behaviors && this.behaviors.size() > 0) {
            boolean bl = false;
            Object[] objectArray2 = new Object[this.behaviors.size()];
            int n = 0;
            for (List list : this.behaviors.values()) {
                Object[] objectArray3 = new Object[list.size()];
                for (int i = 0; i < objectArray3.length; ++i) {
                    Object object = objectArray3[i] = this.initialStateMarked() ? this.saveBehavior(facesContext, (ClientBehavior)list.get(i)) : UIComponentBase.saveAttachedState(facesContext, list.get(i));
                    if (bl) continue;
                    bl = objectArray3[i] != null;
                }
                objectArray2[n++] = objectArray3;
            }
            if (bl) {
                objectArray = new Object[]{this.behaviors.keySet().toArray(new String[this.behaviors.size()]), objectArray2};
            }
        }
        return objectArray;
    }

    private BehaviorsMap restoreBehaviorsState(FacesContext facesContext, Object object) {
        if (null != object) {
            Object[] objectArray = (Object[])object;
            String[] stringArray = (String[])objectArray[0];
            Object[] objectArray2 = (Object[])objectArray[1];
            if (!this.initialStateMarked()) {
                HashMap hashMap = new HashMap(stringArray.length, 1.0f);
                for (int i = 0; i < objectArray2.length; ++i) {
                    Object[] objectArray3 = (Object[])objectArray2[i];
                    ArrayList<ClientBehavior> arrayList = new ArrayList<ClientBehavior>(objectArray2.length);
                    for (int j = 0; j < objectArray3.length; ++j) {
                        arrayList.add((ClientBehavior)UIComponentBase.restoreAttachedState(facesContext, objectArray3[j]));
                    }
                    hashMap.put(stringArray[i], arrayList);
                }
                return new BehaviorsMap(hashMap);
            }
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (this.behaviors == null) continue;
                List list = (List)this.behaviors.get(stringArray[i]);
                this.restoreBehaviors(facesContext, list, (Object[])objectArray2[i]);
            }
            return this.behaviors;
        }
        return null;
    }

    private Object saveBehavior(FacesContext facesContext, ClientBehavior clientBehavior) {
        return clientBehavior instanceof StateHolder ? ((StateHolder)((Object)clientBehavior)).saveState(facesContext) : null;
    }

    private void restoreBehaviors(FacesContext facesContext, List<ClientBehavior> list, Object[] objectArray) {
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            ClientBehavior clientBehavior = list.get(i);
            if (objectArray[i] == null || !(clientBehavior instanceof StateHolder)) continue;
            if (objectArray[i] instanceof StateHolderSaver) {
                ((StateHolderSaver)objectArray[i]).restore(facesContext);
                continue;
            }
            ((StateHolder)((Object)clientBehavior)).restoreState(facesContext, objectArray[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void publishAfterViewEvents(FacesContext facesContext, Application application, UIComponent uIComponent) {
        uIComponent.setInView(true);
        try {
            ArrayList<UIComponent> arrayList;
            uIComponent.pushComponentToEL(facesContext, uIComponent);
            application.publishEvent(facesContext, PostAddToViewEvent.class, uIComponent);
            if (uIComponent.getChildCount() > 0) {
                arrayList = new ArrayList<UIComponent>(uIComponent.getChildren());
                for (UIComponent uIComponent2 : arrayList) {
                    UIComponentBase.publishAfterViewEvents(facesContext, application, uIComponent2);
                }
            }
            if (uIComponent.getFacetCount() > 0) {
                arrayList = new ArrayList<UIComponent>(uIComponent.getFacets().values());
                for (UIComponent uIComponent2 : arrayList) {
                    UIComponentBase.publishAfterViewEvents(facesContext, application, uIComponent2);
                }
            }
        }
        finally {
            uIComponent.popComponentFromEL(facesContext);
        }
    }

    private static void disconnectFromView(FacesContext facesContext, Application application, UIComponent uIComponent) {
        Object object;
        application.publishEvent(facesContext, PreRemoveFromViewEvent.class, uIComponent);
        uIComponent.setInView(false);
        uIComponent.compositeParent = null;
        if (uIComponent.getChildCount() > 0) {
            object = uIComponent.getChildren();
            Iterator<UIComponent> iterator = object.iterator();
            while (iterator.hasNext()) {
                UIComponent uIComponent2 = iterator.next();
                UIComponentBase.disconnectFromView(facesContext, application, uIComponent2);
            }
        }
        if (uIComponent.getFacetCount() > 0) {
            object = uIComponent.getFacets();
            for (UIComponent uIComponent2 : object.values()) {
                UIComponentBase.disconnectFromView(facesContext, application, uIComponent2);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BehaviorsMap
    extends AbstractMap<String, List<ClientBehavior>> {
        private Map<String, List<ClientBehavior>> unmodifiableMap;
        private Map<String, List<ClientBehavior>> modifiableMap;

        private BehaviorsMap(Map<String, List<ClientBehavior>> map) {
            this.modifiableMap = map;
            this.unmodifiableMap = Collections.unmodifiableMap(map);
        }

        @Override
        public Set<Map.Entry<String, List<ClientBehavior>>> entrySet() {
            return this.unmodifiableMap.entrySet();
        }

        private Map<String, List<ClientBehavior>> getModifiableMap() {
            return this.modifiableMap;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FacetsMapValuesIterator
    implements Iterator<UIComponent> {
        private FacetsMap map = null;
        private Iterator<String> iterator = null;
        private Object last = null;

        public FacetsMapValuesIterator(FacetsMap facetsMap) {
            this.map = facetsMap;
            this.iterator = facetsMap.keySetIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public UIComponent next() {
            this.last = this.iterator.next();
            return (UIComponent)this.map.get(this.last);
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.map.remove(this.last);
            this.last = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FacetsMapValues
    extends AbstractCollection<UIComponent> {
        private FacetsMap map;

        public FacetsMapValues(FacetsMap facetsMap) {
            this.map = facetsMap;
        }

        @Override
        public boolean add(UIComponent uIComponent) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Iterator<UIComponent> iterator() {
            return new FacetsMapValuesIterator(this.map);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FacetsMapKeySetIterator
    implements Iterator<String> {
        private FacetsMap map = null;
        private Iterator<String> iterator = null;
        private String last = null;

        public FacetsMapKeySetIterator(FacetsMap facetsMap) {
            this.map = facetsMap;
            this.iterator = facetsMap.keySetIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public String next() {
            this.last = this.iterator.next();
            return this.last;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.map.remove(this.last);
            this.last = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FacetsMapKeySet
    extends AbstractSet<String> {
        private FacetsMap map = null;

        public FacetsMapKeySet(FacetsMap facetsMap) {
            this.map = facetsMap;
        }

        @Override
        public boolean add(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends String> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public boolean contains(Object object) {
            return this.map.containsKey(object);
        }

        @Override
        public boolean containsAll(Collection collection) {
            for (Object e : collection) {
                if (this.map.containsKey(e)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Iterator<String> iterator() {
            return new FacetsMapKeySetIterator(this.map);
        }

        @Override
        public boolean remove(Object object) {
            if (this.map.containsKey(object)) {
                this.map.remove(object);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection collection) {
            boolean bl = false;
            for (Object e : collection) {
                if (!this.map.containsKey(e)) continue;
                this.map.remove(e);
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean retainAll(Collection collection) {
            boolean bl = false;
            Iterator<String> iterator = this.iterator();
            while (iterator.hasNext()) {
                if (collection.contains(iterator.next())) continue;
                iterator.remove();
                bl = true;
            }
            return bl;
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FacetsMapEntrySetIterator
    implements Iterator<Map.Entry<String, UIComponent>> {
        private FacetsMap map = null;
        private Iterator<String> iterator = null;
        private Map.Entry<String, UIComponent> last = null;

        public FacetsMapEntrySetIterator(FacetsMap facetsMap) {
            this.map = facetsMap;
            this.iterator = facetsMap.keySetIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<String, UIComponent> next() {
            this.last = new FacetsMapEntrySetEntry(this.map, this.iterator.next());
            return this.last;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.map.remove(this.last.getKey());
            this.last = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FacetsMapEntrySetEntry
    implements Map.Entry<String, UIComponent> {
        private FacetsMap map;
        private String key;

        public FacetsMapEntrySetEntry(FacetsMap facetsMap, String string) {
            this.map = facetsMap;
            this.key = string;
        }

        @Override
        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            if (this.key == null ? entry.getKey() != null : !this.key.equals(entry.getKey())) {
                return false;
            }
            UIComponent uIComponent = (UIComponent)this.map.get(this.key);
            return !(uIComponent == null ? entry.getValue() != null : !uIComponent.equals(entry.getValue()));
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public UIComponent getValue() {
            return (UIComponent)this.map.get(this.key);
        }

        @Override
        public int hashCode() {
            Object v = this.map.get(this.key);
            return (this.key == null ? 0 : this.key.hashCode()) ^ (v == null ? 0 : v.hashCode());
        }

        @Override
        public UIComponent setValue(UIComponent uIComponent) {
            UIComponent uIComponent2 = (UIComponent)this.map.get(this.key);
            this.map.put(this.key, uIComponent);
            return uIComponent2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FacetsMapEntrySet
    extends AbstractSet<Map.Entry<String, UIComponent>> {
        private FacetsMap map = null;

        public FacetsMapEntrySet(FacetsMap facetsMap) {
            this.map = facetsMap;
        }

        @Override
        public boolean add(Map.Entry<String, UIComponent> entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<String, UIComponent>> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public boolean contains(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (!this.map.containsKey(k)) {
                return false;
            }
            if (v == null) {
                return this.map.get(k) == null;
            }
            return v.equals(this.map.get(k));
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Iterator<Map.Entry<String, UIComponent>> iterator() {
            return new FacetsMapEntrySetIterator(this.map);
        }

        @Override
        public boolean remove(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Object k = ((Map.Entry)object).getKey();
            if (this.map.containsKey(k)) {
                this.map.remove(k);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection collection) {
            boolean bl = false;
            for (Object e : collection) {
                if (!this.remove(e)) continue;
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean retainAll(Collection collection) {
            boolean bl = false;
            Iterator<Map.Entry<String, UIComponent>> iterator = this.iterator();
            while (iterator.hasNext()) {
                if (collection.contains(iterator.next())) continue;
                iterator.remove();
                bl = true;
            }
            return bl;
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FacetsMap
    extends HashMap<String, UIComponent> {
        private UIComponent component;

        public FacetsMap(UIComponent uIComponent) {
            super(3, 1.0f);
            this.component = uIComponent;
        }

        @Override
        public void clear() {
            Iterator<String> iterator = this.keySet().iterator();
            while (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
            super.clear();
        }

        @Override
        public Set<Map.Entry<String, UIComponent>> entrySet() {
            return new FacetsMapEntrySet(this);
        }

        @Override
        public Set<String> keySet() {
            return new FacetsMapKeySet(this);
        }

        @Override
        public UIComponent put(String string, UIComponent uIComponent) {
            if (string == null || uIComponent == null) {
                throw new NullPointerException();
            }
            if (!(string instanceof String) || !(uIComponent instanceof UIComponent)) {
                throw new ClassCastException();
            }
            UIComponent uIComponent2 = (UIComponent)super.get(string);
            if (uIComponent2 != null) {
                uIComponent2.setParent(null);
            }
            UIComponentBase.eraseParent(uIComponent);
            UIComponent uIComponent3 = super.put(string, uIComponent);
            uIComponent.setParent(this.component);
            return uIComponent3;
        }

        @Override
        public void putAll(Map<? extends String, ? extends UIComponent> map) {
            if (map == null) {
                throw new NullPointerException();
            }
            for (Map.Entry<? extends String, ? extends UIComponent> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public UIComponent remove(Object object) {
            UIComponent uIComponent = (UIComponent)this.get(object);
            if (uIComponent != null) {
                uIComponent.setParent(null);
            }
            super.remove(object);
            return uIComponent;
        }

        @Override
        public Collection<UIComponent> values() {
            return new FacetsMapValues(this);
        }

        Iterator<String> keySetIterator() {
            return new ArrayList(super.keySet()).iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FacetsAndChildrenIterator
    implements Iterator<UIComponent> {
        private Iterator<UIComponent> iterator;
        private boolean childMode;
        private UIComponent c;

        public FacetsAndChildrenIterator(UIComponent uIComponent) {
            this.c = uIComponent;
            this.childMode = false;
        }

        private void update() {
            if (this.iterator == null) {
                if (this.c.getFacetCount() != 0) {
                    this.iterator = this.c.getFacets().values().iterator();
                    this.childMode = false;
                } else if (this.c.getChildCount() != 0) {
                    this.iterator = this.c.getChildren().iterator();
                    this.childMode = true;
                } else {
                    this.iterator = EMPTY_ITERATOR;
                    this.childMode = true;
                }
            } else if (!this.childMode && !this.iterator.hasNext() && this.c.getChildCount() != 0) {
                this.iterator = this.c.getChildren().iterator();
                this.childMode = true;
            }
        }

        @Override
        public boolean hasNext() {
            this.update();
            return this.iterator.hasNext();
        }

        @Override
        public UIComponent next() {
            this.update();
            return this.iterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChildrenListIterator
    implements ListIterator<UIComponent> {
        private ChildrenList list;
        private int index;
        private int last = -1;

        public ChildrenListIterator(ChildrenList childrenList) {
            this.list = childrenList;
            this.index = 0;
        }

        public ChildrenListIterator(ChildrenList childrenList, int n) {
            this.list = childrenList;
            if (n < 0 || n > childrenList.size()) {
                throw new IndexOutOfBoundsException(String.valueOf(n));
            }
            this.index = n;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.list.size();
        }

        @Override
        public UIComponent next() {
            try {
                UIComponent uIComponent = (UIComponent)this.list.get(this.index);
                this.last = this.index++;
                return uIComponent;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException(String.valueOf(this.index));
            }
        }

        @Override
        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            this.list.remove(this.last);
            if (this.last < this.index) {
                --this.index;
            }
            this.last = -1;
        }

        @Override
        public void add(UIComponent uIComponent) {
            this.last = -1;
            this.list.add(this.index++, uIComponent);
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 1;
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public UIComponent previous() {
            try {
                int n = this.index - 1;
                UIComponent uIComponent = (UIComponent)this.list.get(n);
                this.last = n;
                this.index = n;
                return uIComponent;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void set(UIComponent uIComponent) {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            this.list.set(this.last, uIComponent);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChildrenList
    extends ArrayList<UIComponent> {
        private UIComponent component;

        public ChildrenList(UIComponent uIComponent) {
            super(6);
            this.component = uIComponent;
        }

        @Override
        public void add(int n, UIComponent uIComponent) {
            if (uIComponent == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n > this.size()) {
                throw new IndexOutOfBoundsException();
            }
            UIComponentBase.eraseParent(uIComponent);
            super.add(n, uIComponent);
            uIComponent.setParent(this.component);
        }

        @Override
        public boolean add(UIComponent uIComponent) {
            if (uIComponent == null) {
                throw new NullPointerException();
            }
            UIComponentBase.eraseParent(uIComponent);
            boolean bl = super.add(uIComponent);
            uIComponent.setParent(this.component);
            return bl;
        }

        @Override
        public boolean addAll(Collection<? extends UIComponent> collection) {
            Iterator<? extends UIComponent> iterator = new ArrayList<UIComponent>(collection).iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                UIComponent uIComponent = iterator.next();
                if (uIComponent == null) {
                    throw new NullPointerException();
                }
                this.add(uIComponent);
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean addAll(int n, Collection<? extends UIComponent> collection) {
            Iterator<? extends UIComponent> iterator = new ArrayList<UIComponent>(collection).iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                UIComponent uIComponent = iterator.next();
                if (uIComponent == null) {
                    throw new NullPointerException();
                }
                this.add(n++, uIComponent);
                bl = true;
            }
            return bl;
        }

        @Override
        public void clear() {
            int n = this.size();
            if (n < 1) {
                return;
            }
            for (int i = 0; i < n; ++i) {
                UIComponent uIComponent = (UIComponent)this.get(i);
                uIComponent.setParent(null);
            }
            super.clear();
        }

        @Override
        public Iterator<UIComponent> iterator() {
            return new ChildrenListIterator(this);
        }

        @Override
        public ListIterator<UIComponent> listIterator() {
            return new ChildrenListIterator(this);
        }

        @Override
        public ListIterator<UIComponent> listIterator(int n) {
            return new ChildrenListIterator(this, n);
        }

        @Override
        public UIComponent remove(int n) {
            UIComponent uIComponent = (UIComponent)this.get(n);
            uIComponent.setParent(null);
            super.remove(n);
            return uIComponent;
        }

        @Override
        public boolean remove(Object object) {
            UIComponent uIComponent = (UIComponent)object;
            if (uIComponent == null) {
                throw new NullPointerException();
            }
            if (super.indexOf(uIComponent) != -1) {
                uIComponent.setParent(null);
            }
            return super.remove(uIComponent);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean bl = false;
            for (Object obj : collection) {
                if (!this.remove(obj)) continue;
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean bl = false;
            Iterator<UIComponent> iterator = this.iterator();
            while (iterator.hasNext()) {
                if (collection.contains(iterator.next())) continue;
                iterator.remove();
                bl = true;
            }
            return bl;
        }

        @Override
        public UIComponent set(int n, UIComponent uIComponent) {
            if (uIComponent == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            UIComponentBase.eraseParent(uIComponent);
            UIComponent uIComponent2 = (UIComponent)this.get(n);
            super.set(n, uIComponent);
            uIComponent2.setParent(null);
            uIComponent.setParent(this.component);
            return uIComponent2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AttributesMap
    implements Map<String, Object>,
    Serializable {
        private static final String ATTRIBUTES_THAT_ARE_SET_KEY = UIComponentBase.class.getName() + ".attributesThatAreSet";
        private transient Map<String, PropertyDescriptor> pdMap;
        private transient UIComponent component;
        private static final long serialVersionUID = -6773035086539772945L;

        private AttributesMap(UIComponent uIComponent) {
            this.component = uIComponent;
            this.pdMap = ((UIComponentBase)uIComponent).getDescriptorMap();
        }

        @Override
        public boolean containsKey(Object object) {
            if (ATTRIBUTES_THAT_ARE_SET_KEY.equals(object)) {
                return true;
            }
            String string = (String)object;
            PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(string);
            if (propertyDescriptor == null) {
                Map map = (Map)this.component.getStateHelper().get((Serializable)((Object)UIComponent.PropertyKeys.attributes));
                if (map != null) {
                    return map.containsKey(string);
                }
                return false;
            }
            return false;
        }

        @Override
        public Object get(Object object) {
            PropertyDescriptor propertyDescriptor;
            String string = (String)object;
            Object object2 = null;
            if (string == null) {
                throw new NullPointerException();
            }
            if (ATTRIBUTES_THAT_ARE_SET_KEY.equals(string)) {
                object2 = this.component.getStateHelper().get((Serializable)((Object)UIComponent.PropertyKeysPrivate.attributesThatAreSet));
            }
            Map map = (Map)this.component.getStateHelper().get((Serializable)((Object)UIComponent.PropertyKeys.attributes));
            if (null == object2) {
                propertyDescriptor = this.getPropertyDescriptor(string);
                if (propertyDescriptor != null) {
                    try {
                        Method method = propertyDescriptor.getReadMethod();
                        if (method == null) {
                            throw new IllegalArgumentException(string);
                        }
                        object2 = method.invoke((Object)this.component, EMPTY_OBJECT_ARRAY);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new FacesException(illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new FacesException(invocationTargetException.getTargetException());
                    }
                } else if (map != null && map.containsKey(string)) {
                    object2 = map.get(string);
                }
            }
            if (null == object2 && (propertyDescriptor = this.component.getValueExpression(string)) != null) {
                try {
                    object2 = propertyDescriptor.getValue(this.component.getFacesContext().getELContext());
                }
                catch (ELException eLException) {
                    throw new FacesException(eLException);
                }
            }
            return object2;
        }

        @Override
        public Object put(String string, Object object) {
            if (string == null) {
                throw new NullPointerException();
            }
            if (ATTRIBUTES_THAT_ARE_SET_KEY.equals(string)) {
                if (this.component.attributesThatAreSet == null && object instanceof List) {
                    this.component.getStateHelper().put((Serializable)((Object)UIComponent.PropertyKeysPrivate.attributesThatAreSet), object);
                }
                return null;
            }
            PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(string);
            if (propertyDescriptor != null) {
                try {
                    Method method;
                    Object object2 = null;
                    Method method2 = propertyDescriptor.getReadMethod();
                    if (method2 != null) {
                        object2 = method2.invoke((Object)this.component, EMPTY_OBJECT_ARRAY);
                    }
                    if ((method = propertyDescriptor.getWriteMethod()) == null) {
                        throw new IllegalArgumentException("Setter not found for property " + string);
                    }
                    method.invoke((Object)this.component, object);
                    return object2;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new FacesException(illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new FacesException(invocationTargetException.getTargetException());
                }
            }
            if (object == null) {
                throw new NullPointerException();
            }
            List list = (List)this.component.getStateHelper().get((Serializable)((Object)UIComponent.PropertyKeysPrivate.attributesThatAreSet));
            if (list == null) {
                this.component.getStateHelper().add((Serializable)((Object)UIComponent.PropertyKeysPrivate.attributesThatAreSet), string);
            } else if (!list.contains(string)) {
                this.component.getStateHelper().add((Serializable)((Object)UIComponent.PropertyKeysPrivate.attributesThatAreSet), string);
            }
            return this.putAttribute(string, object);
        }

        @Override
        public void putAll(Map<? extends String, ?> map) {
            if (map == null) {
                throw new NullPointerException();
            }
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Object remove(Object object) {
            String string = (String)object;
            if (string == null) {
                throw new NullPointerException();
            }
            if (ATTRIBUTES_THAT_ARE_SET_KEY.equals(string)) {
                return null;
            }
            PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(string);
            if (propertyDescriptor != null) {
                throw new IllegalArgumentException(string);
            }
            Map<String, Object> map = this.getAttributes();
            if (map != null) {
                this.component.getStateHelper().remove((Serializable)((Object)UIComponent.PropertyKeysPrivate.attributesThatAreSet), string);
                return this.component.getStateHelper().remove((Serializable)((Object)UIComponent.PropertyKeys.attributes), string);
            }
            return null;
        }

        @Override
        public int size() {
            Map<String, Object> map = this.getAttributes();
            return map != null ? map.size() : 0;
        }

        @Override
        public boolean isEmpty() {
            Map<String, Object> map = this.getAttributes();
            return map == null || map.isEmpty();
        }

        @Override
        public boolean containsValue(Object object) {
            Map<String, Object> map = this.getAttributes();
            return map != null && map.containsValue(object);
        }

        @Override
        public void clear() {
            this.component.getStateHelper().remove((Serializable)((Object)UIComponent.PropertyKeys.attributes));
            this.component.getStateHelper().remove((Serializable)((Object)UIComponent.PropertyKeysPrivate.attributesThatAreSet));
        }

        @Override
        public Set<String> keySet() {
            Map<String, Object> map = this.getAttributes();
            if (map != null) {
                return Collections.unmodifiableSet(map.keySet());
            }
            return Collections.emptySet();
        }

        @Override
        public Collection<Object> values() {
            Map<String, Object> map = this.getAttributes();
            if (map != null) {
                return Collections.unmodifiableCollection(map.values());
            }
            return Collections.emptyList();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            Map<String, Object> map = this.getAttributes();
            if (map != null) {
                return Collections.unmodifiableSet(map.entrySet());
            }
            return Collections.emptySet();
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Map)) {
                return false;
            }
            Map map = (Map)object;
            if (map.size() != this.size()) {
                return false;
            }
            try {
                Iterator<Map.Entry<String, Object>> iterator = this.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Object> entry;
                    Map.Entry<String, Object> entry2 = entry = iterator.next();
                    String string = entry2.getKey();
                    Object object2 = entry2.getValue();
                    if (!(object2 == null ? map.get(string) != null || !map.containsKey(string) : !object2.equals(map.get(string)))) continue;
                    return false;
                }
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int n = 0;
            for (Map.Entry<String, Object> entry : this.entrySet()) {
                n += ((Object)entry).hashCode();
            }
            return n;
        }

        private Map<String, Object> getAttributes() {
            return (Map)this.component.getStateHelper().get((Serializable)((Object)UIComponent.PropertyKeys.attributes));
        }

        private Object putAttribute(String string, Object object) {
            return this.component.getStateHelper().put((Serializable)((Object)UIComponent.PropertyKeys.attributes), string, object);
        }

        PropertyDescriptor getPropertyDescriptor(String string) {
            if (this.pdMap != null) {
                return this.pdMap.get(string);
            }
            return null;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeObject(this.component.getClass());
            objectOutputStream.writeObject(this.component.saveState(FacesContext.getCurrentInstance()));
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            Class clazz = (Class)objectInputStream.readObject();
            try {
                this.component = (UIComponent)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            this.component.restoreState(FacesContext.getCurrentInstance(), objectInputStream.readObject());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PassThroughAttributesMap<K, V>
    extends ConcurrentHashMap<String, Object>
    implements Serializable {
        private PassThroughAttributesMap() {
        }

        @Override
        public Object put(String string, Object object) {
            if (null == string || null == object) {
                throw new NullPointerException();
            }
            this.validateKey(string);
            return super.put(string, object);
        }

        @Override
        public Object putIfAbsent(String string, Object object) {
            if (null == string || null == object) {
                throw new NullPointerException();
            }
            this.validateKey(string);
            return super.putIfAbsent(string, object);
        }

        private void validateKey(Object object) {
            if (!(object instanceof String) || object instanceof ValueExpression || !(object instanceof Serializable)) {
                throw new IllegalArgumentException();
            }
        }
    }
}

