/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.context;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.el.ELContext;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.application.ProjectStage;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.context.PartialViewContext;
import javax.faces.context.PartialViewContextFactory;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import javax.faces.render.RenderKit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FacesContext {
    private FacesContext defaultFacesContext;
    private boolean processingEvents = true;
    private boolean isCreatedFromValidFactory = true;
    private static ConcurrentHashMap threadInitContext = new ConcurrentHashMap(2);
    private static ConcurrentHashMap initContextServletContext = new ConcurrentHashMap(2);
    private Map<Object, Object> attributesForInvalidFactoryConstruction;
    private PartialViewContext partialViewContextForInvalidFactoryConstruction = null;
    private PhaseId currentPhaseIdForInvalidFactoryConstruction;
    private static ThreadLocal<FacesContext> instance = new ThreadLocal<FacesContext>(){

        @Override
        protected FacesContext initialValue() {
            return null;
        }
    };

    public FacesContext() {
        Thread thread = Thread.currentThread();
        StackTraceElement[] stackTraceElementArray = thread.getStackTrace();
        if (null != stackTraceElementArray) {
            String string = stackTraceElementArray[3].getClassName();
            try {
                ClassLoader classLoader = thread.getContextClassLoader();
                Class<?> clazz = classLoader.loadClass(string);
                if (!FacesContextFactory.class.isAssignableFrom(clazz)) {
                    this.isCreatedFromValidFactory = false;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public abstract Application getApplication();

    public Map<Object, Object> getAttributes() {
        if (this.defaultFacesContext != null) {
            return this.defaultFacesContext.getAttributes();
        }
        if (!this.isCreatedFromValidFactory) {
            if (this.attributesForInvalidFactoryConstruction == null) {
                this.attributesForInvalidFactoryConstruction = new HashMap<Object, Object>();
            }
            return this.attributesForInvalidFactoryConstruction;
        }
        throw new UnsupportedOperationException();
    }

    public PartialViewContext getPartialViewContext() {
        if (this.defaultFacesContext != null) {
            return this.defaultFacesContext.getPartialViewContext();
        }
        if (!this.isCreatedFromValidFactory) {
            if (this.partialViewContextForInvalidFactoryConstruction == null) {
                PartialViewContextFactory partialViewContextFactory = (PartialViewContextFactory)FactoryFinder.getFactory("javax.faces.context.PartialViewContextFactory");
                this.partialViewContextForInvalidFactoryConstruction = partialViewContextFactory.getPartialViewContext(FacesContext.getCurrentInstance());
            }
            return this.partialViewContextForInvalidFactoryConstruction;
        }
        throw new UnsupportedOperationException();
    }

    public abstract Iterator<String> getClientIdsWithMessages();

    public ELContext getELContext() {
        if (this.defaultFacesContext != null) {
            return this.defaultFacesContext.getELContext();
        }
        throw new UnsupportedOperationException();
    }

    public ExceptionHandler getExceptionHandler() {
        if (this.defaultFacesContext != null) {
            return this.defaultFacesContext.getExceptionHandler();
        }
        throw new UnsupportedOperationException();
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        if (this.defaultFacesContext == null) {
            throw new UnsupportedOperationException();
        }
        this.defaultFacesContext.setExceptionHandler(exceptionHandler);
    }

    public abstract ExternalContext getExternalContext();

    public abstract FacesMessage.Severity getMaximumSeverity();

    public abstract Iterator<FacesMessage> getMessages();

    public List<FacesMessage> getMessageList() {
        if (this.defaultFacesContext != null) {
            return this.defaultFacesContext.getMessageList();
        }
        throw new UnsupportedOperationException();
    }

    public List<FacesMessage> getMessageList(String string) {
        if (this.defaultFacesContext != null) {
            return this.defaultFacesContext.getMessageList(string);
        }
        throw new UnsupportedOperationException();
    }

    public abstract Iterator<FacesMessage> getMessages(String var1);

    public char getNamingContainerSeparatorChar() {
        return UINamingContainer.getSeparatorChar(this);
    }

    public abstract RenderKit getRenderKit();

    public abstract boolean getRenderResponse();

    public abstract boolean getResponseComplete();

    public List<String> getResourceLibraryContracts() {
        return Collections.emptyList();
    }

    public void setResourceLibraryContracts(List<String> list) {
    }

    public boolean isValidationFailed() {
        if (this.defaultFacesContext != null) {
            return this.defaultFacesContext.isValidationFailed();
        }
        throw new UnsupportedOperationException();
    }

    public abstract ResponseStream getResponseStream();

    public abstract void setResponseStream(ResponseStream var1);

    public abstract ResponseWriter getResponseWriter();

    public abstract void setResponseWriter(ResponseWriter var1);

    public abstract UIViewRoot getViewRoot();

    public abstract void setViewRoot(UIViewRoot var1);

    public abstract void addMessage(String var1, FacesMessage var2);

    public boolean isReleased() {
        if (this.defaultFacesContext != null) {
            return this.defaultFacesContext.isReleased();
        }
        throw new UnsupportedOperationException();
    }

    public abstract void release();

    public abstract void renderResponse();

    public boolean isPostback() {
        if (this.defaultFacesContext != null) {
            return this.defaultFacesContext.isPostback();
        }
        throw new UnsupportedOperationException();
    }

    public abstract void responseComplete();

    public void validationFailed() {
        if (this.defaultFacesContext == null) {
            throw new UnsupportedOperationException();
        }
        this.defaultFacesContext.validationFailed();
    }

    public PhaseId getCurrentPhaseId() {
        if (this.defaultFacesContext != null) {
            return this.defaultFacesContext.getCurrentPhaseId();
        }
        if (!this.isCreatedFromValidFactory) {
            return this.currentPhaseIdForInvalidFactoryConstruction;
        }
        throw new UnsupportedOperationException();
    }

    public void setCurrentPhaseId(PhaseId phaseId) {
        if (this.defaultFacesContext != null) {
            this.defaultFacesContext.setCurrentPhaseId(phaseId);
        } else if (!this.isCreatedFromValidFactory) {
            this.currentPhaseIdForInvalidFactoryConstruction = phaseId;
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public void setProcessingEvents(boolean bl) {
        this.processingEvents = bl;
    }

    public boolean isProcessingEvents() {
        return this.processingEvents;
    }

    public boolean isProjectStage(ProjectStage projectStage) {
        if (projectStage == null) {
            throw new NullPointerException();
        }
        return projectStage.equals((Object)this.getApplication().getProjectStage());
    }

    public static FacesContext getCurrentInstance() {
        FacesContext facesContext = instance.get();
        if (null == facesContext) {
            facesContext = (FacesContext)threadInitContext.get(Thread.currentThread());
        }
        return facesContext;
    }

    protected static void setCurrentInstance(FacesContext facesContext) {
        if (facesContext == null) {
            instance.remove();
        } else {
            instance.set(facesContext);
        }
    }
}

