/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.context;

import java.io.IOException;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.context.ResponseWriterWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartialResponseWriter
extends ResponseWriterWrapper {
    private boolean inChanges = false;
    private boolean inInsertBefore = false;
    private boolean inInsertAfter = false;
    private boolean inUpdate = false;
    ResponseWriter writer;
    public static final String RENDER_ALL_MARKER = "javax.faces.ViewRoot";
    public static final String VIEW_STATE_MARKER = "javax.faces.ViewState";

    public PartialResponseWriter(ResponseWriter responseWriter) {
        this.writer = responseWriter;
    }

    @Override
    public ResponseWriter getWrapped() {
        return this.writer;
    }

    @Override
    public void startDocument() throws IOException {
        ResponseWriter responseWriter = this.getWrapped();
        String string = responseWriter.getCharacterEncoding();
        if (string == null) {
            string = "utf-8";
        }
        responseWriter.writePreamble("<?xml version='1.0' encoding='" + string + "'?>\n");
        responseWriter.startElement("partial-response", null);
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (null != facesContext && null != facesContext.getViewRoot()) {
            String string2 = facesContext.getViewRoot().getContainerClientId(facesContext);
            responseWriter.writeAttribute("id", string2, "id");
        }
    }

    @Override
    public void endDocument() throws IOException {
        this.endChangesIfNecessary();
        ResponseWriter responseWriter = this.getWrapped();
        responseWriter.endElement("partial-response");
    }

    public void startInsertBefore(String string) throws IOException {
        this.startChangesIfNecessary();
        this.inInsertBefore = true;
        ResponseWriter responseWriter = this.getWrapped();
        responseWriter.startElement("insert", null);
        responseWriter.startElement("before", null);
        responseWriter.writeAttribute("id", string, null);
        responseWriter.startCDATA();
    }

    public void startInsertAfter(String string) throws IOException {
        this.startChangesIfNecessary();
        this.inInsertAfter = true;
        ResponseWriter responseWriter = this.getWrapped();
        responseWriter.startElement("insert", null);
        responseWriter.startElement("after", null);
        responseWriter.writeAttribute("id", string, null);
        responseWriter.startCDATA();
    }

    public void endInsert() throws IOException {
        ResponseWriter responseWriter = this.getWrapped();
        responseWriter.endCDATA();
        if (this.inInsertBefore) {
            responseWriter.endElement("before");
            this.inInsertBefore = false;
        } else if (this.inInsertAfter) {
            responseWriter.endElement("after");
            this.inInsertAfter = false;
        }
        responseWriter.endElement("insert");
    }

    public void startUpdate(String string) throws IOException {
        this.startChangesIfNecessary();
        this.inUpdate = true;
        ResponseWriter responseWriter = this.getWrapped();
        responseWriter.startElement("update", null);
        responseWriter.writeAttribute("id", string, null);
        responseWriter.startCDATA();
    }

    public void endUpdate() throws IOException {
        ResponseWriter responseWriter = this.getWrapped();
        responseWriter.endCDATA();
        responseWriter.endElement("update");
        this.inUpdate = false;
    }

    public void updateAttributes(String string, Map<String, String> map) throws IOException {
        this.startChangesIfNecessary();
        ResponseWriter responseWriter = this.getWrapped();
        responseWriter.startElement("attributes", null);
        responseWriter.writeAttribute("id", string, null);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            responseWriter.startElement("attribute", null);
            responseWriter.writeAttribute("name", entry.getKey(), null);
            responseWriter.writeAttribute("value", entry.getValue(), null);
            responseWriter.endElement("attribute");
        }
        responseWriter.endElement("attributes");
    }

    public void delete(String string) throws IOException {
        this.startChangesIfNecessary();
        ResponseWriter responseWriter = this.getWrapped();
        responseWriter.startElement("delete", null);
        responseWriter.writeAttribute("id", string, null);
        responseWriter.endElement("delete");
    }

    public void redirect(String string) throws IOException {
        this.endChangesIfNecessary();
        ResponseWriter responseWriter = this.getWrapped();
        responseWriter.startElement("redirect", null);
        responseWriter.writeAttribute("url", string, null);
        responseWriter.endElement("redirect");
    }

    public void startEval() throws IOException {
        this.startChangesIfNecessary();
        ResponseWriter responseWriter = this.getWrapped();
        responseWriter.startElement("eval", null);
        responseWriter.startCDATA();
    }

    public void endEval() throws IOException {
        ResponseWriter responseWriter = this.getWrapped();
        responseWriter.endCDATA();
        responseWriter.endElement("eval");
    }

    public void startExtension(Map<String, String> map) throws IOException {
        this.startChangesIfNecessary();
        ResponseWriter responseWriter = this.getWrapped();
        responseWriter.startElement("extension", null);
        if (map != null && !map.isEmpty()) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                responseWriter.writeAttribute(entry.getKey(), entry.getValue(), null);
            }
        }
    }

    public void endExtension() throws IOException {
        ResponseWriter responseWriter = this.getWrapped();
        responseWriter.endElement("extension");
    }

    public void startError(String string) throws IOException {
        this.endUpdateIfNecessary();
        this.endChangesIfNecessary();
        ResponseWriter responseWriter = this.getWrapped();
        responseWriter.startElement("error", null);
        responseWriter.startElement("error-name", null);
        responseWriter.write(string);
        responseWriter.endElement("error-name");
        responseWriter.startElement("error-message", null);
        responseWriter.startCDATA();
    }

    public void endError() throws IOException {
        ResponseWriter responseWriter = this.getWrapped();
        responseWriter.endCDATA();
        responseWriter.endElement("error-message");
        responseWriter.endElement("error");
    }

    private void startChangesIfNecessary() throws IOException {
        if (!this.inChanges) {
            ResponseWriter responseWriter = this.getWrapped();
            responseWriter.startElement("changes", null);
            this.inChanges = true;
        }
    }

    private void endUpdateIfNecessary() throws IOException {
        if (this.inUpdate) {
            this.endUpdate();
        }
    }

    private void endChangesIfNecessary() throws IOException {
        if (this.inChanges) {
            ResponseWriter responseWriter = this.getWrapped();
            responseWriter.endElement("changes");
            this.inChanges = false;
        }
    }
}

