/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.webapp;

import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.webapp.UIComponentClassicTagBase;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

public abstract class UIComponentTag
extends UIComponentClassicTagBase
implements Tag {
    private String binding = null;
    private String rendered = null;
    private boolean suppressed = false;

    public void setBinding(String string) throws JspException {
        if (!UIComponentTag.isValueReference(string)) {
            throw new IllegalArgumentException();
        }
        this.binding = string;
    }

    protected boolean hasBinding() {
        return null != this.binding;
    }

    public void setRendered(String string) {
        this.rendered = string;
    }

    protected boolean isSuppressed() {
        return this.suppressed;
    }

    public static boolean isValueReference(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        int n = string.indexOf("#{");
        return n != -1 && n < string.indexOf(125, n);
    }

    public void release() {
        this.suppressed = false;
        this.binding = null;
        this.rendered = null;
        super.release();
    }

    protected void setProperties(UIComponent uIComponent) {
        if (this.rendered != null) {
            if (UIComponentTag.isValueReference(this.rendered)) {
                ValueBinding valueBinding = this.getFacesContext().getApplication().createValueBinding(this.rendered);
                uIComponent.setValueBinding("rendered", valueBinding);
            } else {
                uIComponent.setRendered(Boolean.valueOf(this.rendered));
            }
        }
        if (this.getRendererType() != null) {
            uIComponent.setRendererType(this.getRendererType());
        }
    }

    protected UIComponent createComponent(FacesContext facesContext, String string) {
        UIComponent uIComponent;
        Application application = facesContext.getApplication();
        if (this.binding != null) {
            ValueBinding valueBinding = application.createValueBinding(this.binding);
            uIComponent = application.createComponent(valueBinding, facesContext, this.getComponentType());
            uIComponent.setValueBinding("binding", valueBinding);
        } else {
            uIComponent = application.createComponent(this.getComponentType());
        }
        uIComponent.setId(string);
        this.setProperties(uIComponent);
        return uIComponent;
    }

    public static UIComponentTag getParentUIComponentTag(PageContext pageContext) {
        UIComponentClassicTagBase uIComponentClassicTagBase = UIComponentTag.getParentUIComponentClassicTagBase(pageContext);
        if (!(uIComponentClassicTagBase instanceof UIComponentTag)) {
            return new UIComponentTagAdapter(uIComponentClassicTagBase);
        }
        return (UIComponentTag)uIComponentClassicTagBase;
    }

    private static class UIComponentTagAdapter
    extends UIComponentTag {
        UIComponentClassicTagBase classicDelegate;

        public UIComponentTagAdapter(UIComponentClassicTagBase uIComponentClassicTagBase) {
            this.classicDelegate = uIComponentClassicTagBase;
        }

        public String getComponentType() {
            return this.classicDelegate.getComponentType();
        }

        public String getRendererType() {
            return this.classicDelegate.getRendererType();
        }

        public int doStartTag() throws JspException {
            throw new IllegalStateException();
        }

        public int doEndTag() throws JspException {
            throw new IllegalStateException();
        }

        public UIComponent getComponentInstance() {
            return this.classicDelegate.getComponentInstance();
        }

        public boolean getCreated() {
            return this.classicDelegate.getCreated();
        }

        public Tag getParent() {
            return this.classicDelegate.getParent();
        }

        public void setParent(Tag tag) {
            throw new IllegalStateException();
        }
    }
}

