/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.api.pipe;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.addressing.WsaClientTube;
import com.sun.xml.ws.api.EndpointAddress;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.WSService;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.client.ClientPipelineHook;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.ClientPipeAssemblerContext;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.api.pipe.TransportTubeFactory;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.helper.PipeAdapter;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.client.ClientSchemaValidationTube;
import com.sun.xml.ws.developer.SchemaValidationFeature;
import com.sun.xml.ws.handler.ClientLogicalHandlerTube;
import com.sun.xml.ws.handler.ClientMessageHandlerTube;
import com.sun.xml.ws.handler.ClientSOAPHandlerTube;
import com.sun.xml.ws.handler.HandlerTube;
import com.sun.xml.ws.protocol.soap.ClientMUTube;
import com.sun.xml.ws.transport.DeferredTransportPipe;
import com.sun.xml.ws.util.pipe.DumpTube;
import java.io.PrintStream;
import javax.xml.ws.soap.SOAPBinding;

public class ClientTubeAssemblerContext {
    @NotNull
    private final EndpointAddress address;
    @Nullable
    private final WSDLPort wsdlModel;
    @Nullable
    private final SEIModel seiModel;
    @NotNull
    private final WSService rootOwner;
    @NotNull
    private final WSBinding binding;
    @NotNull
    private final Container container;
    @NotNull
    private Codec codec;

    public ClientTubeAssemblerContext(@NotNull EndpointAddress address, @Nullable WSDLPort wsdlModel, @NotNull WSService rootOwner, @NotNull WSBinding binding) {
        this(address, wsdlModel, rootOwner, binding, Container.NONE);
    }

    public ClientTubeAssemblerContext(@NotNull EndpointAddress address, @Nullable WSDLPort wsdlModel, @NotNull WSService rootOwner, @NotNull WSBinding binding, @NotNull Container container) {
        this(address, wsdlModel, rootOwner, binding, container, ((BindingImpl)binding).createCodec());
    }

    public ClientTubeAssemblerContext(@NotNull EndpointAddress address, @Nullable WSDLPort wsdlModel, @NotNull WSService rootOwner, @NotNull WSBinding binding, @NotNull Container container, Codec codec) {
        this(address, wsdlModel, rootOwner, binding, container, codec, null);
    }

    public ClientTubeAssemblerContext(@NotNull EndpointAddress address, @Nullable WSDLPort wsdlModel, @NotNull WSService rootOwner, @NotNull WSBinding binding, @NotNull Container container, Codec codec, SEIModel seiModel) {
        this.address = address;
        this.wsdlModel = wsdlModel;
        this.rootOwner = rootOwner;
        this.binding = binding;
        this.container = container;
        this.codec = codec;
        this.seiModel = seiModel;
    }

    @NotNull
    public EndpointAddress getAddress() {
        return this.address;
    }

    @Nullable
    public WSDLPort getWsdlModel() {
        return this.wsdlModel;
    }

    @NotNull
    public WSService getService() {
        return this.rootOwner;
    }

    @NotNull
    public WSBinding getBinding() {
        return this.binding;
    }

    @Nullable
    public SEIModel getSEIModel() {
        return this.seiModel;
    }

    public Container getContainer() {
        return this.container;
    }

    public Tube createDumpTube(String name, PrintStream out, Tube next) {
        return new DumpTube(name, out, next);
    }

    @NotNull
    public Tube createSecurityTube(@NotNull Tube next) {
        ClientPipelineHook hook = this.container.getSPI(ClientPipelineHook.class);
        if (hook != null) {
            ClientPipeAssemblerContext ctxt = new ClientPipeAssemblerContext(this.address, this.wsdlModel, this.rootOwner, this.binding, this.container);
            return PipeAdapter.adapt(hook.createSecurityPipe(ctxt, PipeAdapter.adapt(next)));
        }
        return next;
    }

    public Tube createWsaTube(Tube next) {
        if (this.binding instanceof SOAPBinding && AddressingVersion.isEnabled(this.binding) && this.wsdlModel != null) {
            return new WsaClientTube(this.wsdlModel, this.binding, next);
        }
        return next;
    }

    public Tube createHandlerTube(Tube next) {
        HandlerTube cousinHandlerTube = null;
        if (this.binding instanceof SOAPBinding) {
            ClientMessageHandlerTube messageHandlerTube;
            cousinHandlerTube = messageHandlerTube = new ClientMessageHandlerTube(this.seiModel, this.binding, this.wsdlModel, next);
            next = cousinHandlerTube;
            ClientSOAPHandlerTube soapHandlerTube = new ClientSOAPHandlerTube(this.binding, next, cousinHandlerTube);
            cousinHandlerTube = soapHandlerTube;
            next = cousinHandlerTube;
        }
        return new ClientLogicalHandlerTube(this.binding, next, cousinHandlerTube);
    }

    public Tube createClientMUTube(Tube next) {
        if (this.binding instanceof SOAPBinding) {
            return new ClientMUTube(this.binding, next);
        }
        return next;
    }

    public Tube createValidationTube(Tube next) {
        if (this.binding instanceof SOAPBinding && this.binding.isFeatureEnabled(SchemaValidationFeature.class) && this.wsdlModel != null) {
            return new ClientSchemaValidationTube(this.binding, this.wsdlModel, next);
        }
        return next;
    }

    public Tube createTransportTube() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (this.address.toString().equals("") || this.address.toString().equals("REPLACE_WITH_ACTUAL_URL")) {
            return new DeferredTransportPipe(cl, this);
        }
        return TransportTubeFactory.create(cl, this);
    }

    @NotNull
    public Codec getCodec() {
        return this.codec;
    }

    public void setCodec(@NotNull Codec codec) {
        this.codec = codec;
    }
}

