/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.tiff;

import com.sun.imageio.plugins.jpeg.JPEGImageReader;
import com.twelvemonkeys.imageio.ImageReaderBase;
import com.twelvemonkeys.imageio.color.ColorSpaces;
import com.twelvemonkeys.imageio.metadata.CompoundDirectory;
import com.twelvemonkeys.imageio.metadata.Directory;
import com.twelvemonkeys.imageio.metadata.Entry;
import com.twelvemonkeys.imageio.metadata.exif.EXIFReader;
import com.twelvemonkeys.imageio.metadata.exif.Rational;
import com.twelvemonkeys.imageio.plugins.tiff.CCITTFaxDecoderStream;
import com.twelvemonkeys.imageio.plugins.tiff.HorizontalDeDifferencingStream;
import com.twelvemonkeys.imageio.plugins.tiff.LZWDecoder;
import com.twelvemonkeys.imageio.plugins.tiff.TIFFImageReaderSpi;
import com.twelvemonkeys.imageio.plugins.tiff.YCbCr16UpsamplerStream;
import com.twelvemonkeys.imageio.plugins.tiff.YCbCrUpsamplerStream;
import com.twelvemonkeys.imageio.stream.ByteArrayImageInputStream;
import com.twelvemonkeys.imageio.stream.SubImageInputStream;
import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.imageio.util.IndexedImageTypeSpecifier;
import com.twelvemonkeys.imageio.util.ProgressListenerBase;
import com.twelvemonkeys.io.FastByteArrayOutputStream;
import com.twelvemonkeys.io.LittleEndianDataInputStream;
import com.twelvemonkeys.io.enc.Decoder;
import com.twelvemonkeys.io.enc.DecoderStream;
import com.twelvemonkeys.io.enc.PackBitsDecoder;
import com.twelvemonkeys.xml.XMLSerializer;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.event.IIOReadWarningListener;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.plugins.jpeg.JPEGImageReadParam;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TIFFImageReader
extends ImageReaderBase {
    static final boolean DEBUG = "true".equalsIgnoreCase(System.getProperty("com.twelvemonkeys.imageio.plugins.tiff.debug"));
    private CompoundDirectory IFDs;
    private Directory currentIFD;

    TIFFImageReader(TIFFImageReaderSpi tIFFImageReaderSpi) {
        super((ImageReaderSpi)tIFFImageReaderSpi);
    }

    protected void resetMembers() {
        this.IFDs = null;
        this.currentIFD = null;
    }

    private void readMetadata() throws IOException {
        if (this.imageInput == null) {
            throw new IllegalStateException("input not set");
        }
        if (this.IFDs == null) {
            this.IFDs = (CompoundDirectory)new EXIFReader().read(this.imageInput);
            if (DEBUG) {
                System.err.println("Byte order: " + this.imageInput.getByteOrder());
                System.err.println("Number of images: " + this.IFDs.directoryCount());
                for (int i = 0; i < this.IFDs.directoryCount(); ++i) {
                    System.err.printf("IFD %d: %s\n", i, this.IFDs.getDirectory(i));
                }
            }
        }
    }

    private void readIFD(int n) throws IOException {
        this.readMetadata();
        this.checkBounds(n);
        this.currentIFD = this.IFDs.getDirectory(n);
    }

    public int getNumImages(boolean bl) throws IOException {
        this.readMetadata();
        return this.IFDs.directoryCount();
    }

    private Number getValueAsNumberWithDefault(int n, String string, Number number) throws IIOException {
        Entry entry = this.currentIFD.getEntryById((Object)n);
        if (entry == null) {
            if (number != null) {
                return number;
            }
            throw new IIOException("Missing TIFF tag: " + (string != null ? string : Integer.valueOf(n)));
        }
        return (Number)entry.getValue();
    }

    private long getValueAsLongWithDefault(int n, String string, Long l) throws IIOException {
        return this.getValueAsNumberWithDefault(n, string, l).longValue();
    }

    private long getValueAsLongWithDefault(int n, Long l) throws IIOException {
        return this.getValueAsLongWithDefault(n, null, l);
    }

    private int getValueAsIntWithDefault(int n, String string, Integer n2) throws IIOException {
        return this.getValueAsNumberWithDefault(n, string, n2).intValue();
    }

    private int getValueAsIntWithDefault(int n, Integer n2) throws IIOException {
        return this.getValueAsIntWithDefault(n, null, n2);
    }

    private int getValueAsInt(int n, String string) throws IIOException {
        return this.getValueAsIntWithDefault(n, string, null);
    }

    public int getWidth(int n) throws IOException {
        this.readIFD(n);
        return this.getValueAsInt(256, "ImageWidth");
    }

    public int getHeight(int n) throws IOException {
        this.readIFD(n);
        return this.getValueAsInt(257, "ImageHeight");
    }

    public ImageTypeSpecifier getRawImageType(int n) throws IOException {
        this.readIFD(n);
        this.getSampleFormat();
        int n2 = this.getValueAsIntWithDefault(284, 2);
        int n3 = this.getValueAsInt(262, "PhotometricInterpretation");
        int n4 = this.getValueAsIntWithDefault(277, 1);
        int n5 = this.getBitsPerSample();
        int n6 = n5 <= 8 ? 0 : (n5 <= 16 ? 1 : 3);
        ICC_Profile iCC_Profile = this.getICCProfile();
        switch (n3) {
            case 0: 
            case 1: {
                switch (n4) {
                    case 1: {
                        ColorSpace colorSpace;
                        if (iCC_Profile != null && iCC_Profile.getColorSpaceType() != 6) {
                            this.processWarningOccurred(String.format("Embedded ICC color profile (type %s), is incompatible with image data (GRAY/type 6). Ignoring profile.", iCC_Profile.getColorSpaceType()));
                            iCC_Profile = null;
                        }
                        ColorSpace colorSpace2 = colorSpace = iCC_Profile == null ? ColorSpace.getInstance(1003) : ColorSpaces.createColorSpace((ICC_Profile)iCC_Profile);
                        if (colorSpace == ColorSpace.getInstance(1003) && (n5 == 1 || n5 == 2 || n5 == 4 || n5 == 8 || n5 == 16)) {
                            return ImageTypeSpecifier.createGrayscale(n5, n6, false);
                        }
                        if (n5 != 1 && n5 != 2 && n5 != 4 && n5 != 8 && n5 != 16 && n5 != 32) break;
                        return ImageTypeSpecifier.createInterleaved(colorSpace, new int[]{0}, n6, false, false);
                    }
                }
                throw new IIOException(String.format("Unsupported SamplesPerPixel/BitsPerSample combination for Bi-level/Gray TIFF (expected 1/1, 1/2, 1/4, 1/8 or 1/16): %d/%d", n4, n5));
            }
            case 2: 
            case 6: {
                if (iCC_Profile != null && iCC_Profile.getColorSpaceType() != 5) {
                    this.processWarningOccurred(String.format("Embedded ICC color profile (type %s), is incompatible with image data (RGB/type 5). Ignoring profile.", iCC_Profile.getColorSpaceType()));
                    iCC_Profile = null;
                }
                ColorSpace colorSpace = iCC_Profile == null ? ColorSpace.getInstance(1000) : ColorSpaces.createColorSpace((ICC_Profile)iCC_Profile);
                switch (n4) {
                    case 3: {
                        if (n5 == 8 || n5 == 16) {
                            switch (n2) {
                                case 1: {
                                    if (n5 == 8 && colorSpace.isCS_sRGB()) {
                                        return ImageTypeSpecifier.createFromBufferedImageType(5);
                                    }
                                    return ImageTypeSpecifier.createInterleaved(colorSpace, new int[]{0, 1, 2}, n6, false, false);
                                }
                                case 2: {
                                    return ImageTypeSpecifier.createBanded(colorSpace, new int[]{0, 1, 2}, new int[]{0, 0, 0}, n6, false, false);
                                }
                            }
                        }
                    }
                    case 4: {
                        if (n5 != 8 && n5 != 16) break;
                        long[] lArray = this.getValueAsLongArray(338, "ExtraSamples", true);
                        switch (n2) {
                            case 1: {
                                if (n5 == 8 && colorSpace.isCS_sRGB()) {
                                    return ImageTypeSpecifier.createFromBufferedImageType(6);
                                }
                                return ImageTypeSpecifier.createInterleaved(colorSpace, new int[]{0, 1, 2, 3}, n6, true, lArray[0] == 1L);
                            }
                            case 2: {
                                return ImageTypeSpecifier.createBanded(colorSpace, new int[]{0, 1, 2, 3}, new int[]{0, 0, 0, 0}, n6, true, lArray[0] == 1L);
                            }
                        }
                    }
                }
                throw new IIOException(String.format("Unsupported SamplesPerPixels/BitsPerSample combination for RGB TIFF (expected 3/8, 4/8, 3/16 or 4/16): %d/%d", n4, n5));
            }
            case 3: {
                if (n4 != 1) {
                    throw new IIOException("Bad SamplesPerPixel value for Palette TIFF (expected 1): " + n4);
                }
                if (n5 <= 0 || n5 > 16) {
                    throw new IIOException("Bad BitsPerSample value for Palette TIFF (expected <= 16): " + n5);
                }
                Entry entry = this.currentIFD.getEntryById((Object)320);
                if (entry == null) {
                    throw new IIOException("Missing ColorMap for Palette TIFF");
                }
                IndexColorModel indexColorModel = this.createIndexColorModel(n5, n6, (int[])entry.getValue());
                return IndexedImageTypeSpecifier.createFromIndexColorModel((IndexColorModel)indexColorModel);
            }
            case 5: {
                int n7 = this.getValueAsIntWithDefault(332, 1);
                int n8 = this.getValueAsIntWithDefault(334, 4);
                if (n7 != 1 && (iCC_Profile == null || iCC_Profile.getNumComponents() != n8)) {
                    throw new IIOException(String.format("Embedded ICC color profile for Photometric Separated is missing or is incompatible with image data: %s != NumberOfInks (%s).", iCC_Profile != null ? Integer.valueOf(iCC_Profile.getNumComponents()) : "null", n8));
                }
                if (iCC_Profile != null && n7 == 1 && iCC_Profile.getColorSpaceType() != 9) {
                    this.processWarningOccurred(String.format("Embedded ICC color profile (type %s), is incompatible with image data (CMYK/type 9). Ignoring profile.", iCC_Profile.getColorSpaceType()));
                    iCC_Profile = null;
                }
                ColorSpace colorSpace = iCC_Profile == null ? ColorSpaces.getColorSpace((int)5001) : ColorSpaces.createColorSpace((ICC_Profile)iCC_Profile);
                switch (n4) {
                    case 4: {
                        if (n5 == 8 || n5 == 16) {
                            switch (n2) {
                                case 1: {
                                    return ImageTypeSpecifier.createInterleaved(colorSpace, new int[]{0, 1, 2, 3}, n6, false, false);
                                }
                                case 2: {
                                    return ImageTypeSpecifier.createBanded(colorSpace, new int[]{0, 1, 2, 3}, new int[]{0, 0, 0, 0}, n6, false, false);
                                }
                            }
                        }
                    }
                    case 5: {
                        if (n5 != 8 && n5 != 16) break;
                        long[] lArray = this.getValueAsLongArray(338, "ExtraSamples", true);
                        switch (n2) {
                            case 1: {
                                return ImageTypeSpecifier.createInterleaved(colorSpace, new int[]{0, 1, 2, 3, 4}, n6, true, lArray[0] == 1L);
                            }
                            case 2: {
                                return ImageTypeSpecifier.createBanded(colorSpace, new int[]{0, 1, 2, 3, 4}, new int[]{0, 0, 0, 0, 0}, n6, true, lArray[0] == 1L);
                            }
                        }
                    }
                }
                throw new IIOException(String.format("Unsupported TIFF SamplesPerPixels/BitsPerSample combination for Separated TIFF (expected 4/8, 4/16, 5/8 or 5/16): %d/%s", n4, n5));
            }
            case 4: {
                throw new IIOException("Unsupported TIFF PhotometricInterpretation value: " + n3);
            }
        }
        throw new IIOException("Unknown TIFF PhotometricInterpretation value: " + n3);
    }

    private IndexColorModel createIndexColorModel(int n, int n2, int[] nArray) {
        int n3;
        int[] nArray2 = new int[nArray.length / 3];
        boolean bl = true;
        for (n3 = 0; n3 < nArray2.length; ++n3) {
            nArray2[n3] = nArray[n3] / 256 << 16 | nArray[n3 + nArray2.length] / 256 << 8 | nArray[n3 + 2 * nArray2.length] / 256;
            if (!bl || nArray2[n3] == 0) continue;
            bl = false;
        }
        if (bl) {
            this.processWarningOccurred("8 bit ColorMap detected.");
            for (n3 = 0; n3 < nArray2.length; ++n3) {
                nArray2[n3] = nArray[n3] << 16 | nArray[n3 + nArray2.length] << 8 | nArray[n3 + 2 * nArray2.length];
            }
        }
        return new IndexColorModel(n, nArray2.length, nArray2, 0, false, -1, n2);
    }

    private int getSampleFormat() throws IIOException {
        long[] lArray = this.getValueAsLongArray(339, "SampleFormat", false);
        if (lArray != null) {
            long l = lArray[0];
            for (int i = 1; i < lArray.length; ++i) {
                if (lArray[i] == l) continue;
                throw new IIOException("Variable TIFF SampleFormat not supported: " + Arrays.toString(lArray));
            }
            if (l != 1L) {
                throw new IIOException("Unsupported TIFF SampleFormat (expected 1/Unsigned Integer): " + l);
            }
        }
        return 1;
    }

    private int getBitsPerSample() throws IIOException {
        long[] lArray = this.getValueAsLongArray(258, "BitsPerSample", false);
        if (lArray == null || lArray.length == 0) {
            return 1;
        }
        int n = (int)lArray[0];
        for (int i = 1; i < lArray.length; ++i) {
            if (lArray[i] == (long)n) continue;
            throw new IIOException("Variable BitsPerSample not supported: " + Arrays.toString(lArray));
        }
        return n;
    }

    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
        this.readIFD(n);
        ImageTypeSpecifier imageTypeSpecifier = this.getRawImageType(n);
        LinkedHashSet<ImageTypeSpecifier> linkedHashSet = new LinkedHashSet<ImageTypeSpecifier>(5);
        if (imageTypeSpecifier.getColorModel().getColorSpace().getType() == 5) {
            if (imageTypeSpecifier.getNumBands() == 3 && imageTypeSpecifier.getBitsPerBand(0) == 8) {
                linkedHashSet.add(ImageTypeSpecifier.createFromBufferedImageType(5));
            } else if (imageTypeSpecifier.getNumBands() == 4 && imageTypeSpecifier.getBitsPerBand(0) == 8) {
                linkedHashSet.add(ImageTypeSpecifier.createFromBufferedImageType(6));
                linkedHashSet.add(ImageTypeSpecifier.createFromBufferedImageType(7));
            }
        }
        linkedHashSet.add(imageTypeSpecifier);
        return linkedHashSet.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public BufferedImage read(int var1_1, ImageReadParam var2_2) throws IOException {
        this.readIFD(var1_1);
        var3_3 = this.getWidth(var1_1);
        var4_4 = this.getHeight(var1_1);
        var5_5 = TIFFImageReader.getDestination((ImageReadParam)var2_2, this.getImageTypes(var1_1), (int)var3_3, (int)var4_4);
        var6_6 = this.getRawImageType(var1_1);
        TIFFImageReader.checkReadParamBandSettings((ImageReadParam)var2_2, (int)var6_6.getNumBands(), (int)var5_5.getSampleModel().getNumBands());
        var7_7 = new Rectangle();
        var8_8 = new Rectangle();
        TIFFImageReader.computeRegions((ImageReadParam)var2_2, (int)var3_3, (int)var4_4, (BufferedImage)var5_5, (Rectangle)var7_7, (Rectangle)var8_8);
        var9_9 = var2_2 != null ? var2_2.getSourceXSubsampling() : 1;
        var10_10 = var2_2 != null ? var2_2.getSourceYSubsampling() : 1;
        var11_11 = this.clipToRect(var5_5.getRaster(), var8_8, var2_2 != null ? var2_2.getDestinationBands() : null);
        var12_12 = this.getValueAsInt(262, "PhotometricInterpretation");
        var13_13 = this.getValueAsIntWithDefault(259, 1);
        var14_14 = this.getValueAsIntWithDefault(317, 1);
        var15_15 = this.getValueAsIntWithDefault(284, 1);
        var16_16 = var15_15 == 2 ? 1 : var6_6.getNumBands();
        var17_17 = var3_3;
        var18_18 = this.getValueAsLongWithDefault(278, 0xFFFFFFFFL);
        var20_19 = var18_18 < (long)var4_4 ? (int)var18_18 : var4_4;
        var21_20 = this.getValueAsLongArray(324, "TileOffsets", false);
        if (var21_20 != null) {
            var22_21 = this.getValueAsLongArray(325, "TileByteCounts", false);
            if (var22_21 == null) {
                this.processWarningOccurred("Missing TileByteCounts for tiled TIFF with compression: " + var13_13);
            }
            var17_17 = this.getValueAsInt(322, "TileWidth");
            var20_19 = this.getValueAsInt(323, "TileHeight");
        } else {
            var21_20 = this.getValueAsLongArray(273, "StripOffsets", true);
            var22_21 = this.getValueAsLongArray(279, "StripByteCounts", false);
            if (var22_21 == null) {
                this.processWarningOccurred("Missing StripByteCounts for TIFF with compression: " + var13_13);
            }
            var17_17 = this.getValueAsIntWithDefault(322, "TileWidth", var17_17);
            var20_19 = this.getValueAsIntWithDefault(323, "TileHeight", var20_19);
        }
        var23_22 = (var3_3 + var17_17 - 1) / var17_17;
        var24_23 = (var4_4 + var20_19 - 1) / var20_19;
        var25_24 = var6_6.getColorModel().createCompatibleWritableRaster(var17_17, 1);
        var26_25 = 0;
        block4 : switch (var13_13) {
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 32773: 
            case 32946: {
                var27_26 = null;
                var28_27 = 1;
                var29_28 = null;
                if (var12_12 == 6) {
                    if (var25_24.getNumBands() != 3) {
                        throw new IIOException("TIFF PhotometricInterpretation YCbCr requires SamplesPerPixel == 3: " + var25_24.getNumBands());
                    }
                    if (var25_24.getTransferType() != 0 && var25_24.getTransferType() != 1) {
                        throw new IIOException("TIFF PhotometricInterpretation YCbCr requires BitsPerSample == [8,8,8] or [16,16,16]");
                    }
                    var28_27 = this.getValueAsIntWithDefault(531, 1);
                    if (var28_27 != 1 && var28_27 != 2) {
                        this.processWarningOccurred("Uknown TIFF YCbCrPositioning value, expected 1 or 2: " + var28_27);
                    }
                    if ((var30_29 = this.currentIFD.getEntryById((Object)530)) != null) {
                        try {
                            var27_26 = (int[])var30_29.getValue();
                        }
                        catch (ClassCastException var31_33) {
                            throw new IIOException("Unknown TIFF YCbCrSubSampling value type: " + var30_29.getTypeName(), var31_33);
                        }
                        if (var27_26.length != 2 || var27_26[0] != 1 && var27_26[0] != 2 && var27_26[0] != 4 || var27_26[1] != 1 && var27_26[1] != 2 && var27_26[1] != 4) {
                            throw new IIOException("Bad TIFF YCbCrSubSampling value: " + Arrays.toString(var27_26));
                        }
                        if (var27_26[0] < var27_26[1]) {
                            this.processWarningOccurred("TIFF PhotometricInterpretation YCbCr with bad subsampling, expected subHoriz >= subVert: " + Arrays.toString(var27_26));
                        }
                    } else {
                        var27_26 = new int[]{2, 2};
                    }
                    if ((var31_34 = this.currentIFD.getEntryById((Object)529)) != null) {
                        var32_38 = (Rational[])var31_34.getValue();
                        var29_28 = new double[]{var32_38[0].doubleValue(), var32_38[1].doubleValue(), var32_38[2].doubleValue()};
                    } else {
                        var29_28 = YCbCrUpsamplerStream.CCIR_601_1_COEFFICIENTS;
                    }
                }
                this.processImageStarted(var1_1);
                for (var30_30 = 0; var30_30 < var24_23; ++var30_30) {
                    var31_35 = 0;
                    var32_39 = Math.min(var20_19, var4_4 - var26_25);
                    for (var33_41 = 0; var33_41 < var23_22; ++var33_41) {
                        var34_43 = Math.min(var17_17, var3_3 - var31_35);
                        var35_46 = var30_30 * var23_22 + var33_41;
                        this.imageInput.seek(var21_20[var35_46]);
                        if (var13_13 == 1 && var12_12 != 6) {
                            var36_49 /* !! */  = this.imageInput;
                        } else {
                            var37_52 = var22_21 != null ? IIOUtil.createStreamAdapter((ImageInputStream)this.imageInput, (long)var22_21[var35_46]) : IIOUtil.createStreamAdapter((ImageInputStream)this.imageInput);
                            var37_52 = this.createDecompressorStream(var13_13, var17_17, (InputStream)var37_52);
                            var37_52 = this.createUnpredictorStream(var14_14, var17_17, var16_16, this.getBitsPerSample(), (InputStream)var37_52, this.imageInput.getByteOrder());
                            if (var12_12 == 6 && var25_24.getTransferType() == 0) {
                                var37_52 = new YCbCrUpsamplerStream((InputStream)var37_52, var27_26, var28_27, var34_43, var29_28);
                            } else if (var12_12 == 6 && var25_24.getTransferType() == 1) {
                                var37_52 = new YCbCr16UpsamplerStream((InputStream)var37_52, var27_26, var28_27, var34_43, var29_28, this.imageInput.getByteOrder());
                            } else if (var12_12 == 6) {
                                throw new AssertionError();
                            }
                            var36_49 /* !! */  = this.imageInput.getByteOrder() == ByteOrder.BIG_ENDIAN ? new DataInputStream((InputStream)var37_52) : new LittleEndianDataInputStream((InputStream)var37_52);
                        }
                        var37_52 = new Rectangle(var7_7);
                        var37_52.width = Math.min((var34_43 + var9_9 - 1) / var9_9, var7_7.width);
                        var38_56 = this.clipRowToRect(var25_24, (Rectangle)var37_52, var2_2 != null ? var2_2.getSourceBands() : null, var2_2 != null ? var2_2.getSourceXSubsampling() : 1);
                        this.readStripTileData(var38_56, var7_7, var9_9, var10_10, var16_16, var12_12, var11_11, var31_35, var26_25, var34_43, var32_39, var36_49 /* !! */ );
                        if (this.abortRequested()) break;
                        var31_35 += var34_43;
                    }
                    this.processImageProgress(100.0f * (float)var26_25 / (float)var4_4);
                    if (this.abortRequested()) {
                        this.processReadAborted();
                        break block4;
                    }
                    var26_25 += var32_39;
                }
                break;
            }
            case 7: {
                var30_31 = new JPEGImageReader(this.getOriginatingProvider());
                var31_36 = (JPEGImageReadParam)var30_31.getDefaultReadParam();
                var32_40 = this.currentIFD.getEntryById((Object)347);
                v0 = var33_42 = var32_40 != null ? (byte[])var32_40.getValue() : null;
                if (var33_42 != null) {
                    var30_31.setInput(new ByteArrayImageInputStream(var33_42));
                    var30_31.getStreamMetadata();
                } else {
                    this.processWarningOccurred("Missing JPEGTables for TIFF with compression: 7 (JPEG)");
                }
                this.processImageStarted(var1_1);
                for (var34_44 = 0; var34_44 < var24_23; ++var34_44) {
                    var35_47 = 0;
                    var36_50 = Math.min(var20_19, var4_4 - var26_25);
                    for (var37_53 = 0; var37_53 < var23_22; ++var37_53) {
                        var38_57 = var34_44 * var23_22 + var37_53;
                        var39_60 = Math.min(var17_17, var3_3 - var35_47);
                        if (new Rectangle(var35_47, var26_25, var39_60, var36_50).intersects(var7_7)) {
                            this.imageInput.seek(var21_20[var38_57]);
                            var40_62 = new SubImageInputStream(this.imageInput, var22_21 != null ? (long)((int)var22_21[var38_57]) : 32767L);
                            try {
                                var30_31.setInput(var40_62);
                                var31_36.setSourceRegion(new Rectangle(0, 0, var39_60, var36_50));
                                var31_36.setDestinationOffset(new Point(var35_47 - var7_7.x, var26_25 - var7_7.y));
                                var31_36.setDestination(var5_5);
                                var30_31.read(0, var31_36);
                            }
                            finally {
                                var40_62.close();
                            }
                        }
                        if (this.abortRequested()) break;
                        var35_47 += var39_60;
                    }
                    this.processImageProgress(100.0f * (float)var26_25 / (float)var4_4);
                    if (this.abortRequested()) {
                        this.processReadAborted();
                        break block4;
                    }
                    var26_25 += var36_50;
                }
                break;
            }
            case 6: {
                var34_45 = this.getValueAsIntWithDefault(512, 1);
                switch (var34_45) {
                    case 1: {
                        break;
                    }
                    case 14: {
                        throw new IIOException("Unsupported TIFF JPEGProcessingMode: Lossless (14)");
                    }
                    default: {
                        throw new IIOException("Unknown TIFF JPEGProcessingMode value: " + var34_45);
                    }
                }
                var30_32 = new JPEGImageReader(this.getOriginatingProvider());
                var31_37 = (JPEGImageReadParam)var30_32.getDefaultReadParam();
                var35_48 = this.getValueAsIntWithDefault(513, -1);
                var36_51 = this.getValueAsIntWithDefault(514, -1);
                if (var35_48 == -1) ** GOTO lbl196
                if (this.currentIFD.getEntryById((Object)519) != null || this.currentIFD.getEntryById((Object)520) != null || this.currentIFD.getEntryById((Object)521) != null) {
                    this.processWarningOccurred("Old-style JPEG compressed TIFF with JFIF stream encountered. Ignoring JPEG tables. Reading as single tile.");
                } else {
                    this.processWarningOccurred("Old-style JPEG compressed TIFF with JFIF stream encountered. Reading as single tile.");
                }
                this.imageInput.seek(var35_48);
                var38_58 = var35_48;
                var40_63 = (short)(this.imageInput.readByte() << 8 | this.imageInput.readByte());
                if (var40_63 != -40) {
                    if (var21_20 != null && var21_20.length == 1) {
                        this.imageInput.seek(var21_20[0]);
                        var40_63 = (short)(this.imageInput.readByte() << 8 | this.imageInput.readByte());
                        if (var40_63 == -40) {
                            var38_58 = var21_20[0];
                        }
                    }
                    if (var38_58 != (long)var35_48) {
                        this.processWarningOccurred("Incorrect JPEGInterchangeFormat tag, using StripOffsets/TileOffsets instead.");
                    } else {
                        this.processWarningOccurred("Incorrect JPEGInterchangeFormat tag encountered (not a valid SOI marker).");
                    }
                }
                this.imageInput.seek(var38_58);
                var37_54 = new SubImageInputStream(this.imageInput, var36_51 != -1 ? (long)var36_51 : 32767L);
                var30_32.setInput(var37_54);
                this.processImageStarted(var1_1);
                try {
                    var31_37.setSourceRegion(new Rectangle(0, 0, var3_3, var4_4));
                    var31_37.setDestination(var5_5);
                    var30_32.read(0, var31_37);
                }
                finally {
                    var37_54.close();
                }
                this.processImageProgress(100.0f);
                if (!this.abortRequested()) break;
                this.processReadAborted();
                break;
lbl196:
                // 1 sources

                this.processWarningOccurred("Old-style JPEG compressed TIFF without JFIF stream encountered. Attempting to re-create JFIF stream.");
                var38_59 = this.getValueAsLongArray(519, "JPEGQTables", true);
                var39_61 = new byte[var38_59.length][(int)(var38_59[1] - var38_59[0])];
                for (var40_64 = 0; var40_64 < var39_61.length; ++var40_64) {
                    this.imageInput.seek(var38_59[var40_64]);
                    this.imageInput.readFully(var39_61[var40_64]);
                }
                var40_65 = this.getValueAsLongArray(520, "JPEGDCTables", true);
                var41_67 = new byte[var40_65.length][(int)(var40_65[1] - var40_65[0])];
                for (var42_69 = 0; var42_69 < var41_67.length; ++var42_69) {
                    this.imageInput.seek(var40_65[var42_69]);
                    this.imageInput.readFully(var41_67[var42_69]);
                }
                var42_70 = this.getValueAsLongArray(521, "JPEGACTables", true);
                var43_71 = new byte[var42_70.length][(int)(var42_70[1] - var42_70[0])];
                for (var44_72 = 0; var44_72 < var43_71.length; ++var44_72) {
                    this.imageInput.seek(var42_70[var44_72]);
                    this.imageInput.readFully(var43_71[var44_72]);
                }
                this.processImageStarted(var1_1);
                for (var44_72 = 0; var44_72 < var24_23; ++var44_72) {
                    var45_73 = 0;
                    var46_74 = Math.min(var20_19, var4_4 - var26_25);
                    for (var47_75 = 0; var47_75 < var23_22; ++var47_75) {
                        var48_76 = Math.min(var17_17, var3_3 - var45_73);
                        var49_77 = var44_72 * var23_22 + var47_75;
                        if (new Rectangle(var45_73, var26_25, var48_76, var46_74).intersects(var7_7)) {
                            this.imageInput.seek(var21_20[var49_77]);
                            var37_55 = ImageIO.createImageInputStream(new SequenceInputStream(Collections.enumeration(Arrays.asList(new InputStream[]{TIFFImageReader.createJFIFStream(var11_11, var17_17, var20_19, var39_61, var41_67, var43_71), IIOUtil.createStreamAdapter((ImageInputStream)this.imageInput, (long)(var22_21 != null ? (long)((int)var22_21[var49_77]) : 32767L)), new ByteArrayInputStream(new byte[]{-1, -39})}))));
                            var30_32.setInput(var37_55);
                            try {
                                var31_37.setSourceRegion(new Rectangle(0, 0, var48_76, var46_74));
                                var31_37.setDestinationOffset(new Point(var45_73 - var7_7.x, var26_25 - var7_7.y));
                                var31_37.setDestination(var5_5);
                                var30_32.read(0, var31_37);
                            }
                            finally {
                                var37_55.close();
                            }
                        }
                        if (this.abortRequested()) break;
                        var45_73 += var48_76;
                    }
                    this.processImageProgress(100.0f * (float)var26_25 / (float)var4_4);
                    if (this.abortRequested()) {
                        this.processReadAborted();
                        break block4;
                    }
                    var26_25 += var46_74;
                }
                break;
            }
            case 3: 
            case 4: 
            case 32766: 
            case 32771: 
            case 32809: 
            case 32895: 
            case 32896: 
            case 32897: 
            case 32898: 
            case 32908: 
            case 32909: 
            case 32947: 
            case 34661: 
            case 34676: 
            case 34677: 
            case 34712: {
                throw new IIOException("Unsupported TIFF Compression value: " + var13_13);
            }
            default: {
                throw new IIOException("Unknown TIFF Compression value: " + var13_13);
            }
        }
        this.processImageComplete();
        return var5_5;
    }

    private static InputStream createJFIFStream(WritableRaster writableRaster, int n, int n2, byte[][] byArray, byte[][] byArray2, byte[][] byArray3) throws IOException {
        byte[] byArray4;
        int n3;
        FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream(12 + 3 * writableRaster.getNumBands() + 5 * byArray.length + byArray.length * byArray[0].length + 5 * byArray2.length + byArray2.length * byArray2[0].length + 5 * byArray3.length + byArray3.length * byArray3[0].length + 8 + 2 * writableRaster.getNumBands());
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)fastByteArrayOutputStream);
        dataOutputStream.writeShort(65496);
        dataOutputStream.writeShort(65472);
        dataOutputStream.writeShort(8 + 3 * writableRaster.getNumBands());
        dataOutputStream.writeByte(8);
        dataOutputStream.writeShort(n2);
        dataOutputStream.writeShort(n);
        dataOutputStream.writeByte(writableRaster.getNumBands());
        for (n3 = 0; n3 < writableRaster.getNumBands(); ++n3) {
            dataOutputStream.writeByte(n3);
            dataOutputStream.writeByte(n3 == 0 ? 34 : 17);
            dataOutputStream.writeByte(n3);
        }
        for (n3 = 0; n3 < byArray.length; ++n3) {
            byArray4 = byArray[n3];
            dataOutputStream.writeShort(65499);
            dataOutputStream.writeShort(3 + byArray4.length);
            dataOutputStream.writeByte(n3);
            dataOutputStream.write(byArray4);
        }
        for (n3 = 0; n3 < byArray2.length; ++n3) {
            byArray4 = byArray2[n3];
            dataOutputStream.writeShort(65476);
            dataOutputStream.writeShort(3 + byArray4.length);
            dataOutputStream.writeByte(n3);
            dataOutputStream.write(byArray4);
        }
        for (n3 = 0; n3 < byArray3.length; ++n3) {
            byArray4 = byArray3[n3];
            dataOutputStream.writeShort(65476);
            dataOutputStream.writeShort(3 + byArray4.length);
            dataOutputStream.writeByte(16 + (n3 & 0xF));
            dataOutputStream.write(byArray4);
        }
        dataOutputStream.writeShort(65498);
        dataOutputStream.writeShort(6 + 2 * writableRaster.getNumBands());
        dataOutputStream.writeByte(writableRaster.getNumBands());
        for (n3 = 0; n3 < writableRaster.getNumBands(); ++n3) {
            dataOutputStream.writeByte(n3);
            dataOutputStream.writeByte(n3 == 0 ? n3 : 16 + (n3 & 0xF));
        }
        dataOutputStream.writeByte(0);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeByte(0);
        return fastByteArrayOutputStream.createInputStream();
    }

    private Raster clipRowToRect(Raster raster, Rectangle rectangle, int[] nArray, int n) {
        if (rectangle.contains(raster.getMinX(), 0, raster.getWidth(), 1) && n == 1 && nArray == null) {
            return raster;
        }
        return raster.createChild(rectangle.x / n, 0, rectangle.width / n, 1, 0, 0, nArray);
    }

    private WritableRaster clipToRect(WritableRaster writableRaster, Rectangle rectangle, int[] nArray) {
        if (rectangle.contains(writableRaster.getMinX(), writableRaster.getMinY(), writableRaster.getWidth(), writableRaster.getHeight()) && nArray == null) {
            return writableRaster;
        }
        return writableRaster.createWritableChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 0, 0, nArray);
    }

    private void readStripTileData(Raster raster, Rectangle rectangle, int n, int n2, int n3, int n4, WritableRaster writableRaster, int n5, int n6, int n7, int n8, DataInput dataInput) throws IOException {
        switch (raster.getTransferType()) {
            case 0: {
                byte[] byArray = ((DataBufferByte)raster.getDataBuffer()).getData();
                for (int i = n6; i < n6 + n8 && i < rectangle.y + rectangle.height; ++i) {
                    dataInput.readFully(byArray);
                    if (i % n2 != 0 || i < rectangle.y) continue;
                    this.normalizeBlack(n4, byArray);
                    if (n != 1) {
                        for (int j = rectangle.x / n * n3; j < (rectangle.x + rectangle.width) / n * n3; j += n3) {
                            for (int k = 0; k < n3; ++k) {
                                byArray[j + k] = byArray[j * n + k];
                            }
                        }
                    }
                    writableRaster.setDataElements(n5, (i - rectangle.y) / n2, raster);
                }
                break;
            }
            case 1: {
                short[] sArray = ((DataBufferUShort)raster.getDataBuffer()).getData();
                for (int i = n6; i < n6 + n8 && i < rectangle.y + rectangle.height; ++i) {
                    this.readFully(dataInput, sArray);
                    if (i < rectangle.y) continue;
                    this.normalizeBlack(n4, sArray);
                    if (n != 1) {
                        for (int j = rectangle.x / n * n3; j < (rectangle.x + rectangle.width) / n * n3; j += n3) {
                            for (int k = 0; k < n3; ++k) {
                                sArray[j + k] = sArray[j * n + k];
                            }
                        }
                    }
                    writableRaster.setDataElements(n5, i - rectangle.y, raster);
                }
                break;
            }
            case 3: {
                int[] nArray = ((DataBufferInt)raster.getDataBuffer()).getData();
                for (int i = n6; i < n6 + n8 && i < rectangle.y + rectangle.height; ++i) {
                    this.readFully(dataInput, nArray);
                    if (i < rectangle.y) continue;
                    this.normalizeBlack(n4, nArray);
                    if (n != 1) {
                        for (int j = rectangle.x / n * n3; j < (rectangle.x + rectangle.width) / n * n3; j += n3) {
                            for (int k = 0; k < n3; ++k) {
                                nArray[j + k] = nArray[j * n + k];
                            }
                        }
                    }
                    writableRaster.setDataElements(n5, i - rectangle.y, raster);
                }
                break;
            }
        }
    }

    private void readFully(DataInput dataInput, int[] nArray) throws IOException {
        if (dataInput instanceof ImageInputStream) {
            ImageInputStream imageInputStream = (ImageInputStream)dataInput;
            imageInputStream.readFully(nArray, 0, nArray.length);
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = dataInput.readInt();
            }
        }
    }

    private void readFully(DataInput dataInput, short[] sArray) throws IOException {
        if (dataInput instanceof ImageInputStream) {
            ImageInputStream imageInputStream = (ImageInputStream)dataInput;
            imageInputStream.readFully(sArray, 0, sArray.length);
        } else {
            for (int i = 0; i < sArray.length; ++i) {
                sArray[i] = dataInput.readShort();
            }
        }
    }

    private void normalizeBlack(int n, short[] sArray) {
        if (n == 0) {
            for (int i = 0; i < sArray.length; ++i) {
                sArray[i] = (short)(65535 - sArray[i] & 0xFFFF);
            }
        }
    }

    private void normalizeBlack(int n, int[] nArray) {
        if (n == 0) {
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = -1 - nArray[i];
            }
        }
    }

    private void normalizeBlack(int n, byte[] byArray) {
        if (n == 0) {
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (byte)(255 - byArray[i] & 0xFF);
            }
        }
    }

    private InputStream createDecompressorStream(int n, int n2, InputStream inputStream) throws IOException {
        switch (n) {
            case 1: {
                return inputStream;
            }
            case 32773: {
                return new DecoderStream(inputStream, (Decoder)new PackBitsDecoder(), 1024);
            }
            case 5: {
                return new DecoderStream(inputStream, (Decoder)LZWDecoder.create(LZWDecoder.isOldBitReversedStream(inputStream)), n2);
            }
            case 8: 
            case 32946: {
                return new InflaterInputStream(inputStream, new Inflater(), 1024);
            }
            case 2: 
            case 3: 
            case 4: {
                return new CCITTFaxDecoderStream(inputStream, n2, n, this.getValueAsIntWithDefault(266, 1));
            }
        }
        throw new IllegalArgumentException("Unsupported TIFF compression: " + n);
    }

    private InputStream createUnpredictorStream(int n, int n2, int n3, int n4, InputStream inputStream, ByteOrder byteOrder) throws IOException {
        switch (n) {
            case 1: {
                return inputStream;
            }
            case 2: {
                return new HorizontalDeDifferencingStream(inputStream, n2, n3, n4, byteOrder);
            }
            case 3: {
                throw new IIOException("Unsupported TIFF Predictor value: " + n);
            }
        }
        throw new IIOException("Unknown TIFF Predictor value: " + n);
    }

    private long[] getValueAsLongArray(int n, String string, boolean bl) throws IIOException {
        long[] lArray;
        Entry entry = this.currentIFD.getEntryById((Object)n);
        if (entry == null) {
            if (bl) {
                throw new IIOException("Missing TIFF tag " + string);
            }
            return null;
        }
        if (entry.valueCount() == 1) {
            lArray = new long[]{((Number)entry.getValue()).longValue()};
        } else if (entry.getValue() instanceof short[]) {
            short[] sArray = (short[])entry.getValue();
            lArray = new long[sArray.length];
            int n2 = lArray.length;
            for (int i = 0; i < n2; ++i) {
                lArray[i] = sArray[i];
            }
        } else if (entry.getValue() instanceof int[]) {
            int[] nArray = (int[])entry.getValue();
            lArray = new long[nArray.length];
            int n3 = lArray.length;
            for (int i = 0; i < n3; ++i) {
                lArray[i] = nArray[i];
            }
        } else if (entry.getValue() instanceof long[]) {
            lArray = (long[])entry.getValue();
        } else {
            throw new IIOException(String.format("Unsupported %s type: %s (%s)", string, entry.getTypeName(), entry.getValue().getClass()));
        }
        return lArray;
    }

    public ICC_Profile getICCProfile() {
        Entry entry = this.currentIFD.getEntryById((Object)34675);
        if (entry == null) {
            return null;
        }
        byte[] byArray = (byte[])entry.getValue();
        return ICC_Profile.getInstance(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws IOException {
        for (final String string : stringArray) {
            File file = new File(string);
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);
            if (imageInputStream == null) {
                System.err.println("Could not read file: " + file);
                continue;
            }
            TIFFImageReader.deregisterOSXTIFFImageReaderSpi();
            Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
            if (!iterator.hasNext()) {
                System.err.println("No reader for: " + file);
                continue;
            }
            ImageReader imageReader = iterator.next();
            System.err.println("Reading using: " + imageReader);
            imageReader.addIIOReadWarningListener(new IIOReadWarningListener(){

                public void warningOccurred(ImageReader imageReader, String string2) {
                    System.err.println("Warning: " + string + ": " + string2);
                }
            });
            imageReader.addIIOReadProgressListener((IIOReadProgressListener)new ProgressListenerBase(){
                private static final int MAX_W = 78;
                int lastProgress = 0;

                public void imageStarted(ImageReader imageReader, int n) {
                    System.out.print("[");
                }

                public void imageProgress(ImageReader imageReader, float f) {
                    int n = (int)(f * 78.0f) / 100;
                    for (int i = this.lastProgress; i < n; ++i) {
                        System.out.print(".");
                    }
                    System.out.flush();
                    this.lastProgress = n;
                }

                public void imageComplete(ImageReader imageReader) {
                    for (int i = this.lastProgress; i < 78; ++i) {
                        System.out.print(".");
                    }
                    System.out.println("]");
                }
            });
            imageReader.setInput(imageInputStream);
            try {
                ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
                int n = imageReader.getNumImages(true);
                for (int i = 0; i < n; ++i) {
                    long l = System.currentTimeMillis();
                    BufferedImage bufferedImage = imageReader.read(i, imageReadParam);
                    System.err.println("Read time: " + (System.currentTimeMillis() - l) + " ms");
                    IIOMetadata iIOMetadata = imageReader.getImageMetadata(i);
                    if (iIOMetadata != null) {
                        new XMLSerializer((OutputStream)System.out, "UTF-8").serialize(iIOMetadata.getAsTree(iIOMetadata.getNativeMetadataFormatName()), false);
                    }
                    if (bufferedImage.getType() == 0) {
                        l = System.currentTimeMillis();
                        bufferedImage = new ColorConvertOp(null).filter(bufferedImage, new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2));
                        System.err.println("Conversion time: " + (System.currentTimeMillis() - l) + " ms");
                    }
                    TIFFImageReader.showIt(bufferedImage, String.format("Image: %s [%d x %d]", file.getName(), imageReader.getWidth(i), imageReader.getHeight(i)));
                    try {
                        int n2 = imageReader.getNumThumbnails(0);
                        for (int j = 0; j < n2; ++j) {
                            BufferedImage bufferedImage2 = imageReader.readThumbnail(i, j);
                            TIFFImageReader.showIt(bufferedImage2, String.format("Thumbnail: %s [%d x %d]", file.getName(), bufferedImage2.getWidth(), bufferedImage2.getHeight()));
                        }
                        continue;
                    }
                    catch (IIOException iIOException) {
                        System.err.println("Could not read thumbnails: " + iIOException.getMessage());
                        iIOException.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                System.err.println(file);
                throwable.printStackTrace();
            }
            finally {
                imageInputStream.close();
            }
        }
    }

    protected static void showIt(BufferedImage bufferedImage, String string) {
        ImageReaderBase.showIt((BufferedImage)bufferedImage, (String)string);
    }

    private static void deregisterOSXTIFFImageReaderSpi() {
        IIORegistry iIORegistry = IIORegistry.getDefaultInstance();
        Iterator<ImageReaderSpi> iterator = iIORegistry.getServiceProviders(ImageReaderSpi.class, new ServiceRegistry.Filter(){

            public boolean filter(Object object) {
                return object.getClass().getName().equals("com.sun.imageio.plugins.tiff.TIFFImageReaderSpi");
            }
        }, false);
        while (iterator.hasNext()) {
            ImageReaderSpi imageReaderSpi = iterator.next();
            iIORegistry.deregisterServiceProvider(imageReaderSpi);
        }
    }
}

