/*
 * Decompiled with CFR 0.152.
 */
package com.schooner.MemCached;

import com.schooner.MemCached.ByteBufArrayInputStream;
import com.schooner.MemCached.MemcachedItem;
import com.schooner.MemCached.NativeHandler;
import com.schooner.MemCached.ObjectTransCoder;
import com.schooner.MemCached.SchoonerSockIO;
import com.schooner.MemCached.SchoonerSockIOPool;
import com.schooner.MemCached.SockInputStream;
import com.schooner.MemCached.SockOutputStream;
import com.schooner.MemCached.TransCoder;
import com.whalin.MemCached.ErrorHandler;
import com.whalin.MemCached.LineInputStream;
import com.whalin.MemCached.MemCachedClient;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;

public class AscIIClient
extends MemCachedClient {
    private TransCoder transCoder = new ObjectTransCoder();
    private SchoonerSockIOPool pool;
    private String poolName;
    private boolean sanitizeKeys;
    private boolean primitiveAsString;
    private boolean compressEnable;
    private long compressThreshold;
    private String defaultEncoding;

    @Override
    public boolean isUseBinaryProtocol() {
        return false;
    }

    public AscIIClient() {
        this((String)null);
    }

    public AscIIClient(String string) {
        super((MemCachedClient)null);
        this.poolName = string;
        this.init();
    }

    public AscIIClient(String string, ClassLoader classLoader, ErrorHandler errorHandler) {
        super((MemCachedClient)null);
        this.poolName = string;
        this.classLoader = classLoader;
        this.errorHandler = errorHandler;
        this.init();
    }

    private void init() {
        this.sanitizeKeys = true;
        this.primitiveAsString = false;
        this.compressEnable = false;
        this.compressThreshold = 30720L;
        this.defaultEncoding = "UTF-8";
        this.poolName = this.poolName == null ? "default" : this.poolName;
        this.pool = SchoonerSockIOPool.getInstance(this.poolName);
    }

    @Override
    public boolean keyExists(String string) {
        return this.get(string, null) != null;
    }

    @Override
    public boolean delete(String string) {
        return this.delete(string, null, null);
    }

    @Override
    public boolean delete(String string, Date date) {
        return this.delete(string, null, date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(String string, Integer n, Date date) {
        if (string == null) {
            log.error("null value for key passed to delete()");
            return false;
        }
        try {
            string = this.sanitizeKey(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnDelete(this, unsupportedEncodingException, string);
            }
            log.error("failed to sanitize your key!", (Throwable)unsupportedEncodingException);
            return false;
        }
        SchoonerSockIO schoonerSockIO = this.pool.getSock(string, n);
        if (schoonerSockIO == null) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnDelete(this, new IOException("no socket to server available"), string);
            }
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder("delete ").append(string);
        if (date != null) {
            stringBuilder.append(" " + date.getTime() / 1000L);
        }
        stringBuilder.append("\r\n");
        try {
            schoonerSockIO.write(stringBuilder.toString().getBytes());
            SockInputStream sockInputStream = new SockInputStream(schoonerSockIO, Integer.MAX_VALUE);
            String string2 = sockInputStream.getLine();
            sockInputStream.close();
            if ("DELETED\r\n".equals(string2)) {
                log.debug(new StringBuffer().append("++++ deletion of key: ").append(string).append(" from cache was a success").toString());
                boolean bl = true;
                return bl;
            }
            if ("NOT_FOUND\r\n".equals(string2)) {
                log.debug(new StringBuffer().append("++++ deletion of key: ").append(string).append(" from cache failed as the key was not found").toString());
            } else if (log.isErrorEnabled()) {
                log.error(new StringBuffer().append("++++ error deleting key: ").append(string).toString());
                log.error(new StringBuffer().append("++++ server response: ").append(string2).toString());
            }
        }
        catch (IOException iOException) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnDelete(this, iOException, string);
            }
            if (log.isErrorEnabled()) {
                log.error("++++ exception thrown while writing bytes to server on delete");
                log.error(iOException.getMessage(), (Throwable)iOException);
            }
            try {
                schoonerSockIO.sockets.invalidateObject((Object)schoonerSockIO);
            }
            catch (Exception exception) {
                log.error("++++ failed to close socket : " + schoonerSockIO.toString());
            }
            schoonerSockIO = null;
        }
        finally {
            if (schoonerSockIO != null) {
                schoonerSockIO.close();
                schoonerSockIO = null;
            }
        }
        return false;
    }

    @Override
    public boolean set(String string, Object object) {
        return this.set("set", string, object, null, null, 0L, this.primitiveAsString);
    }

    @Override
    public boolean set(String string, Object object, Integer n) {
        return this.set("set", string, object, null, n, 0L, this.primitiveAsString);
    }

    @Override
    public boolean set(String string, Object object, Date date) {
        return this.set("set", string, object, date, null, 0L, this.primitiveAsString);
    }

    @Override
    public boolean set(String string, Object object, Date date, Integer n) {
        return this.set("set", string, object, date, n, 0L, this.primitiveAsString);
    }

    @Override
    public boolean add(String string, Object object) {
        return this.set("add", string, object, null, null, 0L, this.primitiveAsString);
    }

    @Override
    public boolean add(String string, Object object, Integer n) {
        return this.set("add", string, object, null, n, 0L, this.primitiveAsString);
    }

    @Override
    public boolean add(String string, Object object, Date date) {
        return this.set("add", string, object, date, null, 0L, this.primitiveAsString);
    }

    @Override
    public boolean add(String string, Object object, Date date, Integer n) {
        return this.set("add", string, object, date, n, 0L, this.primitiveAsString);
    }

    @Override
    public boolean append(String string, Object object, Integer n) {
        return this.set("append", string, object, null, n, 0L, this.primitiveAsString);
    }

    @Override
    public boolean append(String string, Object object) {
        return this.set("append", string, object, null, null, 0L, this.primitiveAsString);
    }

    @Override
    public boolean cas(String string, Object object, Integer n, long l) {
        return this.set("cas", string, object, null, n, l, this.primitiveAsString);
    }

    @Override
    public boolean cas(String string, Object object, Date date, long l) {
        return this.set("cas", string, object, date, null, l, this.primitiveAsString);
    }

    @Override
    public boolean cas(String string, Object object, Date date, Integer n, long l) {
        return this.set("cas", string, object, date, n, l, this.primitiveAsString);
    }

    @Override
    public boolean cas(String string, Object object, long l) {
        return this.set("cas", string, object, null, null, l, this.primitiveAsString);
    }

    @Override
    public boolean prepend(String string, Object object, Integer n) {
        return this.set("prepend", string, object, null, n, 0L, this.primitiveAsString);
    }

    @Override
    public boolean prepend(String string, Object object) {
        return this.set("prepend", string, object, null, null, 0L, this.primitiveAsString);
    }

    @Override
    public boolean replace(String string, Object object) {
        return this.set("replace", string, object, null, null, 0L, this.primitiveAsString);
    }

    @Override
    public boolean replace(String string, Object object, Integer n) {
        return this.set("replace", string, object, null, n, 0L, this.primitiveAsString);
    }

    @Override
    public boolean replace(String string, Object object, Date date) {
        return this.set("replace", string, object, date, null, 0L, this.primitiveAsString);
    }

    @Override
    public boolean replace(String string, Object object, Date date, Integer n) {
        return this.set("replace", string, object, date, n, 0L, this.primitiveAsString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean set(String string, String string2, Object object, Date date, Integer n, Long l, boolean bl) {
        if (string == null || string2 == null) {
            log.error("key is null or cmd is null/empty for set()");
            return false;
        }
        try {
            string2 = this.sanitizeKey(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnSet(this, unsupportedEncodingException, string2);
            }
            log.error("failed to sanitize your key!", (Throwable)unsupportedEncodingException);
            return false;
        }
        if (object == null) {
            log.error("trying to store a null value to cache");
            return false;
        }
        SchoonerSockIO schoonerSockIO = this.pool.getSock(string2, n);
        if (schoonerSockIO == null) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnSet(this, new IOException("no socket to server available"), string2);
            }
            return false;
        }
        if (date == null) {
            date = new Date(0L);
        }
        int n2 = bl ? 32 : NativeHandler.getMarkerFlag(object);
        String string3 = new StringBuffer().append(string).append(" ").append(string2).append(" ").append(n2).append(" ").append(date.getTime() / 1000L).append(" ").toString();
        try {
            byte[] byArray;
            schoonerSockIO.writeBuf.clear();
            schoonerSockIO.writeBuf.put(string3.getBytes());
            int n3 = schoonerSockIO.writeBuf.position();
            schoonerSockIO.writeBuf.put(this.BLAND_DATA_SIZE);
            if (l != 0L) {
                schoonerSockIO.writeBuf.put((" " + l.toString()).getBytes());
            }
            schoonerSockIO.writeBuf.put(B_RETURN);
            SockOutputStream sockOutputStream = new SockOutputStream(schoonerSockIO);
            int n4 = 0;
            if (n2 != 0) {
                byArray = bl ? object.toString().getBytes(this.defaultEncoding) : NativeHandler.encode(object);
                sockOutputStream.write(byArray);
                n4 = byArray.length;
            } else {
                n4 = this.transCoder.encode(sockOutputStream, object);
            }
            schoonerSockIO.writeBuf.put(B_RETURN);
            byArray = new Integer(n4).toString().getBytes();
            int n5 = schoonerSockIO.writeBuf.position();
            schoonerSockIO.writeBuf.position(n3);
            schoonerSockIO.writeBuf.put(byArray);
            schoonerSockIO.writeBuf.position(n5);
            schoonerSockIO.flush();
            SockInputStream sockInputStream = new SockInputStream(schoonerSockIO, Integer.MAX_VALUE);
            String string4 = sockInputStream.getLine();
            sockInputStream.close();
            if ("STORED\r\n".equals(string4)) {
                boolean bl2 = true;
                return bl2;
            }
        }
        catch (Exception exception) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnSet(this, exception, string2);
            }
            if (log.isErrorEnabled()) {
                log.error("++++ exception thrown while writing bytes to server on set");
                log.error(exception.getMessage(), (Throwable)exception);
            }
            try {
                schoonerSockIO.sockets.invalidateObject((Object)schoonerSockIO);
            }
            catch (Exception exception2) {
                log.error("++++ failed to close socket : " + schoonerSockIO.toString());
            }
            schoonerSockIO = null;
        }
        finally {
            if (schoonerSockIO != null) {
                schoonerSockIO.close();
                schoonerSockIO = null;
            }
        }
        return false;
    }

    @Override
    public long addOrIncr(String string) {
        return this.addOrIncr(string, 0L, null);
    }

    @Override
    public long addOrIncr(String string, long l) {
        return this.addOrIncr(string, l, null);
    }

    @Override
    public long addOrIncr(String string, long l, Integer n) {
        boolean bl = this.add(string, (Object)("" + l), n);
        if (bl) {
            return l;
        }
        return this.incrdecr("incr", string, l, n);
    }

    @Override
    public long addOrDecr(String string) {
        return this.addOrDecr(string, 0L, null);
    }

    @Override
    public long addOrDecr(String string, long l) {
        return this.addOrDecr(string, l, null);
    }

    @Override
    public long addOrDecr(String string, long l, Integer n) {
        boolean bl = this.add(string, (Object)("" + l), n);
        if (bl) {
            return l;
        }
        return this.incrdecr("decr", string, l, n);
    }

    @Override
    public long incr(String string) {
        return this.incrdecr("incr", string, 1L, null);
    }

    @Override
    public long incr(String string, long l) {
        return this.incrdecr("incr", string, l, null);
    }

    @Override
    public long incr(String string, long l, Integer n) {
        return this.incrdecr("incr", string, l, n);
    }

    @Override
    public long decr(String string) {
        return this.incrdecr("decr", string, 1L, null);
    }

    @Override
    public long decr(String string, long l) {
        return this.incrdecr("decr", string, l, null);
    }

    @Override
    public long decr(String string, long l, Integer n) {
        return this.incrdecr("decr", string, l, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long incrdecr(String string, String string2, long l, Integer n) {
        if (string2 == null) {
            log.error("null key for incrdecr()");
            return -1L;
        }
        try {
            string2 = this.sanitizeKey(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)unsupportedEncodingException, string2);
            }
            log.error("failed to sanitize your key!", (Throwable)unsupportedEncodingException);
            return -1L;
        }
        SchoonerSockIO schoonerSockIO = this.pool.getSock(string2, n);
        if (schoonerSockIO == null) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnSet(this, new IOException("no socket to server available"), string2);
            }
            return -1L;
        }
        try {
            String string3 = new StringBuffer().append(string).append(" ").append(string2).append(" ").append(l).append("\r\n").toString();
            schoonerSockIO.write(string3.getBytes());
            SockInputStream sockInputStream = new SockInputStream(schoonerSockIO, Integer.MAX_VALUE);
            String string4 = sockInputStream.getLine().split("\r\n")[0];
            sockInputStream.close();
            if (string4.matches("\\d+")) {
                long l2 = Long.parseLong(string4);
                return l2;
            }
            if ("NOT_FOUND\r\n".equals(string4 + "\r\n")) {
                log.info(new StringBuffer().append("++++ key not found to incr/decr for key: ").append(string2).toString());
            } else if (log.isErrorEnabled()) {
                log.error(new StringBuffer().append("++++ error incr/decr key: ").append(string2).toString());
                log.error(new StringBuffer().append("++++ server response: ").append(string4).toString());
            }
        }
        catch (Exception exception) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)exception, string2);
            }
            if (log.isErrorEnabled()) {
                log.error("++++ exception thrown while writing bytes to server on incr/decr");
                log.error(exception.getMessage(), (Throwable)exception);
            }
            try {
                schoonerSockIO.sockets.invalidateObject((Object)schoonerSockIO);
            }
            catch (Exception exception2) {
                log.error("++++ failed to close socket : " + schoonerSockIO.toString());
            }
            schoonerSockIO = null;
        }
        finally {
            if (schoonerSockIO != null) {
                schoonerSockIO.close();
                schoonerSockIO = null;
            }
        }
        return -1L;
    }

    @Override
    public Object get(String string) {
        return this.get(string, null);
    }

    @Override
    public Object get(String string, Integer n) {
        return this.get("get", string, n, false);
    }

    @Override
    public MemcachedItem gets(String string) {
        return this.gets(string, null);
    }

    @Override
    public MemcachedItem gets(String string, Integer n) {
        return this.gets("gets", string, n, false);
    }

    @Override
    public Object get(String string, Integer n, boolean bl) {
        return this.get("get", string, n, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object get(String string, String string2, Integer n, boolean bl) {
        if (string2 == null) {
            log.error("key is null for get()");
            return null;
        }
        try {
            string2 = this.sanitizeKey(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.error("failed to sanitize your key!", (Throwable)unsupportedEncodingException);
            return null;
        }
        SchoonerSockIO schoonerSockIO = this.pool.getSock(string2, n);
        if (schoonerSockIO == null) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)new IOException("no socket to server available"), string2);
            }
            return null;
        }
        String string3 = string + " " + string2;
        try {
            Object object;
            schoonerSockIO.writeBuf.clear();
            schoonerSockIO.writeBuf.put(string3.getBytes());
            schoonerSockIO.writeBuf.put(B_RETURN);
            schoonerSockIO.flush();
            int n2 = 0;
            int n3 = 0;
            SockInputStream sockInputStream = new SockInputStream(schoonerSockIO, Integer.MAX_VALUE);
            boolean bl2 = false;
            StringBuffer stringBuffer = new StringBuffer();
            int n4 = 0;
            while (!bl2) {
                int n5 = sockInputStream.read();
                if (n5 == 32 || n5 == 13) {
                    switch (n4) {
                        case 0: {
                            if ("END\r\n".startsWith(stringBuffer.toString())) {
                                Object var14_17 = null;
                                return var14_17;
                            }
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            n3 = Integer.parseInt(stringBuffer.toString());
                            break;
                        }
                        case 3: {
                            n2 = Integer.parseInt(stringBuffer.toString());
                        }
                    }
                    ++n4;
                    stringBuffer = new StringBuffer();
                    if (n5 != 13) continue;
                    sockInputStream.read();
                    bl2 = true;
                    continue;
                }
                stringBuffer.append((char)n5);
            }
            Object object2 = null;
            sockInputStream.willRead(n2);
            if (n2 > 0) {
                if (NativeHandler.isHandled(n3)) {
                    object = sockInputStream.getBuffer();
                    if ((n3 & 2) == 2) {
                        int n6;
                        GZIPInputStream gZIPInputStream = new GZIPInputStream(new ByteArrayInputStream((byte[])object));
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(((byte[])object).length);
                        byte[] byArray = new byte[2048];
                        while ((n6 = gZIPInputStream.read(byArray)) != -1) {
                            byteArrayOutputStream.write(byArray, 0, n6);
                        }
                        object = byteArrayOutputStream.toByteArray();
                        gZIPInputStream.close();
                    }
                    object2 = this.primitiveAsString || bl ? new String((byte[])object, this.defaultEncoding) : NativeHandler.decode(object, n3);
                } else if (this.transCoder != null) {
                    object = sockInputStream;
                    if ((n3 & 2) == 2) {
                        object = new GZIPInputStream((InputStream)object);
                    }
                    object2 = this.classLoader == null ? this.transCoder.decode((InputStream)object) : ((ObjectTransCoder)this.transCoder).decode((InputStream)object, this.classLoader);
                }
            }
            sockInputStream.willRead(Integer.MAX_VALUE);
            sockInputStream.getLine();
            sockInputStream.getLine();
            object = object2;
            return object;
        }
        catch (Exception exception) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)exception, string2);
            }
            if (log.isErrorEnabled()) {
                log.error("++++ exception thrown while trying to get object from cache for key: " + string2);
                log.error(exception.getMessage(), (Throwable)exception);
            }
            try {
                schoonerSockIO.sockets.invalidateObject((Object)schoonerSockIO);
            }
            catch (Exception exception2) {
                log.error("++++ failed to close socket : " + schoonerSockIO.toString());
            }
            schoonerSockIO = null;
        }
        finally {
            if (schoonerSockIO != null) {
                schoonerSockIO.close();
                schoonerSockIO = null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemcachedItem gets(String string, String string2, Integer n, boolean bl) {
        if (string2 == null) {
            log.error("key is null for get()");
            return null;
        }
        try {
            string2 = this.sanitizeKey(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.error("failed to sanitize your key!", (Throwable)unsupportedEncodingException);
            return null;
        }
        SchoonerSockIO schoonerSockIO = this.pool.getSock(string2, n);
        if (schoonerSockIO == null) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)new IOException("no socket to server available"), string2);
            }
            return null;
        }
        String string3 = string + " " + string2;
        try {
            Object object;
            schoonerSockIO.writeBuf.clear();
            schoonerSockIO.writeBuf.put(string3.getBytes());
            schoonerSockIO.writeBuf.put(B_RETURN);
            schoonerSockIO.flush();
            int n2 = 0;
            int n3 = 0;
            MemcachedItem memcachedItem = new MemcachedItem();
            SockInputStream sockInputStream = new SockInputStream(schoonerSockIO, Integer.MAX_VALUE);
            boolean bl2 = false;
            StringBuffer stringBuffer = new StringBuffer();
            int n4 = 0;
            while (!bl2) {
                int n5 = sockInputStream.read();
                if (n5 == 32 || n5 == 13) {
                    switch (n4) {
                        case 0: {
                            if ("END\r\n".startsWith(stringBuffer.toString())) {
                                MemcachedItem memcachedItem2 = null;
                                return memcachedItem2;
                            }
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            n3 = Integer.parseInt(stringBuffer.toString());
                            break;
                        }
                        case 3: {
                            n2 = Integer.parseInt(stringBuffer.toString());
                            break;
                        }
                        case 4: {
                            if (!string.equals("gets")) break;
                            memcachedItem.casUnique = Long.parseLong(stringBuffer.toString());
                        }
                    }
                    ++n4;
                    stringBuffer = new StringBuffer();
                    if (n5 != 13) continue;
                    sockInputStream.read();
                    bl2 = true;
                    continue;
                }
                stringBuffer.append((char)n5);
            }
            Object object2 = null;
            sockInputStream.willRead(n2);
            if (n2 > 0) {
                if (NativeHandler.isHandled(n3)) {
                    object = sockInputStream.getBuffer();
                    if ((n3 & 2) == 2) {
                        int n6;
                        GZIPInputStream gZIPInputStream = new GZIPInputStream(new ByteArrayInputStream((byte[])object));
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(((byte[])object).length);
                        byte[] byArray = new byte[2048];
                        while ((n6 = gZIPInputStream.read(byArray)) != -1) {
                            byteArrayOutputStream.write(byArray, 0, n6);
                        }
                        object = byteArrayOutputStream.toByteArray();
                        gZIPInputStream.close();
                    }
                    object2 = this.primitiveAsString || bl ? new String((byte[])object, this.defaultEncoding) : NativeHandler.decode(object, n3);
                } else if (this.transCoder != null) {
                    object = sockInputStream;
                    if ((n3 & 2) == 2) {
                        object = new GZIPInputStream((InputStream)object);
                    }
                    object2 = this.transCoder.decode((InputStream)object);
                }
            }
            memcachedItem.value = object2;
            sockInputStream.willRead(Integer.MAX_VALUE);
            sockInputStream.getLine();
            sockInputStream.getLine();
            object = memcachedItem;
            return object;
        }
        catch (Exception exception) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)exception, string2);
            }
            if (log.isErrorEnabled()) {
                log.error("++++ exception thrown while trying to get object from cache for key: " + string2);
                log.error(exception.getMessage(), (Throwable)exception);
            }
            try {
                schoonerSockIO.sockets.invalidateObject((Object)schoonerSockIO);
            }
            catch (Exception exception2) {
                log.error("++++ failed to close socket : " + schoonerSockIO.toString());
            }
            schoonerSockIO = null;
        }
        finally {
            if (schoonerSockIO != null) {
                schoonerSockIO.close();
                schoonerSockIO = null;
            }
        }
        return null;
    }

    @Override
    public void setTransCoder(TransCoder transCoder) {
        this.transCoder = transCoder;
    }

    @Override
    public Object[] getMultiArray(String[] stringArray) {
        return this.getMultiArray(stringArray, null);
    }

    @Override
    public Object[] getMultiArray(String[] stringArray, Integer[] integerArray) {
        Map<String, Object> map = this.getMulti(stringArray, integerArray);
        if (map == null) {
            return null;
        }
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i] = map.get(stringArray[i]);
        }
        return objectArray;
    }

    @Override
    public Object[] getMultiArray(String[] stringArray, Integer[] integerArray, boolean bl) {
        Map<String, Object> map = this.getMulti(stringArray, integerArray, bl);
        if (map == null) {
            return null;
        }
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i] = map.get(stringArray[i]);
        }
        return objectArray;
    }

    @Override
    public Map<String, Object> getMulti(String[] stringArray) {
        return this.getMulti(stringArray, null);
    }

    @Override
    public Map<String, Object> getMulti(String[] stringArray, Integer[] integerArray) {
        return this.getMulti(stringArray, integerArray, false);
    }

    @Override
    public Map<String, Object> getMulti(String[] stringArray, Integer[] integerArray, boolean bl) {
        if (stringArray == null || stringArray.length == 0) {
            log.error("missing keys for getMulti()");
            return null;
        }
        HashMap<String, StringBuilder> hashMap = new HashMap<String, StringBuilder>();
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string == null) {
                log.error("null key, so skipping");
                continue;
            }
            Integer n = null;
            if (integerArray != null && integerArray.length > i) {
                n = integerArray[i];
            }
            stringArray2[i] = string;
            try {
                stringArray2[i] = this.sanitizeKey(string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)unsupportedEncodingException, string);
                }
                log.error("failed to sanitize your key!", (Throwable)unsupportedEncodingException);
                continue;
            }
            SchoonerSockIO schoonerSockIO = this.pool.getSock(stringArray2[i], n);
            if (schoonerSockIO == null) {
                if (this.errorHandler == null) continue;
                this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)new IOException("no socket to server available"), string);
                continue;
            }
            if (!hashMap.containsKey(schoonerSockIO.getHost())) {
                hashMap.put(schoonerSockIO.getHost(), new StringBuilder("get"));
            }
            ((StringBuilder)hashMap.get(schoonerSockIO.getHost())).append(" " + stringArray2[i]);
            schoonerSockIO.close();
        }
        log.debug("multi get socket count : " + hashMap.size());
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>(stringArray.length);
        new NIOLoader(this).doMulti(bl, hashMap, stringArray, hashMap2);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(stringArray2[i]) || !hashMap2.containsKey(stringArray2[i])) continue;
            hashMap2.put(stringArray[i], hashMap2.get(stringArray2[i]));
            hashMap2.remove(stringArray2[i]);
        }
        log.debug("++++ memcache: got back " + hashMap2.size() + " results");
        return hashMap2;
    }

    private void loadMulti(LineInputStream lineInputStream, Map<String, Object> map, boolean bl) throws IOException {
        while (true) {
            String string;
            if ((string = lineInputStream.readLine()).startsWith("VALUE")) {
                String[] stringArray = string.split(" ");
                String string2 = stringArray[1];
                int n = Integer.parseInt(stringArray[2]);
                int n2 = Integer.parseInt(stringArray[3]);
                byte[] byArray = new byte[n2];
                lineInputStream.read(byArray);
                lineInputStream.clearEOL();
                Object object = null;
                if ((n & 2) == 2) {
                    int n3;
                    GZIPInputStream gZIPInputStream = new GZIPInputStream(new ByteArrayInputStream(byArray));
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
                    byte[] byArray2 = new byte[2048];
                    while ((n3 = gZIPInputStream.read(byArray2)) != -1) {
                        byteArrayOutputStream.write(byArray2, 0, n3);
                    }
                    byArray = byteArrayOutputStream.toByteArray();
                    gZIPInputStream.close();
                }
                if (n != 0) {
                    if (this.primitiveAsString || bl) {
                        object = new String(byArray, this.defaultEncoding);
                    } else {
                        try {
                            object = NativeHandler.decode(byArray, n);
                        }
                        catch (Exception exception) {
                            log.error("++++ Exception thrown while trying to deserialize for key: " + string2 + " -- " + exception.getMessage());
                            exception.printStackTrace();
                        }
                    }
                } else if (this.transCoder != null) {
                    object = this.transCoder.decode(new ByteArrayInputStream(byArray));
                }
                map.put(string2, object);
                continue;
            }
            if ("END\r\n".equals(string)) break;
        }
    }

    @Override
    public boolean flushAll() {
        return this.flushAll(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean flushAll(String[] stringArray) {
        if (this.pool == null) {
            log.error("++++ unable to get SockIOPool instance");
            return false;
        }
        String[] stringArray2 = stringArray = stringArray == null ? this.pool.getServers() : stringArray;
        if (stringArray == null || stringArray.length <= 0) {
            log.error("++++ no servers to flush");
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            SchoonerSockIO schoonerSockIO = this.pool.getConnection(stringArray[i]);
            if (schoonerSockIO == null) {
                log.error("++++ unable to get connection to : " + stringArray[i]);
                bl = false;
                if (this.errorHandler == null) continue;
                this.errorHandler.handleErrorOnFlush(this, new IOException("no socket to server available"));
                continue;
            }
            String string = "flush_all\r\n";
            try {
                schoonerSockIO.write(string.getBytes());
                SockInputStream sockInputStream = new SockInputStream(schoonerSockIO, Integer.MAX_VALUE);
                String string2 = sockInputStream.getLine();
                sockInputStream.close();
                bl = "OK\r\n".equals(string2) ? bl : false;
                continue;
            }
            catch (IOException iOException) {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnFlush(this, iOException);
                }
                if (log.isErrorEnabled()) {
                    log.error("++++ exception thrown while writing bytes to server on flushAll");
                    log.error(iOException.getMessage(), (Throwable)iOException);
                }
                try {
                    schoonerSockIO.sockets.invalidateObject((Object)schoonerSockIO);
                }
                catch (Exception exception) {
                    log.error("++++ failed to close socket : " + schoonerSockIO.toString());
                }
                bl = false;
                schoonerSockIO = null;
                continue;
            }
            finally {
                if (schoonerSockIO != null) {
                    schoonerSockIO.close();
                    schoonerSockIO = null;
                }
            }
        }
        return bl;
    }

    @Override
    public Map<String, Map<String, String>> stats() {
        return this.stats(null);
    }

    @Override
    public Map<String, Map<String, String>> stats(String[] stringArray) {
        return this.stats(stringArray, "stats\r\n", "STAT");
    }

    @Override
    public Map<String, Map<String, String>> statsItems() {
        return this.statsItems(null);
    }

    @Override
    public Map<String, Map<String, String>> statsItems(String[] stringArray) {
        return this.stats(stringArray, "stats items\r\n", "STAT");
    }

    @Override
    public Map<String, Map<String, String>> statsSlabs() {
        return this.statsSlabs(null);
    }

    @Override
    public Map<String, Map<String, String>> statsSlabs(String[] stringArray) {
        return this.stats(stringArray, "stats slabs\r\n", "STAT");
    }

    @Override
    public Map<String, Map<String, String>> statsCacheDump(int n, int n2) {
        return this.statsCacheDump(null, n, n2);
    }

    @Override
    public Map<String, Map<String, String>> statsCacheDump(String[] stringArray, int n, int n2) {
        return this.stats(stringArray, String.format("stats cachedump %d %d\r\n", n, n2), "ITEM");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, String>> stats(String[] stringArray, String string, String string2) {
        if (string == null || string.trim().equals("")) {
            log.error("++++ invalid / missing command for stats()");
            return null;
        }
        String[] stringArray2 = stringArray = stringArray == null ? this.pool.getServers() : stringArray;
        if (stringArray == null || stringArray.length <= 0) {
            log.error("++++ no servers to check stats");
            return null;
        }
        HashMap<String, Map<String, String>> hashMap = new HashMap<String, Map<String, String>>();
        for (int i = 0; i < stringArray.length; ++i) {
            SchoonerSockIO schoonerSockIO = this.pool.getConnection(stringArray[i]);
            if (schoonerSockIO == null) {
                if (this.errorHandler == null) continue;
                this.errorHandler.handleErrorOnStats(this, new IOException("no socket to server available"));
                continue;
            }
            try {
                String string3;
                schoonerSockIO.write(string.getBytes());
                HashMap<String, String> hashMap2 = new HashMap<String, String>();
                SockInputStream sockInputStream = new SockInputStream(schoonerSockIO, Integer.MAX_VALUE);
                while ((string3 = sockInputStream.getLine()) != null) {
                    if (string3.startsWith(string2)) {
                        String[] stringArray3 = string3.split(" ", 3);
                        String string4 = stringArray3.length > 1 ? stringArray3[1] : null;
                        String string5 = stringArray3.length > 2 ? stringArray3[2] : null;
                        hashMap2.put(string4, string5);
                    } else {
                        if ("END\r\n".equals(string3)) break;
                        if (string3.startsWith("ERROR\r\n") || string3.startsWith("CLIENT_ERROR\r\n") || string3.startsWith("SERVER_ERROR\r\n")) {
                            if (!log.isErrorEnabled()) break;
                            log.error("++++ failed to query stats");
                            log.error("++++ server response: " + string3);
                            break;
                        }
                    }
                    hashMap.put(stringArray[i], hashMap2);
                }
                sockInputStream.close();
                continue;
            }
            catch (Exception exception) {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnStats(this, exception);
                }
                if (log.isErrorEnabled()) {
                    log.error("++++ exception thrown while writing bytes to server on stats");
                    log.error(exception.getMessage(), (Throwable)exception);
                }
                try {
                    schoonerSockIO.sockets.invalidateObject((Object)schoonerSockIO);
                }
                catch (Exception exception2) {
                    log.error("++++ failed to close socket : " + schoonerSockIO.toString());
                }
                schoonerSockIO = null;
                continue;
            }
            finally {
                if (schoonerSockIO != null) {
                    schoonerSockIO.close();
                    schoonerSockIO = null;
                }
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sync(String string, Integer n) {
        if (string == null) {
            log.error("null value for key passed to sync()");
            return false;
        }
        SchoonerSockIO schoonerSockIO = this.pool.getSock(string, n);
        if (schoonerSockIO == null) {
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder("sync ").append(string);
        stringBuilder.append("\r\n");
        try {
            schoonerSockIO.write(stringBuilder.toString().getBytes());
            SockInputStream sockInputStream = new SockInputStream(schoonerSockIO, Integer.MAX_VALUE);
            String string2 = sockInputStream.getLine();
            sockInputStream.close();
            if ("SYNCED\r\n".equals(string2)) {
                log.info(new StringBuffer().append("++++ sync of key: ").append(string).append(" from cache was a success").toString());
                boolean bl = true;
                return bl;
            }
            if ("NOT_FOUND\r\n".equals(string2)) {
                log.info(new StringBuffer().append("++++ sync of key: ").append(string).append(" from cache failed as the key was not found").toString());
            } else if (log.isErrorEnabled()) {
                log.error(new StringBuffer().append("++++ error sync key: ").append(string).toString());
                log.error(new StringBuffer().append("++++ server response: ").append(string2).toString());
            }
        }
        catch (IOException iOException) {
            if (log.isErrorEnabled()) {
                log.error("++++ exception thrown while writing bytes to server on delete");
                log.error(iOException.getMessage(), (Throwable)iOException);
            }
            try {
                schoonerSockIO.sockets.invalidateObject((Object)schoonerSockIO);
            }
            catch (Exception exception) {
                log.error("++++ failed to close socket : " + schoonerSockIO.toString(), (Throwable)exception);
            }
            schoonerSockIO = null;
        }
        finally {
            if (schoonerSockIO != null) {
                schoonerSockIO.close();
                schoonerSockIO = null;
            }
        }
        return false;
    }

    @Override
    public boolean sync(String string) {
        return this.sync(string, null);
    }

    @Override
    public boolean syncAll() {
        return this.syncAll(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean syncAll(String[] stringArray) {
        if (this.pool == null) {
            log.error("++++ unable to get SockIOPool instance");
            return false;
        }
        String[] stringArray2 = stringArray = stringArray == null ? this.pool.getServers() : stringArray;
        if (stringArray == null || stringArray.length <= 0) {
            log.error("++++ no servers to sync");
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            SchoonerSockIO schoonerSockIO = this.pool.getConnection(stringArray[i]);
            if (schoonerSockIO == null) {
                log.error("++++ unable to get connection to : " + stringArray[i]);
                bl = false;
                continue;
            }
            String string = "sync_all\r\n";
            try {
                schoonerSockIO.write(string.getBytes());
                SockInputStream sockInputStream = new SockInputStream(schoonerSockIO, Integer.MAX_VALUE);
                String string2 = sockInputStream.getLine();
                sockInputStream.close();
                bl = "SYNCED\r\n".equals(string2) ? bl : false;
                continue;
            }
            catch (IOException iOException) {
                if (log.isErrorEnabled()) {
                    log.error("++++ exception thrown while writing bytes to server on flushAll");
                    log.error(iOException.getMessage(), (Throwable)iOException);
                }
                try {
                    schoonerSockIO.sockets.invalidateObject((Object)schoonerSockIO);
                }
                catch (Exception exception) {
                    log.error("++++ failed to close socket : " + schoonerSockIO.toString(), (Throwable)exception);
                }
                bl = false;
                schoonerSockIO = null;
                continue;
            }
            finally {
                if (schoonerSockIO != null) {
                    schoonerSockIO.close();
                    schoonerSockIO = null;
                }
            }
        }
        return bl;
    }

    @Override
    public void setDefaultEncoding(String string) {
        this.defaultEncoding = string;
    }

    @Override
    public void setPrimitiveAsString(boolean bl) {
        this.primitiveAsString = bl;
    }

    @Override
    public void setSanitizeKeys(boolean bl) {
        this.sanitizeKeys = bl;
    }

    private String sanitizeKey(String string) throws UnsupportedEncodingException {
        return this.sanitizeKeys ? URLEncoder.encode(string, "UTF-8") : string;
    }

    protected final class NIOLoader {
        protected Selector selector;
        protected int numConns = 0;
        protected AscIIClient mc;
        protected Connection[] conns;

        public NIOLoader(AscIIClient ascIIClient2) {
            this.mc = ascIIClient2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doMulti(boolean bl, Map<String, StringBuilder> map, String[] stringArray, Map<String, Object> map2) {
            long l = 0L;
            try {
                long l2;
                this.selector = Selector.open();
                this.conns = new Connection[map.keySet().size()];
                this.numConns = 0;
                for (String connectionArray : map.keySet()) {
                    SchoonerSockIO schoonerSockIO = AscIIClient.this.pool.getConnection(connectionArray);
                    if (schoonerSockIO == null) {
                        if (AscIIClient.this.errorHandler != null) {
                            AscIIClient.this.errorHandler.handleErrorOnGet((MemCachedClient)this.mc, (Throwable)new IOException("no socket to server available"), stringArray);
                        }
                        return;
                    }
                    this.conns[this.numConns++] = new Connection(schoonerSockIO, map.get(connectionArray));
                }
                long l3 = System.currentTimeMillis();
                l = l2 = AscIIClient.this.pool.getMaxBusy();
                while (this.numConns > 0 && l > 0L) {
                    int n = this.selector.select(Math.min(l2, 5000L));
                    if (n > 0) {
                        Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
                        while (iterator.hasNext()) {
                            SelectionKey selectionKey = iterator.next();
                            iterator.remove();
                            this.handleKey(selectionKey);
                        }
                    } else {
                        MemCachedClient.log.error("selector timed out waiting for activity");
                    }
                    l = l2 - (System.currentTimeMillis() - l3);
                }
            }
            catch (IOException iOException) {
                return;
            }
            finally {
                MemCachedClient.log.debug("Disconnecting; numConns=" + this.numConns + "  timeRemaining=" + l);
                try {
                    if (this.selector != null) {
                        this.selector.close();
                    }
                }
                catch (IOException iOException) {}
                for (Connection connection : this.conns) {
                    if (connection == null) continue;
                    connection.close();
                }
            }
            for (Connection connection : this.conns) {
                try {
                    if (connection.incoming.size() <= 0 || !connection.isDone()) continue;
                    AscIIClient.this.loadMulti(new ByteBufArrayInputStream(connection.incoming), map2, bl);
                }
                catch (Exception exception) {
                    MemCachedClient.log.debug("Caught the aforementioned exception on " + connection);
                }
            }
        }

        public void doMulti(Map<String, StringBuilder> map, String[] stringArray, Map<String, Object> map2) {
            this.doMulti(false, map, stringArray, map2);
        }

        private void handleKey(SelectionKey selectionKey) throws IOException {
            if (selectionKey.isReadable()) {
                this.readResponse(selectionKey);
            } else if (selectionKey.isWritable()) {
                this.writeRequest(selectionKey);
            }
        }

        public void writeRequest(SelectionKey selectionKey) throws IOException {
            ByteBuffer byteBuffer = ((Connection)selectionKey.attachment()).outgoing;
            SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
            if (byteBuffer.hasRemaining()) {
                socketChannel.write(byteBuffer);
            }
            if (!byteBuffer.hasRemaining()) {
                selectionKey.interestOps(1);
            }
        }

        public void readResponse(SelectionKey selectionKey) throws IOException {
            Connection connection = (Connection)selectionKey.attachment();
            ByteBuffer byteBuffer = connection.getBuffer();
            int n = connection.channel.read(byteBuffer);
            if (n > 0 && connection.isDone()) {
                selectionKey.cancel();
                --this.numConns;
                return;
            }
        }

        private final class Connection {
            public List<ByteBuffer> incoming = new ArrayList<ByteBuffer>();
            public ByteBuffer outgoing;
            public SchoonerSockIO sock;
            public SocketChannel channel;
            private boolean isDone = false;

            public Connection(SchoonerSockIO schoonerSockIO, StringBuilder stringBuilder) throws IOException {
                this.sock = schoonerSockIO;
                this.outgoing = ByteBuffer.wrap(stringBuilder.append("\r\n").toString().getBytes());
                this.channel = schoonerSockIO.getChannel();
                if (this.channel == null) {
                    throw new IOException("dead connection to: " + schoonerSockIO.getHost());
                }
                this.channel.configureBlocking(false);
                this.channel.register(NIOLoader.this.selector, 4, this);
            }

            public void close() {
                try {
                    if (this.isDone) {
                        this.channel.configureBlocking(true);
                        this.sock.close();
                        return;
                    }
                }
                catch (IOException iOException) {
                    MemCachedClient.log.warn("++++ memcache: unexpected error closing normally", (Throwable)iOException);
                }
                try {
                    this.sock.sockets.invalidateObject((Object)this.sock);
                }
                catch (Exception exception) {
                    MemCachedClient.log.error("++++ failed to close socket : " + this.sock.toString(), (Throwable)exception);
                }
            }

            public boolean isDone() {
                if (this.isDone) {
                    return true;
                }
                int n = MemCachedClient.B_END.length - 1;
                for (int i = this.incoming.size() - 1; i >= 0 && n >= 0; --i) {
                    ByteBuffer byteBuffer = this.incoming.get(i);
                    int n2 = byteBuffer.position() - 1;
                    while (n2 >= 0 && n >= 0) {
                        if (byteBuffer.get(n2--) == MemCachedClient.B_END[n--]) continue;
                        return false;
                    }
                }
                this.isDone = n < 0;
                return this.isDone;
            }

            public ByteBuffer getBuffer() {
                int n = this.incoming.size() - 1;
                if (n >= 0 && this.incoming.get(n).hasRemaining()) {
                    return this.incoming.get(n);
                }
                ByteBuffer byteBuffer = ByteBuffer.allocate(8192);
                this.incoming.add(byteBuffer);
                return byteBuffer;
            }

            public String toString() {
                return new StringBuffer().append("Connection to ").append(this.sock.getHost()).append(" with ").append(this.incoming.size()).append(" bufs; done is ").append(this.isDone).toString();
            }
        }
    }
}

