/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert;

import de.bytefish.pgbulkinsert.IPgBulkInsert;
import de.bytefish.pgbulkinsert.exceptions.SaveEntityFailedException;
import de.bytefish.pgbulkinsert.functional.Action2;
import de.bytefish.pgbulkinsert.functional.Func2;
import de.bytefish.pgbulkinsert.model.ColumnDefinition;
import de.bytefish.pgbulkinsert.model.TableDefinition;
import de.bytefish.pgbulkinsert.pgsql.PgBinaryWriter;
import de.bytefish.pgbulkinsert.pgsql.constants.DataType;
import de.bytefish.pgbulkinsert.pgsql.constants.ObjectIdentifier;
import de.bytefish.pgbulkinsert.pgsql.handlers.CollectionValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.IValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.IValueHandlerProvider;
import de.bytefish.pgbulkinsert.pgsql.handlers.ValueHandlerProvider;
import de.bytefish.pgbulkinsert.pgsql.model.geometric.Box;
import de.bytefish.pgbulkinsert.pgsql.model.geometric.Circle;
import de.bytefish.pgbulkinsert.pgsql.model.geometric.Line;
import de.bytefish.pgbulkinsert.pgsql.model.geometric.LineSegment;
import de.bytefish.pgbulkinsert.pgsql.model.geometric.Path;
import de.bytefish.pgbulkinsert.pgsql.model.geometric.Point;
import de.bytefish.pgbulkinsert.pgsql.model.geometric.Polygon;
import de.bytefish.pgbulkinsert.pgsql.model.network.MacAddress;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.postgresql.PGConnection;
import org.postgresql.copy.CopyIn;
import org.postgresql.copy.CopyManager;
import org.postgresql.copy.PGCopyOutputStream;

public abstract class PgBulkInsert<TEntity>
implements IPgBulkInsert<TEntity> {
    private IValueHandlerProvider provider;
    private TableDefinition table;
    private List<ColumnDefinition<TEntity>> columns;

    public PgBulkInsert(String schemaName, String tableName) {
        this(new ValueHandlerProvider(), schemaName, tableName);
    }

    public PgBulkInsert(IValueHandlerProvider provider, String schemaName, String tableName) {
        this.provider = provider;
        this.table = new TableDefinition(schemaName, tableName);
        this.columns = new ArrayList<ColumnDefinition<TEntity>>();
    }

    @Override
    public void saveAll(PGConnection connection, Stream<TEntity> entities) throws SQLException {
        CopyManager cpManager = connection.getCopyAPI();
        CopyIn copyIn = cpManager.copyIn(this.getCopyCommand());
        try (PgBinaryWriter bw = new PgBinaryWriter();){
            bw.open((OutputStream)new PGCopyOutputStream(copyIn));
            entities.forEach(entity -> this.saveEntity(bw, entity));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveEntity(PgBinaryWriter bw, TEntity entity) throws SaveEntityFailedException {
        PgBinaryWriter pgBinaryWriter = bw;
        synchronized (pgBinaryWriter) {
            bw.startRow(this.columns.size());
            this.columns.forEach(column -> {
                try {
                    column.getWrite().invoke(bw, entity);
                }
                catch (Exception e) {
                    throw new SaveEntityFailedException(e);
                }
            });
        }
    }

    protected <TElementType, TCollectionType extends Collection<TElementType>> void mapCollection(String columnName, DataType dataType, Func2<TEntity, TCollectionType> propertyGetter) {
        IValueHandler valueHandler = this.provider.resolve(dataType);
        int valueOID = ObjectIdentifier.mapFrom(dataType);
        this.map(columnName, new CollectionValueHandler(valueOID, valueHandler), propertyGetter);
    }

    protected <TProperty> void map(String columnName, DataType dataType, Func2<TEntity, TProperty> propertyGetter) {
        IValueHandler valueHandler = this.provider.resolve(dataType);
        this.map(columnName, valueHandler, propertyGetter);
    }

    protected <TProperty> void map(String columnName, IValueHandler<TProperty> valueHandler, Func2<TEntity, TProperty> propertyGetter) {
        this.addColumn(columnName, (binaryWriter, entity) -> binaryWriter.write(valueHandler, propertyGetter.invoke(entity)));
    }

    protected void mapBoolean(String columnName, Func2<TEntity, Boolean> propertyGetter) {
        this.map(columnName, DataType.Boolean, propertyGetter);
    }

    protected void mapByte(String columnName, Func2<TEntity, Byte> propertyGetter) {
        this.map(columnName, DataType.Char, propertyGetter);
    }

    protected void mapSmallInt(String columnName, Func2<TEntity, Short> propertyGetter) {
        this.map(columnName, DataType.Int2, propertyGetter);
    }

    protected void mapInteger(String columnName, Func2<TEntity, Integer> propertyGetter) {
        this.map(columnName, DataType.Int4, propertyGetter);
    }

    protected void mapNumeric(String columnName, Func2<TEntity, BigDecimal> propertyGetter) {
        this.map(columnName, DataType.Numeric, propertyGetter);
    }

    protected void mapLong(String columnName, Func2<TEntity, Long> propertyGetter) {
        this.map(columnName, DataType.Int8, propertyGetter);
    }

    protected void mapReal(String columnName, Func2<TEntity, Float> propertyGetter) {
        this.map(columnName, DataType.SinglePrecision, propertyGetter);
    }

    protected void mapDouble(String columnName, Func2<TEntity, Double> propertyGetter) {
        this.map(columnName, DataType.DoublePrecision, propertyGetter);
    }

    protected void mapDate(String columnName, Func2<TEntity, LocalDate> propertyGetter) {
        this.map(columnName, DataType.Date, propertyGetter);
    }

    protected void mapInet4Addr(String columnName, Func2<TEntity, Inet4Address> propertyGetter) {
        this.map(columnName, DataType.Inet4, propertyGetter);
    }

    protected void mapInet6Addr(String columnName, Func2<TEntity, Inet6Address> propertyGetter) {
        this.map(columnName, DataType.Inet6, propertyGetter);
    }

    protected void mapTimeStamp(String columnName, Func2<TEntity, LocalDateTime> propertyGetter) {
        this.map(columnName, DataType.Timestamp, propertyGetter);
    }

    protected void mapString(String columnName, Func2<TEntity, String> propertyGetter) {
        this.map(columnName, DataType.Text, propertyGetter);
    }

    protected void mapUUID(String columnName, Func2<TEntity, UUID> propertyGetter) {
        this.map(columnName, DataType.Uuid, propertyGetter);
    }

    protected void mapByteArray(String columnName, Func2<TEntity, Byte[]> propertyGetter) {
        this.map(columnName, DataType.Bytea, propertyGetter);
    }

    protected void mapJsonb(String columnName, Func2<TEntity, String> propertyGetter) {
        this.map(columnName, DataType.Jsonb, propertyGetter);
    }

    protected void mapHstore(String columnName, Func2<TEntity, Map<String, String>> propertyGetter) {
        this.map(columnName, DataType.Hstore, propertyGetter);
    }

    protected void mapPoint(String columnName, Func2<TEntity, Point> propertyGetter) {
        this.map(columnName, DataType.Point, propertyGetter);
    }

    protected void mapBox(String columnName, Func2<TEntity, Box> propertyGetter) {
        this.map(columnName, DataType.Box, propertyGetter);
    }

    protected void mapPath(String columnName, Func2<TEntity, Path> propertyGetter) {
        this.map(columnName, DataType.Path, propertyGetter);
    }

    protected void mapPolygon(String columnName, Func2<TEntity, Polygon> propertyGetter) {
        this.map(columnName, DataType.Polygon, propertyGetter);
    }

    protected void mapLine(String columnName, Func2<TEntity, Line> propertyGetter) {
        this.map(columnName, DataType.Line, propertyGetter);
    }

    protected void mapLineSegment(String columnName, Func2<TEntity, LineSegment> propertyGetter) {
        this.map(columnName, DataType.LineSegment, propertyGetter);
    }

    protected void mapCircle(String columnName, Func2<TEntity, Circle> propertyGetter) {
        this.map(columnName, DataType.Circle, propertyGetter);
    }

    protected void mapMacAddress(String columnName, Func2<TEntity, MacAddress> propertyGetter) {
        this.map(columnName, DataType.MacAddress, propertyGetter);
    }

    protected <TCollectionType extends Collection<Boolean>> void mapBooleanArray(String columnName, Func2<TEntity, TCollectionType> propertyGetter) {
        this.mapCollection(columnName, DataType.Boolean, propertyGetter);
    }

    protected <TCollectionType extends Collection<Short>> void mapShortArray(String columnName, Func2<TEntity, TCollectionType> propertyGetter) {
        this.mapCollection(columnName, DataType.Int2, propertyGetter);
    }

    protected <TCollectionType extends Collection<Integer>> void mapIntegerArray(String columnName, Func2<TEntity, TCollectionType> propertyGetter) {
        this.mapCollection(columnName, DataType.Int4, propertyGetter);
    }

    protected <TCollectionType extends Collection<Long>> void mapLongArray(String columnName, Func2<TEntity, TCollectionType> propertyGetter) {
        this.mapCollection(columnName, DataType.Int8, propertyGetter);
    }

    protected <TCollectionType extends Collection<String>> void mapStringArray(String columnName, Func2<TEntity, TCollectionType> propertyGetter) {
        this.mapCollection(columnName, DataType.Text, propertyGetter);
    }

    protected <TCollectionType extends Collection<Float>> void mapFloatArray(String columnName, Func2<TEntity, TCollectionType> propertyGetter) {
        this.mapCollection(columnName, DataType.SinglePrecision, propertyGetter);
    }

    protected <TCollectionType extends Collection<Double>> void mapDoubleArray(String columnName, Func2<TEntity, TCollectionType> propertyGetter) {
        this.mapCollection(columnName, DataType.DoublePrecision, propertyGetter);
    }

    protected <TCollectionType extends Collection<BigDecimal>> void mapNumericArray(String columnName, Func2<TEntity, TCollectionType> propertyGetter) {
        this.mapCollection(columnName, DataType.Numeric, propertyGetter);
    }

    protected <TCollectionType extends Collection<UUID>> void mapUUIDArray(String columnName, Func2<TEntity, TCollectionType> propertyGetter) {
        this.mapCollection(columnName, DataType.Uuid, propertyGetter);
    }

    protected <TCollectionType extends Collection<Inet4Address>> void mapInet4Array(String columnName, Func2<TEntity, TCollectionType> propertyGetter) {
        this.mapCollection(columnName, DataType.Inet4, propertyGetter);
    }

    protected <TCollectionType extends Collection<Inet6Address>> void mapInet6Array(String columnName, Func2<TEntity, TCollectionType> propertyGetter) {
        this.mapCollection(columnName, DataType.Inet6, propertyGetter);
    }

    private PgBulkInsert<TEntity> addColumn(String columnName, Action2<PgBinaryWriter, TEntity> action) {
        this.columns.add(new ColumnDefinition<TEntity>(columnName, action));
        return this;
    }

    private String getCopyCommand() {
        String commaSeparatedColumns = this.columns.stream().map(x -> x.getColumnName()).collect(Collectors.joining(", "));
        return String.format("COPY %1$s(%2$s) FROM STDIN BINARY", this.table.GetFullQualifiedTableName(), commaSeparatedColumns);
    }
}

