/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.pgsql.handlers;

import de.bytefish.pgbulkinsert.pgsql.constants.DataType;
import de.bytefish.pgbulkinsert.pgsql.handlers.BaseValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.utils.GeometricUtils;
import de.bytefish.pgbulkinsert.pgsql.model.geometric.Path;
import de.bytefish.pgbulkinsert.pgsql.model.geometric.Point;
import java.io.DataOutputStream;

public class PathValueHandler
extends BaseValueHandler<Path> {
    @Override
    protected void internalHandle(DataOutputStream buffer, Path value) throws Exception {
        byte pathIsClosed = (byte)(value.isClosed() ? 1 : 0);
        int totalBytesToWrite = 5 + 16 * value.size();
        buffer.writeInt(totalBytesToWrite);
        buffer.writeByte(pathIsClosed);
        buffer.writeInt(value.getPoints().size());
        for (Point p : value.getPoints()) {
            GeometricUtils.writePoint(buffer, p);
        }
    }

    @Override
    public DataType getDataType() {
        return DataType.Path;
    }
}

