/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterAttachable;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import io.dropwizard.logging.AppenderFactory;
import io.dropwizard.logging.AsyncAppender;
import io.dropwizard.logging.DropwizardLayout;
import io.dropwizard.util.Duration;
import io.dropwizard.validation.MinDuration;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public abstract class AbstractAppenderFactory
implements AppenderFactory {
    private boolean bounded;
    @NotNull
    protected Level threshold = Level.ALL;
    protected String logFormat;
    @Min(value=1L)
    @Max(value=0x7FFFFFFFL)
    private int batchSize = 128;
    @NotNull
    @MinDuration(value=1L, unit=TimeUnit.MILLISECONDS)
    private Duration batchDuration = Duration.milliseconds((long)100L);

    @JsonProperty
    public boolean isBounded() {
        return this.bounded;
    }

    @JsonProperty
    public void setBounded(boolean bounded) {
        this.bounded = bounded;
    }

    @JsonProperty
    public int getBatchSize() {
        return this.batchSize;
    }

    @JsonProperty
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @JsonProperty
    public Duration getBatchDuration() {
        return this.batchDuration;
    }

    @JsonProperty
    public void setBatchDuration(Duration batchDuration) {
        this.batchDuration = batchDuration;
    }

    @JsonProperty
    public Level getThreshold() {
        return this.threshold;
    }

    @JsonProperty
    public void setThreshold(Level threshold) {
        this.threshold = threshold;
    }

    @JsonProperty
    public String getLogFormat() {
        return this.logFormat;
    }

    @JsonProperty
    public void setLogFormat(String logFormat) {
        this.logFormat = logFormat;
    }

    protected Appender<ILoggingEvent> wrapAsync(Appender<ILoggingEvent> appender) {
        AsyncAppender asyncAppender = new AsyncAppender(appender, this.batchSize, this.batchDuration, this.bounded);
        asyncAppender.start();
        return asyncAppender;
    }

    protected void addThresholdFilter(FilterAttachable<ILoggingEvent> appender, Level threshold) {
        ThresholdFilter filter = new ThresholdFilter();
        filter.setLevel(threshold.toString());
        filter.start();
        appender.addFilter((Filter)filter);
    }

    protected DropwizardLayout buildLayout(LoggerContext context, TimeZone timeZone) {
        DropwizardLayout formatter = new DropwizardLayout(context, timeZone);
        if (!Strings.isNullOrEmpty((String)this.logFormat)) {
            formatter.setPattern(this.logFormat);
        }
        formatter.start();
        return formatter;
    }
}

