/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.net.SyslogAppender;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.spi.FilterAttachable;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.logging.AbstractAppenderFactory;
import java.lang.management.ManagementFactory;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@JsonTypeName(value="syslog")
public class SyslogAppenderFactory
extends AbstractAppenderFactory {
    private static final String LOG_TOKEN_NAME = "%app";
    private static final String LOG_TOKEN_PID = "%pid";
    private static final Pattern PID_PATTERN = Pattern.compile("(\\d+)@");
    private static String PID = "";
    @NotNull
    private String host = "localhost";
    @Min(value=1L)
    @Max(value=65535L)
    private int port = 514;
    @NotNull
    private Facility facility = Facility.LOCAL0;
    @NotNull
    private String stackTracePrefix = "\t";
    private String logFormat = "%app%pid: [%thread] %logger %msg";
    private boolean includeStackTrace = true;

    @Override
    @JsonProperty
    public String getLogFormat() {
        return this.logFormat;
    }

    @Override
    @JsonProperty
    public void setLogFormat(String logFormat) {
        this.logFormat = logFormat;
    }

    @JsonProperty
    public String getHost() {
        return this.host;
    }

    @JsonProperty
    public void setHost(String host) {
        this.host = host;
    }

    @JsonProperty
    public Facility getFacility() {
        return this.facility;
    }

    @JsonProperty
    public void setFacility(Facility facility) {
        this.facility = facility;
    }

    @JsonProperty
    public int getPort() {
        return this.port;
    }

    @JsonProperty
    public void setPort(int port) {
        this.port = port;
    }

    @JsonProperty
    public boolean getIncludeStackTrace() {
        return this.includeStackTrace;
    }

    @JsonProperty
    public void setIncludeStackTrace(boolean includeStackTrace) {
        this.includeStackTrace = includeStackTrace;
    }

    @JsonProperty
    public String getStackTracePrefix() {
        return this.stackTracePrefix;
    }

    @JsonProperty
    public void setStackTracePrefix(String stackTracePrefix) {
        this.stackTracePrefix = stackTracePrefix;
    }

    @Override
    public Appender<ILoggingEvent> build(LoggerContext context, String applicationName, Layout<ILoggingEvent> layout) {
        SyslogAppender appender = new SyslogAppender();
        appender.setName("syslog-appender");
        appender.setContext((Context)context);
        appender.setSuffixPattern(this.logFormat.replaceAll(LOG_TOKEN_PID, PID).replaceAll(LOG_TOKEN_NAME, Matcher.quoteReplacement(applicationName)));
        appender.setSyslogHost(this.host);
        appender.setPort(this.port);
        appender.setFacility(this.facility.toString().toLowerCase(Locale.ENGLISH));
        appender.setThrowableExcluded(!this.includeStackTrace);
        appender.setStackTracePattern(this.stackTracePrefix);
        this.addThresholdFilter((FilterAttachable<ILoggingEvent>)appender, this.threshold);
        appender.start();
        return this.wrapAsync((Appender<ILoggingEvent>)appender);
    }

    static {
        Matcher matcher = PID_PATTERN.matcher(ManagementFactory.getRuntimeMXBean().getName());
        if (matcher.find()) {
            PID = "[" + matcher.group(1) + "]";
        }
    }

    public static enum Facility {
        AUTH,
        AUTHPRIV,
        DAEMON,
        CRON,
        FTP,
        LPR,
        KERN,
        MAIL,
        NEWS,
        SYSLOG,
        USER,
        UUCP,
        LOCAL0,
        LOCAL1,
        LOCAL2,
        LOCAL3,
        LOCAL4,
        LOCAL5,
        LOCAL6,
        LOCAL7;

    }
}

